
kernel void test_fn(local ushort16 *sSharedStorage, global ushort16 *srcValues, global uint *offsets, global ushort16 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (ushort16)(ushort)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore16(srcValues[ tid ], lid, ((local ushort *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local ushort *sp = (local ushort *)(sSharedStorage + lid);
  global ushort *dp = (global ushort *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
