
kernel void test_fn(local ulong4 *sSharedStorage, global ulong4 *srcValues, global uint *offsets, global ulong4 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (ulong4)(ulong)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore4(srcValues[ tid ], lid, ((local ulong *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local ulong *sp = (local ulong *)(sSharedStorage + lid);
  global ulong *dp = (global ulong *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
