
kernel void test_fn(local long8 *sSharedStorage, global long8 *srcValues, global uint *offsets, global long8 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (long8)(long)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore8(srcValues[ tid ], lid, ((local long *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local long *sp = (local long *)(sSharedStorage + lid);
  global long *dp = (global long *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
