
kernel void test_fn(local float8 *sSharedStorage, global float8 *srcValues, global uint *offsets, global float8 *destBuffer, uint alignmentOffset) {
  int tid = get_global_id(0);
  int lid = get_local_id(0);
  sSharedStorage[ lid ] = (float8)(float)0;
  if (lid+1 < get_local_size(0))
    sSharedStorage[ lid +1 ] =  sSharedStorage[ lid ];
  barrier(CLK_LOCAL_MEM_FENCE);

  vstore8(srcValues[ tid ], lid, ((local float *)sSharedStorage));

  barrier(CLK_LOCAL_MEM_FENCE);

  int i;
  local float *sp = (local float *)(sSharedStorage + lid);
  global float *dp = (global float *)(destBuffer + tid);
  for (i = 0; (size_t)i < sizeof(sSharedStorage[0]) / sizeof(*sp); i++)
    dp[i] = sp[i];
}
