/*!
[config]
name: Vector storea_half global double2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0
require_device_extensions: cl_khr_fp64
[test]
name: vector storea_half global double2
kernel_name: vstorea_half2_global
arg_out: 0 buffer half[5] 0 0 28 46 0xdeadp1
arg_in: 0 buffer half[5] 0 0 0 0  0xdeadp1
arg_in:  1 buffer double2[1] 28 46

[test]
name: vector storea_half global offset double2
kernel_name: vstorea_half2_global_offset
arg_out: 0 buffer half[7] 0 0  28 46  28 46 0xdeadp1
arg_in: 0 buffer half[7] 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer double2[1] 28 46

[test]
name: vector storea_half global double3
kernel_name: vstorea_half3_global
arg_out: 0 buffer half[8] 0 0 0 0 121 66 189 0xdeadp1
arg_in: 0 buffer half[8] 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer double3[1] 121 66 189

[test]
name: vector storea_half global offset double3
kernel_name: vstorea_half3_global_offset
arg_out: 0 buffer half[12] 0 0 0 0  121 66 189 0  121 66 189 0xdeadp1
arg_in: 0 buffer half[12] 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer double3[1] 121 66 189

[test]
name: vector storea_half global double4
kernel_name: vstorea_half4_global
arg_out: 0 buffer half[9] 0 0 0 0 120 155 52 202 0xdeadp1
arg_in: 0 buffer half[9] 0 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer double4[1] 120 155 52 202

[test]
name: vector storea_half global offset double4
kernel_name: vstorea_half4_global_offset
arg_out: 0 buffer half[13] 0 0 0 0  120 155 52 202  120 155 52 202 0xdeadp1
arg_in: 0 buffer half[13] 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer double4[1] 120 155 52 202

[test]
name: vector storea_half global double8
kernel_name: vstorea_half8_global
arg_out: 0 buffer half[17] 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70 0xdeadp1
arg_in: 0 buffer half[17] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer double8[1] 116 189 192 64 98 22 43 70

[test]
name: vector storea_half global offset double8
kernel_name: vstorea_half8_global_offset
arg_out: 0 buffer half[25] 0 0 0 0 0 0 0 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdeadp1
arg_in: 0 buffer half[25] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer double8[1] 116 189 192 64 98 22 43 70

[test]
name: vector storea_half global double16
kernel_name: vstorea_half16_global
arg_out: 0 buffer half[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdeadp1
arg_in: 0 buffer half[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer double16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector storea_half global offset double16
kernel_name: vstorea_half16_global_offset
arg_out: 0 buffer half[49] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdeadp1
arg_in: 0 buffer half[49] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer double16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

#pragma OPENCL EXTENSION cl_khr_fp64: enable

kernel void vstorea_half2_global(global half *out,
                             global double2 *in) {
    double2 tmp = in[0];
    vstorea_half2(tmp, 0, out + 2);
}

kernel void vstorea_half2_global_offset(global half *out,
                                    global double2 *in) {
    double2 tmp = in[0];
    vstorea_half2(tmp, 0, out + 2);
    vstorea_half2(tmp, 1, out + 2);
}

kernel void vstorea_half3_global(global half *out,
                             global double3 *in) {
    double3 tmp = in[0];
    vstorea_half3(tmp, 0, out + 4);
}

kernel void vstorea_half3_global_offset(global half *out,
                                    global double3 *in) {
    double3 tmp = in[0];
    vstorea_half3(tmp, 0, out + 4);
    vstorea_half3(tmp, 1, out + 4);
}

kernel void vstorea_half4_global(global half *out,
                             global double4 *in) {
    double4 tmp = in[0];
    vstorea_half4(tmp, 0, out + 4);
}

kernel void vstorea_half4_global_offset(global half *out,
                                    global double4 *in) {
    double4 tmp = in[0];
    vstorea_half4(tmp, 0, out + 4);
    vstorea_half4(tmp, 1, out + 4);
}

kernel void vstorea_half8_global(global half *out,
                             global double8 *in) {
    double8 tmp = in[0];
    vstorea_half8(tmp, 0, out + 8);
}

kernel void vstorea_half8_global_offset(global half *out,
                                    global double8 *in) {
    double8 tmp = in[0];
    vstorea_half8(tmp, 0, out + 8);
    vstorea_half8(tmp, 1, out + 8);
}

kernel void vstorea_half16_global(global half *out,
                             global double16 *in) {
    double16 tmp = in[0];
    vstorea_half16(tmp, 0, out + 16);
}

kernel void vstorea_half16_global_offset(global half *out,
                                    global double16 *in) {
    double16 tmp = in[0];
    vstorea_half16(tmp, 0, out + 16);
    vstorea_half16(tmp, 1, out + 16);
}
