/*!
[config]
name: Vector store_half private float2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store_half private float
kernel_name: vstore_half_private
arg_out: 0 buffer half[3] 0 68 0xdeadp1
arg_in: 0 buffer half[3] 0 0  0xdeadp1
arg_in:  1 buffer float[1] 68

[test]
name: vector store_half private offset float
kernel_name: vstore_half_private_offset
arg_out: 0 buffer half[4] 0  68  68 0xdeadp1
arg_in: 0 buffer half[4] 0 0 0  0xdeadp1
arg_in: 1 buffer float[1] 68

[test]
name: vector store_half private float2
kernel_name: vstore_half2_private
arg_out: 0 buffer half[4] 0 28 46 0xdeadp1
arg_in: 0 buffer half[4] 0 0 0  0xdeadp1
arg_in:  1 buffer float2[1] 28 46

[test]
name: vector store_half private offset float2
kernel_name: vstore_half2_private_offset
arg_out: 0 buffer half[6] 0  28 46  28 46 0xdeadp1
arg_in: 0 buffer half[6] 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer float2[1] 28 46

[test]
name: vector store_half private float3
kernel_name: vstore_half3_private
arg_out: 0 buffer half[5] 0 121 66 189 0xdeadp1
arg_in: 0 buffer half[5] 0 0 0 0  0xdeadp1
arg_in:  1 buffer float3[1] 121 66 189

[test]
name: vector store_half private offset float3
kernel_name: vstore_half3_private_offset
arg_out: 0 buffer half[8] 0  121 66 189  121 66 189 0xdeadp1
arg_in: 0 buffer half[8] 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer float3[1] 121 66 189

[test]
name: vector store_half private float4
kernel_name: vstore_half4_private
arg_out: 0 buffer half[6] 0 120 155 52 202 0xdeadp1
arg_in: 0 buffer half[6] 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer float4[1] 120 155 52 202

[test]
name: vector store_half private offset float4
kernel_name: vstore_half4_private_offset
arg_out: 0 buffer half[10] 0  120 155 52 202  120 155 52 202 0xdeadp1
arg_in: 0 buffer half[10] 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer float4[1] 120 155 52 202

[test]
name: vector store_half private float8
kernel_name: vstore_half8_private
arg_out: 0 buffer half[10] 0 116 189 192 64 98 22 43 70 0xdeadp1
arg_in: 0 buffer half[10] 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer float8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store_half private offset float8
kernel_name: vstore_half8_private_offset
arg_out: 0 buffer half[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdeadp1
arg_in: 0 buffer half[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer float8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store_half private float16
kernel_name: vstore_half16_private
arg_out: 0 buffer half[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdeadp1
arg_in: 0 buffer half[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in:  1 buffer float16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store_half private offset float16
kernel_name: vstore_half16_private_offset
arg_out: 0 buffer half[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdeadp1
arg_in: 0 buffer half[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdeadp1
arg_in: 1 buffer float16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore_half_private(global half *out,
                             global float *in) {
    float tmp = in[0];
    volatile private short loc[2];
    for (int i = 0; i < 2; ++i)
        loc[i] = 0;

    vstore_half(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 2; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half_private_offset(global half *out,
                                    global float *in) {
    float tmp = in[0];
    volatile private short loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = 0;

    vstore_half(tmp, 0, (private half*)loc + 1);
    vstore_half(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 3; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half2_private(global half *out,
                             global float2 *in) {
    float2 tmp = in[0];
    volatile private short loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = 0;

    vstore_half2(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 3; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half2_private_offset(global half *out,
                                    global float2 *in) {
    float2 tmp = in[0];
    volatile private short loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = 0;

    vstore_half2(tmp, 0, (private half*)loc + 1);
    vstore_half2(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 5; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half3_private(global half *out,
                             global float3 *in) {
    float3 tmp = in[0];
    volatile private short loc[4];
    for (int i = 0; i < 4; ++i)
        loc[i] = 0;

    vstore_half3(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 4; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half3_private_offset(global half *out,
                                    global float3 *in) {
    float3 tmp = in[0];
    volatile private short loc[7];
    for (int i = 0; i < 7; ++i)
        loc[i] = 0;

    vstore_half3(tmp, 0, (private half*)loc + 1);
    vstore_half3(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 7; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half4_private(global half *out,
                             global float4 *in) {
    float4 tmp = in[0];
    volatile private short loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = 0;

    vstore_half4(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 5; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half4_private_offset(global half *out,
                                    global float4 *in) {
    float4 tmp = in[0];
    volatile private short loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = 0;

    vstore_half4(tmp, 0, (private half*)loc + 1);
    vstore_half4(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 9; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half8_private(global half *out,
                             global float8 *in) {
    float8 tmp = in[0];
    volatile private short loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = 0;

    vstore_half8(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 9; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half8_private_offset(global half *out,
                                    global float8 *in) {
    float8 tmp = in[0];
    volatile private short loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = 0;

    vstore_half8(tmp, 0, (private half*)loc + 1);
    vstore_half8(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 17; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half16_private(global half *out,
                             global float16 *in) {
    float16 tmp = in[0];
    volatile private short loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = 0;

    vstore_half16(tmp, 0, (private half*)loc + 1);

    for (int i = 0; i < 17; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore_half16_private_offset(global half *out,
                                    global float16 *in) {
    float16 tmp = in[0];
    volatile private short loc[33];
    for (int i = 0; i < 33; ++i)
        loc[i] = 0;

    vstore_half16(tmp, 0, (private half*)loc + 1);
    vstore_half16(tmp, 1, (private half*)loc + 1);

    for (int i = 0; i < 33; ++i)
        ((global short *)out)[i] = loc[i];
}
