/*!
[config]
name: Vector store global ushort2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store global ushort2
kernel_name: vstore2_global
arg_out: 0 buffer ushort[4] 0 28 46 0xdead
arg_in: 0 buffer ushort[4] 0 0 0  0xdead
arg_in:  1 buffer ushort2[1] 28 46

[test]
name: vector store global offset ushort2
kernel_name: vstore2_global_offset
arg_out: 0 buffer ushort[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer ushort[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer ushort2[1] 28 46

[test]
name: vector store global ushort3
kernel_name: vstore3_global
arg_out: 0 buffer ushort[5] 0 121 66 189 0xdead
arg_in: 0 buffer ushort[5] 0 0 0 0  0xdead
arg_in:  1 buffer ushort3[1] 121 66 189

[test]
name: vector store global offset ushort3
kernel_name: vstore3_global_offset
arg_out: 0 buffer ushort[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer ushort[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer ushort3[1] 121 66 189

[test]
name: vector store global ushort4
kernel_name: vstore4_global
arg_out: 0 buffer ushort[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer ushort[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer ushort4[1] 120 155 52 202

[test]
name: vector store global offset ushort4
kernel_name: vstore4_global_offset
arg_out: 0 buffer ushort[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer ushort[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer ushort4[1] 120 155 52 202

[test]
name: vector store global ushort8
kernel_name: vstore8_global
arg_out: 0 buffer ushort[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer ushort[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer ushort8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store global offset ushort8
kernel_name: vstore8_global_offset
arg_out: 0 buffer ushort[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer ushort[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer ushort8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store global ushort16
kernel_name: vstore16_global
arg_out: 0 buffer ushort[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer ushort[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer ushort16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store global offset ushort16
kernel_name: vstore16_global_offset
arg_out: 0 buffer ushort[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer ushort[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer ushort16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore2_global(global ushort *out,
                             global ushort2 *in) {
    ushort2 tmp = in[0];
    vstore2(tmp, 0, out + 1);
}

kernel void vstore2_global_offset(global ushort *out,
                                    global ushort2 *in) {
    ushort2 tmp = in[0];
    vstore2(tmp, 0, out + 1);
    vstore2(tmp, 1, out + 1);
}

kernel void vstore3_global(global ushort *out,
                             global ushort3 *in) {
    ushort3 tmp = in[0];
    vstore3(tmp, 0, out + 1);
}

kernel void vstore3_global_offset(global ushort *out,
                                    global ushort3 *in) {
    ushort3 tmp = in[0];
    vstore3(tmp, 0, out + 1);
    vstore3(tmp, 1, out + 1);
}

kernel void vstore4_global(global ushort *out,
                             global ushort4 *in) {
    ushort4 tmp = in[0];
    vstore4(tmp, 0, out + 1);
}

kernel void vstore4_global_offset(global ushort *out,
                                    global ushort4 *in) {
    ushort4 tmp = in[0];
    vstore4(tmp, 0, out + 1);
    vstore4(tmp, 1, out + 1);
}

kernel void vstore8_global(global ushort *out,
                             global ushort8 *in) {
    ushort8 tmp = in[0];
    vstore8(tmp, 0, out + 1);
}

kernel void vstore8_global_offset(global ushort *out,
                                    global ushort8 *in) {
    ushort8 tmp = in[0];
    vstore8(tmp, 0, out + 1);
    vstore8(tmp, 1, out + 1);
}

kernel void vstore16_global(global ushort *out,
                             global ushort16 *in) {
    ushort16 tmp = in[0];
    vstore16(tmp, 0, out + 1);
}

kernel void vstore16_global_offset(global ushort *out,
                                    global ushort16 *in) {
    ushort16 tmp = in[0];
    vstore16(tmp, 0, out + 1);
    vstore16(tmp, 1, out + 1);
}
