/*!
[config]
name: Vector store global uint2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store global uint2
kernel_name: vstore2_global
arg_out: 0 buffer uint[4] 0 28 46 0xdead
arg_in: 0 buffer uint[4] 0 0 0  0xdead
arg_in:  1 buffer uint2[1] 28 46

[test]
name: vector store global offset uint2
kernel_name: vstore2_global_offset
arg_out: 0 buffer uint[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer uint[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer uint2[1] 28 46

[test]
name: vector store global uint3
kernel_name: vstore3_global
arg_out: 0 buffer uint[5] 0 121 66 189 0xdead
arg_in: 0 buffer uint[5] 0 0 0 0  0xdead
arg_in:  1 buffer uint3[1] 121 66 189

[test]
name: vector store global offset uint3
kernel_name: vstore3_global_offset
arg_out: 0 buffer uint[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer uint[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uint3[1] 121 66 189

[test]
name: vector store global uint4
kernel_name: vstore4_global
arg_out: 0 buffer uint[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer uint[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer uint4[1] 120 155 52 202

[test]
name: vector store global offset uint4
kernel_name: vstore4_global_offset
arg_out: 0 buffer uint[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer uint[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uint4[1] 120 155 52 202

[test]
name: vector store global uint8
kernel_name: vstore8_global
arg_out: 0 buffer uint[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer uint[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer uint8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store global offset uint8
kernel_name: vstore8_global_offset
arg_out: 0 buffer uint[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer uint[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uint8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store global uint16
kernel_name: vstore16_global
arg_out: 0 buffer uint[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer uint[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer uint16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store global offset uint16
kernel_name: vstore16_global_offset
arg_out: 0 buffer uint[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer uint[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uint16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore2_global(global uint *out,
                             global uint2 *in) {
    uint2 tmp = in[0];
    vstore2(tmp, 0, out + 1);
}

kernel void vstore2_global_offset(global uint *out,
                                    global uint2 *in) {
    uint2 tmp = in[0];
    vstore2(tmp, 0, out + 1);
    vstore2(tmp, 1, out + 1);
}

kernel void vstore3_global(global uint *out,
                             global uint3 *in) {
    uint3 tmp = in[0];
    vstore3(tmp, 0, out + 1);
}

kernel void vstore3_global_offset(global uint *out,
                                    global uint3 *in) {
    uint3 tmp = in[0];
    vstore3(tmp, 0, out + 1);
    vstore3(tmp, 1, out + 1);
}

kernel void vstore4_global(global uint *out,
                             global uint4 *in) {
    uint4 tmp = in[0];
    vstore4(tmp, 0, out + 1);
}

kernel void vstore4_global_offset(global uint *out,
                                    global uint4 *in) {
    uint4 tmp = in[0];
    vstore4(tmp, 0, out + 1);
    vstore4(tmp, 1, out + 1);
}

kernel void vstore8_global(global uint *out,
                             global uint8 *in) {
    uint8 tmp = in[0];
    vstore8(tmp, 0, out + 1);
}

kernel void vstore8_global_offset(global uint *out,
                                    global uint8 *in) {
    uint8 tmp = in[0];
    vstore8(tmp, 0, out + 1);
    vstore8(tmp, 1, out + 1);
}

kernel void vstore16_global(global uint *out,
                             global uint16 *in) {
    uint16 tmp = in[0];
    vstore16(tmp, 0, out + 1);
}

kernel void vstore16_global_offset(global uint *out,
                                    global uint16 *in) {
    uint16 tmp = in[0];
    vstore16(tmp, 0, out + 1);
    vstore16(tmp, 1, out + 1);
}
