/*!
[config]
name: Vector store private uchar2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store private uchar2
kernel_name: vstore2_private
arg_out: 0 buffer uchar[4] 0 28 46 0xdead
arg_in: 0 buffer uchar[4] 0 0 0  0xdead
arg_in:  1 buffer uchar2[1] 28 46

[test]
name: vector store private offset uchar2
kernel_name: vstore2_private_offset
arg_out: 0 buffer uchar[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer uchar[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer uchar2[1] 28 46

[test]
name: vector store private uchar3
kernel_name: vstore3_private
arg_out: 0 buffer uchar[5] 0 121 66 189 0xdead
arg_in: 0 buffer uchar[5] 0 0 0 0  0xdead
arg_in:  1 buffer uchar3[1] 121 66 189

[test]
name: vector store private offset uchar3
kernel_name: vstore3_private_offset
arg_out: 0 buffer uchar[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer uchar[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uchar3[1] 121 66 189

[test]
name: vector store private uchar4
kernel_name: vstore4_private
arg_out: 0 buffer uchar[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer uchar[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer uchar4[1] 120 155 52 202

[test]
name: vector store private offset uchar4
kernel_name: vstore4_private_offset
arg_out: 0 buffer uchar[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer uchar[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uchar4[1] 120 155 52 202

[test]
name: vector store private uchar8
kernel_name: vstore8_private
arg_out: 0 buffer uchar[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer uchar[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer uchar8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store private offset uchar8
kernel_name: vstore8_private_offset
arg_out: 0 buffer uchar[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer uchar[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uchar8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store private uchar16
kernel_name: vstore16_private
arg_out: 0 buffer uchar[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer uchar[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer uchar16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store private offset uchar16
kernel_name: vstore16_private_offset
arg_out: 0 buffer uchar[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer uchar[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer uchar16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore2_private(global uchar *out,
                             global uchar2 *in) {
    uchar2 tmp = in[0];
    volatile private uchar loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = (uchar)0;

    vstore2(tmp, 0, (private uchar*)loc + 1);
    for (int i = 0; i < 3; ++i)
        out[i] = loc[i];
}

kernel void vstore2_private_offset(global uchar *out,
                                    global uchar2 *in) {
    uchar2 tmp = in[0];
    volatile private uchar loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (uchar)0;

    vstore2(tmp, 0, (private uchar*)loc + 1);
    vstore2(tmp, 1, (private uchar*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore3_private(global uchar *out,
                             global uchar3 *in) {
    uchar3 tmp = in[0];
    volatile private uchar loc[4];
    for (int i = 0; i < 4; ++i)
        loc[i] = (uchar)0;

    vstore3(tmp, 0, (private uchar*)loc + 1);
    for (int i = 0; i < 4; ++i)
        out[i] = loc[i];
}

kernel void vstore3_private_offset(global uchar *out,
                                    global uchar3 *in) {
    uchar3 tmp = in[0];
    volatile private uchar loc[7];
    for (int i = 0; i < 7; ++i)
        loc[i] = (uchar)0;

    vstore3(tmp, 0, (private uchar*)loc + 1);
    vstore3(tmp, 1, (private uchar*)loc + 1);
    for (int i = 0; i < 7; ++i)
        out[i] = loc[i];
}

kernel void vstore4_private(global uchar *out,
                             global uchar4 *in) {
    uchar4 tmp = in[0];
    volatile private uchar loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (uchar)0;

    vstore4(tmp, 0, (private uchar*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore4_private_offset(global uchar *out,
                                    global uchar4 *in) {
    uchar4 tmp = in[0];
    volatile private uchar loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (uchar)0;

    vstore4(tmp, 0, (private uchar*)loc + 1);
    vstore4(tmp, 1, (private uchar*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_private(global uchar *out,
                             global uchar8 *in) {
    uchar8 tmp = in[0];
    volatile private uchar loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (uchar)0;

    vstore8(tmp, 0, (private uchar*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_private_offset(global uchar *out,
                                    global uchar8 *in) {
    uchar8 tmp = in[0];
    volatile private uchar loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (uchar)0;

    vstore8(tmp, 0, (private uchar*)loc + 1);
    vstore8(tmp, 1, (private uchar*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_private(global uchar *out,
                             global uchar16 *in) {
    uchar16 tmp = in[0];
    volatile private uchar loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (uchar)0;

    vstore16(tmp, 0, (private uchar*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_private_offset(global uchar *out,
                                    global uchar16 *in) {
    uchar16 tmp = in[0];
    volatile private uchar loc[33];
    for (int i = 0; i < 33; ++i)
        loc[i] = (uchar)0;

    vstore16(tmp, 0, (private uchar*)loc + 1);
    vstore16(tmp, 1, (private uchar*)loc + 1);
    for (int i = 0; i < 33; ++i)
        out[i] = loc[i];
}
