/*!
[config]
name: Vector store local long2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store local long2
kernel_name: vstore2_local
arg_out: 0 buffer long[4] 0 28 46 0xdead
arg_in: 0 buffer long[4] 0 0 0  0xdead
arg_in:  1 buffer long2[1] 28 46

[test]
name: vector store local offset long2
kernel_name: vstore2_local_offset
arg_out: 0 buffer long[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer long[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer long2[1] 28 46

[test]
name: vector store local long3
kernel_name: vstore3_local
arg_out: 0 buffer long[5] 0 121 66 189 0xdead
arg_in: 0 buffer long[5] 0 0 0 0  0xdead
arg_in:  1 buffer long3[1] 121 66 189

[test]
name: vector store local offset long3
kernel_name: vstore3_local_offset
arg_out: 0 buffer long[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer long[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer long3[1] 121 66 189

[test]
name: vector store local long4
kernel_name: vstore4_local
arg_out: 0 buffer long[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer long[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer long4[1] 120 155 52 202

[test]
name: vector store local offset long4
kernel_name: vstore4_local_offset
arg_out: 0 buffer long[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer long[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer long4[1] 120 155 52 202

[test]
name: vector store local long8
kernel_name: vstore8_local
arg_out: 0 buffer long[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer long[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer long8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store local offset long8
kernel_name: vstore8_local_offset
arg_out: 0 buffer long[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer long[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer long8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store local long16
kernel_name: vstore16_local
arg_out: 0 buffer long[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer long[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer long16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store local offset long16
kernel_name: vstore16_local_offset
arg_out: 0 buffer long[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer long[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer long16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore2_local(global long *out,
                             global long2 *in) {
    long2 tmp = in[0];
    volatile local long loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = (long)0;

    vstore2(tmp, 0, (local long*)loc + 1);
    for (int i = 0; i < 3; ++i)
        out[i] = loc[i];
}

kernel void vstore2_local_offset(global long *out,
                                    global long2 *in) {
    long2 tmp = in[0];
    volatile local long loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (long)0;

    vstore2(tmp, 0, (local long*)loc + 1);
    vstore2(tmp, 1, (local long*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore3_local(global long *out,
                             global long3 *in) {
    long3 tmp = in[0];
    volatile local long loc[4];
    for (int i = 0; i < 4; ++i)
        loc[i] = (long)0;

    vstore3(tmp, 0, (local long*)loc + 1);
    for (int i = 0; i < 4; ++i)
        out[i] = loc[i];
}

kernel void vstore3_local_offset(global long *out,
                                    global long3 *in) {
    long3 tmp = in[0];
    volatile local long loc[7];
    for (int i = 0; i < 7; ++i)
        loc[i] = (long)0;

    vstore3(tmp, 0, (local long*)loc + 1);
    vstore3(tmp, 1, (local long*)loc + 1);
    for (int i = 0; i < 7; ++i)
        out[i] = loc[i];
}

kernel void vstore4_local(global long *out,
                             global long4 *in) {
    long4 tmp = in[0];
    volatile local long loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (long)0;

    vstore4(tmp, 0, (local long*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore4_local_offset(global long *out,
                                    global long4 *in) {
    long4 tmp = in[0];
    volatile local long loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (long)0;

    vstore4(tmp, 0, (local long*)loc + 1);
    vstore4(tmp, 1, (local long*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_local(global long *out,
                             global long8 *in) {
    long8 tmp = in[0];
    volatile local long loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (long)0;

    vstore8(tmp, 0, (local long*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_local_offset(global long *out,
                                    global long8 *in) {
    long8 tmp = in[0];
    volatile local long loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (long)0;

    vstore8(tmp, 0, (local long*)loc + 1);
    vstore8(tmp, 1, (local long*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_local(global long *out,
                             global long16 *in) {
    long16 tmp = in[0];
    volatile local long loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (long)0;

    vstore16(tmp, 0, (local long*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_local_offset(global long *out,
                                    global long16 *in) {
    long16 tmp = in[0];
    volatile local long loc[33];
    for (int i = 0; i < 33; ++i)
        loc[i] = (long)0;

    vstore16(tmp, 0, (local long*)loc + 1);
    vstore16(tmp, 1, (local long*)loc + 1);
    for (int i = 0; i < 33; ++i)
        out[i] = loc[i];
}
