/*!
[config]
name: Vector store local half2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0
require_device_extensions: cl_khr_fp16
[test]
name: vector store local half2
kernel_name: vstore2_local
arg_out: 0 buffer half[4] 0 28 46 0xdead
arg_in: 0 buffer half[4] 0 0 0  0xdead
arg_in:  1 buffer half2[1] 28 46

[test]
name: vector store local offset half2
kernel_name: vstore2_local_offset
arg_out: 0 buffer half[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer half[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer half2[1] 28 46

[test]
name: vector store local half3
kernel_name: vstore3_local
arg_out: 0 buffer half[5] 0 121 66 189 0xdead
arg_in: 0 buffer half[5] 0 0 0 0  0xdead
arg_in:  1 buffer half3[1] 121 66 189

[test]
name: vector store local offset half3
kernel_name: vstore3_local_offset
arg_out: 0 buffer half[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer half[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer half3[1] 121 66 189

[test]
name: vector store local half4
kernel_name: vstore4_local
arg_out: 0 buffer half[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer half[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer half4[1] 120 155 52 202

[test]
name: vector store local offset half4
kernel_name: vstore4_local_offset
arg_out: 0 buffer half[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer half[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer half4[1] 120 155 52 202

[test]
name: vector store local half8
kernel_name: vstore8_local
arg_out: 0 buffer half[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer half[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer half8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store local offset half8
kernel_name: vstore8_local_offset
arg_out: 0 buffer half[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer half[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer half8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store local half16
kernel_name: vstore16_local
arg_out: 0 buffer half[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer half[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer half16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store local offset half16
kernel_name: vstore16_local_offset
arg_out: 0 buffer half[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer half[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer half16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

#pragma OPENCL EXTENSION cl_khr_fp16: enable

kernel void vstore2_local(global half *out,
                             global half2 *in) {
    half2 tmp = in[0];
    volatile local short loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = 0;

    vstore2(tmp, 0, (local half*)loc + 1);

    for (int i = 0; i < 3; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore2_local_offset(global half *out,
                                    global half2 *in) {
    half2 tmp = in[0];
    volatile local short loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = 0;

    vstore2(tmp, 0, (local half*)loc + 1);
    vstore2(tmp, 1, (local half*)loc + 1);

    for (int i = 0; i < 5; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore3_local(global half *out,
                             global half3 *in) {
    half3 tmp = in[0];
    volatile local short loc[4];
    for (int i = 0; i < 4; ++i)
        loc[i] = 0;

    vstore3(tmp, 0, (local half*)loc + 1);

    for (int i = 0; i < 4; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore3_local_offset(global half *out,
                                    global half3 *in) {
    half3 tmp = in[0];
    volatile local short loc[7];
    for (int i = 0; i < 7; ++i)
        loc[i] = 0;

    vstore3(tmp, 0, (local half*)loc + 1);
    vstore3(tmp, 1, (local half*)loc + 1);

    for (int i = 0; i < 7; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore4_local(global half *out,
                             global half4 *in) {
    half4 tmp = in[0];
    volatile local short loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = 0;

    vstore4(tmp, 0, (local half*)loc + 1);

    for (int i = 0; i < 5; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore4_local_offset(global half *out,
                                    global half4 *in) {
    half4 tmp = in[0];
    volatile local short loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = 0;

    vstore4(tmp, 0, (local half*)loc + 1);
    vstore4(tmp, 1, (local half*)loc + 1);

    for (int i = 0; i < 9; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore8_local(global half *out,
                             global half8 *in) {
    half8 tmp = in[0];
    volatile local short loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = 0;

    vstore8(tmp, 0, (local half*)loc + 1);

    for (int i = 0; i < 9; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore8_local_offset(global half *out,
                                    global half8 *in) {
    half8 tmp = in[0];
    volatile local short loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = 0;

    vstore8(tmp, 0, (local half*)loc + 1);
    vstore8(tmp, 1, (local half*)loc + 1);

    for (int i = 0; i < 17; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore16_local(global half *out,
                             global half16 *in) {
    half16 tmp = in[0];
    volatile local short loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = 0;

    vstore16(tmp, 0, (local half*)loc + 1);

    for (int i = 0; i < 17; ++i)
        ((global short *)out)[i] = loc[i];
}

kernel void vstore16_local_offset(global half *out,
                                    global half16 *in) {
    half16 tmp = in[0];
    volatile local short loc[33];
    for (int i = 0; i < 33; ++i)
        loc[i] = 0;

    vstore16(tmp, 0, (local half*)loc + 1);
    vstore16(tmp, 1, (local half*)loc + 1);

    for (int i = 0; i < 33; ++i)
        ((global short *)out)[i] = loc[i];
}
