/*!
[config]
name: Vector store private char2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector store private char2
kernel_name: vstore2_private
arg_out: 0 buffer char[4] 0 28 46 0xdead
arg_in: 0 buffer char[4] 0 0 0  0xdead
arg_in:  1 buffer char2[1] 28 46

[test]
name: vector store private offset char2
kernel_name: vstore2_private_offset
arg_out: 0 buffer char[6] 0  28 46  28 46 0xdead
arg_in: 0 buffer char[6] 0 0 0 0 0  0xdead
arg_in: 1 buffer char2[1] 28 46

[test]
name: vector store private char3
kernel_name: vstore3_private
arg_out: 0 buffer char[5] 0 121 66 189 0xdead
arg_in: 0 buffer char[5] 0 0 0 0  0xdead
arg_in:  1 buffer char3[1] 121 66 189

[test]
name: vector store private offset char3
kernel_name: vstore3_private_offset
arg_out: 0 buffer char[8] 0  121 66 189  121 66 189 0xdead
arg_in: 0 buffer char[8] 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer char3[1] 121 66 189

[test]
name: vector store private char4
kernel_name: vstore4_private
arg_out: 0 buffer char[6] 0 120 155 52 202 0xdead
arg_in: 0 buffer char[6] 0 0 0 0 0  0xdead
arg_in:  1 buffer char4[1] 120 155 52 202

[test]
name: vector store private offset char4
kernel_name: vstore4_private_offset
arg_out: 0 buffer char[10] 0  120 155 52 202  120 155 52 202 0xdead
arg_in: 0 buffer char[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer char4[1] 120 155 52 202

[test]
name: vector store private char8
kernel_name: vstore8_private
arg_out: 0 buffer char[10] 0 116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer char[10] 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer char8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store private offset char8
kernel_name: vstore8_private_offset
arg_out: 0 buffer char[18] 0  116 189 192 64 98 22 43 70  116 189 192 64 98 22 43 70 0xdead
arg_in: 0 buffer char[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer char8[1] 116 189 192 64 98 22 43 70

[test]
name: vector store private char16
kernel_name: vstore16_private
arg_out: 0 buffer char[18] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer char[18] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in:  1 buffer char16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector store private offset char16
kernel_name: vstore16_private_offset
arg_out: 0 buffer char[34] 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171 0xdead
arg_in: 0 buffer char[34] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  0xdead
arg_in: 1 buffer char16[1] 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vstore2_private(global char *out,
                             global char2 *in) {
    char2 tmp = in[0];
    volatile private char loc[3];
    for (int i = 0; i < 3; ++i)
        loc[i] = (char)0;

    vstore2(tmp, 0, (private char*)loc + 1);
    for (int i = 0; i < 3; ++i)
        out[i] = loc[i];
}

kernel void vstore2_private_offset(global char *out,
                                    global char2 *in) {
    char2 tmp = in[0];
    volatile private char loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (char)0;

    vstore2(tmp, 0, (private char*)loc + 1);
    vstore2(tmp, 1, (private char*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore3_private(global char *out,
                             global char3 *in) {
    char3 tmp = in[0];
    volatile private char loc[4];
    for (int i = 0; i < 4; ++i)
        loc[i] = (char)0;

    vstore3(tmp, 0, (private char*)loc + 1);
    for (int i = 0; i < 4; ++i)
        out[i] = loc[i];
}

kernel void vstore3_private_offset(global char *out,
                                    global char3 *in) {
    char3 tmp = in[0];
    volatile private char loc[7];
    for (int i = 0; i < 7; ++i)
        loc[i] = (char)0;

    vstore3(tmp, 0, (private char*)loc + 1);
    vstore3(tmp, 1, (private char*)loc + 1);
    for (int i = 0; i < 7; ++i)
        out[i] = loc[i];
}

kernel void vstore4_private(global char *out,
                             global char4 *in) {
    char4 tmp = in[0];
    volatile private char loc[5];
    for (int i = 0; i < 5; ++i)
        loc[i] = (char)0;

    vstore4(tmp, 0, (private char*)loc + 1);
    for (int i = 0; i < 5; ++i)
        out[i] = loc[i];
}

kernel void vstore4_private_offset(global char *out,
                                    global char4 *in) {
    char4 tmp = in[0];
    volatile private char loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (char)0;

    vstore4(tmp, 0, (private char*)loc + 1);
    vstore4(tmp, 1, (private char*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_private(global char *out,
                             global char8 *in) {
    char8 tmp = in[0];
    volatile private char loc[9];
    for (int i = 0; i < 9; ++i)
        loc[i] = (char)0;

    vstore8(tmp, 0, (private char*)loc + 1);
    for (int i = 0; i < 9; ++i)
        out[i] = loc[i];
}

kernel void vstore8_private_offset(global char *out,
                                    global char8 *in) {
    char8 tmp = in[0];
    volatile private char loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (char)0;

    vstore8(tmp, 0, (private char*)loc + 1);
    vstore8(tmp, 1, (private char*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_private(global char *out,
                             global char16 *in) {
    char16 tmp = in[0];
    volatile private char loc[17];
    for (int i = 0; i < 17; ++i)
        loc[i] = (char)0;

    vstore16(tmp, 0, (private char*)loc + 1);
    for (int i = 0; i < 17; ++i)
        out[i] = loc[i];
}

kernel void vstore16_private_offset(global char *out,
                                    global char16 *in) {
    char16 tmp = in[0];
    volatile private char loc[33];
    for (int i = 0; i < 33; ++i)
        loc[i] = (char)0;

    vstore16(tmp, 0, (private char*)loc + 1);
    vstore16(tmp, 1, (private char*)loc + 1);
    for (int i = 0; i < 33; ++i)
        out[i] = loc[i];
}
