/*!
[config]
name: Vector loada_half global float2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector loada_half global float2
kernel_name: vloada_half2_global
arg_in:  0 buffer half[4] 0 0 28 46
arg_out: 1 buffer float2[2] 0 0  28 46

[test]
name: vector loada_half global offset float2
kernel_name: vloada_half2_global_offset
arg_in:  0 buffer half[6] 0 0 0 0 28 46
arg_out: 1 buffer float2[2] 0 0  28 46

[test]
name: vector loada_half global float3
kernel_name: vloada_half3_global
arg_in:  0 buffer half[7] 0 0 0 0 121 66 189
arg_out: 1 buffer float3[2] 0 0 0  121 66 189

[test]
name: vector loada_half global offset float3
kernel_name: vloada_half3_global_offset
arg_in:  0 buffer half[11] 0 0 0 0 0 0 0 0 121 66 189
arg_out: 1 buffer float3[2] 0 0 0  121 66 189

[test]
name: vector loada_half global float4
kernel_name: vloada_half4_global
arg_in:  0 buffer half[8] 0 0 0 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 0 0 0  120 155 52 202

[test]
name: vector loada_half global offset float4
kernel_name: vloada_half4_global_offset
arg_in:  0 buffer half[12] 0 0 0 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 0 0 0  120 155 52 202

[test]
name: vector loada_half global float8
kernel_name: vloada_half8_global
arg_in:  0 buffer half[16] 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 0 0 0 0 0 0 0  116 189 192 64 98 22 43 70

[test]
name: vector loada_half global offset float8
kernel_name: vloada_half8_global_offset
arg_in:  0 buffer half[24] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 0 0 0 0 0 0 0  116 189 192 64 98 22 43 70

[test]
name: vector loada_half global float16
kernel_name: vloada_half16_global
arg_in:  0 buffer half[32] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector loada_half global offset float16
kernel_name: vloada_half16_global_offset
arg_in:  0 buffer half[48] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vloada_half2_global(global half *in,
                             global float2 *out) {
    out[0] = vloada_half2(0, in);
    out[1] = vloada_half2(0, in + 2);
}

kernel void vloada_half2_global_offset(global half *in,
                                    global float2 *out) {
    out[0] = vloada_half2(1, in);
    out[1] = vloada_half2(1, in + 2);
}

kernel void vloada_half3_global(global half *in,
                             global float3 *out) {
    out[0] = vloada_half3(0, in);
    out[1] = vloada_half3(0, in + 4);
}

kernel void vloada_half3_global_offset(global half *in,
                                    global float3 *out) {
    out[0] = vloada_half3(1, in);
    out[1] = vloada_half3(1, in + 4);
}

kernel void vloada_half4_global(global half *in,
                             global float4 *out) {
    out[0] = vloada_half4(0, in);
    out[1] = vloada_half4(0, in + 4);
}

kernel void vloada_half4_global_offset(global half *in,
                                    global float4 *out) {
    out[0] = vloada_half4(1, in);
    out[1] = vloada_half4(1, in + 4);
}

kernel void vloada_half8_global(global half *in,
                             global float8 *out) {
    out[0] = vloada_half8(0, in);
    out[1] = vloada_half8(0, in + 8);
}

kernel void vloada_half8_global_offset(global half *in,
                                    global float8 *out) {
    out[0] = vloada_half8(1, in);
    out[1] = vloada_half8(1, in + 8);
}

kernel void vloada_half16_global(global half *in,
                             global float16 *out) {
    out[0] = vloada_half16(0, in);
    out[1] = vloada_half16(0, in + 16);
}

kernel void vloada_half16_global_offset(global half *in,
                                    global float16 *out) {
    out[0] = vloada_half16(1, in);
    out[1] = vloada_half16(1, in + 16);
}
