/*!
[config]
name: Vector load_half constant float2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector load_half constant float
kernel_name: vload_half_constant
arg_in:  0 buffer half[2] 0 68
arg_out: 1 buffer float[2] 0  68

[test]
name: vector load_half constant offset float
kernel_name: vload_half_constant_offset
arg_in:  0 buffer half[3] 0 0 68
arg_out: 1 buffer float[2] 0  68

[test]
name: vector load_half constant float2
kernel_name: vload_half2_constant
arg_in:  0 buffer half[3] 0 28 46
arg_out: 1 buffer float2[2] 0 28 28 46

[test]
name: vector load_half constant offset float2
kernel_name: vload_half2_constant_offset
arg_in:  0 buffer half[5] 0 0 0 28 46
arg_out: 1 buffer float2[2] 0 28 28 46

[test]
name: vector load_half constant float3
kernel_name: vload_half3_constant
arg_in:  0 buffer half[4] 0 121 66 189
arg_out: 1 buffer float3[2] 0 121 66 121 66 189

[test]
name: vector load_half constant offset float3
kernel_name: vload_half3_constant_offset
arg_in:  0 buffer half[7] 0 0 0 0 121 66 189
arg_out: 1 buffer float3[2] 0 121 66 121 66 189

[test]
name: vector load_half constant float4
kernel_name: vload_half4_constant
arg_in:  0 buffer half[5] 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load_half constant offset float4
kernel_name: vload_half4_constant_offset
arg_in:  0 buffer half[9] 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load_half constant float8
kernel_name: vload_half8_constant
arg_in:  0 buffer half[9] 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load_half constant offset float8
kernel_name: vload_half8_constant_offset
arg_in:  0 buffer half[17] 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load_half constant float16
kernel_name: vload_half16_constant
arg_in:  0 buffer half[17] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector load_half constant offset float16
kernel_name: vload_half16_constant_offset
arg_in:  0 buffer half[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vload_half_constant(constant half *in,
                             global float *out) {
    out[0] = vload_half(0, in);
    out[1] = vload_half(0, in + 1);
}

kernel void vload_half_constant_offset(constant half *in,
                                    global float *out) {
    out[0] = vload_half(1, in);
    out[1] = vload_half(1, in + 1);
}

kernel void vload_half2_constant(constant half *in,
                             global float2 *out) {
    out[0] = vload_half2(0, in);
    out[1] = vload_half2(0, in + 1);
}

kernel void vload_half2_constant_offset(constant half *in,
                                    global float2 *out) {
    out[0] = vload_half2(1, in);
    out[1] = vload_half2(1, in + 1);
}

kernel void vload_half3_constant(constant half *in,
                             global float3 *out) {
    out[0] = vload_half3(0, in);
    out[1] = vload_half3(0, in + 1);
}

kernel void vload_half3_constant_offset(constant half *in,
                                    global float3 *out) {
    out[0] = vload_half3(1, in);
    out[1] = vload_half3(1, in + 1);
}

kernel void vload_half4_constant(constant half *in,
                             global float4 *out) {
    out[0] = vload_half4(0, in);
    out[1] = vload_half4(0, in + 1);
}

kernel void vload_half4_constant_offset(constant half *in,
                                    global float4 *out) {
    out[0] = vload_half4(1, in);
    out[1] = vload_half4(1, in + 1);
}

kernel void vload_half8_constant(constant half *in,
                             global float8 *out) {
    out[0] = vload_half8(0, in);
    out[1] = vload_half8(0, in + 1);
}

kernel void vload_half8_constant_offset(constant half *in,
                                    global float8 *out) {
    out[0] = vload_half8(1, in);
    out[1] = vload_half8(1, in + 1);
}

kernel void vload_half16_constant(constant half *in,
                             global float16 *out) {
    out[0] = vload_half16(0, in);
    out[1] = vload_half16(0, in + 1);
}

kernel void vload_half16_constant_offset(constant half *in,
                                    global float16 *out) {
    out[0] = vload_half16(1, in);
    out[1] = vload_half16(1, in + 1);
}
