/*!
[config]
name: Vector load global ushort2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector load global ushort2
kernel_name: vload2_global
arg_in:  0 buffer ushort[3] 0 28 46
arg_out: 1 buffer ushort2[2] 0 28 28 46

[test]
name: vector load global offset ushort2
kernel_name: vload2_global_offset
arg_in:  0 buffer ushort[5] 0 0 0 28 46
arg_out: 1 buffer ushort2[2] 0 28 28 46

[test]
name: vector load global ushort3
kernel_name: vload3_global
arg_in:  0 buffer ushort[4] 0 121 66 189
arg_out: 1 buffer ushort3[2] 0 121 66 121 66 189

[test]
name: vector load global offset ushort3
kernel_name: vload3_global_offset
arg_in:  0 buffer ushort[7] 0 0 0 0 121 66 189
arg_out: 1 buffer ushort3[2] 0 121 66 121 66 189

[test]
name: vector load global ushort4
kernel_name: vload4_global
arg_in:  0 buffer ushort[5] 0 120 155 52 202
arg_out: 1 buffer ushort4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load global offset ushort4
kernel_name: vload4_global_offset
arg_in:  0 buffer ushort[9] 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer ushort4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load global ushort8
kernel_name: vload8_global
arg_in:  0 buffer ushort[9] 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer ushort8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load global offset ushort8
kernel_name: vload8_global_offset
arg_in:  0 buffer ushort[17] 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer ushort8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load global ushort16
kernel_name: vload16_global
arg_in:  0 buffer ushort[17] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer ushort16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector load global offset ushort16
kernel_name: vload16_global_offset
arg_in:  0 buffer ushort[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer ushort16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vload2_global(global ushort *in,
                             global ushort2 *out) {
    out[0] = vload2(0, in);
    out[1] = vload2(0, in + 1);
}

kernel void vload2_global_offset(global ushort *in,
                                    global ushort2 *out) {
    out[0] = vload2(1, in);
    out[1] = vload2(1, in + 1);
}

kernel void vload3_global(global ushort *in,
                             global ushort3 *out) {
    out[0] = vload3(0, in);
    out[1] = vload3(0, in + 1);
}

kernel void vload3_global_offset(global ushort *in,
                                    global ushort3 *out) {
    out[0] = vload3(1, in);
    out[1] = vload3(1, in + 1);
}

kernel void vload4_global(global ushort *in,
                             global ushort4 *out) {
    out[0] = vload4(0, in);
    out[1] = vload4(0, in + 1);
}

kernel void vload4_global_offset(global ushort *in,
                                    global ushort4 *out) {
    out[0] = vload4(1, in);
    out[1] = vload4(1, in + 1);
}

kernel void vload8_global(global ushort *in,
                             global ushort8 *out) {
    out[0] = vload8(0, in);
    out[1] = vload8(0, in + 1);
}

kernel void vload8_global_offset(global ushort *in,
                                    global ushort8 *out) {
    out[0] = vload8(1, in);
    out[1] = vload8(1, in + 1);
}

kernel void vload16_global(global ushort *in,
                             global ushort16 *out) {
    out[0] = vload16(0, in);
    out[1] = vload16(0, in + 1);
}

kernel void vload16_global_offset(global ushort *in,
                                    global ushort16 *out) {
    out[0] = vload16(1, in);
    out[1] = vload16(1, in + 1);
}
