/*!
[config]
name: Vector load global uint2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector load global uint2
kernel_name: vload2_global
arg_in:  0 buffer uint[3] 0 28 46
arg_out: 1 buffer uint2[2] 0 28 28 46

[test]
name: vector load global offset uint2
kernel_name: vload2_global_offset
arg_in:  0 buffer uint[5] 0 0 0 28 46
arg_out: 1 buffer uint2[2] 0 28 28 46

[test]
name: vector load global uint3
kernel_name: vload3_global
arg_in:  0 buffer uint[4] 0 121 66 189
arg_out: 1 buffer uint3[2] 0 121 66 121 66 189

[test]
name: vector load global offset uint3
kernel_name: vload3_global_offset
arg_in:  0 buffer uint[7] 0 0 0 0 121 66 189
arg_out: 1 buffer uint3[2] 0 121 66 121 66 189

[test]
name: vector load global uint4
kernel_name: vload4_global
arg_in:  0 buffer uint[5] 0 120 155 52 202
arg_out: 1 buffer uint4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load global offset uint4
kernel_name: vload4_global_offset
arg_in:  0 buffer uint[9] 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer uint4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load global uint8
kernel_name: vload8_global
arg_in:  0 buffer uint[9] 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer uint8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load global offset uint8
kernel_name: vload8_global_offset
arg_in:  0 buffer uint[17] 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer uint8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load global uint16
kernel_name: vload16_global
arg_in:  0 buffer uint[17] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer uint16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector load global offset uint16
kernel_name: vload16_global_offset
arg_in:  0 buffer uint[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer uint16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vload2_global(global uint *in,
                             global uint2 *out) {
    out[0] = vload2(0, in);
    out[1] = vload2(0, in + 1);
}

kernel void vload2_global_offset(global uint *in,
                                    global uint2 *out) {
    out[0] = vload2(1, in);
    out[1] = vload2(1, in + 1);
}

kernel void vload3_global(global uint *in,
                             global uint3 *out) {
    out[0] = vload3(0, in);
    out[1] = vload3(0, in + 1);
}

kernel void vload3_global_offset(global uint *in,
                                    global uint3 *out) {
    out[0] = vload3(1, in);
    out[1] = vload3(1, in + 1);
}

kernel void vload4_global(global uint *in,
                             global uint4 *out) {
    out[0] = vload4(0, in);
    out[1] = vload4(0, in + 1);
}

kernel void vload4_global_offset(global uint *in,
                                    global uint4 *out) {
    out[0] = vload4(1, in);
    out[1] = vload4(1, in + 1);
}

kernel void vload8_global(global uint *in,
                             global uint8 *out) {
    out[0] = vload8(0, in);
    out[1] = vload8(0, in + 1);
}

kernel void vload8_global_offset(global uint *in,
                                    global uint8 *out) {
    out[0] = vload8(1, in);
    out[1] = vload8(1, in + 1);
}

kernel void vload16_global(global uint *in,
                             global uint16 *out) {
    out[0] = vload16(0, in);
    out[1] = vload16(0, in + 1);
}

kernel void vload16_global_offset(global uint *in,
                                    global uint16 *out) {
    out[0] = vload16(1, in);
    out[1] = vload16(1, in + 1);
}
