/*!
[config]
name: Vector load constant half2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0
require_device_extensions: cl_khr_fp16
[test]
name: vector load constant half2
kernel_name: vload2_constant
arg_in:  0 buffer half[3] 0 28 46
arg_out: 1 buffer half2[2] 0 28 28 46

[test]
name: vector load constant offset half2
kernel_name: vload2_constant_offset
arg_in:  0 buffer half[5] 0 0 0 28 46
arg_out: 1 buffer half2[2] 0 28 28 46

[test]
name: vector load constant half3
kernel_name: vload3_constant
arg_in:  0 buffer half[4] 0 121 66 189
arg_out: 1 buffer half3[2] 0 121 66 121 66 189

[test]
name: vector load constant offset half3
kernel_name: vload3_constant_offset
arg_in:  0 buffer half[7] 0 0 0 0 121 66 189
arg_out: 1 buffer half3[2] 0 121 66 121 66 189

[test]
name: vector load constant half4
kernel_name: vload4_constant
arg_in:  0 buffer half[5] 0 120 155 52 202
arg_out: 1 buffer half4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load constant offset half4
kernel_name: vload4_constant_offset
arg_in:  0 buffer half[9] 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer half4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load constant half8
kernel_name: vload8_constant
arg_in:  0 buffer half[9] 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer half8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load constant offset half8
kernel_name: vload8_constant_offset
arg_in:  0 buffer half[17] 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer half8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load constant half16
kernel_name: vload16_constant
arg_in:  0 buffer half[17] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer half16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector load constant offset half16
kernel_name: vload16_constant_offset
arg_in:  0 buffer half[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer half16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

#pragma OPENCL EXTENSION cl_khr_fp16: enable

kernel void vload2_constant(constant half *in,
                             global half2 *out) {
    out[0] = vload2(0, in);
    out[1] = vload2(0, in + 1);
}

kernel void vload2_constant_offset(constant half *in,
                                    global half2 *out) {
    out[0] = vload2(1, in);
    out[1] = vload2(1, in + 1);
}

kernel void vload3_constant(constant half *in,
                             global half3 *out) {
    out[0] = vload3(0, in);
    out[1] = vload3(0, in + 1);
}

kernel void vload3_constant_offset(constant half *in,
                                    global half3 *out) {
    out[0] = vload3(1, in);
    out[1] = vload3(1, in + 1);
}

kernel void vload4_constant(constant half *in,
                             global half4 *out) {
    out[0] = vload4(0, in);
    out[1] = vload4(0, in + 1);
}

kernel void vload4_constant_offset(constant half *in,
                                    global half4 *out) {
    out[0] = vload4(1, in);
    out[1] = vload4(1, in + 1);
}

kernel void vload8_constant(constant half *in,
                             global half8 *out) {
    out[0] = vload8(0, in);
    out[1] = vload8(0, in + 1);
}

kernel void vload8_constant_offset(constant half *in,
                                    global half8 *out) {
    out[0] = vload8(1, in);
    out[1] = vload8(1, in + 1);
}

kernel void vload16_constant(constant half *in,
                             global half16 *out) {
    out[0] = vload16(0, in);
    out[1] = vload16(0, in + 1);
}

kernel void vload16_constant_offset(constant half *in,
                                    global half16 *out) {
    out[0] = vload16(1, in);
    out[1] = vload16(1, in + 1);
}
