/*!
[config]
name: Vector load constant float2,3,4,8,16
clc_version_min: 11

dimensions: 1
global_size: 1 0 0

[test]
name: vector load constant float2
kernel_name: vload2_constant
arg_in:  0 buffer float[3] 0 28 46
arg_out: 1 buffer float2[2] 0 28 28 46

[test]
name: vector load constant offset float2
kernel_name: vload2_constant_offset
arg_in:  0 buffer float[5] 0 0 0 28 46
arg_out: 1 buffer float2[2] 0 28 28 46

[test]
name: vector load constant float3
kernel_name: vload3_constant
arg_in:  0 buffer float[4] 0 121 66 189
arg_out: 1 buffer float3[2] 0 121 66 121 66 189

[test]
name: vector load constant offset float3
kernel_name: vload3_constant_offset
arg_in:  0 buffer float[7] 0 0 0 0 121 66 189
arg_out: 1 buffer float3[2] 0 121 66 121 66 189

[test]
name: vector load constant float4
kernel_name: vload4_constant
arg_in:  0 buffer float[5] 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load constant offset float4
kernel_name: vload4_constant_offset
arg_in:  0 buffer float[9] 0 0 0 0 0 120 155 52 202
arg_out: 1 buffer float4[2] 0 120 155 52 120 155 52 202

[test]
name: vector load constant float8
kernel_name: vload8_constant
arg_in:  0 buffer float[9] 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load constant offset float8
kernel_name: vload8_constant_offset
arg_in:  0 buffer float[17] 0 0 0 0 0 0 0 0 0 116 189 192 64 98 22 43 70
arg_out: 1 buffer float8[2] 0 116 189 192 64 98 22 43 116 189 192 64 98 22 43 70

[test]
name: vector load constant float16
kernel_name: vload16_constant
arg_in:  0 buffer float[17] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

[test]
name: vector load constant offset float16
kernel_name: vload16_constant_offset
arg_in:  0 buffer float[33] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171
arg_out: 1 buffer float16[2] 0 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 185 240 246 145 213 116 228 2 209 132 121 113 5 151 154 171

!*/

kernel void vload2_constant(constant float *in,
                             global float2 *out) {
    out[0] = vload2(0, in);
    out[1] = vload2(0, in + 1);
}

kernel void vload2_constant_offset(constant float *in,
                                    global float2 *out) {
    out[0] = vload2(1, in);
    out[1] = vload2(1, in + 1);
}

kernel void vload3_constant(constant float *in,
                             global float3 *out) {
    out[0] = vload3(0, in);
    out[1] = vload3(0, in + 1);
}

kernel void vload3_constant_offset(constant float *in,
                                    global float3 *out) {
    out[0] = vload3(1, in);
    out[1] = vload3(1, in + 1);
}

kernel void vload4_constant(constant float *in,
                             global float4 *out) {
    out[0] = vload4(0, in);
    out[1] = vload4(0, in + 1);
}

kernel void vload4_constant_offset(constant float *in,
                                    global float4 *out) {
    out[0] = vload4(1, in);
    out[1] = vload4(1, in + 1);
}

kernel void vload8_constant(constant float *in,
                             global float8 *out) {
    out[0] = vload8(0, in);
    out[1] = vload8(0, in + 1);
}

kernel void vload8_constant_offset(constant float *in,
                                    global float8 *out) {
    out[0] = vload8(1, in);
    out[1] = vload8(1, in + 1);
}

kernel void vload16_constant(constant float *in,
                             global float16 *out) {
    out[0] = vload16(0, in);
    out[1] = vload16(0, in + 1);
}

kernel void vload16_constant_offset(constant float *in,
                                    global float16 *out) {
    out[0] = vload16(1, in);
    out[1] = vload16(1, in + 1);
}
