/*!
[config]
name: Test float signbit built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: signbit float1
kernel_name: test_1_signbit_float
global_size: 9 0 0

arg_out: 0 buffer int[9] 0 1 0 0 1 0 1 0 1  tolerance 0 
arg_in: 1 buffer float[9] 0.0 -0.0 1.0 1 -inf inf -1.0 nan -nan 

[test]
name: signbit float2
kernel_name: test_2_signbit_float
global_size: 9 0 0

arg_out: 0 buffer int[18] 0 0 -1 -1 0 0 0 0 -1 -1 0 0 -1 -1 0 0 -1 -1  tolerance 0 
arg_in: 1 buffer float[18] 0.0 0.0 -0.0 -0.0 1.0 1.0 1 1 -inf -inf inf inf -1.0 -1.0 nan nan -nan -nan 

[test]
name: signbit float4
kernel_name: test_4_signbit_float
global_size: 9 0 0

arg_out: 0 buffer int[36] 0 0 0 0 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[36] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1 1 1 1 -inf -inf -inf -inf inf inf inf inf -1.0 -1.0 -1.0 -1.0 nan nan nan nan -nan -nan -nan -nan 

[test]
name: signbit float8
kernel_name: test_8_signbit_float
global_size: 9 0 0

arg_out: 0 buffer int[72] 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[72] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan -nan -nan -nan -nan -nan -nan -nan -nan 

[test]
name: signbit float16
kernel_name: test_16_signbit_float
global_size: 9 0 0

arg_out: 0 buffer int[144] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[144] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan -nan 

!*/

kernel void test_1_signbit_float(global int* out, global float* in0){
  out[get_global_id(0)] = signbit(in0[get_global_id(0)]);
}

kernel void test_2_signbit_float(global int* out, global float* in0){
  vstore2(signbit(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_signbit_float(global int* out, global float* in0){
  vstore4(signbit(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_signbit_float(global int* out, global float* in0){
  vstore8(signbit(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_signbit_float(global int* out, global float* in0){
  vstore16(signbit(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

