/*!
[config]
name: Test float isnotequal built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: isnotequal float1
kernel_name: test_1_isnotequal_float
global_size: 8 0 0

arg_out: 0 buffer int[8] 0 1 0 1 1 0 1 1  tolerance 0 
arg_in: 1 buffer float[8] 0.0 nan 1.0 1 nan inf 1.0 0.5 
arg_in: 2 buffer float[8] 0.0 nan 1.0 nan 1 inf 0.5 1.0 

[test]
name: isnotequal float2
kernel_name: test_2_isnotequal_float
global_size: 8 0 0

arg_out: 0 buffer int[16] 0 0 -1 -1 0 0 -1 -1 -1 -1 0 0 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[16] 0.0 0.0 nan nan 1.0 1.0 1 1 nan nan inf inf 1.0 1.0 0.5 0.5 
arg_in: 2 buffer float[16] 0.0 0.0 nan nan 1.0 1.0 nan nan 1 1 inf inf 0.5 0.5 1.0 1.0 

[test]
name: isnotequal float4
kernel_name: test_4_isnotequal_float
global_size: 8 0 0

arg_out: 0 buffer int[32] 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[32] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 1 1 1 1 nan nan nan nan inf inf inf inf 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 
arg_in: 2 buffer float[32] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 nan nan nan nan 1 1 1 1 inf inf inf inf 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 

[test]
name: isnotequal float8
kernel_name: test_8_isnotequal_float
global_size: 8 0 0

arg_out: 0 buffer int[64] 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 
arg_in: 2 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan 1 1 1 1 1 1 1 1 inf inf inf inf inf inf inf inf 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 

[test]
name: isnotequal float16
kernel_name: test_16_isnotequal_float
global_size: 8 0 0

arg_out: 0 buffer int[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[128] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 
arg_in: 2 buffer float[128] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 

!*/

kernel void test_1_isnotequal_float(global int* out, global float* in0, global float* in1){
  out[get_global_id(0)] = isnotequal(in0[get_global_id(0)], in1[get_global_id(0)]);
}

kernel void test_2_isnotequal_float(global int* out, global float* in0, global float* in1){
  vstore2(isnotequal(vload2(get_global_id(0), in0), vload2(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_4_isnotequal_float(global int* out, global float* in0, global float* in1){
  vstore4(isnotequal(vload4(get_global_id(0), in0), vload4(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_8_isnotequal_float(global int* out, global float* in0, global float* in1){
  vstore8(isnotequal(vload8(get_global_id(0), in0), vload8(get_global_id(0), in1)), get_global_id(0), out);
}

kernel void test_16_isnotequal_float(global int* out, global float* in0, global float* in1){
  vstore16(isnotequal(vload16(get_global_id(0), in0), vload16(get_global_id(0), in1)), get_global_id(0), out);
}

