/*!
[config]
name: Test float isnormal built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: isnormal float1
kernel_name: test_1_isnormal_float
global_size: 8 0 0

arg_out: 0 buffer int[8] 0 0 1 1 0 0 1 0  tolerance 0 
arg_in: 1 buffer float[8] 0.0 nan 1.0 1.0 inf -inf -123.0 1e-126 

[test]
name: isnormal float2
kernel_name: test_2_isnormal_float
global_size: 8 0 0

arg_out: 0 buffer int[16] 0 0 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1 0 0  tolerance 0 
arg_in: 1 buffer float[16] 0.0 0.0 nan nan 1.0 1.0 1.0 1.0 inf inf -inf -inf -123.0 -123.0 1e-126 1e-126 

[test]
name: isnormal float4
kernel_name: test_4_isnormal_float
global_size: 8 0 0

arg_out: 0 buffer int[32] 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[32] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 1e-126 1e-126 1e-126 1e-126 

[test]
name: isnormal float8
kernel_name: test_8_isnormal_float
global_size: 8 0 0

arg_out: 0 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 

[test]
name: isnormal float16
kernel_name: test_16_isnormal_float
global_size: 8 0 0

arg_out: 0 buffer int[128] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[128] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 1e-126 

!*/

kernel void test_1_isnormal_float(global int* out, global float* in0){
  out[get_global_id(0)] = isnormal(in0[get_global_id(0)]);
}

kernel void test_2_isnormal_float(global int* out, global float* in0){
  vstore2(isnormal(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_isnormal_float(global int* out, global float* in0){
  vstore4(isnormal(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_isnormal_float(global int* out, global float* in0){
  vstore8(isnormal(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_isnormal_float(global int* out, global float* in0){
  vstore16(isnormal(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

