/*!
[config]
name: Test float isnan built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: isnan float1
kernel_name: test_1_isnan_float
global_size: 4 0 0

arg_out: 0 buffer int[4] 0 1 0 0  tolerance 0 
arg_in: 1 buffer float[4] 0.0 nan 1.0 inf 

[test]
name: isnan float2
kernel_name: test_2_isnan_float
global_size: 4 0 0

arg_out: 0 buffer int[8] 0 0 -1 -1 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[8] 0.0 0.0 nan nan 1.0 1.0 inf inf 

[test]
name: isnan float4
kernel_name: test_4_isnan_float
global_size: 4 0 0

arg_out: 0 buffer int[16] 0 0 0 0 -1 -1 -1 -1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[16] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 inf inf inf inf 

[test]
name: isnan float8
kernel_name: test_8_isnan_float
global_size: 4 0 0

arg_out: 0 buffer int[32] 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[32] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf 

[test]
name: isnan float16
kernel_name: test_16_isnan_float
global_size: 4 0 0

arg_out: 0 buffer int[64] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[64] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf 

!*/

kernel void test_1_isnan_float(global int* out, global float* in0){
  out[get_global_id(0)] = isnan(in0[get_global_id(0)]);
}

kernel void test_2_isnan_float(global int* out, global float* in0){
  vstore2(isnan(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_isnan_float(global int* out, global float* in0){
  vstore4(isnan(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_isnan_float(global int* out, global float* in0){
  vstore8(isnan(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_isnan_float(global int* out, global float* in0){
  vstore16(isnan(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

