/*!
[config]
name: Test float isinf built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: isinf float1
kernel_name: test_1_isinf_float
global_size: 7 0 0

arg_out: 0 buffer int[7] 0 0 0 0 1 1 0  tolerance 0 
arg_in: 1 buffer float[7] 0.0 nan 1.0 1.0 inf -inf -123.0 

[test]
name: isinf float2
kernel_name: test_2_isinf_float
global_size: 7 0 0

arg_out: 0 buffer int[14] 0 0 0 0 0 0 0 0 -1 -1 -1 -1 0 0  tolerance 0 
arg_in: 1 buffer float[14] 0.0 0.0 nan nan 1.0 1.0 1.0 1.0 inf inf -inf -inf -123.0 -123.0 

[test]
name: isinf float4
kernel_name: test_4_isinf_float
global_size: 7 0 0

arg_out: 0 buffer int[28] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 

[test]
name: isinf float8
kernel_name: test_8_isinf_float
global_size: 7 0 0

arg_out: 0 buffer int[56] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 

[test]
name: isinf float16
kernel_name: test_16_isinf_float
global_size: 7 0 0

arg_out: 0 buffer int[112] 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0  tolerance 0 
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 

!*/

kernel void test_1_isinf_float(global int* out, global float* in0){
  out[get_global_id(0)] = isinf(in0[get_global_id(0)]);
}

kernel void test_2_isinf_float(global int* out, global float* in0){
  vstore2(isinf(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_isinf_float(global int* out, global float* in0){
  vstore4(isinf(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_isinf_float(global int* out, global float* in0){
  vstore8(isinf(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_isinf_float(global int* out, global float* in0){
  vstore16(isinf(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

