/*!
[config]
name: Test float isfinite built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: isfinite float1
kernel_name: test_1_isfinite_float
global_size: 7 0 0

arg_out: 0 buffer int[7] 1 0 1 1 0 0 1  tolerance 0 
arg_in: 1 buffer float[7] 0.0 nan 1.0 1.0 inf -inf -123.0 

[test]
name: isfinite float2
kernel_name: test_2_isfinite_float
global_size: 7 0 0

arg_out: 0 buffer int[14] -1 -1 0 0 -1 -1 -1 -1 0 0 0 0 -1 -1  tolerance 0 
arg_in: 1 buffer float[14] 0.0 0.0 nan nan 1.0 1.0 1.0 1.0 inf inf -inf -inf -123.0 -123.0 

[test]
name: isfinite float4
kernel_name: test_4_isfinite_float
global_size: 7 0 0

arg_out: 0 buffer int[28] -1 -1 -1 -1 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 

[test]
name: isfinite float8
kernel_name: test_8_isfinite_float
global_size: 7 0 0

arg_out: 0 buffer int[56] -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 

[test]
name: isfinite float16
kernel_name: test_16_isfinite_float
global_size: 7 0 0

arg_out: 0 buffer int[112] -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1 -1  tolerance 0 
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 -123.0 

!*/

kernel void test_1_isfinite_float(global int* out, global float* in0){
  out[get_global_id(0)] = isfinite(in0[get_global_id(0)]);
}

kernel void test_2_isfinite_float(global int* out, global float* in0){
  vstore2(isfinite(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_isfinite_float(global int* out, global float* in0){
  vstore4(isfinite(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_isfinite_float(global int* out, global float* in0){
  vstore8(isfinite(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_isfinite_float(global int* out, global float* in0){
  vstore16(isfinite(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

