/*!
[config]
name: shuffle2 ushort ushort
dimensions: 1

[test]
name: shuffle2 ushort2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_ushort2_ushort2
arg_out: 0 buffer ushort2[8] 47887 33359 4970 4970 42572 42572 12198 29176 37314 37314 44087 25173 28869 60733 64938 62167
arg_in:  1 buffer ushort2[8] 35230 56717 64162 4970 53685 1843 48820 12198 60140 37314 25173 43545 60733 52219 64938 1807
arg_in:  2 buffer ushort2[8] 33359 47887 16350 62681 42572 37997 26191 29176 8245 25049 44087 33966 1036 28869 62167 54117
arg_in:  3 buffer ushort2[8] 57327 44106 17657 64821 18430 9874 33273 25811 45853 42505 37098 11060 53955 11344 53260 30562

[test]
name: shuffle2 ushort2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_ushort2_ushort4
arg_out: 0 buffer ushort4[8] 21325 52191 52191 9928 2811 30950 2811 21733 28927 63408 28927 63408 30466 24108 56218 56218 55358 37599 37599 37599 13153 57197 13153 57197 63809 10853 42539 42539 13689 13689 8674 17957
arg_in:  1 buffer ushort2[8] 33199 21325 17684 30950 24337 12446 30466 37288 33754 5027 13153 53632 37167 42539 13689 8674
arg_in:  2 buffer ushort2[8] 52191 9928 21733 2811 63408 28927 24108 56218 55358 37599 50988 57197 63809 10853 17957 37147
arg_in:  3 buffer ushort4[8] 8817 15170 59050 57611 37299 60281 42583 30850 33143 22326 62359 1058 57240 13370 21843 29935 2618 65039 62095 48567 45848 60255 41860 36379 29118 5579 43453 12197 21324 58084 41301 17830

[test]
name: shuffle2 ushort2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_ushort2_ushort8
arg_out: 0 buffer ushort8[8] 18072 57255 1051 59493 57255 59493 1051 18072 33142 18798 10570 10570 33142 10570 33142 33142 61864 58780 19215 61864 19215 61864 61864 58780 57758 65049 56213 56213 57758 57758 57758 56213 36597 61095 1733 1733 61095 1733 36597 1733 64684 64684 43010 6460 15936 15936 43010 43010 22704 5406 17288 54466 5406 17288 22704 54466 36917 6459 6459 15242 35985 6459 15242 15242
arg_in:  1 buffer ushort2[8] 57255 59493 10570 16487 61864 19215 9007 56213 36597 61095 6460 43010 54466 5406 36917 35985
arg_in:  2 buffer ushort2[8] 1051 18072 33142 18798 37611 58780 57758 65049 39263 1733 64684 15936 17288 22704 15242 6459
arg_in:  3 buffer ushort8[8] 32599 53832 4982 25885 49668 25665 10102 28039 37778 27223 53152 18464 10794 15616 56582 31230 40900 1431 12841 60236 64853 46140 53852 7543 5730 24847 15861 6005 19582 47226 44462 25405 3732 27605 35491 19167 13373 19687 46512 15427 3894 1438 10349 35904 35823 57155 62621 41133 18739 48937 13506 27724 27361 24362 16391 38368 18664 19407 37791 7798 24957 28003 22730 50018

[test]
name: shuffle2 ushort2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_ushort2_ushort16
arg_out: 0 buffer ushort16[8] 34386 38959 31718 38959 38959 38959 15914 31718 31718 38959 38959 31718 38959 34386 15914 15914 28718 61000 12548 28718 12548 12548 28718 4531 61000 4531 61000 4531 4531 61000 28718 4531 17479 19598 19598 17098 17098 20187 20187 17098 17479 17098 20187 17479 17098 17479 20187 17479 59805 56449 49526 25879 56449 59805 25879 49526 59805 56449 25879 59805 25879 59805 56449 49526 59986 59986 59986 3445 59986 59986 3445 3445 3445 7979 7979 59986 7979 59986 3445 3445 53229 55847 53229 12106 43402 53229 55847 12106 55847 53229 55847 12106 55847 43402 12106 55847 24680 5759 43807 5759 24680 14382 14382 43807 5759 14382 24680 43807 5759 24680 24680 24680 46571 45547 46571 54483 48549 54483 45547 46571 46571 46571 46571 45547 45547 54483 54483 48549
arg_in:  1 buffer ushort2[8] 34386 38959 28718 4531 20187 17479 25879 49526 3445 59986 12106 55847 14382 5759 48549 54483
arg_in:  2 buffer ushort2[8] 31718 15914 12548 61000 17098 19598 56449 59805 35592 7979 43402 53229 43807 24680 46571 45547
arg_in:  3 buffer ushort16[8] 53804 62017 27342 59793 48333 52381 52003 24818 19118 51925 28877 31174 25697 40420 1815 7891 56260 61191 13502 44848 6054 37862 27528 24733 29455 11733 35923 2301 10129 7763 18140 40757 52141 13175 56707 30430 61410 6076 22648 39610 24469 33502 30756 3885 49010 59381 4080 14905 7883 43046 12417 49116 65530 51183 51052 33405 35675 49934 26100 1107 64932 17811 51526 35021 39257 36561 17597 50504 9161 7833 49068 61912 38396 28715 13767 59013 22103 18981 21340 45720 44251 3189 64911 62924 24978 9783 23369 28704 54801 19571 64641 3948 52437 21358 28196 9497 51735 7637 3250 22213 63363 40004 38160 63026 15421 2072 3219 25826 45313 7319 23567 58931 9642 42011 41858 46905 44804 35601 48227 57690 26754 57174 4238 43815 47887 54597 12397 25776

[test]
name: shuffle2 ushort4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_ushort4_ushort2
arg_out: 0 buffer ushort2[8] 5333 24523 4796 54052 59706 18978 59858 51242 9325 57620 51344 31414 1147 1068 20049 24414
arg_in:  1 buffer ushort4[8] 17133 63146 58981 39533 46367 22903 4796 30386 37547 44126 10536 59706 17865 56179 11825 25246 8898 22611 9325 35123 51344 27336 10852 42875 16322 1068 21476 20168 2045 16749 20049 24414
arg_in:  2 buffer ushort4[8] 38320 24523 28395 5333 23522 42776 42804 54052 23113 41557 38358 18978 51242 59858 15386 23177 33825 20617 48221 57620 40117 31414 5757 58868 51121 1147 40325 24692 11808 32042 46039 30633
arg_in:  3 buffer ushort2[8] 23903 34477 11818 44135 22307 10903 12661 9772 9178 28183 52288 32565 47269 13849 10722 43467

[test]
name: shuffle2 ushort4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_ushort4_ushort4
arg_out: 0 buffer ushort4[8] 61302 30748 55663 43034 19283 60317 19283 46745 34023 32848 3893 21961 19364 9874 29866 37271 2324 23568 23568 2324 26150 16236 26245 26150 57275 19064 32330 48584 27359 25170 27359 25559
arg_in:  1 buffer ushort4[8] 43034 55663 50827 30061 61170 5857 9185 10158 3893 57630 45208 15811 37271 15047 9874 18967 24795 29246 5236 63985 15396 26245 26150 59513 32113 19064 28524 32330 25559 22562 27359 10279
arg_in:  2 buffer ushort4[8] 30748 20693 61302 15127 40241 60317 46745 19283 23885 21961 32848 34023 38838 39848 29866 19364 23568 2324 7601 59240 22423 64642 16599 16236 43381 48584 57275 24846 10977 35089 25170 20737
arg_in:  3 buffer ushort4[8] 64590 9396 61001 61112 38799 4181 51783 46750 3591 36518 29136 26381 10935 31130 20278 50416 58997 15940 10100 49845 39882 34271 64785 57034 64502 22729 29963 62317 7306 12798 41522 22016

[test]
name: shuffle2 ushort4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_ushort4_ushort8
arg_out: 0 buffer ushort8[8] 9298 61480 62656 24449 61480 56457 61480 32604 56273 6857 10558 56273 20341 52084 6857 56273 4695 35896 35896 23727 53707 30533 23727 23727 62547 62547 51489 51489 21961 62547 52532 51489 46509 37775 30680 37775 37775 54499 54499 46509 47993 32112 9427 9427 12175 12175 47993 39617 38342 47603 38342 23138 49041 26598 47603 9677 37791 13839 5891 53994 5891 5891 37791 30160
arg_in:  1 buffer ushort4[8] 16043 56457 9298 62656 20341 52084 23187 6857 30533 23727 10269 53707 23217 21961 43327 35851 46509 56717 30680 37775 22615 55316 12175 32112 23138 26598 41411 38342 2672 53994 27326 37791
arg_in:  2 buffer ushort4[8] 42679 61480 24449 32604 2564 10558 56273 7524 35896 42997 4695 2687 62547 51489 52532 28921 53580 48637 18646 54499 39617 48082 47993 9427 49041 21036 9677 47603 30160 49683 5891 13839
arg_in:  3 buffer ushort8[8] 28578 18981 49283 21502 27997 14433 64333 31279 24638 51203 23933 966 49520 7225 3291 12574 61646 22884 60892 2577 24323 33824 61953 35129 27684 46148 54605 9397 11721 10828 55838 48653 29816 7595 8746 58019 50755 61599 39871 39048 23182 16731 4415 19543 20938 38826 5694 42804 51579 55431 21275 4792 21308 56593 8751 43350 62203 44623 21198 18745 758 63750 23699 30732

[test]
name: shuffle2 ushort4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_ushort4_ushort16
arg_out: 0 buffer ushort16[8] 56244 25843 30388 52776 52776 41516 52776 30388 30388 195 65294 52776 65294 25843 52776 52776 27136 37179 8303 41870 41870 27136 37179 41870 27136 32332 8303 8303 32332 32332 27136 32332 21446 292 3684 292 3684 48700 38371 292 3684 27350 48700 292 38371 3684 38371 27350 12376 56582 34099 51468 59257 29046 59257 12376 51468 56582 56582 62933 34099 59257 8418 34099 34261 34261 30730 44450 25837 30730 2778 19516 25837 2778 2778 44450 34261 44450 15841 2778 47424 47926 36103 47926 14121 47926 52173 39369 30516 14121 30516 52173 39369 22788 52173 36103 32122 51223 10535 10535 22247 10535 31537 22247 10535 32122 53062 53062 32122 65490 53062 32122 20300 41460 32388 30179 5596 44742 56140 44742 44742 7535 32388 44742 41460 44742 44742 7535
arg_in:  1 buffer ushort4[8] 195 41516 25843 65294 37179 25298 8303 27136 34811 27350 16626 292 34099 12376 62933 56582 42975 25837 2778 34261 36103 14121 39369 52173 985 51223 10535 22247 32388 30179 20300 41460
arg_in:  2 buffer ushort4[8] 49963 30388 52776 56244 41870 46098 32332 37278 38371 48700 21446 3684 8418 51468 59257 29046 30730 44450 15841 19516 47926 22788 47424 30516 53062 32122 31537 65490 5596 56140 7535 44742
arg_in:  3 buffer ushort16[8] 8023 48754 13109 34918 350 1113 38190 58645 59709 27384 7235 49078 51323 50034 13062 15142 55515 12224 30082 19132 50084 28451 2488 34908 9883 18030 37042 35298 21294 4854 10147 49862 32030 9003 27503 50219 58287 2813 4076 49891 34519 28041 8317 13611 33532 13135 60452 56777 42753 27259 50080 43173 4494 56359 686 55553 1293 7019 1187 30170 37552 27902 2228 40456 14555 29219 55780 32165 39793 48156 64994 51735 47105 1602 3666 9309 35187 37053 56942 21090 58374 53748 52312 39396 34625 2900 34563 48058 23687 43321 43895 60499 46586 58517 56795 23864 64125 45553 38714 24378 24971 63306 22702 54819 2226 709 61972 20796 31941 31295 58964 61861 52034 17323 53296 8537 2484 47247 33325 43295 21127 55622 43040 32599 11195 57703 3967 12750

[test]
name: shuffle2 ushort8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_ushort8_ushort2
arg_out: 0 buffer ushort2[8] 24376 52857 23173 20548 41526 55609 445 445 28830 28830 31834 41800 52803 21494 57701 22688
arg_in:  1 buffer ushort8[8] 48337 5652 41589 52952 13747 22009 11920 54929 55971 14584 55807 49826 24236 51927 10030 55566 42589 54982 19232 41526 29694 50249 52783 26309 12293 24647 41665 445 64246 49453 54924 51311 63901 56969 16712 59156 42723 34821 21484 30324 23125 9817 50174 23726 62003 22783 26809 40097 50956 20134 21494 6368 21368 26510 14648 9210 38618 45308 61305 22688 10591 57701 26856 55304
arg_in:  2 buffer ushort8[8] 52857 49212 16664 49728 13728 24376 29809 64027 57270 51028 3886 32812 20548 53630 63047 23173 15055 33269 57369 55609 39683 18188 38596 52706 50569 4048 37125 4632 33052 30492 7819 61284 11833 47839 5725 20755 28830 30932 56371 41978 34025 4772 31834 40537 8589 32110 41800 24436 52803 41294 9578 33930 39339 42099 11751 42618 3962 38326 61271 61385 12722 58993 62200 6391
arg_in:  3 buffer ushort2[8] 2189 18232 53823 23164 14835 395 31347 51875 54060 956 45370 49886 18456 62514 7941 28131

[test]
name: shuffle2 ushort8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_ushort8_ushort4
arg_out: 0 buffer ushort4[8] 64689 20885 23777 62900 43742 37860 43742 59320 41827 2658 59384 2658 13455 56727 12050 13455 13582 7769 58576 34438 56714 12332 33141 47795 19157 22351 45480 54822 44853 22984 48871 39793
arg_in:  1 buffer ushort8[8] 49777 35991 23777 55816 62900 4159 60690 64689 11920 3286 45976 21051 43520 43494 60821 48159 16832 52290 54338 19311 7247 53288 41827 7430 62486 59170 18546 13455 20043 53121 15111 46032 29129 1593 48891 3291 13582 48073 46155 5894 55465 35777 47795 56714 12941 12332 20918 45563 45480 54822 15040 56436 15189 9478 39559 22351 50991 19965 54056 30037 37758 22984 15898 39793
arg_in:  2 buffer ushort8[8] 4140 53047 56083 14530 30095 20885 45701 10847 18547 30847 64722 43742 58212 37185 59320 37860 59384 2658 2034 11298 63734 34872 37698 56905 12050 47782 31579 29415 52647 37476 56727 45416 44095 7769 58576 58211 24031 42088 32710 34438 42972 52043 46367 33141 34329 61825 62769 44339 54992 13831 2139 2339 40842 30081 28492 19157 23356 12506 63738 44853 53908 48135 46585 48871
arg_in:  3 buffer ushort4[8] 62183 60173 39794 48308 4507 54303 3307 5246 42678 28505 17224 54057 51523 20030 51768 39891 20036 18009 24810 19615 25507 52309 1899 14034 35935 62119 53552 37729 31243 20949 18815 5591

[test]
name: shuffle2 ushort8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_ushort8_ushort8
arg_out: 0 buffer ushort8[8] 14639 24167 24167 1594 41125 62138 18943 29766 16658 10974 9779 15917 4494 10974 29245 14689 27629 24071 4954 24071 22182 32427 56148 53410 47870 47870 18993 44857 42538 414 43929 57623 23865 24846 16947 46911 50380 46911 46911 46911 5087 1809 31157 5087 28905 33098 1809 5087 28908 697 15412 15459 64280 48842 22414 48842 64292 30566 16986 9486 39047 10357 9486 16994
arg_in:  1 buffer ushort8[8] 48897 49054 40554 33344 8534 1594 41125 14639 4494 7606 27656 16658 29245 52732 10974 35388 19156 53410 4954 27856 22182 62496 202 18572 44857 43929 57229 43268 59750 42538 43656 1704 24846 30988 50380 22513 16947 51853 4848 6207 53185 33098 60632 31157 6575 53760 53916 58143 7467 50739 27857 53373 54931 2640 64280 28908 16994 10357 9486 9092 46666 9179 5558 10323
arg_in:  2 buffer ushort8[8] 24167 40863 18943 62138 31519 27068 29766 42484 47475 9779 33236 65106 14689 15917 16346 51380 32427 40613 24071 36600 62007 56148 27629 64988 57623 49990 414 18993 47870 36755 13248 29162 2451 32988 23865 40011 22551 25679 46911 36926 5087 10877 59653 7449 1809 11309 1547 28905 17381 3397 46755 22414 697 15412 48842 15459 16986 43992 30566 5434 3818 39047 64292 61960
arg_in:  3 buffer ushort8[8] 7543 5192 55720 47173 53686 23003 10810 26574 28515 64598 22889 14813 13056 57350 18804 2988 20078 26074 33154 40778 28948 62120 42317 37073 20348 9388 51083 1440 64341 30554 7777 5256 51882 12160 64708 44046 60642 48974 41518 27038 5432 2700 27491 43464 40991 29809 61116 44296 43319 20556 19741 19903 43926 28366 49419 46014 56062 47994 48632 43922 205 1441 5138 49456

[test]
name: shuffle2 ushort8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_ushort8_ushort16
arg_out: 0 buffer ushort16[8] 27446 19271 50227 26691 32167 12747 31574 31574 50227 13924 50227 38746 30879 31574 21400 13924 53707 56031 27027 47934 34657 11683 27537 54894 60479 54894 60851 34657 51934 9280 47934 47934 51215 6049 8642 49545 49545 51215 34673 16774 10516 8642 49545 3019 16774 46040 3114 51215 61717 45781 32615 56560 32615 26262 45781 51088 54702 40849 45781 45781 61780 61717 61780 61717 39534 38486 20505 20505 24992 65056 47507 20505 47507 65056 44003 15813 44003 21879 21663 20505 10670 29807 29807 644 61645 16242 13122 30716 14392 9155 644 2334 34810 61645 10670 644 34311 32146 54277 16464 6040 540 64529 10482 540 32146 29469 6040 16464 23480 16987 44812 33876 14987 59524 14987 53566 10943 53465 10943 52324 53465 11079 53566 39878 16207 26292 63338
arg_in:  1 buffer ushort8[8] 50227 21400 31574 30879 38746 26691 15539 1472 62014 60851 34657 51934 34442 53707 57239 56031 46040 12113 6049 34673 34611 12218 55449 59860 45781 38460 56560 32615 8797 61717 10986 40849 65056 21663 21879 41319 38486 44003 40877 24992 29807 52488 19893 30716 14392 644 9155 10670 10482 23480 64529 34311 6040 16464 54277 16987 10943 39878 33876 63338 26414 11079 14987 49599
arg_in:  2 buffer ushort8[8] 12747 35102 19271 26423 53657 32167 27446 13924 60479 27027 27537 9280 51892 54894 11683 47934 8642 51215 3114 21324 16774 10516 3019 49545 65094 54702 41758 19639 26262 12235 51088 61780 43175 49250 15813 39534 47507 2357 20505 16259 2334 34810 42035 16242 31466 13122 61203 61645 64484 30706 540 32146 37419 44812 29469 43570 52324 16207 26292 22174 53465 8476 53566 59524
arg_in:  3 buffer ushort16[8] 3662 18362 816 24101 15357 59672 41634 58274 33664 2847 29520 54084 43555 38066 32769 61327 31765 57159 57081 34543 50114 43502 25226 13373 30376 61117 19777 5554 29571 31547 55183 27935 54441 8466 1448 54367 53007 62345 21667 56364 18877 24504 23135 10798 14156 6496 35130 24969 7653 38336 6019 35778 2547 38284 23872 40782 56985 34407 768 37808 30287 60469 21519 60421 5099 50084 63950 14526 36631 43472 4492 61550 39452 3712 24165 14474 26933 60242 25201 16798 40583 53408 6976 22805 35983 64971 5645 64035 55332 39254 3573 33640 32489 47839 23319 50933 22979 57851 44790 47781 47412 47178 47762 42320 19850 8315 46 51524 3189 57665 30631 57197 50194 38166 51903 31830 42382 61376 2748 60688 39704 12588 1605 57726 51601 41881 35034 2643

[test]
name: shuffle2 ushort16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_ushort16_ushort2
arg_out: 0 buffer ushort2[8] 65059 456 60755 36101 12297 52845 53724 50405 27620 56103 1379 36353 36457 54623 26596 26521
arg_in:  1 buffer ushort16[8] 52477 15743 51258 46648 456 58048 43434 10498 1017 35348 10300 63652 3574 28679 30578 47360 57774 6967 1781 6403 34416 49662 54119 53088 27566 40144 2540 28883 20490 60755 46565 63183 27095 52410 44181 12297 27366 8186 7449 58953 30065 13220 43954 21894 18433 64007 33048 47194 1563 14927 30956 61147 56902 61421 58027 6058 50328 15945 58715 8709 42925 53724 17879 23544 22427 45222 56929 27075 12519 53584 39519 55189 27556 3637 31267 12299 3555 46464 60550 24687 42921 1476 34764 16954 19339 37465 8120 26641 36353 6680 37027 34033 10013 10899 49279 53792 65425 48213 36457 13455 21452 40296 1066 20691 52003 31070 55747 21959 54623 19734 15571 58061 46172 39819 22474 2011 8101 52749 53500 42944 33879 57852 46996 14961 44890 50543 26596 25799
arg_in:  2 buffer ushort16[8] 48208 732 48810 45143 25914 32277 45209 19565 49779 11730 52594 63516 24613 52204 65059 53730 36101 5275 23212 54220 14492 54467 29029 23254 51806 48101 65186 3836 21603 63997 46167 9504 42344 29039 4942 38389 5303 56393 34435 47136 8616 42977 11832 5080 50706 12061 52845 59317 27824 47266 3524 51648 58436 50405 25642 4748 30764 7252 38171 37560 49718 60523 43651 54229 50142 14855 53823 59576 38241 61553 27616 781 35917 53032 27620 56103 8540 41004 53103 62477 1362 51261 59321 30682 1379 21868 31736 27445 64088 38482 61803 31893 12366 25105 29958 48670 28252 60008 47861 40814 16594 11852 39601 34362 37727 52438 14478 63321 61133 55426 48009 9396 52583 34272 15894 34211 5731 36038 13213 9015 29620 58920 17393 50256 26521 49038 61375 34230
arg_in:  3 buffer ushort2[8] 45502 17508 63821 21776 37763 19902 3053 36373 49626 17115 5108 50856 51362 2476 25454 43964

[test]
name: shuffle2 ushort16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_ushort16_ushort4
arg_out: 0 buffer ushort4[8] 64365 64365 50976 42479 15516 9830 23092 21959 48876 62368 48876 14016 17854 63531 8467 46803 61460 48581 20349 10210 54859 412 19242 53488 10683 52402 59840 62668 46056 53059 38176 27584
arg_in:  1 buffer ushort16[8] 45836 50976 50353 42059 35827 29240 64419 42244 39306 41436 23971 1877 587 33409 22132 4584 15516 49821 23092 21959 63932 15063 37776 25024 35302 18037 46873 27386 17083 30282 7793 28811 49814 7631 34530 58564 63028 41424 48876 62823 62368 14016 40317 13023 32936 5946 15259 8120 6305 8467 60901 42876 62812 44984 61935 37953 57872 42801 2106 54665 51741 6233 17854 62821 26723 37920 33308 24862 63234 47075 45743 64077 54375 24090 13051 53447 61460 8199 26234 33754 53602 27591 15497 57278 29653 60305 29623 33339 2408 39791 53488 50446 45092 40928 412 30476 34062 52402 28259 8997 46865 96 17881 57488 42630 395 10683 7448 35785 50186 57550 49895 57567 20379 15261 1890 54561 44133 27584 34824 47144 42149 58028 23620 6419 59807 39152 29205
arg_in:  2 buffer ushort16[8] 42245 27542 62732 42170 63316 5430 44881 64365 46253 32813 39586 58267 42479 13686 12150 17838 33150 61887 35750 11544 9830 23609 26015 43374 23473 28414 33589 50048 25326 12171 34038 61269 4402 42396 22642 18515 59724 26462 32313 54203 2896 24012 20818 32982 14827 2274 36582 49459 3543 1119 4541 24483 29267 25602 8083 33765 63531 54089 2531 14401 46803 32716 20485 30747 10210 8225 58707 48581 5712 49120 20763 55432 20349 26582 24620 63046 40453 65409 2235 65106 50933 38544 54859 25802 37983 10347 50930 39615 2434 6688 13533 2164 12625 19242 3030 38786 23043 6294 29195 18892 59840 7586 47986 39942 60684 32479 46375 50646 42793 62668 9721 31293 9903 59873 5381 25052 34090 12874 51515 46056 53059 38176 49137 13745 4203 11698 28979 65235
arg_in:  3 buffer ushort4[8] 887 54967 26977 30204 36224 46900 5858 42819 15782 3752 47014 21833 28046 42840 40769 4188 32364 32275 65336 14768 60978 36398 42845 33066 32074 4545 60116 43421 54903 60824 21721 63526

[test]
name: shuffle2 ushort16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_ushort16_ushort8
arg_out: 0 buffer ushort8[8] 57076 13725 27572 13725 52302 39273 4208 38556 30076 4014 18969 48957 48836 12175 57494 29204 26480 33681 58837 15366 2036 57884 58837 10333 22774 55106 24759 1415 5933 53113 1415 22774 48394 48394 61388 4130 13010 51908 61388 45140 59734 59916 58737 59916 65001 25945 1326 8074 21617 58960 6581 11431 3964 37238 7219 37238 22014 41968 39400 17828 57676 51346 7180 12085
arg_in:  1 buffer ushort16[8] 13725 31459 43977 43691 48872 55264 44330 8834 39273 17990 48008 30780 64914 18176 36696 10983 18969 42698 12175 36216 5516 2018 60837 9843 7450 46070 4791 54080 34997 4014 61770 30076 10959 2036 25274 44093 48957 21118 19004 50096 4699 58837 15366 59989 42590 7853 22380 37020 22241 24759 32205 53120 19200 26002 45054 60996 5933 22056 48851 53974 14515 16328 54977 48302 61388 42826 13010 46889 4130 59806 48394 38809 17838 37458 15530 54108 13717 11845 22983 14194 25914 23709 32737 53365 39341 40188 419 59734 8074 25945 59818 60666 4024 11663 17926 48329 54425 36851 20899 7219 41191 42121 39877 20266 38294 21617 45257 20548 29827 64232 3964 58960 22014 33093 52767 3933 53531 9714 22231 51346 12085 14911 25923 54491 34387 19053 36411 65533
arg_in:  2 buffer ushort16[8] 23289 52302 26552 38556 52225 25949 3481 8445 60960 47788 27572 52074 57076 4208 12138 48906 26515 28112 48836 61246 29204 64564 9597 25107 48957 47955 50575 57494 31655 19679 12833 50602 56205 40883 46550 57884 30201 35514 47838 48026 27105 10333 46636 16708 9561 33681 26480 13716 6914 55106 45946 55188 22774 21699 35336 2945 31846 62443 1415 53113 11474 30928 28812 50882 60672 32288 22157 46742 20199 18550 43676 22492 50406 45140 45740 41050 51908 20671 57679 51051 16648 59916 44122 24357 6155 4995 58737 34178 30839 16144 1326 62231 65001 29898 31438 17129 25061 37238 6508 50911 6581 59691 53840 30877 11431 45350 41966 32661 25167 60136 10950 13818 7180 21986 41968 63261 56332 60554 18632 9092 39400 36303 57676 19774 17828 44498 37409 50879
arg_in:  3 buffer ushort8[8] 62588 41536 58714 58944 22673 58472 54653 14195 53391 18221 2880 25752 26866 18658 32347 60180 48734 24125 29865 53578 50337 42323 24681 53433 12468 25329 48225 33146 50280 475 26810 6292 62374 44262 40384 45476 19746 56668 35680 53817 21543 23921 53622 7249 61052 29961 40666 39176 16937 26895 14356 52248 26318 9297 55555 36753 28832 39122 50072 24092 2170 61671 55344 11688

[test]
name: shuffle2 ushort16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_ushort16_ushort16
arg_out: 0 buffer ushort16[8] 16541 49042 33429 57228 41358 23849 18516 53357 45776 58333 41062 21109 53357 877 15173 16541 3807 48463 13150 5983 31770 54890 18997 6683 29793 13150 21772 23398 31770 53422 21544 21544 5223 23851 63719 63719 39218 6467 25387 20439 7615 5299 23851 16260 8087 24764 5223 6467 22187 12297 44213 12611 38766 11511 23265 54070 11511 60251 13824 40535 45553 30981 1202 37003 47097 21796 16962 39567 44145 4417 39567 45584 44416 36881 55188 13820 52149 16962 44145 64797 56619 53265 40866 28888 17993 9230 49939 37275 35546 43649 53265 41343 60032 27164 27557 51465 40265 15261 7848 52343 44410 28162 7848 25844 53859 25844 4745 20479 43069 49299 7848 2316 59519 31315 31530 30350 29804 31315 61503 29804 59519 5197 59167 30350 61503 21332 12615 18429
arg_in:  1 buffer ushort16[8] 59044 21109 18516 57228 53357 877 1192 37614 43976 41358 41351 12075 32251 34011 45776 33429 20873 22138 29849 18997 38109 65533 53806 58608 19989 6683 48463 6334 43852 13150 26807 3807 20439 39218 7615 32405 715 16260 8087 20610 1306 63719 22882 18282 38787 38962 24764 45517 12297 45553 5279 44213 11511 2729 43107 38766 33545 62819 23265 23770 34692 58712 13824 9740 60614 46101 37976 17953 39567 44416 11155 39455 47097 44145 50361 6873 21796 21476 49246 5877 37275 7236 54795 43649 27557 56619 34241 27164 21599 60532 31810 41343 54588 6249 133 29792 53859 61766 32441 44410 31778 43069 34111 39684 49299 40881 20479 15261 55730 2254 51300 40265 12615 8935 31315 21274 43184 48497 82 57113 59519 14768 21163 59755 5197 29804 31530 21332
arg_in:  2 buffer ushort16[8] 63879 48411 10591 36402 23849 62093 13685 15173 58333 18536 49042 41062 50332 15676 16541 46186 62121 31770 53422 58258 5983 4368 23398 54890 21772 53919 21544 53017 8335 36163 29793 19091 27558 59771 23851 65171 29365 5299 27304 4454 35683 5223 6467 47713 25387 58472 27418 14758 46215 37003 26395 30981 22187 12611 54070 46568 60251 40535 38199 19268 7685 1202 8387 55367 48753 59460 7280 55188 38361 52149 22454 24644 59027 4417 13820 16962 36881 64797 45584 58440 39812 9230 28888 49390 49939 43475 35546 51491 17993 53265 60032 51465 37641 32156 40866 25809 4745 21556 2316 46981 49831 19880 28162 52343 24729 1928 14031 12700 25844 15773 7848 54264 34389 18347 18429 16908 30350 46760 61503 58642 46170 59167 48719 18330 37358 30747 48756 1581
arg_in:  3 buffer ushort16[8] 61790 28346 22575 52931 12905 5076 9954 13348 37486 44728 45723 10657 53412 12389 21783 64958 35311 27242 49133 16116 57233 4599 14627 58601 65022 22061 55160 12118 35313 38482 2234 21658 43577 43826 35817 64233 25857 58874 25852 65504 9282 9653 36658 32101 63078 45518 32697 12250 42676 63072 17987 43957 25031 64868 18218 44470 27972 14424 27918 49625 59809 19155 61917 34065 1384 3788 27003 18468 31881 42681 30436 24990 58149 38108 62099 54874 31253 40027 30985 49213 10789 20793 9150 50866 44824 10545 1076 4064 18358 49891 37881 55115 25658 58791 14084 11963 21295 15115 46878 31991 40131 46166 25566 5020 51104 22268 37104 59818 21349 54728 34494 11090 38408 16642 16910 22228 50541 5762 55222 40557 12456 52812 41305 3412 37846 23951 4512 1938
!*/
kernel void test_shuffle2_ushort2_ushort2(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort2_ushort4(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort2_ushort8(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort2_ushort16(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort4_ushort2(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort4_ushort4(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort4_ushort8(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort4_ushort16(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort8_ushort2(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort8_ushort4(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort8_ushort8(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort8_ushort16(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort16_ushort2(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort16_ushort4(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort16_ushort8(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ushort16_ushort16(global ushort* out, global ushort* in1, global ushort* in2, global ushort* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
