/*!
[config]
name: shuffle2 ulong ulong
dimensions: 1

[test]
name: shuffle2 ulong2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_ulong2_ulong2
arg_out: 0 buffer ulong2[8] 27093 51817 18675 18675 41963 57367 62258 5836 2722 40896 44048 7044 17025 17025 28113 33830
arg_in:  1 buffer ulong2[8] 51817 27093 38953 57565 57367 12467 60071 62258 48184 40896 12924 6816 41545 6029 20850 33830
arg_in:  2 buffer ulong2[8] 40353 35324 18675 4909 48873 41963 5836 9603 2722 47217 44048 7044 17025 37560 61380 28113
arg_in:  3 buffer ulong2[8] 12592769647516435209 12200984684047856532 8961169214799470646 22694293089128274 10143761696570808215 5815237291568664232 7699774777871509717 541655885059096654 17694747746286030414 10711297385898437545 6473830676540560750 5358928585262981759 13906802967597145310 3453008597055359406 3795029889503057095 14984357154698950633

[test]
name: shuffle2 ulong2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_ulong2_ulong4
arg_out: 0 buffer ulong4[8] 2087 2087 1880 11704 30526 30006 38040 30526 38073 29932 29932 27566 62140 5745 5745 5745 4980 4980 4980 33419 7682 49449 13700 7682 45456 33409 33409 40107 915 915 9414 915
arg_in:  1 buffer ulong2[8] 3651 1880 38040 30006 27566 38073 62140 2047 52202 4980 49449 13700 40107 33409 915 47900
arg_in:  2 buffer ulong2[8] 2087 11704 33903 30526 52691 29932 3447 5745 28455 33419 53407 7682 57334 45456 45564 9414
arg_in:  3 buffer ulong4[8] 4830124841743837234 13940879090224390862 1465750026922664101 14454942839982326283 3888005572196644627 1215268920130782877 10428267079494226672 13141345950509744655 17913820263986749913 6141913490529994131 10005870021981159611 6125766777564213556 5813663808337075972 9584154861350142835 7388006186641055263 10495124372996598263 10708834154689265953 13182572734327164593 13151560501306485001 17801213103941728431 14575163053587440087 565538731341713928 9837894199243599405 6215134275280438095 15011603222770605223 3872655829926002173 10850398857027387017 15498940773108520960 8180133487931545748 5567113197781062580 6900992116134610495 11549311723119341300

[test]
name: shuffle2 ulong2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_ulong2_ulong8
arg_out: 0 buffer ulong8[8] 25129 54357 54357 2267 54357 25129 20053 20053 13169 32148 32148 9080 32148 9080 9080 57716 24840 8257 8257 8257 8257 40210 64173 40210 54693 54693 17125 54693 50373 54693 17125 57066 22920 22920 52326 34745 34745 22920 34745 52326 32013 52333 32013 32013 50749 27853 27853 52333 23918 64989 23490 23490 64989 23490 23490 23490 15837 46711 56107 56107 46711 15837 15837 9755
arg_in:  1 buffer ulong2[8] 54357 25129 32148 9080 40210 8257 54693 50373 63018 34745 27853 50749 23918 34728 15837 9755
arg_in:  2 buffer ulong2[8] 2267 20053 13169 57716 64173 24840 57066 17125 22920 52326 32013 52333 64989 23490 46711 56107
arg_in:  3 buffer ulong8[8] 10716481121570843425 6058768215876661584 4194405318588881684 17360696264303488638 11186604614144263044 15792087145663502073 18439336425591370639 13763605629690358607 18140861206341717770 8211749721898299588 9008679667467495960 1623235192414791109 16352856995633802972 14730575531107293349 6207732223676681741 17343006973367841279 13566880200986922547 4413849884930973265 9879040565370671001 6773322530363022273 18367708215435685893 9493012989170718492 18046388619566027726 7313453599791613612 819740839708465828 5887326541934961740 6616688893763247627 12447297747343250588 3848037020808240433 5552167967209330552 3834533963014337943 12275451407819414030 18264671850219415598 4275922390862878862 6215608190384518247 8813831569320072049 14189819708994056825 13802897463605888190 11403500339265359889 8467617756982433563 3795831239351406654 13149783959065621543 15844974672703738334 7261008222344948546 7944378205598126481 10817349533904126228 2378595085103338772 869754018820985355 15235903050682925188 17168725970911892550 18316492513418612163 14847885050131645399 12264727119635796794 7061871565751832503 11976631878392322315 3882072933178505743 1273545816859836224 17087693019694961550 7414748785279381147 16607886585011401507 6875842529101095834 3454232439438220056 8127814932007054316 1443281011373731713

[test]
name: shuffle2 ulong2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_ulong2_ulong16
arg_out: 0 buffer ulong16[8] 42390 42390 40554 17850 40554 40554 60891 17850 40554 40554 17850 60891 40554 60891 42390 40554 21510 21510 44013 38511 50620 44013 44013 38511 21510 38511 50620 44013 50620 38511 38511 21510 10305 46325 29301 10305 41463 10305 29301 10305 46325 41463 29301 41463 10305 46325 10305 29301 2203 40057 55529 2203 2203 40057 2203 43726 2203 43726 2203 40057 40057 2203 40057 40057 59259 8863 8863 24135 24135 58477 58477 59259 24135 24135 8863 58477 24135 24135 58477 8863 64476 64476 9473 64476 36873 36873 36873 9473 55951 55951 64476 36873 9473 9473 36873 55951 16263 16263 16263 47710 16263 47710 47710 16263 26370 16263 1946 47710 26370 26370 16263 16263 18803 13095 13095 13095 41227 13244 41227 13095 41227 13244 13095 13095 18803 13244 18803 18803
arg_in:  1 buffer ulong2[8] 42390 17850 44013 50620 10305 46325 40057 2203 58477 8863 36873 9473 26370 16263 18803 41227
arg_in:  2 buffer ulong2[8] 40554 60891 21510 38511 41463 29301 55529 43726 24135 59259 55951 64476 1946 47710 13244 13095
arg_in:  3 buffer ulong16[8] 17048713076281468244 17014890297578561704 17413575008496022890 13459251364516850049 13547614282046894550 14167206859355449898 15794123229587527499 15517995681037009873 12960583131235252690 17801194597955983530 15880646043504628041 16368786994703434803 8126204786265284374 16941827667805332335 9980415642415801452 6322283353769419626 9569329418476134362 2525376844555536530 10253205005322538000 2430981092951281683 16840225574042158057 11069705680178335432 5411166670669095180 13763874763845878219 18140626104412867578 9173583350274145571 9874673745418404541 2954951079825617172 10880593817939527941 3172446517786911123 8111117579251301539 982363493765926786 528240096556705852 909391194369828229 14237850247111185491 1132400920043096044 9298754633253156186 7114226351482394024 14121056452496611035 8579417666791683788 3375490544609488177 10674855673384170050 3724838658171985859 14990848686056044506 15549085512297099036 15189669696789192637 1895388804946077904 14334549713236069479 9097279811993964349 15783397611412760916 777612968652117690 9422399751630439677 5692033298648061513 18193769931760132720 16833244969517807721 6738953629061828723 10910982291300196113 2906362265880617283 5003339808499925301 6070082640135228968 2857011348927179532 5548439425942006589 13614920653681197888 938697302302302892 10230306662545410591 15809337352833409873 1955702876789607457 908277256609564502 15143691640103190590 16170600866140385964 169676077462556768 7703504622393469767 8962563156997748154 4387328391986027890 18339134797668920405 7070472913717258836 4586315879950773218 5947320642591547738 5903885364663054440 8414186206330962425 12930107163679611107 7926368783042421323 11974225530737456653 12131035245704525767 2490236156698900748 18217936078193565600 6252736588851969592 1604716668848784261 12572261244534121926 12579267219894373498 15638862381730385727 3977846668897574504 4280373328831028489 9304606518457631433 11878931678225679620 1012093134998649214 16692344728729243973 17657247064923671517 6888343816319725553 16986363313084348455 7959479495979539593 13205446480363166427 5709710609004242931 4670182886130175233 10196954440010614692 590832626576651733 11798964964506711602 11481783374340459011 17950707041248257368 13118267706865136520 2051937080365716761 7426467569698181125 12498711904231488928 4506185176582745203 9125530002855562527 4231959917807429283 3904368479340319265 14085218071315452330 4784176717427269349 14221853622635204635 2654542843855399509 2062563100853358646 14432187459734225635 3929314823275973519 53303251914400028 51385612377172826 2711043095116723480 14819216094541507692

[test]
name: shuffle2 ulong4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_ulong4_ulong2
arg_out: 0 buffer ulong2[8] 23018 25415 30041 53855 50537 24139 6838 29294 62170 8236 22522 54306 1708 62598 34127 41773
arg_in:  1 buffer ulong4[8] 23018 25415 2883 46598 48970 56159 30041 5174 4074 13873 24139 7435 43188 58197 12986 29294 38363 53921 54657 7943 34975 58832 51690 13030 62598 52324 21365 49722 15915 43525 28814 52393
arg_in:  2 buffer ulong4[8] 9356 34316 23096 47466 53855 57292 2933 55780 15096 50537 49351 42263 6750 3739 17464 6838 8236 11372 17716 62170 20995 1925 54306 22522 47456 1708 9303 22159 7301 34127 41773 50112
arg_in:  3 buffer ulong2[8] 17882840245590751088 8329498406370242057 16492070056258030594 14578706989694348988 13671271449246168781 138382997334894594 11798437120518721239 14938918738574759579 3261925657290656559 11401488860740821844 8854718590946269471 7360446559676717710 14932051148022392709 10801784779072544608 8749720809007741997 2799192869700087718

[test]
name: shuffle2 ulong4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_ulong4_ulong4
arg_out: 0 buffer ulong4[8] 1771 20205 44567 28369 42791 46117 57211 40143 39237 10074 52068 52068 11737 13794 12899 39404 19534 57639 44373 52368 10437 10437 10437 26217 7050 60600 16047 60600 6462 62210 8776 30659
arg_in:  1 buffer ulong4[8] 25742 24838 44567 28369 42740 57211 40143 46117 26399 52068 36740 39237 12899 55704 17481 13794 44373 57639 59899 16826 27488 26217 50287 5537 22755 16047 65364 39686 21753 6128 31208 8776
arg_in:  2 buffer ulong4[8] 1771 55284 20205 30695 39530 1615 42791 43113 56298 24182 47201 10074 4124 11737 4909 39404 19534 53755 12037 52368 39804 10437 56213 9069 50173 60600 7050 35244 42667 30659 62210 6462
arg_in:  3 buffer ulong4[8] 458207808877350716 17862035214399690110 17964221445848648386 94610614994046819 14072646118499989830 12987593788125056531 1566759124849467833 353023232587263098 10341792214329329243 3193840740191552455 2101665313365405273 15156011121004936833 4441600950252678629 7216180037915289995 9197920884320199784 3102917173382991015 5571210440099111636 2588586422237262129 11016239925972241536 15260749871476424631 18244851296889925213 15571748555532821325 148183202021701253 2568557571079562937 7213485379276592262 14858473278212945301 11304259085272619153 2980717184814596765 3544019191370337111 9465714406269622542 1883353104612143499 5727817684854539869

[test]
name: shuffle2 ulong4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_ulong4_ulong8
arg_out: 0 buffer ulong8[8] 41249 39788 41249 65169 54054 31741 39788 39788 24994 47529 24994 16386 39135 4915 27180 16386 56880 57027 52226 41260 57027 13419 13419 19172 5448 36900 36900 18774 4184 5598 5598 44276 4178 9915 4178 29574 14573 5798 5798 4178 54099 22423 34367 22423 30118 30118 22423 54099 3274 49064 49064 54853 20613 54853 64069 54853 58208 58208 2336 8069 29282 52933 58208 59086
arg_in:  1 buffer ulong4[8] 56101 54054 8992 31741 16386 39920 39135 27180 30064 52226 56880 41260 18774 414 5448 36900 29574 35794 59525 4178 36023 34367 51415 3157 54853 41258 49064 31468 59086 2336 15402 58208
arg_in:  2 buffer ulong4[8] 65169 5969 41249 39788 4915 47529 57600 24994 57027 19172 12418 13419 5598 4184 44276 47033 9915 14573 5798 43698 30118 52787 54099 22423 20613 3274 43327 64069 8069 29282 52933 37907
arg_in:  3 buffer ulong8[8] 12257102401123493606 1210837045473683543 820593537499032398 9579054653068855316 6699351344142760577 3817588920019291299 7260764299464719719 6889184847281294911 8692710686273887207 9332630492245881221 7960832300774529679 13953429421106435168 15978000310613325826 15488345185352837788 704069224913081387 13150687534769572928 17010742209561217018 16876903292294959924 13254764393616731681 16219206613671907627 10081870241092898836 17137130826756277191 2143454543408446047 2228791131699019781 13566517884945646490 6958412560162470763 15006487154542943539 9636708054237855496 17774800870273469285 17225617196621156420 7323187242250643444 243180729330599190 3242400425708953747 10643926093895056620 14452086959946967315 8976176612377400952 13290475407842086389 8823496731715010246 5391691136841189134 10556546796260972427 3037585359799022470 7176621881495663887 4653074146017269225 5965408263653310895 14989148055194448516 18404083257688249260 16928415027155796151 9667279711760143846 2245275276021079429 8462274927322043290 14000725415648203730 14850013149901638160 3628264714451491316 16622145441217309032 6620973079204224255 2120438522914993080 9102499825160882955 16085695654044025299 15665241508319653025 13199848613491150588 8818346930814599253 6325126536174860278 5903477377321733499 18394171324555494688

[test]
name: shuffle2 ulong4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_ulong4_ulong16
arg_out: 0 buffer ulong16[8] 53808 7642 53269 37717 37717 32391 48889 16265 16265 7642 7642 16265 53808 58106 58106 48889 12265 61972 11381 32302 29525 11381 29696 29696 61972 11381 23574 29696 12265 11381 23574 34082 63970 58658 54458 28461 46737 52378 52378 16311 14092 58658 54458 63970 28461 16311 52378 16311 11154 18671 51553 47872 51553 18671 47872 31944 58743 18671 31944 58743 11154 32059 47872 58743 9722 26343 22057 20973 20973 20973 369 61683 369 20973 9722 63852 61683 9722 63852 369 1276 62968 55702 28180 31676 31676 55702 62968 6690 31676 55702 31676 62968 55702 7119 28180 54226 48917 50064 50064 50064 18924 33535 18924 50064 50064 62760 48917 18924 48917 62760 54226 37641 56963 37641 12632 31330 10270 56963 10270 12632 20092 12632 31330 12632 20092 10270 20092
arg_in:  1 buffer ulong4[8] 53269 53808 7642 48889 12265 23574 34082 32302 54458 16311 58658 52378 47931 58743 47872 18671 369 61683 9722 20973 62968 7119 55702 1276 33535 41641 18924 54226 31330 12632 4206 20092
arg_in:  2 buffer ulong4[8] 32391 16265 58106 37717 11381 29696 61972 29525 63970 28461 14092 46737 32059 51553 31944 11154 22057 26343 63852 62912 28180 31676 6690 19049 50064 48917 65305 62760 37641 56963 35481 10270
arg_in:  3 buffer ulong16[8] 10459310947571670553 920679783843460882 8261051949221752856 7861526012606726583 13376715810620212999 8835392035896558436 17241273144204553339 13038001878865019765 11581933714314278885 16794135701726209738 13728201146938649114 17833724154982104893 8703094893574694649 7455843070611564246 13675049192066958918 2134812624811950523 14033268717471656096 2104589340436577414 6088791337982711684 2250606374204106827 4261153293981725167 4065039118835765220 17901723769136131013 6327442169459305245 5287861867746195918 6914449722653869300 15295933471095044057 11371108940501289893 13674396591636923640 15098288762824423340 9281608673237717057 8926768468700213850 11195518151246503852 1429334011110807978 15370708257804477584 11155529246932962373 17121491032151179167 1145856272329592595 15192964706876197395 14423554537905848697 1295025895481493894 18398048852508145658 17712966534850677528 17227414538348062028 18440624194881375709 13362389644026187649 18173159908042919843 10080949098578861737 17381955142394872343 16924162629818191195 8733027423834131797 16698580875892356666 17541024572219476069 1145061982834527667 13802407669465193346 8598639049550632038 15294869438840353489 7259953713694250675 9242465921354908558 3037607752697746417 6200225332937163407 5767903404250627228 4321706084776107530 14277149542979146033 14702846650551854594 13088703196898316669 4290962140632157060 8905227114811888155 10582796560828889899 1567918798640811011 11780641382770414112 5161102495388911545 2119375034217797240 810707639575412411 2600986321456459178 17354300968303492222 12607142333642496217 16034052729261135898 13988393707526527566 10694473424358164688 14592181094140307651 10971142911561207584 3123231427971028922 1066038597347797540 12690602855867864893 11974648531953228237 7852643240432938970 5332334391845487784 3443051016143003886 1967091024918418221 4699001258117489298 17028206432411357517 2581411662231874264 13712140413291876354 3744452152422751457 11278052418351211604 16538557478777426923 7269496715331110189 6676034378525018924 298254958503500188 6202350796244166276 8822172478868997410 694317031070680440 8814192001335247954 7703435240973308324 3720567238565855244 189071109574907151 10681219581016201821 504864644744495930 3988773919912686557 9470622836287461199 6372942441953180075 18095950987086458716 2086105813036985349 17631791747832776340 9332502283496561041 10191320026254800768 17578811566198225519 6656238642343640781 8935895157507267767 10642920878345617153 4835624358453197179 14733899945983372713 8708723654171868560 12216562068347832137 8911275954689326219 14508471061230611951 5471610780521256043

[test]
name: shuffle2 ulong8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_ulong8_ulong2
arg_out: 0 buffer ulong2[8] 47448 26549 33711 64525 54578 5779 6074 19985 40736 54076 55223 51419 61154 9436 49952 17891
arg_in:  1 buffer ulong8[8] 53784 61673 18410 56032 8134 41393 30674 49482 60862 64525 496 38212 36918 35785 20644 29445 5779 14244 54213 9857 54578 46394 3769 22264 60969 54570 19985 24649 2554 22540 32821 60504 40736 29625 54076 4419 8523 19900 15718 1220 26372 17631 38246 62187 47488 57957 20227 55223 9436 61154 54365 2646 48839 44327 29124 30394 29504 29847 49252 5385 11616 54017 41585 17891
arg_in:  2 buffer ulong8[8] 18672 47448 27864 26549 9912 49776 54218 54733 41876 34421 28919 33711 755 43740 50883 23932 27046 35449 10082 2647 40077 62943 9555 40379 65063 30175 53077 49609 47427 7672 6074 31933 60992 47499 38301 57074 36297 3439 28981 42371 8535 52301 51419 37796 60371 56559 64528 9847 64455 64495 38139 23457 8385 55404 686 29506 25150 15489 36816 49952 10782 19987 622 59947
arg_in:  3 buffer ulong2[8] 15280936611384389545 14661195828350926923 15472895691434328555 7240747756050496625 4493707982790461348 4968252625154637536 17061289320420223422 12005320815425762242 9040718317917662112 1296656526709284098 16791736217900259207 2479722667816507290 14443192493764697425 7015392294619334288 4609893514398129147 10065232258114145095

[test]
name: shuffle2 ulong8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_ulong8_ulong4
arg_out: 0 buffer ulong4[8] 48330 52448 48330 11970 28506 28266 8506 28506 7685 28167 34540 7685 55503 26523 65240 55503 47508 11745 12818 575 13345 13345 24935 65040 19519 40585 61529 13626 4157 33231 11565 11572
arg_in:  1 buffer ulong8[8] 52448 11970 4512 34801 48331 37211 28128 36333 28266 8506 27197 4921 31342 52628 35901 53530 18985 34540 9825 39680 15819 41683 10949 570 53644 47577 17612 1476 45407 56814 55503 48238 18335 58785 7560 12818 54158 21372 47508 13778 24344 18759 3156 63526 8626 65040 7089 44511 37339 61529 7144 690 2961 4814 11778 58057 33231 3840 4157 11572 21039 6613 33847 27746
arg_in:  2 buffer ulong8[8] 8733 36347 36845 36091 48330 32299 6838 36656 37821 28506 35792 54739 1307 9833 32968 45066 24983 18636 7685 32083 30018 61144 37329 28167 26523 3578 26867 65240 12021 31180 12176 14983 575 48943 11155 32152 44620 11745 54713 9404 13345 54375 27757 39551 17197 24935 2553 64671 32300 55352 42183 25261 40585 12271 13626 19519 13377 11565 14559 38148 6311 37488 5535 52644
arg_in:  3 buffer ulong4[8] 1057701866207947164 10153318484107698960 9999549862127167388 1356651237123508465 1382478198696275705 3598691537388021248 12175454370712164657 1468816706508020313 4575206315030275610 12329481218715829967 9199599397304150209 3131454430835929450 6402006666059632790 12322569238901196552 17757322840898672155 9587204784180289462 5438157286045327846 8214700479368621837 17640820019991041923 6881743864780665976 6447645300700768600 3733984364849777656 128520809995785741 17558016970660454949 3540855945412153023 2779347565191926348 1615240385297655329 11399190706589177550 2480415763406673986 3354758238222393296 13369835410137782505 2592999585829285267

[test]
name: shuffle2 ulong8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_ulong8_ulong8
arg_out: 0 buffer ulong8[8] 38547 60296 291 62979 15154 4706 47317 8276 56374 44123 58712 22929 43282 44123 57897 47052 32701 2709 37639 1641 11773 18241 45717 25548 35933 64105 31457 1252 10723 9841 4040 39558 12120 46689 59708 16389 21686 12120 39060 21686 30153 30153 30153 13063 12663 12663 5647 20018 25651 53849 28002 25651 45828 21768 27277 27277 46520 48049 64821 3112 7042 11981 50596 37434
arg_in:  1 buffer ulong8[8] 48746 291 18784 48537 38547 19435 62979 57702 61751 43964 58986 44330 47052 47143 57897 56374 2709 63862 12537 37639 11119 32701 45717 1641 10723 64105 4040 35933 28172 19475 31457 61233 64729 9562 46689 12289 16389 12120 55720 59708 20018 58351 5647 52666 13837 6978 38975 13063 18956 849 62999 21768 36280 18300 36126 28002 37434 47927 61140 46520 52771 11254 7042 64821
arg_in:  2 buffer ulong8[8] 15154 60296 4706 4032 8276 16109 39096 47317 58712 43282 22929 11781 63774 44123 32503 23094 33248 30463 25548 10754 18241 8605 1520 11773 24734 9841 40017 1252 53101 16450 62534 39558 14266 19902 19565 10866 57475 43313 21686 39060 3490 4714 56605 1752 59102 12663 6591 30153 27277 15641 4954 45828 13782 15889 25651 53849 11981 48049 14863 4476 31834 50596 3112 8351
arg_in:  3 buffer ulong8[8] 13795386466885658004 4454330983554632505 7571575106730584785 4546200301122133894 7151174747042411688 5614111154638800410 8549254627398013919 8326800979712579036 996658983737318615 10272911228006226621 10709284695646238536 10569006878303495546 15283252047410874217 17911018564025072125 1125363859423060278 2372321069296882724 9130158003787777013 13837551542505063056 9238983149149210083 7750077959475124647 5894569945886497407 9632582336067697132 9477307342151926566 5855636411889668714 1957256560110969667 14450541025052673969 9090388797537106614 15412904779781171675 14423744732989146064 13989797572764055449 4561161685674097138 1353912845700759791 8892655146003311989 70048926995438546 9569618920006641511 14430518208828626884 8685912666075535790 4642183713036977957 10419781120515031471 10346292265062647470 17972354813857612143 1300584417252503487 2190181208162049647 11330445982473986823 16930747485213683341 15067478820903075917 11099265687148667938 14453367586964672976 12670064484938602926 12922568612897588063 2867703596670157079 18379710995448982014 17880048253961884219 2036360219447579171 13480378822232796168 11687437679750088408 14010989652557718595 17838570357627442073 2350173984533200679 13456734497624897966 12593769277895266022 12438211097342235624 15406083259888133101 10535806607633251360

[test]
name: shuffle2 ulong8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_ulong8_ulong16
arg_out: 0 buffer ulong16[8] 62054 52838 10253 15815 11432 17747 19827 15815 62054 26358 50136 15815 32391 15815 11432 62054 32274 26644 22770 36845 65423 29292 29292 32274 29061 28482 29061 36845 44213 22770 22770 28482 30456 51465 49829 30456 11830 24564 30456 1746 1746 1746 51465 27316 11830 51465 1746 51465 21994 29858 38088 33286 9127 54694 18806 38978 407 34741 59649 38088 59649 34741 26568 54694 55227 38250 6406 6406 17595 31314 3788 17595 34818 55227 51853 3788 6406 37595 32971 55227 48203 48203 36644 25163 36644 25163 54969 19149 44017 48110 26139 44627 25163 44627 48203 44017 26914 62991 39908 26914 21507 26340 19403 62991 21507 42537 40239 40239 21507 21507 26914 28889 13828 20508 11747 20508 27867 11747 27867 27867 46098 46098 30245 30245 30245 11747 27867 51700
arg_in:  1 buffer ulong8[8] 62054 52604 10169 17726 10253 51128 46933 26358 44213 26644 35090 65423 21637 92 36845 37514 2736 49829 31630 24564 62846 30456 20981 20423 34741 21994 33286 5891 64342 38088 47370 18806 18838 6406 55227 38250 14433 28373 17595 37595 13827 25163 34964 44017 23859 36644 48110 19149 19403 47681 62991 57942 31307 27750 40239 39416 20259 51700 48665 29402 27359 27867 20508 30245
arg_in:  2 buffer ulong8[8] 11432 50136 32391 15815 17747 19827 11610 52838 2131 29061 29292 22770 28482 32274 34546 7166 53911 54671 1746 27316 30382 51465 11830 16707 59649 9127 54694 7912 407 29858 26568 38978 51853 3788 20715 30146 31314 34818 32971 32060 44627 50347 49433 48203 26139 39080 54969 47784 42537 26340 12541 26914 28889 39908 21507 25512 33816 1598 26869 11747 46098 35609 9995 13828
arg_in:  3 buffer ulong16[8] 10428439589802687808 15511635127758922911 7063019311636520836 15282891083546613179 18257283695111542392 1379541501321400204 2739846539090242605 11642088402237018891 12528891426030864352 60914493273260311 13305972027636738857 17040977779085709659 6455608044960144394 7120456562608624427 2184568812466929272 2514992446987401024 4864947537203534765 15566708367589801089 15480280223818869067 4893539513663324902 10570821350647438115 7213530861311179082 16014051903126131450 5295024106069424477 6001020924099847209 9364277683664923676 1394926810864657577 15663167403475550886 9892699885449288688 1841930628165515819 7915679048556101707 13675771341783568476 3664022533760926325 12161639851205950061 11587497930432377329 13493578978201827365 8155912692598524238 7111815276539375411 18143207741625956853 4009254318318009210 9390269136893414618 15016250460417872666 14422153554091586589 17403883047985407195 2530067578736832206 13498782565995062557 11240008387728108058 946692550254254333 2754901276744922161 10238039523767478333 495227818612223077 13207857237132634402 1514714486034589801 18300860978105536266 1299766290650785511 8861148181765886735 11321245714884505772 13882832822858544208 7716140073109586360 15917557978210521493 7197076092580986664 9823697520871031968 12154460299846625214 1028114354146047530 4605641540148289170 3425275321951502387 3471341869814606193 14463481255530578161 11817674648513056454 1049140509219552764 11451065459123918745 15208014775756701414 6780705459522713773 3282628975617172082 3474010643921565848 11212972809408416265 18397760478716555809 1331037151546228231 1562174657866470526 17578387099681944498 14197797731476078267 6297485827259181195 2943093784212319653 3411980659790963105 167069991717610261 12073040778778310177 2540218676559135246 9779026322853273447 7769658619744197939 11167008242664328902 12777947090870762668 1637428413504873208 14947819828798885217 2027662529182192936 17020963360784896411 425917510087525923 5818645019260506667 6992093707065045362 9436620979475940397 1828523016483294715 11426866210948721262 1720498829740212553 16480988497413346352 10704498091425151666 10583168180253616846 4260071725551469256 18365106667477595862 3225553949125843622 16392663222474320238 10326265120320406366 15073653161162564027 5591301509018159276 17771964453340244735 17447833834076605622 4571724810303503835 537676513928910102 17898827429720844453 1969110643145703243 9851760183014568805 8671457642672331189 10489144383413752332 17755040285561965340 18397112919491531335 11606321731060034727 14775042476624278599 3226929485771026395 3620830238031634965 8141576921682087889

[test]
name: shuffle2 ulong16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_ulong16_ulong2
arg_out: 0 buffer ulong2[8] 11483 45307 9170 61706 51317 27161 22440 2929 25382 65075 10134 7280 42250 969 61142 13240
arg_in:  1 buffer ulong16[8] 30055 37081 39224 21943 1759 62704 32362 11483 42607 17278 31360 20716 26778 50782 65152 51258 46514 41693 62981 65185 3623 5352 10159 38106 61706 45449 51584 11033 2238 29971 13840 12668 41153 3459 45327 1263 48225 7879 25793 8922 46027 43867 20898 54610 46083 50391 36424 27161 47393 48867 46206 13687 30949 56773 36850 44140 12350 29766 54523 3077 60813 46885 40230 36254 63827 43976 22947 40124 37101 29396 14501 65075 32275 5772 25830 41579 832 2313 54188 5320 10134 1807 5537 37130 9275 29194 7461 33383 62579 59411 20206 54583 55988 57548 65106 7280 15016 1073 39066 39204 5051 52051 10012 24514 17809 63702 57074 54093 5427 62181 11519 969 1399 4773 19324 58717 43692 16917 25587 13240 14323 39451 36446 5750 35333 35111 46801 25968
arg_in:  2 buffer ulong16[8] 45307 49181 14271 54209 24712 13535 44342 9603 9194 15536 2836 18186 3503 54568 57224 14949 19015 25064 9170 43572 41308 56586 39876 17645 41705 24716 36657 10405 32264 57403 29979 20782 30831 7847 26804 48017 42340 5946 4206 51317 16228 11887 23882 2172 52496 22391 1144 43869 10631 58123 15034 2929 50560 38270 6798 23492 26854 23672 47405 49983 54780 40191 22440 64213 22833 12228 6077 32951 10495 11555 35494 17769 7035 27879 14583 51233 25776 25382 60404 724 50303 28552 7047 40254 7617 17870 17830 22658 18542 55537 18345 6436 30767 36030 51100 58730 12737 20125 26936 3704 34490 54091 42250 28870 33205 60259 36917 17481 25687 30641 45218 62442 51707 28994 31952 6928 61142 62087 29294 64045 1763 46172 64658 4291 11062 1359 46701 7576
arg_in:  3 buffer ulong2[8] 3891005064231738311 11725722624255302128 8655650565039743442 13422394011309945224 8700131991264140887 7028998091422775919 17177090022642370238 2105491578220283859 17847253679143660861 11571083424211402535 17771458658215841792 12301287152961477807 12462468356234790486 15093926816615490639 12715252709596804212 12967742863790996039

[test]
name: shuffle2 ulong16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_ulong16_ulong4
arg_out: 0 buffer ulong4[8] 2423 11902 26154 20833 40857 40857 34139 38336 53194 25170 47195 16633 24040 42534 49864 42944 30385 6381 30004 1928 27693 53248 45811 19597 31717 54407 2800 27330 57987 47663 57987 57987
arg_in:  1 buffer ulong16[8] 695 65184 30010 653 20833 9743 38674 25076 16627 49123 1069 46614 2423 11902 1566 36923 43461 43472 38336 29980 4530 40857 38472 50256 38398 9988 48587 34139 37335 28455 62645 37852 1044 53194 25170 11615 48302 57200 46602 51277 19321 38896 1704 51646 44333 10256 43248 27467 45214 15765 17757 58884 15472 43083 14451 19486 32446 61845 39948 65508 61384 24040 1254 14128 6381 49536 30004 62455 10484 309 34601 10222 11255 46646 41685 11950 51133 1435 48872 11411 25741 58583 44972 52976 31384 13267 56123 25574 50711 17074 19597 53157 52556 51662 27693 32072 16883 36076 38052 20554 51359 2800 29973 32723 28326 43487 14323 31717 54537 24820 55874 18112 49244 10886 59687 55629 31068 30087 57987 45631 8376 31313 37637 19439 61875 23790 44837 2431
arg_in:  2 buffer ulong16[8] 26154 58868 18027 48641 59853 22689 42475 15231 21746 25001 30749 12259 17680 47011 44112 42271 55184 38061 17703 53896 19215 21527 37313 39227 51966 1901 54460 26330 4996 61409 54550 23738 54915 323 62002 13710 23244 42653 438 47195 51492 63850 39712 11224 48299 46409 25371 16633 12337 36818 26029 52012 49864 6980 9121 43238 42944 44684 57829 50182 35964 42534 63676 52093 30964 31472 17598 10410 19441 732 30385 36058 1928 40719 16282 26015 56552 40791 58170 21643 47463 32101 63435 44670 1360 52365 53248 4846 7865 32995 3879 54104 45811 23025 63268 42172 62041 46754 30946 64129 54407 2929 347 34262 29546 28605 54654 29813 27330 43553 42009 59100 19511 42722 45357 4537 35082 38558 47663 39862 29367 27525 60319 52305 18841 24167 56696 41226
arg_in:  3 buffer ulong4[8] 3000328792957171468 8467452067951825485 7873602430802912112 1590540545114519812 591545200092528581 1233828271565893733 9719850709467794027 13366785289764309602 1852049112137242113 5302575471165973506 7176823638344295127 17186247508656023039 2339902190963787693 3250140845372395997 9552451271181874900 12534321163652091160 14974911452378663062 10355924682014139200 708171624070492962 8014430501030398520 8567329056413916334 4358515642032129942 14625335349816445628 15903868596160279146 8062505522184423787 2187100621794656756 7238691229462586661 16253741191485602492 7566609633923491014 7169337293073333270 14275977644522608198 3507827619405363750

[test]
name: shuffle2 ulong16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_ulong16_ulong8
arg_out: 0 buffer ulong8[8] 7261 57183 63306 13471 24444 4218 22830 22605 55491 21543 21543 35197 57414 33214 21543 6444 57360 6256 43190 26396 57531 5842 6262 57531 1501 63843 60461 18524 4718 55864 28851 31128 25195 63714 8071 43994 55321 62401 564 54544 53119 3645 41297 36255 49963 15743 29384 43036 19926 12422 21838 35309 28677 3098 60476 14560 44962 47560 45949 44962 11138 59161 5232 43016
arg_in:  1 buffer ulong16[8] 7261 36288 41530 19519 10784 24444 24557 9054 45441 54090 57183 4218 22830 50545 54738 56694 42566 27944 57414 39198 18482 38219 45298 6499 55491 49119 21543 33214 51038 21281 6444 39665 31658 846 25658 57531 43190 55843 27625 26396 24009 31141 62530 31866 5508 564 29383 5821 42535 51160 55767 47605 18309 60461 10215 55864 44477 18524 1501 47732 13652 41681 38830 9256 21334 31305 63714 44559 8995 27144 25195 20820 54544 40677 55321 6665 40992 61241 818 5752 63022 47091 53119 30023 12411 33263 41122 59707 6488 17428 32665 14080 42235 15743 43036 10867 59405 28241 18809 23092 19926 60476 12510 21454 21838 63677 28677 14560 12422 15336 24268 27732 45330 59161 12038 44962 58921 32669 29478 966 46498 30361 50372 43016 46522 9416 11138 53603
arg_in:  2 buffer ulong16[8] 13471 39483 62132 14505 38492 12609 24608 35832 50678 63306 59045 22605 50291 61912 59437 54841 49456 26492 46759 50479 22589 64528 35197 62147 50277 43938 2016 43969 5713 64230 5127 47008 32420 58513 15745 57291 9046 60787 21880 53626 50997 64446 5842 43119 6256 6262 57360 4651 28851 8608 36178 4718 34640 32871 37676 63843 9106 2236 40301 31128 39599 48984 40362 20570 53975 3516 564 62401 11031 48963 8071 40115 27044 43994 57226 51897 7522 54595 39398 60827 47766 29384 52062 21355 12165 4173 51645 36255 47766 34533 12193 58232 49963 3645 41297 58426 8321 50612 42231 1428 3098 1085 42192 20555 20552 18157 34151 55347 29775 35309 60674 34669 55919 13708 56757 45949 22726 24158 5232 50201 61063 3094 42732 34629 41370 46364 64218 47560
arg_in:  3 buffer ulong8[8] 8953544751981054112 4514803587200261354 914382918325615385 14072894476096099248 167956420194802629 8606645283001060203 4374067091285283628 14669887638032369883 9950325511332161224 4822518508546610250 3792866374874085962 17741072552542175894 17276411200917941410 12090294324336931211 5837559181898454314 3013258972871617966 4088727220497176766 5038690860744729084 10311306481356141668 13111622952458426183 2522475467658447619 8853569319302523482 11676229864117172829 10121788570700011907 14456221465526679786 17972493628152440439 17027088354469915397 5993098105352107849 10016163015535847955 5873041946061679847 10480654689311313232 18269405685109120731 16662582684697113414 8881515434245848194 13222245499739011158 15714233817153458649 15249309114263959594 4870726769313294035 8004229967022084978 15405675079504530568 12526831070179514594 2555393505251330077 15877410733706010814 8880480563735124087 16605104743223013052 13011895492922114541 10199594347300280401 17042969825823236334 15007866636167048452 15275466861782213036 17745723543129794440 3492642541873187453 16462739205962365130 13529663781363678516 15224388689402330629 16447396965215849131 6855950638005323011 4979605132056413887 2039462250269257139 8521814628237340451 12215939165369445326 8203155077287466113 13702051896781745046 9461360802967374187

[test]
name: shuffle2 ulong16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_ulong16_ulong16
arg_out: 0 buffer ulong16[8] 2315 37993 14810 48134 48134 22570 53698 46333 23449 22065 2315 14931 62983 4530 47632 23449 58270 58270 65143 28004 28004 30018 56372 56372 14068 30924 60516 30018 50285 30924 30018 14068 25313 48659 48659 9842 4570 11814 64953 12691 9842 50212 2606 52433 43592 4570 11814 12691 61560 7531 49287 42884 21218 40438 15075 62608 12927 63679 13456 7531 40438 49287 17263 1124 51553 49917 36312 23392 57208 7636 40873 31364 41218 56898 53682 5334 63379 7636 40873 20638 35046 18557 60879 4431 24565 41315 5100 24040 4273 5100 15894 2730 17694 18557 46413 60053 50298 22114 8635 25185 58403 64506 38389 36496 13811 21804 64506 52979 38884 33599 25185 64835 27083 27083 46384 6097 46384 27083 57284 61433 6097 38618 46384 28929 2772 61433 16292 22378
arg_in:  1 buffer ulong16[8] 40588 47025 62983 23449 23796 53698 22065 14931 48178 47632 56398 6837 2315 37993 22570 62222 29564 64680 47641 56372 65143 41578 60516 28407 43121 52281 30924 57084 59569 58760 29069 6816 19364 11685 50212 43012 11814 2201 48659 58280 4570 34361 55747 36871 2606 52433 34498 48482 7089 13352 1124 16856 46266 57391 49568 63679 16380 58654 42884 50202 46076 61560 17263 62608 44828 65277 26769 20638 57208 63011 24321 11659 65465 7636 41218 56516 53682 51553 36312 22370 53233 16641 24040 4441 59454 41315 15693 34126 2414 35046 17694 39689 39710 46413 42195 8688 30768 13811 22114 15176 58403 33650 40617 49918 64835 55766 21804 31362 52979 8635 61308 36496 47175 21836 25556 44669 61433 46295 38165 27083 23491 20689 57284 36220 44364 46384 14917 6097
arg_in:  2 buffer ulong16[8] 40854 46333 46787 35313 29279 58228 14810 53010 55496 48468 60098 4530 6545 48134 48223 23440 60315 29443 58270 1322 45952 59790 42962 50285 52168 64973 30018 28004 35556 14068 21464 3353 48173 25313 9842 23250 56370 21138 64953 18262 52556 12691 11170 21293 64917 59618 43592 5487 12927 53240 44859 52521 13162 49287 7531 61343 63485 21218 20229 15075 3603 40438 13456 7681 40873 63379 42989 2805 5334 28070 30640 31364 56898 49917 3746 53470 23392 57513 9714 36473 54311 60879 26232 2730 2793 12018 24565 22133 4431 4273 15894 18557 5100 43524 60053 21461 64506 38884 54762 25185 28650 55008 28252 8865 8818 64852 34511 38389 33599 54610 19204 50298 38708 32128 18475 54783 33840 60261 38618 22378 3234 4172 28929 18331 16292 2772 62987 25261
arg_in:  3 buffer ulong16[8] 13014351496484425836 946491070678841645 8661409697228334710 15250392818773115965 794974396682123357 8770843100096605166 4041407825683881285 8905569508421830609 4143954542161156099 1477527249076099750 1547459152809096812 15762422546420940359 14857859254791706722 5994475652647505627 2944358255617751177 17858166549977517315 6632875031251792914 8732820175818153650 14472422498731698308 6207084758827016155 15256382589210769723 3646488679130387034 6996747175214027843 9016369236591643619 5867781256346952029 223447725214560938 10429398271341561478 5828239607201852954 7341823454015479895 864536435097632874 10983658729868488666 6319549158526833085 10024227033656902545 5393514063527524262 8904245697635505030 7753949156901886418 11833609325366745928 13092822799539562212 17563455182044792278 18445366123964585561 7714267721613926258 483429776650970274 16578142786634557420 6510084787045353261 14902756296580752734 15092163709065901128 9388865827747190340 4804373128194358041 12480180028999426541 18138243004947560726 9030488299066152565 16644385737291338538 7847901867619018713 898319801200042749 4831484076988360539 285984833429315183 3035025618899612720 1243805782394643079 6519292120768641758 5578952443863628246 9961531787879337341 15613431655634466197 3424580165731461294 1140061315796271522 2195436277442898221 13474824898330390137 14523797596721097582 10983393380199771196 7990370882198255748 1849041888135155945 5417501706544332112 11242875776878882839 3364861330551823498 7589644392462756664 12781561836982206188 7673332121669473012 4292296767739322097 5242894283147913001 7787172463079935184 2137586577310782115 16831614271402781353 17896462226337105851 9978712734099416817 17242352846280429112 16239143066745181814 14974572181716550277 6832584778118279868 12694684169602581794 8629118581639657785 4008353131435393116 6139737733971925530 5270920195213363699 1314690214330123530 4106401628314220987 5675508000099853805 15422545735734316254 8387440860862224319 8594747595133754626 11506425289220292685 2487513783473775699 13475435539123675012 5637227362632019472 16000209927366989659 2906034956946416623 4899840289964489217 1529230468953188138 719517471508953584 16157484246982156172 2963195155882860625 8690053741401357948 7174695887893316243 2770248236084705928 4281390329995638759 703856833045201895 12801370238323161453 4307485960719324911 7070249210444417613 1161770709997024519 11627495354702191978 8047717189892173924 15146836795088805071 7291489145355164470 5683826929896707309 8314675740594927354 3980348189232346557 17027746806008488900 14295758947781315292 8909053168984794039
!*/
kernel void test_shuffle2_ulong2_ulong2(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong2_ulong4(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong2_ulong8(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong2_ulong16(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong4_ulong2(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong4_ulong4(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong4_ulong8(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong4_ulong16(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong8_ulong2(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong8_ulong4(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong8_ulong8(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong8_ulong16(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong16_ulong2(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong16_ulong4(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong16_ulong8(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_ulong16_ulong16(global ulong* out, global ulong* in1, global ulong* in2, global ulong* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
