/*!
[config]
name: shuffle2 uint uint
dimensions: 1

[test]
name: shuffle2 uint2 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_uint2_uint2
arg_out: 0 buffer uint2[8] 39958 27545 30325 23388 55339 1385 16963 16963 32933 15827 41523 41523 10707 48184 47680 47680
arg_in:  1 buffer uint2[8] 27545 7103 59626 30325 1385 5004 12322 55543 15827 32933 43612 41523 41768 48184 1939 47680
arg_in:  2 buffer uint2[8] 39958 30129 23388 16971 918 55339 56994 16963 17477 63243 10744 17184 10707 3540 18504 11128
arg_in:  3 buffer uint2[8] 4124103066 2247830080 1715196765 2540081342 293923335 4240667904 920453623 1654150143 2854206177 740426488 923819129 1326632833 2741140174 4273957549 3194086681 885303797

[test]
name: shuffle2 uint2 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_uint2_uint4
arg_out: 0 buffer uint4[8] 13246 3881 48964 13246 63655 18713 58573 63655 64988 31282 31282 12879 45873 45873 45873 45873 25500 25500 12353 48171 53767 58765 60703 53767 59282 59282 55776 5890 62561 53742 62561 3922
arg_in:  1 buffer uint2[8] 44537 3881 2293 63655 12879 64988 31218 52063 12353 48171 53767 58765 8194 55776 3922 53742
arg_in:  2 buffer uint2[8] 13246 48964 58573 18713 31282 11261 23584 45873 25500 4928 19876 60703 5890 59282 23339 62561
arg_in:  3 buffer uint4[8] 3810693790 3722453245 2779900467 2541497850 3254715713 1727623931 3500914762 2283763689 1466865653 2560035342 1878982842 763965428 1293917323 2534775771 3116949639 1131714591 3936452318 3349577254 4106320304 4041832333 2579463412 2668168037 3523645491 750331784 2945489911 2000283291 2833145345 608127370 4170738731 3653200461 1048073015 619442980

[test]
name: shuffle2 uint2 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_uint2_uint8
arg_out: 0 buffer uint8[8] 29026 29026 6573 54565 54565 29026 6573 6573 37790 37790 60421 17122 34050 60421 37790 37790 25892 12161 25892 18643 12161 25892 18643 18643 31947 47317 63428 24132 47317 47317 31947 47317 33857 6888 33857 33857 6888 52675 52675 6888 45071 62775 62775 45071 61645 61645 62775 62775 50861 60992 60992 52642 50861 60992 33009 60992 10958 41317 17584 17584 52136 10958 41317 10958
arg_in:  1 buffer uint2[8] 57387 6573 34050 37790 18643 25892 31947 24132 27763 6888 62775 45071 50861 33009 41317 10958
arg_in:  2 buffer uint2[8] 54565 29026 17122 60421 12161 9689 63428 47317 33857 52675 61645 23799 52642 60992 17584 52136
arg_in:  3 buffer uint8[8] 1971611575 3893850011 2186128749 3980278290 1065139170 621803595 1461598997 3379517649 3430270837 42681857 3908920579 3424013514 1407339976 3129339155 1083768521 4278600457 2367695897 3152522094 3955256253 3419575652 2284083558 442578117 2789609212 3810762076 865860516 2362519279 1863891310 2034583825 1361288799 1568395139 3851199704 1451268167 2274947962 1346611565 3184551818 2983107186 470261541 2765059575 2864671647 1253570449 303994893 2998559948 2125803980 4098295149 959716634 1649786170 956870764 211168316 2000162088 1998069851 1516183179 3401356422 2681337240 3143373187 1607060937 2335047103 3681507705 2020308776 4209564342 1604274650 3704683663 366290385 2616920548 1627408261

[test]
name: shuffle2 uint2 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_uint2_uint16
arg_out: 0 buffer uint16[8] 48837 13012 13012 22756 48837 22756 48837 13012 48837 13012 48837 48837 52704 22756 48837 48837 53892 53892 40195 53892 47393 24631 24631 47393 40195 40195 47393 53892 40195 53892 40195 24631 64309 64309 50948 40494 11184 40494 40494 64309 50948 64309 11184 40494 11184 50948 40494 11184 4194 25902 53293 53293 4194 4194 4194 4194 4194 25902 57915 53293 57915 4194 53293 53293 32167 55150 32167 55150 32167 18678 32167 18678 7826 7826 32167 18678 7826 55150 7826 18678 56688 51391 51391 56688 51391 6833 56688 56688 6833 51391 56688 56688 51391 56688 51391 51391 4158 4158 46600 46600 52034 46345 52034 4158 46345 4158 4158 4158 52034 4158 4158 46600 23719 25774 36717 25774 25774 28557 23719 23719 36717 36717 28557 25774 25774 23719 28557 23719
arg_in:  1 buffer uint2[8] 52704 22756 47393 24631 50948 64309 53293 57915 32167 18678 56688 6833 52034 46600 23719 28557
arg_in:  2 buffer uint2[8] 48837 13012 40195 53892 11184 40494 4194 25902 55150 7826 60417 51391 46345 4158 25774 36717
arg_in:  3 buffer uint16[8] 2806083786 2009824555 3369830879 2745370701 896129842 3994662985 2077206398 2124219363 228224982 1342534031 2217915638 2810607114 1996355620 3048202941 33804670 1596131370 2883009779 1471254191 2235407646 1878644835 2933383624 4050689829 3645950385 256588080 4029532494 1522657934 2141641676 677619195 1085542862 786264927 1650519290 4069265549 1716071257 3873334617 3911987148 2224327207 2470881698 789234191 20788755 567837273 2270901920 2623020913 3084329314 2010230823 755581602 1783943700 4230432563 4103559006 3697818914 3972938307 380231968 2825397768 2179123526 3857627810 2278960346 2161484986 740783126 3448135735 742337041 1726154236 2898793717 2523192754 3688047836 4243254348 2659519420 1609161698 3513383104 2544400354 2319788560 4120374121 1859267868 1714531357 3159652835 835607271 897889824 1394368893 4263675391 3771694842 3566551311 3850769137 3177711128 2658743203 1385676831 1253374072 2601062471 3577973809 3041917952 1242909740 2110788937 133927967 1600420308 2039300516 2541278955 3606110304 23671019 584865611 159117911 3669337807 4067963073 1493773833 2410167044 4240407590 2234852440 4086464183 3905593234 2218658019 1678965867 1582025879 649474528 3214920011 3167227751 3626777517 3207247144 3616874666 994008915 2587750294 2816482094 4259182145 2437726220 2192071544 1306841179 2166200215 3303474233 1151593734 2489662426 3615292816 3844896469 2715541520

[test]
name: shuffle2 uint4 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_uint4_uint2
arg_out: 0 buffer uint2[8] 1228 20985 37131 48534 21222 55565 18198 18198 39604 26409 56891 6536 13699 22370 36538 36538
arg_in:  1 buffer uint4[8] 50013 47814 1228 51891 3960 1919 11282 48534 21550 21222 55565 7397 12121 3767 5112 24132 9708 4867 58863 55103 36353 6536 17013 7010 21079 11824 53797 36690 50479 36538 7235 13385
arg_in:  2 buffer uint4[8] 11849 19950 54684 20985 32200 37131 25839 48196 46142 3364 51558 59324 7379 27724 18198 59861 47883 26409 39604 38633 56891 44455 65495 47824 13699 9636 28031 22370 41394 37712 65087 58014
arg_in:  3 buffer uint2[8] 1184783026 1972140855 2127037741 2536558619 3228890545 3963249210 3124301718 736536470 3466963022 1564104693 3713741884 4031142961 2611816516 1415830191 2944324033 3003934665

[test]
name: shuffle2 uint4 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_uint4_uint4
arg_out: 0 buffer uint4[8] 45639 36643 41764 9397 26355 26355 26197 62694 29200 14533 32156 48077 7798 29405 65318 36440 30754 25810 21363 30754 18644 29899 29899 34032 28134 55567 34476 34476 31126 34768 34768 34768
arg_in:  1 buffer uint4[8] 41764 9397 6704 38450 57624 710 49184 62694 32156 5278 29200 54959 4836 36440 27806 36002 53948 64841 34867 30754 18644 62432 29899 14381 34476 1173 26702 28134 31970 62669 19677 16563
arg_in:  2 buffer uint4[8] 5934 63132 36643 45639 27850 55211 26355 26197 15209 14533 41425 48077 7798 65318 29405 8177 25810 22177 49891 21363 7236 28577 34032 11155 48513 9044 55567 46153 27442 34768 31126 39290
arg_in:  3 buffer uint4[8] 1984916535 3048791510 219259112 1650978953 129027382 1897049078 2557262791 1946711123 4283250682 2209330853 1039815128 3171705271 1525358524 1444487750 3663253229 855256465 1697420315 2447733252 3915006343 2835463555 324539832 1381860594 1953539138 2787999734 45018659 1697688390 1714412720 3356912744 2547647438 3365558773 3615126821 712747013

[test]
name: shuffle2 uint4 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_uint4_uint8
arg_out: 0 buffer uint8[8] 26228 26228 56814 43947 26228 8562 9957 26228 59295 47080 19349 34222 34222 47080 56010 59295 13565 611 60661 611 46867 2049 13565 13565 2738 39611 39611 10706 27750 12292 39611 16521 57030 52655 27292 39629 21597 34658 27292 52655 11787 16410 38769 31151 41456 38769 32396 11787 33864 10652 1415 1415 14618 14618 10652 14618 48874 48874 36485 24500 18720 48874 15134 18720
arg_in:  1 buffer uint4[8] 56814 26228 9957 43947 56010 38180 42410 34222 60661 611 815 46714 10706 12292 4494 16521 21597 39629 27292 34658 11787 38769 41456 32396 60181 13324 14618 30758 15134 48363 24500 36485
arg_in:  2 buffer uint4[8] 50642 3663 8562 10582 19349 47080 7001 59295 5181 2049 13565 46867 39611 2738 45669 27750 9627 52655 57030 44367 16410 13333 52564 31151 2787 10652 33864 1415 16354 46402 48874 18720
arg_in:  3 buffer uint8[8] 1110633209 1719185601 1846148872 3809598067 1507355329 1260445974 1836384850 470865609 1521322263 1640195549 4166828788 1979066667 4267277515 2018261501 1829316072 2978326679 2758292334 3260338513 129783344 2553254057 1876357695 3723838765 1230891862 2136062174 2247397341 642042868 3900993876 3339143976 413939975 2358803529 2642486924 2126381947 3287737126 216465941 1525169306 2173074041 3030657160 4181331835 629199522 2578055717 4001536280 1046630748 301958425 2318307039 2496713314 2305353185 2583966083 3084774312 1806170750 1285937989 3785605935 2505418271 3137437898 2307986962 3849945869 2196144626 1443597750 3022475158 2188489787 1954210714 2919216543 3215417790 4035546824 3569905911

[test]
name: shuffle2 uint4 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_uint4_uint16
arg_out: 0 buffer uint16[8] 42861 1704 1704 62150 40398 62150 4056 1704 6756 59143 42861 62150 6756 1704 4056 46175 62086 22753 5048 13750 22753 41262 41262 62086 62086 62086 17882 41262 5048 41262 63838 41262 55972 15111 55972 15111 13062 61602 56404 56404 55972 15111 61602 61602 15111 55972 56404 55972 27447 35623 9756 25019 27447 50770 40257 50770 64559 9756 25019 25019 25019 50770 40257 35623 58576 2270 5303 57591 32811 20950 12077 12077 2270 65470 2270 5303 20950 20950 58576 12077 9749 36217 36060 38559 9749 36060 36060 54873 19499 21644 9749 9749 36217 36060 36060 9749 49284 12543 49284 24661 18630 37840 26562 24661 12543 26562 49284 28254 64635 24661 49284 49284 65109 3625 17086 109 30727 3625 3625 30727 52509 109 30727 3625 52509 109 3896 109
arg_in:  1 buffer uint4[8] 1704 59143 6756 46175 41262 17882 5048 62086 15111 56404 29058 61602 50770 21347 64559 35623 12077 5303 58576 57591 54873 36060 38559 19499 18630 49284 12543 28254 109 3896 17086 65109
arg_in:  2 buffer uint4[8] 42861 40398 4056 62150 21019 22753 63838 13750 13062 39323 55972 54616 40257 25019 9756 27447 32811 65470 2270 20950 21644 9749 64159 36217 64635 26562 24661 37840 3625 52509 30727 16797
arg_in:  3 buffer uint16[8] 3098173948 2160803792 2697030992 854344447 4006137637 102838263 1347647662 1413245976 1379519866 1453866969 1310788916 1947587519 193416418 2575964248 2801127334 1417178443 2950214187 1824396349 3002889194 806895527 3408499957 791647264 4163028264 2154978707 3631475659 1877551659 2084073401 1120646312 3011700274 975309696 2442988550 2324936840 3683439982 1517162640 699295526 2378885888 3932515804 11050283 3396499473 972616905 370715134 1576978640 994686651 905109523 3908635968 3855959150 184864441 3815277206 567391311 601768635 3219742206 921343469 2616698575 2736698160 978587076 3498161240 2375228490 949052774 1064042773 4074026565 575660421 4182141864 3302542996 1301097579 2181938394 368091822 1648037897 654895307 2448120292 2589828999 946954432 3971990136 4122611854 3764034429 4090752566 4003529265 333617775 30091207 687656770 2049011184 225910477 891478631 3728410081 1807174930 1072721493 346001273 2419121257 3401599728 2968761155 4064463796 2805061573 1204741101 2647218719 1379157713 3975399385 686515605 183164489 3189071754 789375809 3295533134 3209741976 19476399 3013611365 2607776806 4043109962 1393111725 1280461129 264570147 2358127532 308856398 3418002657 3667135377 356081971 3404066764 2111477786 1157879440 2929817062 3466258300 4171577644 1982597358 3205884069 1077545928 644999806 3989134668 1045486373 4050317792 812566489 1883027568

[test]
name: shuffle2 uint8 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_uint8_uint2
arg_out: 0 buffer uint2[8] 55505 36687 62206 46185 24086 17119 17958 40483 25682 34854 7764 58457 30521 24077 43126 24810
arg_in:  1 buffer uint8[8] 52727 64050 15631 36687 55505 23915 60475 51464 50570 41089 29660 16866 35101 58851 14845 62206 17119 65444 2122 41104 4842 47013 19179 24086 17958 1673 12549 48534 35025 24203 40483 1433 6071 20912 46041 59244 34854 4180 6599 12981 65514 35451 7764 52933 26362 48134 34039 8151 60683 21127 21196 30521 57824 24077 42697 8505 58493 44330 22813 51789 41734 30541 60129 26250
arg_in:  2 buffer uint8[8] 10403 5573 29555 14945 65010 58585 30001 18098 39342 22959 23617 31285 39744 40257 4384 46185 30421 17827 1663 17910 16765 7771 38126 47064 55687 47146 52122 48994 29060 60585 47857 40770 19152 6966 48168 65012 23559 1710 25682 64872 12693 21093 49295 58457 42813 8476 12211 8889 37622 61680 20929 13263 37594 7584 16421 15463 338 33024 15216 43126 11967 20187 46694 24810
arg_in:  3 buffer uint2[8] 1727281108 391997523 568905159 3020227535 3115629975 3034432640 3145546560 1243638502 1788307262 262562644 1397123474 3096282139 3415037315 525944741 3438772907 1832434991

[test]
name: shuffle2 uint8 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_uint8_uint4
arg_out: 0 buffer uint4[8] 34914 13537 52494 52494 40491 55446 38084 37958 35724 5118 17291 28801 30687 60223 15849 15849 7700 53690 51689 43995 38316 35876 38316 51575 35070 6004 15540 54307 25054 10778 26314 36356
arg_in:  1 buffer uint8[8] 22030 21295 60146 52494 14697 10037 37894 34556 37958 45587 23510 55446 39616 4715 38084 45103 46683 30684 10372 47679 57082 46725 24661 19824 11216 28260 15849 62977 61727 18519 63365 30687 41278 18712 57495 40926 7700 51689 58964 52088 38316 9958 25086 23243 51575 60861 18856 16541 6004 22494 5516 64756 15540 47316 10454 31177 47348 17006 10778 63774 54414 6487 47428 24328
arg_in:  2 buffer uint8[8] 16785 49851 9709 55168 34914 13537 45878 9700 20212 51829 65429 40491 22937 39424 13231 51326 4675 63819 54719 28801 49180 35724 17291 5118 50282 36291 17742 39209 43769 55177 60223 45375 59654 47050 23551 43995 18632 53690 9734 24582 35876 5103 21992 35524 16804 54150 26647 22653 54307 42715 12358 28382 35070 15988 33039 28184 25054 1598 5089 26314 54735 36356 23960 34756
arg_in:  3 buffer uint4[8] 2421227868 2803549325 1653080707 2153011251 1617212139 1703679523 2663988358 1453850496 3902240269 958129759 4285084254 2623727435 4000227943 3775671582 2257925170 1811838258 2387825012 1493562141 1889201157 2640998667 4099956096 3541540808 1034369056 1038124436 4243403708 2121389904 3495388324 463492632 1033641800 129167170 1756966427 3758849885

[test]
name: shuffle2 uint8 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_uint8_uint8
arg_out: 0 buffer uint8[8] 1 1116 60877 47090 25649 47090 23970 60930 36530 34192 26982 31075 31661 39320 46672 34192 48681 63095 10701 54035 5151 36089 48681 14795 48162 21239 63419 28374 21239 21065 21065 26758 56705 51797 13095 63444 51797 14342 17878 1988 39507 35846 58955 32885 18455 18455 38644 12779 54693 23463 18448 18582 59178 1847 65353 37361 37576 61097 22850 33671 33671 37576 54647 39776
arg_in:  1 buffer uint8[8] 60877 44312 60930 25649 23970 1116 62128 52049 36530 39320 8837 13060 26982 34192 34211 46672 6684 39797 2497 6177 48681 52518 25521 63095 24032 21065 48162 9790 39394 15938 21239 58858 3202 50558 60929 56705 48062 1988 48322 14342 49650 26479 38644 35846 58955 58483 6216 64141 1847 37361 18582 61206 40122 28755 40446 23463 7254 3689 54647 54111 22850 61097 17626 4899
arg_in:  2 buffer uint8[8] 63239 1 42708 8326 44314 26028 7636 47090 38581 12265 31075 31661 1051 41936 4331 36944 10701 36089 41757 12010 5151 14795 54035 58564 28383 18147 63419 28374 38495 26758 55744 61279 17878 63444 15466 52701 51116 51797 13095 25633 36548 12779 32885 18455 31713 31905 33212 39507 18448 65353 54693 3581 29713 59178 30663 18170 24897 39776 56961 60690 33671 59723 20415 37576
arg_in:  3 buffer uint8[8] 4231897433 191531093 3854944544 544535407 3535655859 3296096591 4280785204 2437965698 1901419600 2462093845 760805620 3831139466 2975076667 1022320337 3056677063 2845130261 905266388 3243123239 2738008920 3851420222 870218876 4221339321 1228182532 1902691437 808335714 3051368342 694549754 3961727707 2575362694 1614846737 936596001 3548168333 1710369843 2395436077 2628679038 1697340857 2532050573 3044606439 459221144 1969801829 192191823 3551269891 3474233748 1401553194 947720715 1808678907 877012658 498266537 3651336538 1322586439 1552956968 4043632178 302694061 4054828720 803537641 1614311153 3471548271 725745925 1821829732 2052147596 3018895340 759571727 4074902322 2096561561

[test]
name: shuffle2 uint8 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_uint8_uint16
arg_out: 0 buffer uint16[8] 6633 28329 14315 37801 49131 24851 40003 49131 42612 2593 2593 46749 40003 14315 2593 49131 5115 24268 3136 64891 64891 11848 11848 51611 27392 5115 11848 27392 29877 15486 24268 29877 28985 32242 64008 60673 32242 40203 52537 63984 7798 32242 34902 3494 63984 24197 52537 64008 18005 17054 61503 11012 61503 12926 61011 9739 11012 62808 18005 31918 61011 12926 17054 11012 51433 38717 11042 51433 44532 24427 38717 24201 24201 25681 57830 44532 24201 51433 7186 34438 12459 62474 9256 26938 7448 18052 4554 21623 18052 26938 19873 21623 52264 36601 19873 4554 19136 32695 19136 38059 52151 17532 41142 49328 1889 29439 59856 17532 49328 29439 11707 41142 51995 31085 34470 35285 61844 31085 63549 28016 34470 43588 4564 60499 31085 4564 1714 63549
arg_in:  1 buffer uint8[8] 31394 24851 28329 42612 34127 34224 49131 6633 921 58050 29877 8156 1013 28875 30272 15486 60673 518 32242 64008 63984 7798 6064 56733 17054 12347 61503 12926 18181 18005 44699 62808 25681 58958 24201 11042 16529 34438 38717 45503 9256 21080 26938 26605 31218 36601 3544 52264 1889 52151 29439 10610 59856 47827 11707 63278 51995 58310 34470 1714 43588 28016 31085 63549
arg_in:  2 buffer uint8[8] 46749 37801 2593 40003 38718 61247 18312 14315 5115 11848 27392 64891 22958 3136 51611 24268 24197 52537 28985 28459 39292 3494 34902 40203 47960 31918 11012 8709 54558 48871 61011 9739 7186 57830 44532 51433 19928 24427 27460 53686 62474 12459 19873 18052 7448 21623 4554 19393 41142 32695 38059 29180 49328 17532 19136 16987 4564 62829 35285 60499 46532 9321 17887 61844
arg_in:  3 buffer uint16[8] 3238828023 405656066 2084802623 741164985 4191212358 1092626289 4198663003 3135355254 1143236611 649937434 3570142490 1255705096 3081986347 972930735 1263685674 4172927190 93394472 1595248047 3162225405 1329208779 2959809195 2866262793 2065724617 3547820878 2631217498 2867249272 1952095769 1501041450 3475016770 2765000807 1519594751 1146910530 686619946 1534716258 3977680499 2525069760 2971530722 122127679 830044361 2687219140 1352902277 2798041794 2101977854 2438408477 2601329668 3284422424 529773961 673142787 3029155285 3932891456 1020342434 1701862298 937840706 636642899 2475680206 7310335 1799080554 267217127 2844957941 3118481721 4012205950 4230522067 437659696 1213493914 1866201291 2674324326 3975380579 1497248539 485297866 2248866653 3338102502 976914466 508392066 2683904880 2878775753 4291485498 4165707842 2917340235 1863114920 436480261 1349595945 4027062472 1771518400 2924047218 685877964 4144374923 3628567470 1814190013 2765604331 1344459218 1402984298 2584317245 750090919 2363590693 1626436170 4059919646 2020508862 552768329 1053691358 9045642 3650362833 1977448205 1066376712 2587424220 183942736 438870738 4148608964 1228417309 2450961676 1326519234 3296331878 1450094600 3180041200 1192585654 1731682626 3278372714 2307837935 2732630566 1616062727 1796851397 3753481058 3513464212 1899106392 1029177771 2939578086 768293128 3019758595 2675482439

[test]
name: shuffle2 uint16 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_uint16_uint2
arg_out: 0 buffer uint2[8] 63140 47817 12654 52058 14152 1091 23942 52988 10465 9303 1364 33603 32696 42221 63993 26691
arg_in:  1 buffer uint16[8] 51354 63775 15896 22905 3955 15826 25680 20807 48932 16915 50403 37540 40209 36805 14691 35437 12654 2435 9279 6411 17490 49261 62516 60130 51898 22901 52058 34444 27841 659 31309 58789 12335 31091 57871 11440 30315 2049 36614 38946 3559 19714 4613 50085 38955 46178 9235 1091 20367 20807 60560 20002 60637 48465 36057 50373 31096 20893 32714 57815 52988 30332 10357 2822 31661 50659 16317 23349 18517 6458 30263 26853 12783 36420 10465 65447 6310 9303 58188 37323 59221 18780 3470 4344 48490 170 50908 22533 64849 46845 34867 25471 48601 46159 19357 47209 60747 56687 46850 21345 52739 35112 56087 32696 62586 50171 8541 12792 44365 8415 30963 1552 29066 44829 49221 58203 56460 47336 62637 32940 51223 13071 7602 35699 65386 23144 37430 26691
arg_in:  2 buffer uint16[8] 19804 49651 23478 22680 15884 63140 32688 47817 17095 42250 27916 60611 1023 13895 51486 16325 33581 8023 3179 13058 22497 27236 17266 24347 4423 29393 6435 11488 56043 29063 22665 62128 20533 20527 1575 38734 53445 57208 53724 20428 2861 141 6732 59962 34050 15242 14152 12051 61560 16515 21041 55605 10864 59559 21539 42448 61065 4045 18919 29732 14795 38529 23942 24718 36774 5274 22899 34363 22939 34414 64284 26371 29112 23569 9946 24521 59864 43801 13028 30619 33603 57123 536 6550 34102 44606 19723 32052 40149 36271 20327 25007 1364 15595 3092 50688 29732 40465 13950 13102 47315 5341 34102 43851 41631 3044 24036 8840 62058 20502 15916 42221 34930 44284 26443 63993 1634 58865 12440 36543 63764 26402 13316 54594 38106 23318 13675 46997
arg_in:  3 buffer uint2[8] 483593333 1466333303 1776644928 2827654858 91156254 1228135119 3086330878 4204919020 3404628202 1637472237 1410223740 937583952 2400057863 1529830623 4213511443 3356579247

[test]
name: shuffle2 uint16 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_uint16_uint4
arg_out: 0 buffer uint4[8] 45140 45689 63257 24704 53835 32569 51555 36671 5135 2148 59665 19414 10816 19758 46025 9997 37902 25083 44598 21963 22566 65356 31256 54874 13609 31199 797 47799 23952 16637 43154 52170
arg_in:  1 buffer uint16[8] 2343 24704 22325 12018 45689 39658 23311 25317 14336 64320 2561 13597 40056 20262 63257 57546 53835 1592 1119 8189 31115 32569 42849 31671 54270 25548 51555 48518 5795 22676 14512 31618 43587 2148 62459 5135 27701 9487 63489 42454 59665 19414 17802 13476 35210 30219 29868 51983 16681 39939 10816 55628 51928 46025 4806 18104 28063 34120 19758 25421 11735 9455 6987 6556 27563 16225 25083 27563 19358 5379 33572 11696 36755 25053 43830 53611 21963 37692 20220 9802 54874 31256 2797 35407 65356 22566 17412 63364 14805 12634 6862 43994 42656 39141 12715 16866 797 46653 51598 62800 20705 58212 31672 49305 22878 29733 24722 37129 46284 31199 733 9475 49649 46467 48614 52170 28303 16637 25051 65150 26860 10564 33751 7110 53946 18760 57845 12716
arg_in:  2 buffer uint16[8] 56959 56579 21265 45140 47178 38424 41507 52760 60032 35824 26301 11477 23242 32998 20835 2866 49653 11765 39548 64107 40238 50756 52241 11035 47916 43746 52954 39047 43754 9742 5620 36671 19199 59154 56101 6019 27736 58631 22575 51643 44609 58477 39959 7616 43850 22993 33889 16088 9997 30449 887 58129 33353 25646 28500 28405 28564 25430 53936 4775 33805 58222 39902 40254 32330 21479 6877 21643 36298 49432 61684 37902 44598 44306 36657 27296 4817 20085 42918 12415 56286 21924 48841 2447 57963 22241 2170 50356 14998 45310 21946 45306 9399 38486 42685 15925 10484 53299 13609 64412 22669 18427 47799 11699 20767 48034 29331 8415 22914 53763 56665 39942 57896 46538 12657 36887 44097 29742 23952 40770 15785 35880 7250 38631 49339 24714 24972 43154
arg_in:  3 buffer uint4[8] 1571837363 1503655268 2624169454 1225569729 1695176096 805423109 1092919242 630218655 1234283651 949829345 1527583656 2296386185 1512446754 1512107338 2909633957 163156336 1918877751 1261315234 2722946488 228043116 1661098021 548608836 166842337 1901557504 2552024754 2565524397 665813536 2012057558 3199391510 267702533 1956145503 444843683

[test]
name: shuffle2 uint16 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_uint16_uint8
arg_out: 0 buffer uint8[8] 23437 38067 52658 21483 51286 47675 36212 18038 13690 39774 48382 42838 60527 44777 5254 23151 685 136 65256 25657 49329 19440 35264 14953 6887 49098 11131 37784 47039 49098 5008 50656 20095 17219 47209 17686 5481 13269 5481 5015 19062 28044 37883 9988 46645 48131 20296 2659 17464 55974 55974 18296 31192 9889 22502 5413 62848 25682 57956 3809 63840 63840 14839 56434
arg_in:  1 buffer uint16[8] 23437 38067 36915 30845 52252 36212 52658 27649 40943 63163 29492 60923 9138 41475 10275 25608 22550 20564 25703 1525 48382 51471 39774 23151 60527 16299 11070 24964 53021 42838 13690 22028 35923 30680 26776 54834 53024 39924 50659 25167 61075 14953 45586 65256 30763 47846 685 59313 9801 35360 35305 12395 6440 52423 45142 38999 49098 12422 11489 44661 5008 27795 37784 34399 6413 33834 5015 487 12081 14615 20095 13269 53570 5409 39191 63383 7772 47209 34317 56093 46645 63891 22097 17118 3804 19062 45375 24195 61665 39659 1703 37883 51825 12503 44660 59957 9889 27225 7006 5413 17984 2576 58206 22502 9019 19656 3076 39154 36505 16066 48096 17208 5372 29659 57167 6021 37158 57956 61015 14839 63840 49875 12160 56434 44320 3809 158 62848
arg_in:  2 buffer uint16[8] 56772 58339 38810 47675 35882 61008 21483 50300 28712 14300 18038 53175 1167 50106 51286 22191 14405 11872 14826 30017 12985 28126 39161 50421 5254 44777 42137 10708 41737 50809 46823 26179 17708 18521 57324 49329 43403 19440 20356 61185 47494 46146 35264 3374 25657 136 23682 53561 51451 11131 63362 50656 6887 7001 1624 47039 18788 45497 58303 19712 34609 63889 16264 47775 14810 41890 22196 32542 17219 52436 5481 40147 15856 47803 29065 31606 60335 17686 3863 5445 6952 27738 33910 30109 28044 17159 2910 9988 4782 27567 48131 2659 28045 58381 63061 20296 51122 47976 40456 37239 46527 2450 24504 31192 10916 49141 55974 13560 37209 17464 18296 21176 25682 189 35288 10021 5899 23801 59875 37005 35601 52192 48678 8699 18340 25915 7201 21550
arg_in:  3 buffer uint8[8] 3450825760 611464193 4125894854 2521474998 2237797822 3028110963 411061157 558542202 433194830 1836572102 519690180 3690178221 2547213224 3715712505 4216743352 3229129319 2032008750 4113442493 2248596651 1509718236 1360906323 1803961941 3399088154 2354049193 2289892276 3887651944 2976721073 3408336686 3238925911 79793544 756645036 1754351763 4151645574 2871323156 2910365485 2247500509 1322632342 3359712263 3040403094 1383612610 3597435781 3247447284 4044724203 1170030007 2779087872 3119738362 785930239 3896299163 1463940573 869019034 2661084762 2140388190 3730804151 860907136 2073457159 4123376131 127880463 1994239792 3887216421 639028589 1958741800 3611668552 1207756871 3298582795

[test]
name: shuffle2 uint16 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_uint16_uint16
arg_out: 0 buffer uint16[8] 50507 58903 15347 24805 60730 27633 55192 46930 4255 45872 55192 33792 60730 30557 28018 41980 30920 43003 60068 17614 25280 42585 17614 11010 33707 33707 9949 25680 9949 58030 11010 44488 37464 220 38899 24081 7713 50713 32585 41909 24002 31648 32585 7713 54489 10440 24081 9149 38598 63914 35637 18957 53283 21759 10697 38598 53452 56164 56562 41296 55714 15560 49121 35534 42395 203 65008 32392 32392 32898 33194 58052 32392 34151 3488 34151 40175 50181 34151 65008 47871 58739 26367 34091 60099 48980 47138 8587 45354 28220 2231 55984 47138 17582 17922 34091 5275 11787 23187 38184 52931 51342 5656 7045 16281 60969 5656 7388 5656 51342 23187 18972 57389 33236 52319 22278 25406 22278 36759 17282 17282 53647 17282 56018 32439 36759 2693 32439
arg_in:  1 buffer uint16[8] 41301 1135 30557 55645 58903 59981 9752 28018 13162 18508 45872 47880 60730 64667 55192 41980 11010 58030 14822 53146 30920 20174 4527 9949 44488 14702 33707 28187 29199 48961 50712 13463 9147 38899 23981 31648 25701 7713 30799 220 13465 37464 24002 16276 9149 10440 24740 32585 35003 61581 51912 38598 18957 5384 49121 35534 46955 53283 55714 39394 35637 56164 9963 56562 32392 36208 13593 21272 24629 2027 34151 32898 50181 40175 3488 33194 58052 37849 34059 30463 11756 34063 8587 28220 55984 10675 58739 45354 2231 17922 2308 7151 35431 55704 53956 55260 5656 29824 60969 9743 16091 50291 35976 11787 27518 3083 48153 38184 60068 18972 45666 54947 28495 17282 53647 14975 36759 48399 30707 46120 26511 25406 27406 53862 57389 61519 33236 29883
arg_in:  2 buffer uint16[8] 46930 50507 4384 24805 4255 27633 50713 3886 64905 33792 11805 23763 36842 15347 62844 26636 43003 25280 50810 20368 42585 60987 6628 17614 60068 49390 58611 25680 4766 28929 12260 64261 41909 19892 45115 36360 24081 57851 30995 26023 54489 62262 60823 29659 1095 61881 27944 50713 30122 21759 10349 5052 58072 54901 41296 9847 63914 42028 10697 8229 23548 53452 15560 15685 62235 31261 6236 39607 15666 60550 27142 19637 65008 42395 203 57152 60613 65007 25814 14431 26367 42843 47871 22795 45910 39805 39963 17582 64269 4234 2232 47138 31128 60099 34091 48980 42145 5275 52931 52823 34090 8730 16281 5633 113 7388 22455 51342 23187 7045 62788 65489 56931 32439 43283 52319 62342 46346 7430 22278 1599 56018 47873 27663 2693 7801 54314 2331
arg_in:  3 buffer uint16[8] 2478874705 4109235972 3442287709 2606055219 4131836556 433309173 2169821486 2873177264 3128731476 1435246026 1550165134 1613101785 2538725292 454203074 3993240743 413958607 158242084 2220931600 1513189336 2695360215 3916171601 224117716 4257706743 1291473152 117525226 2914054538 2971081543 2718789403 2945173991 2322160961 719889216 1971387752 4095963785 1708805415 3364678433 3727456052 560003461 49117055 489861071 3202810672 916179338 2934491907 2984819343 1718672165 2130023480 1607981997 3136953876 2553427980 3485851843 2090152824 114016012 431609860 2612342313 3080807633 541538618 1418563747 2151074429 2511086605 2227016143 3875834614 4098651370 3776953566 2701636966 2291633639 994780281 1529612218 2903565816 2234650144 2373867360 1436555623 692854859 1861755180 3096271456 1930194854 678456074 204230406 2520250121 3387237512 1330355910 1236724248 1883805458 1253153510 3235637392 3567222622 2646180221 2227480415 3762032699 2054237826 3308412839 3807963715 1557100776 3895620804 812956859 2588299767 4036554409 1536013566 968186641 3160937959 2073524348 2025757099 3192571282 1356013755 1967022112 2806180509 3031109622 3784561218 4248409472 1584057081 3888465760 2319035003 4246738524 1813806317 2305094316 2332923598 2684591443 571533463 2930531497 2591689847 880896868 2415353089 1525636193 1596999202 4294378561 1267632409 2731245041 2615175396 2385002204 403889073
!*/
kernel void test_shuffle2_uint2_uint2(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint2_uint4(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint2_uint8(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint2_uint16(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint4_uint2(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint4_uint4(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint4_uint8(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint4_uint16(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint8_uint2(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint8_uint4(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint8_uint8(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint8_uint16(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint16_uint2(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint16_uint4(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint16_uint8(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uint16_uint16(global uint* out, global uint* in1, global uint* in2, global uint* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
