/*!
[config]
name: shuffle2 uchar uchar
dimensions: 1

[test]
name: shuffle2 uchar2 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_uchar2_uchar2
arg_out: 0 buffer uchar2[8] 55198 4423 20872 35411 9692 53478 10428 37376 680 43899 3937 3937 22542 23490 33212 48404
arg_in:  1 buffer uchar2[8] 4423 55198 35411 20872 34332 6117 35087 10428 43899 54592 1020 34952 29717 23490 33212 48404
arg_in:  2 buffer uchar2[8] 14864 22407 65198 26115 9692 53478 37376 5587 33823 680 3937 20799 43174 22542 53023 30697
arg_in:  3 buffer uchar2[8] 101 16 97 232 230 171 177 186 59 8 214 186 95 245 116 197

[test]
name: shuffle2 uchar2 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_uchar2_uchar4
arg_out: 0 buffer uchar4[8] 24666 24666 1938 12942 32806 32806 64793 32806 51420 23117 52157 51420 55204 33634 56212 55204 49974 55619 55619 58292 60830 60830 64289 28137 15724 32873 20745 8279 41303 290 39427 290
arg_in:  1 buffer uchar2[8] 1938 24666 64793 54182 51420 21200 20165 56212 49974 58292 28137 33121 8279 20745 290 39427
arg_in:  2 buffer uchar2[8] 24193 12942 20214 32806 23117 52157 33634 55204 41999 55619 64289 60830 15724 32873 41303 33686
arg_in:  3 buffer uchar4[8] 129 145 192 11 255 103 216 139 208 18 11 212 43 142 13 15 252 199 179 241 227 243 94 12 182 107 157 220 34 112 49 84

[test]
name: shuffle2 uchar2 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_uchar2_uchar8
arg_out: 0 buffer uchar8[8] 59396 16870 40202 40202 40202 17004 16870 16870 65156 65156 19058 65156 65156 41372 19058 65156 44559 44559 44559 44559 20254 8368 20254 57701 64060 33078 64060 64060 25501 5802 33078 33078 3536 44714 64389 3536 3536 64389 44714 44714 61717 10220 5887 10220 29369 5887 61717 29369 6624 18256 34577 18256 6624 34577 47286 34577 17744 17744 61139 17744 12608 12608 51621 17744
arg_in:  1 buffer uchar2[8] 59396 16870 65156 41372 57701 20254 64060 33078 64389 44714 29369 5887 47286 34577 51621 12608
arg_in:  2 buffer uchar2[8] 40202 17004 18305 19058 8368 44559 25501 5802 3536 64177 61717 10220 6624 18256 61139 17744
arg_in:  3 buffer uchar8[8] 132 41 154 182 66 239 189 21 168 52 51 56 156 157 187 92 3 243 207 207 109 46 213 136 248 221 252 192 74 219 105 217 98 137 36 70 238 164 185 149 230 175 125 83 236 65 174 112 254 79 49 227 162 89 44 161 83 139 182 59 57 193 164 167

[test]
name: shuffle2 uchar2 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_uchar2_uchar16
arg_out: 0 buffer uchar16[8] 51258 40591 60799 40591 40591 43683 51258 43683 51258 51258 60799 40591 60799 43683 51258 43683 24801 63522 63522 197 18456 63522 24801 18456 18456 63522 24801 197 24801 63522 63522 197 7563 24451 24451 39639 18436 24451 24451 18436 7563 18436 18436 7563 24451 39639 7563 39639 22250 19817 20844 20844 22250 22250 20844 22250 14816 14816 22250 22250 20844 20844 14816 20844 15694 52960 62290 52960 31554 15694 62290 62290 62290 52960 52960 62290 62290 31554 15694 62290 10401 10401 12309 36872 10401 10401 12309 36872 10401 34027 10401 12309 12309 10401 12309 12309 13063 10726 13063 13063 13063 13063 13863 13863 13063 13063 10726 6683 13063 10726 13063 13063 11698 39600 49656 28430 39600 28430 39600 49656 11698 39600 28430 39600 28430 39600 28430 49656
arg_in:  1 buffer uchar2[8] 40591 43683 197 24801 39639 24451 22250 20844 62290 31554 10401 34027 13863 6683 49656 11698
arg_in:  2 buffer uchar2[8] 51258 60799 63522 18456 18436 7563 14816 19817 15694 52960 12309 36872 10726 13063 28430 39600
arg_in:  3 buffer uchar16[8] 206 88 231 136 172 89 206 133 90 82 43 108 183 233 46 169 217 154 234 28 71 178 89 255 115 118 33 64 225 222 50 184 115 61 165 68 102 121 161 254 175 246 138 151 9 92 139 100 56 159 225 89 56 24 233 192 214 162 172 116 169 253 74 13 246 71 0 43 9 70 56 28 164 159 99 32 24 117 90 184 196 188 214 107 200 20 114 3 228 5 212 78 102 32 66 162 143 150 231 175 211 251 168 136 155 227 170 205 171 206 143 7 109 239 152 206 219 66 91 244 97 87 98 39 138 83 94 248

[test]
name: shuffle2 uchar4 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_uchar4_uchar2
arg_out: 0 buffer uchar2[8] 56888 63080 24076 58404 11779 18001 43371 13090 8586 49370 38920 32114 50281 12510 12523 23321
arg_in:  1 buffer uchar4[8] 15911 63080 32521 56888 24076 15234 7130 5011 11779 12382 18001 19286 27507 47068 47999 13090 12556 49370 64001 16464 43994 26629 29331 58194 37614 12510 18394 54836 12523 24705 17072 23321
arg_in:  2 buffer uchar4[8] 34827 36126 42554 22170 58404 44044 13112 11841 51944 1509 8166 24721 45018 57042 32535 43371 56031 16240 43019 8586 63139 64643 38920 32114 50281 7742 45202 43459 22153 11769 36186 60057
arg_in:  3 buffer uchar2[8] 3 81 72 172 232 34 199 139 239 145 14 207 12 233 56 67

[test]
name: shuffle2 uchar4 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_uchar4_uchar4
arg_out: 0 buffer uchar4[8] 33119 39036 39397 33119 58428 906 40832 5030 1946 3494 62096 54277 23383 23383 44164 44164 36842 38487 21330 59352 17331 17331 49542 26175 33510 20230 20230 20230 10178 62700 49311 10178
arg_in:  1 buffer uchar4[8] 39397 43195 39036 20388 64120 58285 906 42551 20345 54277 3494 39152 23383 20535 10257 55204 59352 18174 55070 44509 17331 47130 22088 10804 12179 31759 14727 26505 62700 25097 3631 49311
arg_in:  2 buffer uchar4[8] 43229 34643 46536 33119 58055 5030 40832 58428 56818 29206 62096 1946 51840 44164 28098 45729 38487 21330 23207 36842 26175 15568 46202 49542 20230 39557 33510 21980 53179 3629 10178 24354
arg_in:  3 buffer uchar4[8] 199 210 40 39 127 34 110 165 231 50 86 81 24 224 133 109 31 252 37 8 24 96 87 252 102 148 44 76 190 0 171 158

[test]
name: shuffle2 uchar4 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_uchar4_uchar8
arg_out: 0 buffer uchar8[8] 22971 39818 22971 22971 28820 22971 54081 29646 53133 36694 43086 9291 9291 53133 9291 43086 13165 41791 22434 3447 22434 45347 39373 45347 46151 46697 55045 52491 46697 52491 1900 52491 4226 54420 56446 64545 56446 64545 64545 64545 23003 553 44340 59994 24122 60951 553 26211 27834 8853 5731 4676 4676 27834 26218 26218 43247 16693 50287 42407 43247 50287 42407 11913
arg_in:  1 buffer uchar4[8] 29646 39818 1596 54081 46404 9291 43086 36694 45347 13165 39373 19541 46151 5027 1900 52491 1110 56619 30599 56446 60951 38522 553 23003 59546 8853 1794 5731 11913 16693 51562 50287
arg_in:  2 buffer uchar4[8] 22971 28820 14091 3907 5359 51708 53133 37091 22434 49845 3447 41791 55045 26344 46697 32251 4226 54420 64545 6251 26211 44340 59994 24122 25847 27834 4676 26218 15621 38490 42407 43247
arg_in:  3 buffer uchar8[8] 156 73 92 212 141 28 195 56 254 83 194 113 209 198 65 226 185 23 116 110 204 248 114 40 56 78 84 155 14 163 58 67 92 213 131 6 187 70 22 110 227 138 213 30 127 136 98 172 53 137 251 190 150 29 135 55 183 145 99 174 119 123 102 96

[test]
name: shuffle2 uchar4 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_uchar4_uchar16
arg_out: 0 buffer uchar16[8] 22136 35201 35201 42953 22136 18409 22136 32956 18409 18409 49604 13539 42953 35201 18409 13539 60762 5732 5732 60762 60762 51206 16996 60762 46037 60762 60762 3521 5732 16996 3521 46037 63192 60412 63192 56848 63192 52566 14355 63192 14355 26344 14355 56848 41797 26344 33284 26344 11248 37146 40838 40838 40838 11248 37146 39400 37146 39400 11248 63454 63454 55337 40838 39400 5980 8694 23523 60763 46258 23523 53827 5980 23523 5980 19320 19320 53827 19320 19320 19320 38626 63706 23266 63706 8931 22802 51628 8931 37632 38626 8931 38626 51628 8931 63706 22802 10182 14056 31528 55749 55749 38596 14056 32387 30312 31528 38256 14056 31528 55749 14056 38256 6427 6427 62600 6427 46962 52988 55899 55899 62600 25262 6427 4080 25262 46962 6427 25262
arg_in:  1 buffer uchar4[8] 49604 15948 32956 22136 45395 51206 3521 5732 56848 14355 33284 26344 39400 11248 13707 55337 46258 23523 19320 15978 37632 38626 22802 63706 38596 32387 31528 10182 62600 25262 46962 55899
arg_in:  2 buffer uchar4[8] 35201 42953 13539 18409 60762 46037 16996 8217 60412 52566 63192 41797 40838 63454 18475 37146 5980 53827 8694 60763 23266 8931 14798 51628 30312 38256 14056 55749 38706 4080 6427 52988
arg_in:  3 buffer uchar16[8] 211 188 116 125 83 55 59 74 151 183 248 126 221 76 95 174 92 11 171 76 52 161 126 52 53 244 252 146 171 46 106 21 206 132 174 112 174 133 33 230 65 19 49 224 143 171 130 227 9 175 164 124 180 185 183 192 103 8 201 157 205 11 60 160 12 222 73 47 64 25 149 100 185 124 42 114 221 162 146 10 33 235 140 195 109 82 231 5 80 1 85 25 47 189 27 114 115 254 130 159 191 160 254 25 124 66 109 118 50 71 54 21 46 222 232 230 202 7 163 107 64 153 150 205 25 234 126 201

[test]
name: shuffle2 uchar8 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_uchar8_uchar2
arg_out: 0 buffer uchar2[8] 37320 5808 38611 13533 20678 58392 49657 49657 60976 23078 59816 45701 37341 61141 6197 50317
arg_in:  1 buffer uchar8[8] 34591 40310 15856 41156 33513 35023 59272 58546 13533 40769 42295 9992 57110 44680 894 14212 43133 13822 25742 657 2397 2369 40648 60632 14440 2617 65489 31000 35958 39502 34616 26319 52610 58570 62489 40214 43382 1952 38588 13989 44790 11949 20128 50462 59816 34374 45701 36483 29033 23994 59551 61141 33955 62358 12318 10883 22606 6844 32896 47208 43573 47182 7474 50317
arg_in:  2 buffer uchar8[8] 44723 22809 37320 62406 5808 39693 41841 35406 41923 9844 45749 2596 58830 22779 47040 38611 34659 64372 239 58392 20678 31977 45558 30581 14878 6247 49811 58350 49657 4810 42523 3339 1662 60189 32773 27813 23078 60976 13460 52460 7307 34646 13722 17980 7653 1375 33767 55457 37341 8943 43714 63126 44364 34798 43828 30333 6197 31205 57960 2338 50150 41771 5588 26601
arg_in:  3 buffer uchar2[8] 58 124 15 160 76 123 252 252 221 92 228 134 88 19 184 151

[test]
name: shuffle2 uchar8 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_uchar8_uchar4
arg_out: 0 buffer uchar4[8] 35933 13141 44777 17793 20306 60258 43267 20306 403 6844 53630 19803 53090 30052 48148 8001 33071 41997 41997 15972 33477 41105 62897 16481 24238 34376 12766 54865 37605 58670 50718 56574
arg_in:  1 buffer uchar8[8] 44777 35933 30017 51257 717 7774 13141 17793 43267 21629 2538 5449 21316 20306 10295 18291 19803 24468 53405 50979 2454 48397 37776 45125 2094 31096 1310 48179 48148 44872 11308 48622 47874 8482 53665 24605 47303 33071 19701 27892 24313 17685 14621 41772 12591 21691 46881 33477 61336 34376 58543 24238 51767 54865 47236 12766 41578 19623 34005 23504 44060 58670 10604 49042
arg_in:  2 buffer uchar8[8] 48997 35136 46114 19457 54266 27122 26178 20671 60258 55955 32011 206 47916 17888 4042 57814 53630 12415 6844 50899 37931 26125 56475 403 30052 52947 63570 64710 55729 52857 53090 8001 40628 23075 21934 41997 15972 58887 20861 51112 29859 16481 33487 2330 59982 41105 62897 45629 28710 40929 3744 64379 18010 35553 27133 48995 2035 37605 56574 29703 876 28924 50718 17441
arg_in:  3 buffer uchar4[8] 129 102 64 199 245 184 240 69 15 202 216 176 158 72 148 255 133 203 123 236 103 93 254 233 19 209 103 149 217 53 158 138

[test]
name: shuffle2 uchar8 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_uchar8_uchar8
arg_out: 0 buffer uchar8[8] 45495 21474 19749 27412 19749 30886 22433 40282 1495 37167 24343 37566 16579 26080 50421 50421 8006 65376 14136 30601 54219 30601 43643 14136 55594 7415 4907 14179 7415 56649 4907 13297 15008 31527 15639 37095 5286 37095 8506 10960 43894 52300 17098 43894 31196 43894 5189 50655 55615 5378 25303 13767 55615 25303 12753 27687 27156 58874 26459 62389 38713 53946 27156 15185
arg_in:  1 buffer uchar8[8] 21375 19749 27435 40282 17089 21474 45495 27412 20864 7862 13729 16579 33080 37566 37167 24343 8006 36572 48640 14136 54219 34152 43822 34165 14112 7415 3890 44758 55594 63426 41630 30001 15639 55738 55293 10960 32780 45067 19694 5286 1213 16521 50655 47847 3694 48834 43894 52300 14564 13767 25303 27687 42304 52748 18915 5378 10880 4282 46458 27238 53963 15185 53946 27156
arg_in:  2 buffer uchar8[8] 44353 11865 13511 18012 35825 30886 22433 28230 50421 57047 26080 26645 1495 36769 54874 28205 13335 47573 43643 32929 30601 65376 27792 6705 14179 34788 56649 13297 4907 13096 42968 43336 15008 37095 12823 31527 39716 8506 12677 51323 62938 19553 42554 29489 17098 31196 18077 5189 7102 61298 62471 30818 55615 32440 28504 12753 43572 22895 38713 13371 58874 59076 26459 62389
arg_in:  3 buffer uchar8[8] 134 245 97 231 81 109 206 179 220 134 199 85 67 250 56 120 176 141 3 156 228 108 202 115 148 161 12 184 17 218 12 11 24 27 208 153 231 169 13 195 54 215 140 22 173 22 31 178 60 7 50 17 108 210 143 51 55 92 62 79 122 118 247 133

[test]
name: shuffle2 uchar8 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_uchar8_uchar16
arg_out: 0 buffer uchar16[8] 51150 12680 52446 51516 34727 9851 1130 17048 51150 63967 51150 34727 51150 51618 34950 34950 15523 20372 60061 43664 26067 29921 21343 32276 54518 20372 3252 21343 7920 20372 54518 55779 4841 49783 55097 4644 5325 19789 25160 25160 33597 34992 33597 4644 51182 11299 51182 19789 6321 59791 55162 50635 55162 6321 30321 31010 30321 55734 55162 62889 21520 55734 62889 63761 39174 39174 8409 35310 1736 8409 9788 19276 44565 8409 8409 56930 8409 44565 39174 31448 49885 27221 49885 36192 39227 49940 2664 49885 27221 41938 42240 42240 36192 36192 12512 39751 13313 41380 46439 60577 41380 41380 21475 46439 27896 27896 1209 41078 41380 60577 3422 54835 64016 8673 33935 60925 64016 30429 47782 33935 35989 7747 64016 33935 21720 35989 64016 57671
arg_in:  1 buffer uchar8[8] 52446 26752 6697 63967 9851 29951 17048 51618 60061 8697 32276 29921 15523 20372 56885 64339 55097 33597 25160 4841 51182 20338 64647 18198 6321 40202 50635 62889 59791 55162 43527 30321 8409 39174 31110 44565 39808 31448 56930 35700 38272 49885 42240 41938 27221 12512 39751 39227 25571 13313 31785 53556 21475 41380 27896 54835 60925 32084 35989 47782 51440 8673 62454 57671
arg_in:  2 buffer uchar8[8] 12680 21841 15794 34950 34727 1130 51150 51516 26067 3252 21343 7920 54518 55779 43664 55962 49783 5325 34992 62056 1858 11299 4644 19789 31010 21520 43541 55734 18316 38256 63761 32344 9788 35310 19276 25374 32300 17629 1736 3635 57906 36192 39529 2664 49940 61179 22013 5043 21907 1209 52358 46439 12009 41078 3422 60577 30429 33935 49417 7747 56741 59012 64016 21720
arg_in:  3 buffer uchar16[8] 110 56 48 111 204 164 141 118 30 163 142 44 94 55 235 11 244 181 128 222 88 19 90 82 220 101 153 26 27 117 12 189 131 232 144 142 169 191 66 34 225 58 49 78 84 173 212 111 128 180 181 130 5 32 215 56 215 235 37 51 233 75 195 94 209 17 176 217 142 144 72 42 227 160 96 22 112 227 209 69 17 100 145 105 135 28 187 145 196 67 18 98 153 105 229 150 1 21 219 223 5 85 52 187 214 118 137 205 181 79 46 167 110 21 201 192 142 168 99 121 18 251 126 105 143 82 94 231

[test]
name: shuffle2 uchar16 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_uchar16_uchar2
arg_out: 0 buffer uchar2[8] 10489 1266 47677 14532 4343 21102 20661 9016 60734 47488 46832 10628 8960 2484 64036 8262
arg_in:  1 buffer uchar16[8] 30347 5724 10273 30372 51891 52081 55410 3616 19077 37774 40435 5834 26743 39068 63726 50098 14792 45707 11701 60005 47677 29343 5806 13255 46945 60433 25016 40666 37904 12991 385 8921 57037 26295 64919 26790 64058 53128 61967 21102 20228 572 59611 9694 54106 41952 23486 10496 44594 59687 25281 64131 55034 6687 20661 32819 38242 38590 57105 253 64627 9016 61836 38167 61197 48060 62892 9163 40399 27598 54852 60734 46102 57995 18970 63137 47332 8436 33699 27419 17753 37494 10628 23227 556 59747 63287 36416 23763 680 56990 46132 39555 57307 6254 4294 6077 32592 55473 12006 6115 49206 61577 27509 15342 35048 2396 22783 62146 6182 8783 2484 32960 19078 57372 20784 28447 31344 28692 2347 8056 58859 64036 43503 19868 9420 8089 6284
arg_in:  2 buffer uchar16[8] 7363 29932 52636 34620 1266 64797 34242 13162 19641 10489 48532 41732 26297 27708 39179 32498 20696 24289 46361 8829 13264 37390 54321 55494 33326 20056 14532 48740 52200 15794 24425 6453 53540 4067 35644 41335 30925 2218 7246 4343 2855 30598 42931 14687 11968 37320 33536 61164 7552 13976 55486 30649 34712 35537 14511 17694 15463 48536 47423 35032 47921 7074 8213 53566 38184 47488 36675 928 18064 64146 43968 28901 26800 9924 55597 45511 9562 21202 23065 30586 11638 37540 49666 7668 46832 28210 60537 26448 61226 13348 58018 25775 46073 41041 44749 3225 55576 13991 41366 50992 55329 49014 31328 17396 48935 49175 50830 36982 24823 27207 8960 49371 27196 24013 25342 6376 44176 49507 8262 13596 6087 47823 20031 21514 46880 60506 54427 44513
arg_in:  3 buffer uchar2[8] 153 148 164 218 87 231 70 237 71 209 180 162 62 15 74 182

[test]
name: shuffle2 uchar16 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_uchar16_uchar4
arg_out: 0 buffer uchar4[8] 64764 20958 12298 2162 42422 24244 45161 399 49115 54346 63720 14265 4139 28446 5939 61690 59509 55792 52204 55792 25466 44533 2379 34387 46622 34627 31957 48110 40334 59004 64536 3805
arg_in:  1 buffer uchar16[8] 42659 26671 16028 37948 47558 6338 12298 57398 30207 2162 59632 62388 8596 31104 9967 26839 27139 25937 46673 48689 958 38931 36672 1263 44440 7782 45161 21596 53835 10261 56829 19044 59726 62361 41177 1762 49115 3037 10793 61014 63720 908 32439 7639 14265 49646 13041 53710 16703 62473 39829 50630 732 4139 28446 21772 23259 60561 23361 59326 25044 1447 5939 61690 63533 50911 35128 59509 44304 13024 22303 5321 58658 63603 62871 35039 55632 29540 6119 4102 42909 50103 63688 30856 3025 26173 43879 25466 20470 38568 23816 57269 13877 33588 50273 28446 8233 48447 51998 19566 53892 64203 13688 34627 55335 46843 48110 52313 46622 53934 34230 927 27310 59976 48097 28157 12120 41515 1662 49179 54853 26658 55720 32551 54960 41711 15203 2208
arg_in:  2 buffer uchar16[8] 27137 39052 9779 28057 39554 11221 26873 20958 30857 56954 42647 38416 20491 31509 64764 914 17221 63686 8700 399 40323 58101 35085 25889 18398 44671 39974 17808 24244 42422 52878 38777 45887 59104 63150 54346 23261 59493 27434 34611 54982 57320 64293 8084 44923 64408 44955 6419 42380 64804 47826 57512 8828 12254 37129 38750 57196 44738 59650 14615 45423 58576 54054 4316 52204 46061 850 46443 3011 61648 55792 28894 7726 39999 25521 28502 15044 53070 15465 7038 34387 41777 44533 6689 59182 19578 2379 53281 32806 63199 35701 29238 38499 21252 32317 26360 64316 31815 31957 35488 45284 24694 42722 19537 8236 50388 25380 26941 27341 49971 21395 63716 39508 10426 12514 40334 28631 3805 7147 45777 11432 59004 38042 40868 64536 49380 36096 29166
arg_in:  3 buffer uchar4[8] 190 55 166 201 189 60 74 243 196 179 136 76 69 38 78 47 131 22 112 182 199 178 54 240 12 103 210 10 211 217 124 53

[test]
name: shuffle2 uchar16 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_uchar16_uchar8
arg_out: 0 buffer uchar8[8] 19617 47739 45531 22622 243 60205 2581 243 31579 33027 8219 29934 23712 19792 20980 56005 36252 46182 39803 62817 44716 2311 15528 48073 44396 16296 60098 24486 40714 28693 60098 48691 25160 19431 20905 6669 168 14021 168 24973 29536 15913 16754 21047 59335 23279 21132 43961 26021 23585 54195 23585 1237 26763 51146 33348 16618 64309 58484 62316 64926 2194 39930 49697
arg_in:  1 buffer uchar16[8] 10527 44170 54401 40172 28100 64661 60542 22622 37598 61465 47739 12837 243 44635 45531 60205 19792 35893 6706 8219 59197 23712 64724 39510 19954 20980 9226 31579 21192 60320 4980 15863 46182 44015 56038 45834 29697 14753 53871 63638 11679 61300 39803 3968 44716 62817 15528 39189 13462 48691 5450 23798 40714 23877 44577 62592 29365 49668 44267 1778 48839 44396 58503 26768 59927 54576 41462 56428 56177 62651 24973 20927 62943 6669 25160 5589 64940 168 20905 13686 21418 27765 14693 15913 56118 24774 2815 21132 49518 21047 15608 55169 43961 29536 59910 7818 14578 14390 26101 13796 13645 11185 10390 1237 23585 33348 60010 19158 40525 38485 29209 42218 36450 17138 64926 21780 43166 26178 31272 16618 51606 62182 49697 7923 23869 2514 36902 12897
arg_in:  2 buffer uchar16[8] 6237 56148 4443 19617 27698 40053 10038 25335 2581 58971 49626 57296 62031 27136 35966 9802 46324 64444 56005 43428 2300 4212 15087 61675 57628 25623 58665 979 33027 32211 5428 29934 41453 36252 4342 51246 48073 27250 31931 24746 41402 2311 13800 6457 11598 28712 46434 13919 51322 35817 26159 24486 57457 59198 60098 28693 12280 23812 16296 44726 24143 9539 34010 56775 39801 27110 17456 14228 31888 27603 40597 33131 6327 14021 19431 65435 34486 17654 10970 14597 26330 32559 29114 17226 59335 25875 65142 64963 13468 47512 55611 23279 179 53720 16754 17209 51146 48299 26021 26763 47003 29665 65494 6536 54195 60817 5507 42101 26389 41327 21385 3733 42626 64309 9587 52748 40283 23380 29525 2194 62316 15118 26999 58484 38027 39930 38055 939
arg_in:  3 buffer uchar8[8] 179 138 46 7 12 239 24 76 43 28 131 159 37 32 41 114 17 160 170 237 12 249 206 148 13 122 182 179 164 87 214 97 202 26 14 137 109 153 77 6 205 131 126 9 20 91 231 76 114 168 152 200 39 243 112 137 135 17 187 152 130 119 157 170

[test]
name: shuffle2 uchar16 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_uchar16_uchar16
arg_out: 0 buffer uchar16[8] 60602 57998 23031 29172 56687 40232 14683 29172 14683 29172 49386 28563 48694 27369 21410 25838 23062 30669 2906 6581 58271 62606 2002 2002 2906 6673 40615 12449 9345 13807 40615 44834 4536 29688 62129 38740 62129 16674 53331 59231 29688 7821 16674 26948 6482 64945 62010 7821 32546 14382 44689 19297 44689 44158 14382 20724 18686 20724 43958 54362 39806 50303 59326 32546 31172 60129 14852 34258 17872 21216 31375 30782 31172 30782 25547 33551 43165 5952 5952 59500 39592 13650 19733 49609 33635 25426 61444 64957 43607 12790 7169 40086 47581 19733 47581 35701 17361 31199 16971 31199 7701 16971 3406 40588 24323 23578 3406 104 25820 50774 44632 65124 20098 39654 44030 20098 36658 12342 40793 43150 36658 9682 44982 62524 36658 56526 58575 46866
arg_in:  1 buffer uchar16[8] 38313 35905 49523 63597 14683 10091 54656 25838 23031 27369 35938 48694 57998 57797 53756 27578 58271 44834 12402 28432 62606 40615 13807 2906 4136 9345 30669 55405 42038 12449 11935 63264 38740 64945 61187 7821 40570 62010 48626 62129 16674 29688 6482 58914 31511 32766 29716 4536 37163 14382 50604 44158 54560 45291 18686 50303 59894 16889 54362 20724 30282 4982 48976 60458 59500 14894 43165 34016 17026 38980 4736 25612 38323 34258 31172 10628 60129 14852 63839 42069 23619 40086 13650 442 26662 28951 47581 23478 48892 43607 30311 40629 25426 7169 49609 33635 37929 50774 35308 11042 7554 54 17361 29855 104 16713 37767 22597 21037 63750 4919 65124 40793 31279 46866 15704 27541 28918 20117 20310 36658 62524 40116 58575 38669 25251 44982 27044
arg_in:  2 buffer uchar16[8] 17697 60533 62682 21410 29172 56420 51009 36324 28563 45640 40232 60602 17353 56687 49386 58841 53597 27653 6673 33492 6581 63125 6165 54071 22827 3640 2002 33032 23062 9024 4173 35751 43565 2928 39221 51332 13449 49697 53331 43347 26948 32601 21522 58119 50429 41165 59231 19395 12783 37023 59326 15199 17897 39806 32546 44689 53781 43958 8862 47615 64584 1905 14659 19297 17872 33551 36242 16657 31375 21216 45765 44715 29060 30782 5952 25547 64054 48879 22821 51730 61444 64957 26639 58644 50371 39592 29764 15849 60647 54357 35701 41428 11269 12790 19733 29690 64879 23578 7701 60254 24323 63008 16971 3406 31199 24479 25820 4143 44632 45814 63056 40588 43150 44030 42343 11193 39654 53081 9682 64224 41702 45945 56526 12342 15773 2085 20098 48094
arg_in:  3 buffer uchar16[8] 123 12 40 52 157 218 196 148 164 244 30 120 139 169 211 167 28 42 39 20 160 68 26 154 135 114 165 109 105 70 229 193 79 41 135 192 167 168 150 222 169 99 8 216 74 161 37 67 118 65 247 159 23 227 225 75 198 43 121 234 213 167 114 22 10 140 205 73 112 117 212 89 74 25 123 49 2 122 58 32 21 98 126 78 111 172 208 209 41 189 45 161 198 62 166 26 38 24 150 152 18 86 55 191 180 145 87 232 218 97 124 47 62 212 81 254 232 91 0 48 8 246 78 105 168 26 43 130
!*/
kernel void test_shuffle2_uchar2_uchar2(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar2_uchar4(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar2_uchar8(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar2_uchar16(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar4_uchar2(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar4_uchar4(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar4_uchar8(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar4_uchar16(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar8_uchar2(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar8_uchar4(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar8_uchar8(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar8_uchar16(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar16_uchar2(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar16_uchar4(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar16_uchar8(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_uchar16_uchar16(global uchar* out, global uchar* in1, global uchar* in2, global uchar* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
