/*!
[config]
name: shuffle2 short ushort
dimensions: 1

[test]
name: shuffle2 short2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_short2_ushort2
arg_out: 0 buffer short2[8] 16741 16027 43412 4269 29756 51438 37334 552 54466 54466 64855 56777 62683 7063 64687 54840
arg_in:  1 buffer short2[8] 16832 34060 43412 55777 15546 51438 552 37334 39265 54466 41621 64855 40255 7063 2243 64687
arg_in:  2 buffer short2[8] 16741 16027 4269 27540 32788 29756 15685 29253 24981 38705 56777 38624 60607 62683 54840 28015
arg_in:  3 buffer ushort2[8] 26714 583 28308 47990 21763 40305 28489 4384 57033 53569 44465 27934 16923 38433 11461 16994

[test]
name: shuffle2 short2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_short2_ushort4
arg_out: 0 buffer short4[8] 1614 30576 30576 7751 1052 21606 1052 16962 34635 34635 57357 34635 6146 23746 23746 6146 51556 19249 41341 19249 49426 21875 21875 49426 3985 18996 18996 15644 24989 13426 13426 20428
arg_in:  1 buffer short2[8] 7751 43372 6594 16962 8749 14409 14561 6146 15607 19249 49426 39986 3985 57817 13426 24989
arg_in:  2 buffer short2[8] 1614 30576 21606 1052 57357 34635 38110 23746 51556 41341 13793 21875 15644 18996 62107 20428
arg_in:  3 buffer ushort4[8] 1322 4435 38927 28476 15559 34050 33807 58973 63615 29167 35358 57231 59789 39651 58215 28729 54982 13877 54807 51389 26292 15999 47699 31768 2596 8963 2703 53358 46785 26332 26868 43179

[test]
name: shuffle2 short2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_short2_ushort8
arg_out: 0 buffer short8[8] 41615 14284 57103 41615 47726 41615 47726 14284 61271 5999 64409 64409 64409 57151 5999 64409 56726 26570 40129 52572 56726 52572 56726 52572 7958 35810 51031 46801 51031 46801 46801 7958 60046 50297 50182 50182 50297 60046 36488 60046 20226 16392 20226 16392 16392 52765 20226 20226 14449 22783 2177 14449 2177 2177 22783 9020 22668 5529 22668 22668 37564 5529 37564 22461
arg_in:  1 buffer short2[8] 57103 14284 5999 64409 56726 40129 35810 51031 36488 50182 20226 16392 2177 9020 22668 5529
arg_in:  2 buffer short2[8] 41615 47726 61271 57151 26570 52572 7958 46801 50297 60046 52765 33205 14449 22783 37564 22461
arg_in:  3 buffer ushort8[8] 53046 33749 18248 10582 40763 57034 39795 56937 358 65244 26825 37245 26613 1739 40304 12769 53284 47478 50097 47951 50144 27555 40968 1051 7686 13388 54685 14455 54345 44055 28787 44586 43791 45590 48425 19253 40962 44499 11020 33367 44896 35941 36920 19905 54081 51922 28932 13704 30130 35271 58704 16958 37308 18144 36183 6193 1232 31325 47420 43704 15294 59149 7802 35847

[test]
name: shuffle2 short2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_short2_ushort16
arg_out: 0 buffer short16[8] 63859 52867 63859 20126 20126 52867 52867 16507 20126 63859 52867 63859 52867 20126 63859 20126 28358 28358 35671 29872 29872 35671 35671 35671 28358 35671 11256 28358 11256 11256 28358 35671 21819 21819 43708 12012 37974 21819 21819 21819 43708 21819 43708 12012 21819 37974 21819 12012 13945 13945 34425 34425 61995 34425 54365 13945 34425 61995 61995 13945 34425 54365 54365 54365 32227 49007 61369 64302 32227 32227 49007 64302 32227 61369 61369 49007 32227 32227 61369 64302 35864 35507 35864 35507 35864 35864 35507 35507 39991 55132 39991 55132 39991 39991 35507 39991 47634 24307 22907 22907 43166 47634 43166 47634 24307 47634 47634 43166 24307 24307 22907 22907 15388 28472 28472 15388 15388 33983 28472 33983 11922 33983 15388 28472 28472 11922 28472 15388
arg_in:  1 buffer short2[8] 20126 63859 28358 29872 43708 12012 13945 34425 64302 61369 39991 55132 47634 24307 11922 15388
arg_in:  2 buffer short2[8] 16507 52867 35671 11256 37974 21819 61995 54365 32227 49007 35864 35507 43166 22907 33983 28472
arg_in:  3 buffer ushort16[8] 12893 38199 50673 52472 44412 60939 12495 9086 31904 21661 59975 24825 47207 34840 4713 17888 996 48228 58234 37453 40773 43126 23450 1946 38892 21430 3427 57708 58131 15771 57332 61974 10787 4623 60944 57257 29518 36123 16763 62671 58508 11287 46332 54281 40583 65062 62011 59125 41068 40516 10881 15041 13946 9953 32279 55648 57833 8954 60994 2968 23365 18575 53895 43379 21846 43979 20625 31888 63026 51386 22203 12692 47910 20885 59717 12699 19962 43526 4897 15016 39186 40883 35966 22811 27178 51478 61891 2607 35324 52429 14696 38929 48460 50060 37827 38716 10444 58853 29543 37927 62118 2716 31258 2364 14381 2912 43948 55534 18721 39125 5139 13495 12857 40395 61423 40273 18369 56162 33343 47406 34004 54878 55293 40843 63239 57268 31223 23497

[test]
name: shuffle2 short4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_short4_ushort2
arg_out: 0 buffer short2[8] 37580 64901 25758 32926 41523 59505 7033 64595 5895 5895 33683 22339 55371 41134 53395 53395
arg_in:  1 buffer short4[8] 59594 37580 17577 12772 23859 16934 32926 36888 36307 13904 41523 14615 561 25803 8578 41676 5895 34926 63726 56026 15747 22339 33683 25558 30371 41134 23583 4901 6868 150 25616 12416
arg_in:  2 buffer short4[8] 6508 64901 11999 40181 25758 46689 55919 20950 31529 21767 59505 50417 26401 7033 56003 64595 19667 53346 10076 22590 22191 41434 21006 53931 47270 55371 54672 38051 27091 53096 53395 54646
arg_in:  3 buffer ushort2[8] 29433 60365 11244 1346 62394 4686 42557 44143 42504 63400 37042 9345 8005 8825 38742 24166

[test]
name: shuffle2 short4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_short4_ushort4
arg_out: 0 buffer short4[8] 12417 63711 7735 7735 56596 16511 39771 4457 33571 2476 32417 33571 11692 30649 17241 55695 48715 48715 48715 48715 30014 62010 27085 9386 61693 20706 53810 60003 39205 32765 18251 20649
arg_in:  1 buffer short4[8] 35806 31923 11483 12417 24904 4457 39771 57241 33571 11069 4280 2476 17001 30649 11037 55695 17179 46040 10031 27132 30014 62010 11908 29239 60675 20706 60003 49098 32765 18251 14833 40053
arg_in:  2 buffer short4[8] 63711 7735 52803 28482 56596 59447 16511 50598 5122 421 32417 47958 4057 17241 11692 13879 28897 21574 50904 48715 27085 9386 53624 26091 18855 30481 61693 53810 39205 46271 20649 36163
arg_in:  3 buffer ushort4[8] 38923 52036 49053 31269 31908 26086 54146 17929 53072 36939 27030 22096 5462 41681 44621 4555 38047 24591 63863 17687 5944 21713 27396 48429 60390 55537 29879 16778 23724 63224 18865 2718

[test]
name: shuffle2 short4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_short4_ushort8
arg_out: 0 buffer short8[8] 44228 62667 17398 30720 43800 52739 17398 44228 50113 62588 51311 51395 51311 27656 26536 50113 9288 16266 9288 9288 63528 496 63528 63512 63392 63392 60712 57459 227 6634 25827 227 63553 18011 7115 7115 12001 18011 29712 63553 63506 63506 7948 51512 63506 51204 42883 22758 3743 25912 10972 10972 25912 122 12948 10196 64885 9453 9453 15124 27173 54244 54244 9453
arg_in:  1 buffer short4[8] 5243 52739 17398 8128 26536 50113 27656 62588 496 52855 16266 34159 60712 6634 41260 63392 7115 63553 18011 17803 46232 59808 42883 7948 10972 25912 122 10830 54244 35594 27173 15124
arg_in:  2 buffer short4[8] 44228 30720 43800 62667 51395 25201 30240 51311 9288 63512 63528 2253 57459 25847 227 25827 29712 40483 21869 12001 63506 51512 51204 22758 3743 8123 10196 12948 64885 12479 9453 26871
arg_in:  3 buffer ushort8[8] 51436 42111 35954 7237 62462 42777 12802 44644 34001 2571 35415 7868 4415 52858 45696 713 61884 45994 24356 32012 24310 21624 36070 57477 60259 18019 28344 35428 24486 16217 29103 18294 10929 35330 58888 61656 45247 1162 18860 25625 45956 32332 5691 2437 33756 24574 4842 57471 34060 46977 13864 49232 35441 42338 52639 44694 49308 46166 41590 25315 39842 64120 25784 6198

[test]
name: shuffle2 short4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_short4_ushort16
arg_out: 0 buffer short16[8] 46749 36522 45167 46749 43321 49644 46749 46749 36522 45167 5774 49644 49644 45167 20498 42002 53027 32234 50227 53027 32234 57104 62131 50227 39825 32234 39825 57104 62131 53027 50227 38366 19673 22713 11200 3205 3205 36534 11200 44779 36534 36534 3205 22713 3205 44779 3205 44779 34590 2464 63936 19358 53194 60215 63936 53194 63936 2464 34590 19358 2464 2464 34590 19358 45499 21406 27886 48093 48093 14303 27886 48093 14303 15507 45499 45046 14303 15507 14303 48093 33219 44671 2086 35189 42864 42864 44671 42638 33219 2086 29218 42864 42638 2086 33219 42638 63043 27335 20131 21781 20131 63043 21781 78 20131 47146 20131 78 63043 21781 20131 78 31872 50765 34657 31872 51319 32062 13386 45078 51319 13386 30259 31872 13386 32062 32062 30259
arg_in:  1 buffer short4[8] 5774 36522 46749 20498 62131 39825 50227 32234 3205 19673 35820 22713 53194 39871 34590 2464 45499 14303 48093 45046 42864 29218 31138 33219 2376 21781 41276 27335 34657 45078 32062 51319
arg_in:  2 buffer short4[8] 45167 49644 42002 43321 57104 53027 38366 30598 13866 36534 11200 44779 60215 19358 63936 10915 33558 27886 21406 15507 35189 42638 2086 44671 78 20131 47146 63043 13386 31872 50765 30259
arg_in:  3 buffer ushort16[8] 34666 6673 756 45274 35199 41917 4042 234 50841 31500 60376 63485 38261 16612 50555 3566 28533 29843 55402 8453 12163 40740 9416 44274 17369 56267 15081 14772 27832 13429 22834 25318 26281 48275 10262 32720 35952 25629 25270 36007 10349 27669 62856 31187 9272 45327 184 40087 22570 27611 2342 61325 45272 29692 52702 18264 48126 20995 64954 9773 27267 65387 47506 61853 54680 33398 23021 466 64130 34617 5309 9346 4209 45151 63304 57203 63777 16191 26417 6466 48491 51023 34054 45140 44464 18384 43103 19653 15899 46774 11969 35440 46013 52342 13635 41117 18551 51075 37085 33193 46877 21271 7417 14540 25413 62022 12149 41204 29023 33377 58061 22060 56109 26678 59600 24525 63523 17130 62028 63097 47155 4340 27551 21549 8580 41202 49658 65239

[test]
name: shuffle2 short8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_short8_ushort2
arg_out: 0 buffer short2[8] 35900 4697 22124 23615 16165 14221 32730 22238 58004 29119 5863 34946 5549 40081 55458 2840
arg_in:  1 buffer short8[8] 52045 52856 4697 41657 18831 20942 34369 21371 22124 60500 13091 46042 29370 52989 41992 17929 58267 14221 52150 49173 38334 43527 57923 41815 50604 59757 13933 16497 65207 63460 57899 23130 28084 22643 14727 45636 16801 23901 58004 29119 29289 53497 61581 23575 5863 34946 38177 12376 2790 64432 36241 55920 5181 32910 62655 5549 61954 63154 44104 62383 55458 36119 4993 9431
arg_in:  2 buffer short8[8] 11488 29914 24646 28297 35900 41441 22922 53105 29894 31888 11569 3001 47991 1723 23615 40403 52713 62212 7878 18999 47756 16165 40103 19082 50207 55042 63884 61506 42432 22238 32730 45063 41726 22515 53275 50103 43716 42819 53413 18737 58092 10432 39832 50218 25618 3292 57566 28994 40081 1399 1168 38323 80 8083 31531 43442 47440 45965 11038 36732 2840 17851 7774 9040
arg_in:  3 buffer ushort2[8] 43772 10002 35200 18974 45165 32241 798 57341 44566 56071 52100 50421 60663 15304 692 57916

[test]
name: shuffle2 short8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_short8_ushort4
arg_out: 0 buffer short4[8] 17513 19640 14901 19640 77 49204 60892 13257 46407 38109 63309 46407 2384 47621 35109 38482 26982 26982 48391 26849 21550 53291 47110 21550 24089 35076 40961 54940 27329 43096 11785 44209
arg_in:  1 buffer short8[8] 34150 14901 47051 9714 64269 43866 51759 49648 13257 77 23539 53863 53094 45240 4373 7538 20793 46407 23470 59932 38109 63309 40991 39116 13264 47621 22718 64760 4800 60006 56579 35109 48391 25496 927 48892 32358 15138 26982 50214 40360 22317 3902 54950 48860 60053 23332 53291 38786 25592 35076 45166 40961 49263 54940 14808 49496 26892 4715 27329 64294 44209 29899 32732
arg_in:  2 buffer short8[8] 64361 62487 32717 14364 17513 19640 35567 41553 16872 5493 49202 21755 49204 60892 5281 33669 61328 48332 40072 51152 56640 8465 55004 61492 39886 32570 2384 54539 38482 58668 63236 50621 43482 45883 16708 45217 40353 60405 18706 26849 40259 11158 59960 18343 32945 15283 21550 47110 62576 5324 24089 54965 26346 35158 1217 45943 128 41779 43096 12953 25176 11785 50123 5486
arg_in:  3 buffer ushort4[8] 50796 37693 32225 16541 12993 45372 27453 24816 54017 21236 57285 2545 36010 32897 11175 300 59254 38662 36208 48031 5326 54903 4271 5550 25850 226 18996 11286 26387 51834 53373 41397

[test]
name: shuffle2 short8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_short8_ushort8
arg_out: 0 buffer short8[8] 9974 14170 57808 57808 41381 11766 10980 57808 6843 43855 64643 2064 64643 20408 20408 14121 5192 21 21 14335 14335 26809 10580 21 30947 4555 47039 12953 47039 47039 4555 12953 12956 41536 11726 63666 11726 35527 57585 22894 9723 44879 42502 52177 51163 44879 17295 4017 53369 53369 40845 55440 4097 40845 4097 4097 1206 38886 11519 1698 38886 11519 46555 46555
arg_in:  1 buffer short8[8] 14170 13194 31710 41381 10980 23514 23521 30856 63680 12277 56627 30364 43855 35550 50048 58185 14335 21 53589 10580 45171 38590 7554 6154 48716 23931 12953 32378 47039 4555 43474 30947 29335 41536 11726 10582 7170 12956 42105 65517 51163 52942 65221 44879 47059 6086 17295 58767 12205 44740 17896 54161 44846 4097 58213 53369 22611 46726 61158 60960 31378 46555 1698 28824
arg_in:  2 buffer short8[8] 9974 32285 11766 23348 54619 57808 31509 39477 14121 606 64643 7677 2064 20408 6843 62748 17598 25442 56880 19253 5192 26809 21591 2900 27348 8809 20202 603 26104 52565 62587 1216 60542 52477 35527 2927 57585 22894 63666 25961 9723 25418 60869 4017 42502 50650 15414 52177 23849 50449 55440 40845 23175 54106 35013 15779 54494 11519 45861 1206 63082 38886 51135 57885
arg_in:  3 buffer ushort8[8] 65016 46624 62477 32013 3539 47530 30116 32477 40350 33236 56474 57292 36410 36941 16605 3224 31724 17729 65201 26800 64880 65533 7171 61825 5815 2309 13188 29906 10116 31652 19845 55586 39877 18577 28050 34014 60194 38474 36764 19309 33432 29683 54636 27055 32160 5219 17814 36043 47191 29159 34619 28698 2389 9851 64629 35285 28427 3981 46777 49654 55021 57705 49109 56069

[test]
name: shuffle2 short8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_short8_ushort16
arg_out: 0 buffer short16[8] 34137 5934 38096 44458 38096 38080 47434 9264 434 47434 47434 38096 434 42564 44458 482 47979 40410 23405 31138 23405 29116 16311 49227 40523 20452 47979 40523 45059 47979 20452 20707 18356 59259 49365 13897 7030 51758 39635 36072 59259 41529 5660 41529 36072 13897 49365 7030 24244 24244 24244 33841 33841 46189 60951 7696 46189 7696 29656 24244 28896 33841 60951 60951 31002 22097 31002 26554 5735 15282 12539 65255 22097 26284 16436 1430 22097 12539 22097 33135 56322 27156 32415 9264 56322 49836 31457 31457 9264 27156 5633 49246 8777 56958 5633 49836 63373 58008 60207 17113 23632 63373 709 4692 63373 23632 34320 2833 51384 2833 17113 63373 61217 64312 28941 9628 42252 9628 3739 64312 9628 64312 9628 9628 51995 61217 11699 11699
arg_in:  1 buffer short8[8] 34137 36655 38096 44458 38080 482 434 47890 16311 49227 46418 65332 62889 47979 20452 20707 2375 51758 32119 13897 18356 26319 39635 36072 60951 33841 29656 39655 8061 18942 29978 46189 43853 26284 63349 15282 65255 33135 26554 51686 53658 5633 56958 8015 49836 9264 60777 27156 42865 2833 18659 58008 60207 55097 4692 17113 19595 28941 64312 9628 5993 8973 3739 337
arg_in:  2 buffer short8[8] 42564 8581 47434 5934 28365 61630 9264 26190 40523 40410 3850 29116 63564 23405 31138 45059 7030 8079 59259 41529 49365 6083 5660 2067 24244 9374 31617 63992 31320 7696 28896 57991 1430 16436 5735 22097 59351 31002 61972 12539 41897 56322 58136 31457 32415 8777 35060 49246 63373 51384 23632 37810 38366 34320 709 27811 29460 30258 61217 903 11699 51995 42252 8922
arg_in:  3 buffer ushort16[8] 65120 1307 47986 59123 64914 6500 36026 35598 26518 22666 33210 33074 11590 13832 53475 49429 8293 45593 34765 34686 56317 58443 58768 53569 53592 54774 33253 13416 19535 54917 2438 41655 24036 52426 39356 4627 42408 1633 3942 1703 32506 48027 26478 9755 27111 5523 28316 24344 45432 36584 54904 13553 64657 19831 55792 957 47079 23085 62706 43704 1006 97 34880 27616 23149 51467 62189 64342 26618 29219 48175 63348 47515 56465 38681 57144 32939 37199 64219 12293 6153 599 35100 51061 51577 25124 7531 49307 2837 42599 65105 32319 47581 43346 8097 4468 29160 57843 53636 65127 36282 37032 11454 2326 33448 11786 13853 31057 42441 30113 21543 64328 54042 15522 46321 6163 12270 20147 16310 14322 50275 63506 50611 22851 41949 64954 3228 25308

[test]
name: shuffle2 short16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_short16_ushort2
arg_out: 0 buffer short2[8] 12419 14 33116 56780 547 15957 42276 28137 11114 3842 45850 9927 32436 39306 33973 36141
arg_in:  1 buffer short16[8] 40503 43250 31345 22248 50459 38798 35136 13647 51106 45220 10631 34631 49029 27274 56515 45415 12057 295 62707 3353 31961 9572 38392 14796 33045 56780 6887 33116 13953 49401 27466 49007 27418 19960 59932 9121 49327 15957 23777 14784 58636 27538 22845 40994 20602 547 39265 57129 54474 6028 25191 9659 65001 23497 30136 60217 60534 1651 51515 14671 34362 28137 50685 24633 11634 13214 15686 52941 27225 40925 1946 15225 47541 28815 3842 51177 4967 18064 13597 18031 9927 58449 48175 28301 21613 35091 10657 54598 42037 38109 41155 15053 31424 24924 53221 53676 18559 10095 31402 29208 38356 57075 37876 53721 6499 8183 51486 51339 36753 3412 52758 13366 819 14800 2657 37390 5788 2514 50245 18764 63973 12380 11915 6452 53527 26884 32416 30961
arg_in:  2 buffer short16[8] 14 9488 12419 28557 27501 57639 48708 44473 45679 1372 57003 50973 49683 63381 54553 42873 19951 947 28503 27431 52729 52083 17080 64243 35018 5849 54622 42536 24755 2251 54361 42275 23307 15218 31626 41608 51775 41729 41497 23958 25578 32562 49184 14280 50543 32467 39273 1048 24005 39443 47455 42276 44097 53620 57918 23975 45713 11227 32415 47893 47435 26211 5108 42752 12347 49120 32947 3143 11114 36172 17743 57648 36170 38651 9602 10121 18275 15705 8579 32052 7333 17028 44094 12600 9980 18412 22938 45850 17559 34149 62172 36397 32032 442 38612 28076 45766 25613 50154 64668 42923 33475 1673 19012 34755 30205 39859 39306 18405 32436 42569 19889 11332 14068 65483 44229 11205 30568 38553 21008 5217 36141 2003 3516 10334 40277 33973 41679
arg_in:  3 buffer ushort2[8] 55858 54928 17771 14857 54509 58949 46899 39501 62388 13418 58199 55872 14749 57307 13758 40025

[test]
name: shuffle2 short16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_short16_ushort4
arg_out: 0 buffer short4[8] 30118 34788 25573 40082 23249 25350 52983 25674 54480 16048 57757 58596 23417 35876 55605 20069 31157 31383 31720 31720 11868 24229 4092 11868 19049 18793 28710 52141 39420 35686 56175 56175
arg_in:  1 buffer short16[8] 58378 34788 21821 51205 17243 53485 25087 18077 21164 12187 30118 25573 48044 39040 38866 60273 64446 5427 44828 36352 38536 56364 65496 2600 36969 55826 2470 25350 10317 31499 37438 29468 3065 54480 11017 29331 10848 34538 12811 50002 49417 16048 58596 11378 1892 35281 21367 46942 65156 30936 27797 38374 46153 25246 19771 19419 65173 27897 64734 24169 20069 42817 35876 2042 20369 34205 9994 57389 31720 55622 31383 58649 7504 48279 13889 55922 36353 8699 65366 45869 24805 11346 24229 8987 4092 56907 16211 44753 42303 14898 20702 43403 39366 14779 17725 45020 54171 24383 19049 5557 44331 40044 26237 32728 37486 57411 673 33082 15912 1722 27136 24239 53453 3203 17140 59187 53214 58002 60340 41825 57470 63345 11620 35525 8506 56175 25682 10411
arg_in:  2 buffer short16[8] 10955 45869 11065 50408 51498 54593 24714 45004 64635 5566 41336 17482 40082 38559 1242 17012 7382 21977 36000 42456 52843 32989 52983 29970 25674 43512 63213 42373 23249 3978 35464 19388 35821 29278 53100 16118 55061 60228 57757 53338 54263 11595 1049 27673 40486 737 30144 17310 23706 49478 22501 26349 55605 5274 23417 2261 4253 17453 36293 36588 35321 53511 26008 10109 10938 2930 39376 28658 2342 42691 8253 42331 29977 9408 58494 63477 62832 57414 60701 31157 14130 6277 5045 7373 55759 53642 62919 27098 3167 42269 580 57288 27158 64804 11868 13798 36379 53422 16895 37288 24985 4019 23771 56715 28710 49109 7396 18793 52141 59797 51703 13249 50278 39420 7872 35686 30054 18552 49881 22630 42197 28768 8026 47889 52579 54152 3692 31106
arg_in:  3 buffer ushort4[8] 9642 48769 21259 64124 13052 12875 62998 47576 61473 2665 21046 23370 57366 27118 65428 17388 55967 39142 8068 61156 21534 24738 63620 9406 17154 50523 14200 29340 53553 64659 39277 39629

[test]
name: shuffle2 short16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_short16_ushort8
arg_out: 0 buffer short8[8] 49616 57399 49616 40462 3183 55412 41284 41179 36455 64471 52916 48734 64471 7032 5076 14489 39668 50818 32885 23166 12863 527 39127 38379 62609 12770 15339 21552 58180 54503 30686 30686 8645 40002 9972 13320 17575 36080 40002 7345 167 62429 4623 40122 48100 167 676 54179 10990 48368 60644 48368 21222 56061 48368 12343 20529 44834 43820 3320 43820 4534 19150 20060
arg_in:  1 buffer short16[8] 15915 9283 57399 55628 49777 24924 18412 45952 9806 2478 34246 29767 41284 11133 19043 28757 53316 7032 36976 1003 9632 55793 8867 49830 5887 8788 15052 25148 8414 54331 5076 52916 41693 51146 527 64383 39668 48900 61762 7274 32885 472 38860 37083 32538 23166 39127 28678 12519 24938 30686 58640 54503 15339 998 17092 22397 12770 24146 50853 25793 57647 62609 25772 30515 8645 39742 17575 7345 55663 36080 38228 35419 61799 51979 33334 44100 49489 9972 12689 61981 8858 16847 44030 48100 9031 54179 36303 52302 23572 40436 39887 7510 40122 19811 62429 25151 56936 5423 27378 37950 36198 9441 59382 21222 36119 10990 42239 7558 21719 23116 56061 44932 43820 1374 10140 19334 48105 46221 56006 3320 47599 8248 45903 44834 19150 60408 14113
arg_in:  2 buffer short16[8] 58670 17351 58500 49616 63181 40462 63686 27841 55412 41396 3183 63835 53529 19404 38532 41179 27958 14489 25756 16641 54152 5190 64471 44397 35280 43334 63423 13899 257 3948 48734 36455 55192 30416 50818 28898 8879 12863 35622 2211 51923 38379 49119 53167 24085 47326 49384 16222 55751 43604 33884 43841 12340 23365 58180 31266 24920 12905 58715 21552 511 24309 46690 7211 40002 30963 21183 10898 42822 62962 10687 42747 3873 5133 42346 14994 13320 54411 62954 49680 45691 36216 4623 31721 35523 25617 167 64870 676 3619 512 9793 23062 47370 60396 64861 12343 52942 20950 60602 24321 48368 61049 21375 8656 60542 3609 61182 50423 10253 6736 60644 10816 14768 20060 57603 20529 4534 16365 5739 56638 48941 44920 16016 48697 54414 65155 13417
arg_in:  3 buffer ushort8[8] 7859 25282 16371 23221 60026 1400 64748 54687 17887 2134 18351 52830 14358 16289 30158 32497 3268 15058 10824 5133 42869 25058 47822 14969 41358 16809 41701 29371 6518 64228 13250 17154 42977 62640 20078 23452 63939 45542 17712 5796 22454 36527 45522 44493 32068 34966 54168 37702 41706 2229 62463 38485 19848 33999 25589 2128 64180 40364 62273 1064 13153 48501 32365 31442

[test]
name: shuffle2 short16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_short16_ushort16
arg_out: 0 buffer short16[8] 25376 54111 51000 19878 50517 16589 13057 2146 30697 21464 37933 22084 17631 50672 13717 12597 11632 36936 54448 61755 27145 42003 53958 27145 52801 65308 40285 42847 36936 54448 42003 3454 16626 40976 12817 28095 4686 16626 45369 51658 12817 64827 13699 22852 12817 13699 30248 39685 24311 19062 35141 34871 35514 12844 34871 54975 9284 57437 19062 49860 8353 3049 12844 15858 26402 31161 57048 56725 63780 26402 17049 65408 26402 11002 29089 62723 25224 57048 62723 988 36367 3672 9867 36367 57763 32749 50441 28496 43423 3672 57763 32749 43423 61430 9681 39484 15023 57145 22777 15541 4631 3726 4631 15413 31692 15413 43631 61985 46220 4631 38480 15541 61004 14107 61963 53761 61749 2594 49532 40780 53761 11212 36818 2594 14107 7977 2283 22189
arg_in:  1 buffer short16[8] 51000 25376 50517 12597 23135 33443 13057 37086 22084 17631 59678 54111 50215 54288 30351 10539 12214 56133 41860 40285 65308 54448 53958 45540 52801 61755 52165 32611 4243 15357 36936 42003 7029 40976 39685 42858 64250 10145 16626 4384 13699 51658 32698 306 38842 30248 40914 13177 50651 54975 36163 8353 1976 29683 37760 3049 9284 34871 20113 29534 26689 31176 37510 8365 11002 29089 60797 8757 3029 64446 17049 46416 55729 50140 43650 60887 17808 988 25727 57048 28496 9681 36367 15218 39484 61268 50441 25491 49865 32749 13397 53485 7001 8399 41857 44026 40399 21662 16800 3726 31692 11865 38480 4680 29961 22777 57145 54691 43631 15413 61985 9937 49532 61749 6363 14107 22189 62021 53761 34361 28613 54287 40780 22364 11212 13021 59674 2283
arg_in:  2 buffer short16[8] 37933 21491 16589 50672 19878 30697 14759 50897 19707 25404 21464 63780 48975 13717 2146 50546 3454 53494 35156 33293 42847 11632 27145 46313 8765 45476 4259 32621 53190 11857 8653 10043 39985 4786 50898 3634 51727 53894 12817 45369 28095 64827 22852 4686 9010 24689 17929 35242 57437 30186 24311 51627 62594 15858 35514 35141 54272 9184 49860 48672 12288 12844 19062 38226 28868 57894 25224 26842 65408 24777 26402 25781 35067 56725 33059 31161 33474 62723 18175 63780 32409 3672 43423 9867 63010 53126 23997 61430 4136 4477 57763 29073 29248 30598 53175 714 31717 61932 28339 50352 46220 64099 10820 4631 65255 32310 15541 26358 61383 16688 39103 15023 7977 43419 5283 36818 18005 8818 40970 49731 61004 37795 9564 13356 61963 46936 27966 2594
arg_in:  3 buffer ushort16[8] 12801 49579 24896 43604 56098 59794 44774 34942 52117 63418 10384 56744 33481 25171 24989 16771 20117 47886 63749 46985 59606 33135 39238 6294 58056 42980 46083 31988 46990 2277 17423 28528 9382 46017 55926 22488 25211 10502 51031 42633 34038 45401 23912 50490 246 19624 12397 5858 61522 2814 29751 29513 60566 44893 46441 56961 45224 42800 30142 8890 36803 40583 17309 469 26678 44571 37295 60217 18015 21078 16134 11412 20214 50528 53281 51453 5426 60015 39229 49837 14178 23313 26707 46434 52762 16777 37574 49056 55026 56113 34138 44297 2194 53527 4545 37636 59551 54474 30761 17338 15127 32227 52215 16909 33860 62253 24876 35022 40532 27287 29670 47450 30840 5987 39516 40870 64449 38847 52032 54858 46534 16204 83 16799 45155 12368 12271 28516
!*/
kernel void test_shuffle2_short2_ushort2(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short2_ushort4(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short2_ushort8(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short2_ushort16(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short4_ushort2(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short4_ushort4(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short4_ushort8(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short4_ushort16(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short8_ushort2(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short8_ushort4(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short8_ushort8(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short8_ushort16(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short16_ushort2(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short16_ushort4(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short16_ushort8(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_short16_ushort16(global short* out, global short* in1, global short* in2, global ushort* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
