/*!
[config]
name: shuffle2 long ulong
dimensions: 1

[test]
name: shuffle2 long2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_long2_ulong2
arg_out: 0 buffer long2[8] 39131 39131 24705 14788 52176 52176 31539 19352 15099 15099 2708 2708 37545 2202 3677 18553
arg_in:  1 buffer long2[8] 33003 62615 40958 43621 52176 33723 5070 31539 15099 30831 2708 40725 31163 40679 64722 3677
arg_in:  2 buffer long2[8] 36845 39131 24705 14788 34358 17502 36453 19352 50349 44304 58898 39121 37545 2202 33797 18553
arg_in:  3 buffer ulong2[8] 15231097855621649723 4323544224899351647 8925908272619027130 13756390347646458139 17646047468931130092 16656608285254418128 11658826990239708461 4282441209564532223 4548013261494463996 2941381931943004600 12288663713583526492 705116544707287640 10979407745951366314 10550031732931241315 3617108906566053753 4589349157988191995

[test]
name: shuffle2 long2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_long2_ulong4
arg_out: 0 buffer long4[8] 7549 18640 7549 60716 44871 56098 44871 56862 13045 13045 17919 3745 61736 40045 51703 61736 64120 5701 5701 63134 45638 45638 45638 29731 17014 59794 52969 52969 6359 35610 8467 17523
arg_in:  1 buffer long2[8] 18640 7549 44871 56862 3745 17919 50242 51703 64120 63134 45638 46881 39570 17014 35610 6359
arg_in:  2 buffer long2[8] 2209 60716 56098 43434 50020 13045 61736 40045 53157 5701 29731 22400 52969 59794 17523 8467
arg_in:  3 buffer ulong4[8] 3325983190941170461 13107825970128750932 14919476542017695633 11520047023677446259 7274483525204577168 17724810052553750154 11689898910780667792 8459175163187282585 15637378148519952179 1741614109728370103 5323402474633550233 7249053672643774484 5181697147757843610 5353052417455372595 6566920990231455405 11895515996414716114 16753629313920828552 14961000419987646131 14504779627472086487 15055012441242280777 7469227523440976692 9415915348685306288 8440924262236015040 2578996265938291902 6078749324708094385 10702407836696965227 18117474411821495250 17278806854773427442 15104810928752919961 17750092189974622256 8680407453317947215 2152106735977608826

[test]
name: shuffle2 long2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_long2_ulong8
arg_out: 0 buffer long8[8] 5200 43846 43846 5200 31749 33365 33365 5200 382 55428 382 28975 382 28975 382 28975 43370 45037 45148 45037 45037 43370 45037 45037 62401 40939 62401 62401 59412 40939 59412 62401 20638 18093 48531 20638 18093 48531 48531 20638 9960 9960 2912 9960 9960 54842 54842 54842 47973 11538 25044 25044 11538 25044 62951 62951 22440 14812 22440 1043 14812 14812 1043 22440
arg_in:  1 buffer long2[8] 43846 5200 382 57673 45148 43370 17427 59412 55156 20638 9960 2912 47973 11538 22440 14812
arg_in:  2 buffer long2[8] 33365 31749 28975 55428 4713 45037 62401 40939 18093 48531 25245 54842 25044 62951 46895 1043
arg_in:  3 buffer ulong8[8] 5349577110348254377 8440215174105490012 15619932008563291700 15244859859280432505 1353326953545007983 10212181090614503218 1985300346831084358 17888312379176015109 14457509060820118660 14581567402721545147 5636152121259742076 15853392781005238446 1667522057456520272 2600931585732230182 14556770706745668704 11775754767732467634 6124617552638259349 13295383919261172011 15870420657019024852 70651135659224983 6604188121635108543 9743215547203425213 15591272167608563031 16315674810337728247 2738419244444767882 2822233122129801511 10618687698604131618 5698242489131486422 16905107065198186313 8565522891548336395 9216473034189541261 11238540882048879126 11758675981614607417 11799109999817784390 13839540648734534703 9586342672955477577 8065635013071294258 18240904873310934271 313129127699698075 14166466402725210441 7542706009300483068 3403967540586001468 12378440817746592069 9693025626120128628 16058230317193875608 8736297038338720995 12599423736363449303 10776090332255627139 16919153393854565756 6252805467250781185 17850683861912603374 16077476609657964382 16620628500112880473 17893673874458325778 17406015121274609951 13277445664865668771 6907673499032205168 14301361176206799961 8476971169901263656 3862022536520189239 1484133075483670861 12280371363071887153 16204324016373270087 11837112118846996660

[test]
name: shuffle2 long2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_long2_ulong16
arg_out: 0 buffer long16[8] 51272 51272 51272 64726 51272 64726 51272 51272 64726 51272 24171 24171 64726 24171 24171 57698 55194 55194 22323 22323 22323 21400 63047 22323 63047 21400 55194 63047 55194 55194 55194 55194 29598 60638 53674 29598 60638 53674 29598 60638 60638 29598 29598 15697 15697 60638 60638 60638 14056 44474 54318 54318 44474 55418 14056 55418 14056 14056 54318 54318 54318 54318 14056 54318 54258 54258 61655 1620 61655 61655 36521 61655 54258 1620 54258 61655 1620 61655 54258 1620 19098 52695 2180 52695 2180 19098 17357 19098 52695 17357 17357 52695 19098 2180 2180 52695 39252 59719 13067 59719 13067 13067 13067 13067 39252 45536 59719 39252 13067 13067 45536 59719 15092 53980 15092 1202 52006 1202 1202 53980 1202 15092 52006 53980 53980 52006 15092 53980
arg_in:  1 buffer long2[8] 57698 24171 55194 22323 60638 53674 55418 44474 61655 1620 2180 17357 13067 39252 53980 1202
arg_in:  2 buffer long2[8] 64726 51272 63047 21400 15697 29598 54318 14056 54258 36521 19098 52695 45536 59719 52006 15092
arg_in:  3 buffer ulong16[8] 16943983576542977875 810284723422440339 14719120170265884743 10531027183673639246 5518726007966724151 3998646282061644646 17119656068049767095 17223366288704078755 14807004075172021594 15268610192302494819 11995903713877014093 2160441469706054789 15226009277916816642 16744220030451192833 16961824834874110357 4570079219476807400 4690211121944464440 6619646978332224740 10470669024718979177 16263229872981233293 18217195814059137585 2951381629754870859 15852957043279762118 386779549346189197 12324314427381305194 5147636681908507999 6597751966820150992 4303204387168905250 10067890060969204620 6710962906816235956 10611762648938984364 1536613125429430520 15559420972960147639 17010021597046211344 3770558915335055945 7955756709724751083 5053884014704997740 14589238503020314769 5347341990168081175 10377572458918007900 10955896401722749092 14815046364618529107 5627260975043028147 14347710236024425746 12445360365368562282 16096666653240047040 9227070070030070656 3728917511698848492 17795912450747146967 10667305951391481741 5684595483616650950 8734395820324970326 1892864507674332349 12937961605000394436 1685991567037144083 16915490879806225164 1142622386631648487 17871360160117597167 1680305863277274006 4676982763510541994 115111783382453762 6334718324411859262 10068829236695409455 330880557654371138 7097517107181310274 13005642441127378562 3230974526644573468 150831205756713841 13958922434874100396 8362170259422108900 7826592532153556887 1653448669200902308 10171683464463118550 6228893828363213617 4702978710023758470 2270609110608374460 3328185931111794785 10828559333063927836 2807570516661211946 17488670217663844449 14541415158446795698 962706217410172011 4190876050533466196 12512681864371395879 8502507208305877572 14117879983194412950 12590351244810526949 6113969358007225126 4840849633363050203 4573088170493818117 5948206108586715089 6008538148397245323 2341504409985207298 12011052026605981128 5246648980603275208 1515586054558496219 17441492841330408569 9862617136441249795 12807211507333934236 8675095357545905035 9615675303206264912 2984623045273951608 8179638756088811492 17625017421287576500 14544695493777233645 16250657864190017646 10069297003448853227 7354595919343532829 6140221936497657524 11051365943249794060 4734842281874951926 13564697786735929611 1826699753783718503 12221861585607771108 796274546104696003 12048921731626387789 2485494506380354166 9205692442851557929 16047221039549166149 12761626691784458688 10662408184981647137 13747438577757007483 9011905433694907794 14069941117410923540 9927993715282000280 9078684103014132246 18099267170067095163 9156992319697107724

[test]
name: shuffle2 long4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_long4_ulong2
arg_out: 0 buffer long2[8] 60305 3531 4612 51522 61302 40517 41211 41211 25845 53065 54041 3858 50607 44696 57295 10963
arg_in:  1 buffer long4[8] 44342 3531 39773 60305 4239 61758 31673 45548 2336 63492 61302 64661 56854 31258 26970 29922 30399 61298 37127 25845 13184 50328 2067 5509 29689 34235 22066 44696 40048 63184 56615 21898
arg_in:  2 buffer long4[8] 6524 38446 59011 16728 4612 51522 34741 37134 40517 50883 6237 59546 49130 41211 22841 64846 8214 43856 46476 53065 3858 28285 12436 54041 50607 28694 62098 20688 42099 10963 57295 45300
arg_in:  3 buffer ulong2[8] 2519195847612774123 10981940872567767953 9166478230873602492 14017955592410635205 14880576069997453722 11606743651998214788 1160533878983966421 11003707560620751653 12288243358604226939 14180902506596426007 4152862369673337479 9517690250523457532 7879785551328128548 12599811031914041083 11447246562328209646 4769136259140099317

[test]
name: shuffle2 long4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_long4_ulong4
arg_out: 0 buffer long4[8] 43677 29685 24160 29685 7425 17764 43914 16605 26013 7994 63961 33734 16276 22596 23124 61857 49010 52012 52012 52012 20774 42824 33763 20613 7474 25424 65456 25151 7974 65459 43976 43976
arg_in:  1 buffer long4[8] 59495 24160 56219 43677 9402 43914 40141 16605 33734 63961 16164 20225 23124 21391 42701 61857 59479 38305 53106 52012 20613 4908 20774 42824 35871 29062 7474 65456 52351 26344 43976 65459
arg_in:  2 buffer long4[8] 51953 50447 49946 29685 17764 47039 8698 7425 26013 31294 58847 7994 16276 6886 22596 9002 10383 51402 62444 49010 39092 9505 49401 33763 26708 61550 25151 25424 37100 52992 7974 8311
arg_in:  3 buffer ulong4[8] 155554693282312219 4615232774000704639 8413374837855649673 11214854670527698703 2406353117111281911 16581831176544968380 7424041665949552017 5101911153063203531 977999548042415564 10429213152763498991 2777510172393010441 5379655904161233936 10526469769186845996 10567215079064994566 1173743896713074208 2628952721607657403 17991583179152825631 4297376548442393611 10895068614721539211 10950903416068452467 6615816596076371426 3575862086324224051 12807547340306146103 1280522849169208792 5261263548950171834 5003258523574663415 3850234301924719491 14003655234247187694 9770934161698430910 5516597721711964779 5420172278985571178 15805715672242359218

[test]
name: shuffle2 long4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_long4_ulong8
arg_out: 0 buffer long8[8] 49608 1566 51338 56940 1566 64334 51338 34527 52822 63663 41632 23261 52822 49975 28142 23261 54735 35435 11873 8229 35435 11873 35435 25161 2271 2271 44909 19017 2271 44909 2271 9140 40188 15097 44552 40188 9819 40188 15698 44552 33945 41426 18201 26906 26906 24438 24438 41426 14201 29026 14201 54613 10510 29026 10510 27181 47477 47477 52325 39221 39221 30301 39221 13269
arg_in:  1 buffer long4[8] 39923 51338 64334 34527 23261 44391 52822 63663 54735 13007 25161 38540 25429 44909 19692 19017 44552 60498 9819 15698 33945 26906 20570 24438 14201 39917 10510 44093 5575 30301 15663 13269
arg_in:  2 buffer long4[8] 38634 1566 56940 49608 28142 41632 51184 49975 35435 8229 11873 63418 2271 21878 33562 9140 40188 9012 11650 15097 41426 12918 48205 18201 18545 54613 27181 29026 47477 52325 11644 39221
arg_in:  3 buffer ulong8[8] 11906516403295918127 12925265686448663981 17854375039632019865 12666732986046352222 16623033529671625573 11400558477333253930 18051789526474684049 1670505430563358291 17184075177337192594 3739205918142814779 11890903559070774117 3003520214096659752 17346179747579049218 6036167693908852647 582489259929382452 2973361276695063240 15513887649677127040 15822700507066506588 13182712893941207862 8988119942880284357 3691185395137027572 15927334442763622558 5565060885207695780 12174003933916418346 14187518904556445724 17787962289702431156 14391538651355457313 2594209370154840187 4583948002329351228 760320920177974425 16174003279981321188 15077535336944420007 2927675619565225596 5970371133198427471 13103307415511092416 12752199304959169684 8074435634522546082 3219110608411558788 1915871501810205531 11436300338226314080 9429568390420721560 5454921153688386356 1964357974213787951 17795314250029654241 2530539694047045449 1218457244612159411 1885571390344188195 5736917518514418668 4530665283609787152 16303207099602353175 6025530299947354360 18013475313674777277 16278965917335290082 11012995610010247071 3174282625889084618 36461656624836974 4281867155800997700 15135137537132023188 7870179955257037373 10528863128212123687 13772232105422228887 13123699441085015897 17240879420259460823 1633297052643672779

[test]
name: shuffle2 long4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_long4_ulong16
arg_out: 0 buffer long16[8] 36090 58799 50254 57052 60313 60313 50644 36090 36090 36090 58799 60313 50644 58799 50254 50644 65022 20515 62876 62788 28075 62788 62876 20515 211 62788 37202 65022 62876 62788 62788 21064 27550 5784 40345 5784 48081 5784 40345 45257 9827 45257 36083 40345 40345 5784 39697 45257 45476 4943 48814 17649 48814 7893 48814 7893 48814 45476 17649 43562 45476 44789 45476 44789 26588 36678 64927 36678 26588 55022 55022 64927 15531 64927 26588 65270 15531 43066 43066 64927 49563 47125 47125 4855 14754 48854 19117 4855 49563 9262 14754 19117 4855 47125 48854 19117 31778 918 918 1776 32965 31957 1776 32965 50025 32965 31957 35785 32965 31778 31778 32965 18100 18100 65433 24850 25773 34937 18100 36954 25773 7251 34937 7251 34937 7251 36954 36954
arg_in:  1 buffer long4[8] 58799 36090 50644 57052 37202 65022 62788 28075 39697 27550 48081 45257 4943 44789 48814 7893 43066 36678 15531 64927 9262 48854 47125 14754 32965 918 1776 35785 65433 51809 36954 34937
arg_in:  2 buffer long4[8] 3846 17918 50254 60313 20515 21064 62876 211 36083 5784 40345 9827 43562 60532 45476 17649 55022 65270 26588 41826 49563 60567 19117 4855 42509 31778 31957 50025 18100 7251 25773 24850
arg_in:  3 buffer ulong16[8] 16105895928664124065 14927748548826428416 5842582319540718078 1799553511307488987 6929403372633464279 14393597845554770663 18169262009654730802 11055735373214476625 5929895385761872209 11767948702135611873 3458312184439358872 466659241344509455 13858063050092163898 15906273610965465704 10343794422339214102 9926237608390061554 7825394633338983033 4579712222064154828 6080153772899939566 154551952956185730 8021661234287472819 10435057051385565018 1011813174011061910 15447030139267430588 15523567971431541103 11931055044716042826 10227459924951652216 11922964537610862305 555909750775094966 11280014854601828554 5947942166873745298 3269838924871180133 5244158575271687281 2921983692853645821 4676782518292950806 5302885126237411997 8964975240369499850 1049834637310412285 12645673519793999934 5351770163951401307 10745411861417218583 14378199716880047395 15833951638412476868 11870877096235987430 16494319619273584718 8470315123030473117 17839705118772252656 5426443499388976443 9051879065289756534 17844446680061873608 13694480665961952210 2479755410296953639 16895760508190107682 5293396906599410763 13906632481822652866 7010919698537176139 10544711519958284074 15577073747366808190 3247922161183861679 9134830750538577892 14867313159189045126 1503073063057775209 15389186436368060526 3988636087730972961 17985256876670616294 10887960980387281153 11630785053290805923 8622218577671777921 7025320139957934798 6494002625264050548 16837526230594636580 3469714513728364467 10235634020172552914 10060781570969729251 7035918384264968878 15834741636153711925 12973097383938051002 11405581721648978280 9365202339539878304 12590889996976227843 12036017278294431204 3676540649799447578 3438063230067353050 477748682525154959 17208330772433302259 230506521864987665 16863742698275685550 10142782271978390207 18304477601933132332 18195533758099004136 12949839772073381651 1150934015106621390 9593163648254708263 6976693369881841258 5101479890839898393 3105191756085639254 15599823539965321189 9730741014474284705 6652961024395713745 5965787792466665818 17792105601046710424 9520657879043700070 10987714942652116762 6033016431508971680 13136203407959375151 12709792096740684776 17727973791665489534 16863061828266862131 10574391702377781616 6746315684665901845 5140790423095720725 12728912932292135840 4320711042334837788 7230366184714528276 14966629559277458848 4044194456587599151 1503283709809837422 9993269746225690995 11576993504958050788 12141411529875509218 7386611685566401342 4161416281782680021 15529353057670530883 12539170324952419485 11932632762165055523 10399860440921384485 3562704355855397978 12808214039269273946

[test]
name: shuffle2 long8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_long8_ulong2
arg_out: 0 buffer long2[8] 53216 55117 12261 32200 60529 49319 48679 10892 25084 27266 35804 43185 24951 1371 17627 17627
arg_in:  1 buffer long8[8] 55600 36469 61457 55117 45275 53216 33665 18959 17669 32200 44230 12261 31287 41221 8167 38229 8051 49319 28309 21047 41492 55000 37342 9456 57758 18647 10764 54652 3341 7908 19790 10892 61869 41654 3786 30105 37330 17241 25084 60801 35804 37259 40127 18875 51556 56124 64104 43185 59952 15360 62045 24951 16743 41333 25334 40587 17044 65137 20815 2444 56692 40863 338 46561
arg_in:  2 buffer long8[8] 49898 42945 12016 43575 4729 11562 25732 46439 27251 29056 9646 866 18462 36699 7063 23155 2590 37210 64368 7775 60529 34175 42815 38112 64298 62761 2140 12756 53126 48679 32047 61949 64902 18135 63485 58570 48985 12316 6736 27266 22180 17565 63233 12881 62925 19577 871 21040 7912 4298 52997 48890 22514 20386 13530 1371 17627 45149 33453 65329 6739 41454 36927 38090
arg_in:  3 buffer ulong2[8] 15406175311105953637 14181608462404547235 10921929447732066867 5034987447560767697 9916737777247635740 13470857747670176193 12915710997076661725 10939495649561000183 7907766464426570694 4621733954103900319 8390923063401857136 14556746262644303799 2592088162057745187 16300502296786239151 17827896024667408296 8190603531754728728

[test]
name: shuffle2 long8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_long8_ulong4
arg_out: 0 buffer long4[8] 62493 37353 18414 39635 25740 14920 14920 60776 26643 43227 43415 10918 37015 48884 62255 41941 40838 64719 64719 58968 51922 40387 8135 19180 44024 43171 21463 13216 28778 65064 26978 63920
arg_in:  1 buffer long8[8] 39635 23563 18414 53042 40185 27334 62493 55723 19326 17906 8811 14749 10723 20670 31610 60776 2526 6891 7308 26118 36216 10918 46521 26643 35243 2860 37015 28120 48884 41941 37658 61134 40838 65043 58621 61066 64991 26743 23926 35746 8135 7897 59293 24361 53688 57124 27893 19180 39191 21463 21688 26603 27189 46411 30391 41801 63920 44992 26978 60635 57243 65064 33423 9445
arg_in:  2 buffer long8[8] 20993 24402 23769 20157 58682 13179 37353 49326 56673 25740 52125 24980 65044 52268 14920 30280 32196 43035 15269 30333 14227 44085 43227 43415 53797 62255 41490 37946 28283 29964 26700 61670 13686 48070 14842 33450 15005 46990 64719 58968 14193 40387 51922 30270 33722 23149 10397 52840 13216 47179 61044 17210 51660 44024 19188 43171 47096 13070 13833 28778 17856 61838 48802 11977
arg_in:  3 buffer ulong4[8] 2220296365937495622 681203754469670894 2856796931810461522 10840281874027283040 9300272881017795609 7151501076204870830 9320813508598812222 12167136520323156007 5219709223188135399 18036876817936931374 168499720619376175 7831002262633120373 10866411135926330354 315257933855031764 5661869544102005961 14780369840115267877 6060540321280696496 543787176622747694 5609871711765856142 5476466546060584223 9436074656817691178 8711223820567134281 7688136936561678560 158894585890142039 12525537397293576877 7898706168676607551 15962286376814200497 12667376660036325896 5596912130041477435 16452463062741253285 329494481565143970 3668170076095225296

[test]
name: shuffle2 long8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_long8_ulong8
arg_out: 0 buffer long8[8] 37303 50818 37303 26287 6968 55634 55634 6968 63394 30779 48085 30779 2963 39103 51772 53382 17214 50348 50348 16601 52787 25315 35894 22273 5525 7994 61294 60069 61294 44526 38008 38008 53271 36996 36996 25875 64265 36996 43650 36996 7406 20276 52088 52088 7406 62999 14358 52088 45269 24641 33654 24641 19448 10319 24641 10319 55182 14164 61003 35461 35461 28586 11599 14164
arg_in:  1 buffer long8[8] 6968 50818 47995 44654 28740 55634 54141 3442 24913 51772 43540 43311 63394 34089 57403 21155 50348 61194 16601 13473 25315 22273 63899 17665 38008 48158 712 17491 49899 39438 55980 44526 18472 53271 43650 17137 25875 42060 22633 36996 21774 54620 5551 47888 15317 50900 17534 13200 5780 235 9807 9273 45269 13312 48789 19448 60352 28586 14164 3077 55733 61003 4972 35461
arg_in:  2 buffer long8[8] 37303 60379 26287 30168 47267 62870 8906 11987 30779 53382 48085 39103 6437 44852 51409 2963 50139 22741 11361 17214 35894 34767 32001 52787 41624 5525 957 37069 52577 61294 7994 60069 46781 64382 11038 64265 25522 33562 57747 23590 20276 14358 52088 7406 62999 62965 61341 15899 37949 11459 51927 35661 24641 33654 10319 60294 55182 11634 57342 26312 54861 41669 11599 28361
arg_in:  3 buffer ulong8[8] 528860831032109048 4418168656678535377 12957780546548374872 18372369947839407322 15430210627648391760 12462293362854295301 4195969654816432613 18317721730387915232 6410663884643498804 8495087490229944472 9651257194606405402 3222232206661146840 16813556509704403807 6568811355473978635 1873036965997368945 1308068651156096089 14559262184913873563 14597024587114546560 956290960115368944 13732061309921327330 8052514121932497135 5948681784352151988 6342764377010373836 9944186036294557637 6903354596854934857 1499418486294599950 17688740996209992733 14161093196616731903 4428622237358108429 13140502015676997639 992009409318553520 12969945207342836960 14098456561523450513 13163091387077983351 10301653931163466071 9464492822700212292 217725730354893659 9587185104487152423 7288177120121772146 3109085581182648951 18240588886631862443 11076050400543144584 9279158667827046314 11766634950010721114 14451970071080850363 6742715557742941532 7238127939793844889 8447791437954238970 7388745943432475508 37227894800673548 12058920079994134557 452955090383472572 15918266264571108503 13361201982682689406 6270462779754788140 4143139456206414062 11434806411584213944 11052581546877602594 1768111384140911973 13829628976959649623 1508838814404340631 16973558184027793121 3161249264241426910 2532659643500050818

[test]
name: shuffle2 long8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_long8_ulong16
arg_out: 0 buffer long16[8] 43493 14987 44110 48080 64980 43493 9338 1258 8040 28595 24742 44110 1258 24742 3274 29354 20008 20008 49825 27284 17820 17820 64850 17820 27890 8005 58452 20008 23552 52235 23552 29356 26029 11054 35389 5730 11054 26029 43373 43680 47137 47972 47137 43373 47137 26029 3342 61572 8828 5271 12689 62889 47695 59195 29673 64187 8828 5916 37540 52299 47695 29673 52299 52299 9143 10821 13236 46057 27309 21857 16057 23500 12816 23500 8069 9143 33298 10821 46057 8069 63010 20434 20656 61334 62342 62342 34469 12777 62280 34469 28709 62280 28709 56616 28709 20656 33539 43350 51608 36578 26662 59 43350 50669 3837 51608 26662 50669 36578 32165 51608 32165 45003 63857 63857 27503 60457 27503 58629 58629 55839 45003 14186 61551 6583 6583 38568 32433
arg_in:  1 buffer long8[8] 1258 52698 17738 23301 24742 28595 43493 43392 62019 29356 27890 27284 52235 64850 49825 11955 47972 56347 3342 5730 43373 7263 43680 26029 29673 47695 8828 59195 43732 62889 10677 5271 10821 27309 23500 16057 40152 29912 64767 46057 20434 63010 34469 61334 62280 9200 62342 28709 50669 33539 32165 26662 3837 39709 15285 32821 63857 10428 3364 58629 32433 51575 55839 27503
arg_in:  2 buffer long8[8] 14987 3274 8040 48080 64980 9338 44110 29354 8005 24751 45187 17820 58452 47002 23552 20008 35389 11054 24739 65175 47137 61572 7560 24746 56409 5916 52299 12689 64187 37540 39126 28059 9143 8069 12816 21857 41961 15425 33298 13236 25656 20656 29458 56616 10833 12777 56315 31836 59 31284 43350 51608 36578 7201 61977 14376 6583 14186 829 45003 61551 53630 38568 60457
arg_in:  3 buffer ulong16[8] 9890850020989270726 4492053505278342920 11308490773215183582 7094442992412749035 6930892745997876236 6807920064505726982 3074090274512981645 10524579860880123280 3829153595571501802 3344340235722872949 15302975040168658660 3509719757724971390 1794809384300897296 350031125671666884 14850622110107701945 18342323225598138111 5801408544501223055 14325455663938833695 6239270313999183654 220188508840177299 7117799982112953275 16059664876820051083 7829018121038109141 17088167286220363275 6549272458121575842 7202578286326491352 5668603919076698780 5685526483815104143 16357092799991559966 10094677421846086548 4991231365590220046 6784587485873951937 16768229872559273895 368821695388576793 12875835002121003592 6692308443506347139 3208052826193526409 368632749663218551 17147967685958585220 1241983355155525862 13205152430624838204 7341566865666939456 4897456429270371916 11606958255695061476 15476810311930278796 1719666727055058775 12167055009326420690 7540364059093382077 11728142862612195298 5928779758200200583 256055961792003275 3665894282193543205 10775722299193916161 3931739360299949523 11670918531795094144 579925034347468924 505424673206674770 13588719901551580313 10980204716797016493 5513941053784769002 3736474676008548705 3597156673733942416 13364927539146366954 2873253457406904570 12818233240770094760 9572695998917208976 14146782215841271423 4454103095052668567 5673321772713420641 5265949063790685243 15546220670983995635 4793933068705503858 9346409699001041018 990510557456108450 651091077247590137 4205924540657505064 8018476345299758254 13516088077513528464 2662856354652366791 2885082390455315273 8557386236836655297 14511679043305859872 14683017608179715993 4173860890571740003 7174587779919625702 8042567037730442870 11984825176745628386 7756286636436389325 12815151531180525284 9254336787999654066 16797921791660409879 5021070455334089476 9713385699500749943 18217862322023145899 17729522624198376439 10579920992538671257 3872593402906208001 7789735205606231738 3940637716902684011 10911705670120239916 16220771633533400979 10539050541071429368 11219490586567213674 12720801258910372144 3057518400290085028 16298837490575967915 17017502599571993251 10537769720533404816 17673842918092423404 15585092002896635074 8442957335830332987 7333563172401990050 15836681121777544379 16092613508208818944 18299758060472409680 15007351172115562839 13783491598978005647 12379505163929844455 14294060572124143331 9449941768981963091 15361535982260393766 18104120460187562267 1791111133615645737 5204263013323919564 1212738298228500296 2763133283982510472 13233074833384595886 4779211769564113060

[test]
name: shuffle2 long16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_long16_ulong2
arg_out: 0 buffer long2[8] 39233 55841 60733 54475 48623 51769 28221 25576 29542 15273 39682 18220 45538 24219 64130 57757
arg_in:  1 buffer long16[8] 14546 9316 27438 23909 19107 46526 54884 19822 54482 55841 62143 26126 32185 1294 55745 18004 28059 29277 63034 34974 4137 26438 21447 27992 916 44123 899 29727 34067 9648 26642 29570 27547 30859 36836 45311 37555 11203 1716 11989 62455 20324 1450 14496 62974 25680 29899 41368 9882 21920 32153 21129 47173 6311 20219 2917 7115 7752 15453 49781 59255 18988 31234 25576 28295 6165 29542 6380 19211 53567 46530 7027 61095 33195 21058 12160 26987 4809 55927 8385 7362 23931 2479 40095 5355 44646 50581 27862 64577 30793 11941 11160 18220 14101 10735 1151 23938 8612 59706 59210 32744 48217 3219 32777 19216 5803 54989 8494 24219 29482 35546 57444 44164 7771 14654 20824 56602 26614 2780 57771 10553 45781 57757 45993 63803 11465 62993 34092
arg_in:  2 buffer long16[8] 7991 11700 41031 4125 58620 15104 18831 54618 17000 8946 18782 38958 61681 39233 60530 17922 35107 6596 30339 60859 61966 56325 59413 31669 54475 8978 60059 3431 38517 60733 5243 46528 51510 54879 57973 51769 24850 31222 48623 46562 44985 47391 4243 38714 47340 22423 53840 46941 50065 52619 6443 8032 63775 10559 28221 49770 50185 58213 27290 32746 40259 47786 7506 34817 64663 61624 63685 24407 63481 26659 36930 12408 38817 35599 10031 54494 12667 52738 15273 9454 39682 3203 32403 15906 50765 47695 12822 20316 63187 19413 56612 53106 57473 53432 59873 5322 50753 52651 28350 65245 59320 5120 15926 10332 45538 49700 47605 16955 61741 27924 10231 53578 60737 55275 47683 51630 8180 1695 3909 27807 35485 64130 43699 43989 17936 8929 16927 57587
arg_in:  3 buffer ulong2[8] 17608635614654634877 12131628638015113449 17775623147402420797 8948207058395945752 7455511397904960214 7817704487080552947 2177517741153305494 3435058239691035503 6578613073969792098 13752458747573008094 14628668808425979184 12061638154263814956 16995880626043359416 15085796497091333452 185104236259589273 1163911205799758954

[test]
name: shuffle2 long16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_long16_ulong4
arg_out: 0 buffer long4[8] 44403 20514 32911 19450 36483 32435 36483 35400 52231 41197 44164 35822 62688 31278 45379 26770 48714 37036 36804 17865 63809 25439 41248 23348 55571 8627 26109 21167 16647 50959 23184 32668
arg_in:  1 buffer long16[8] 8446 2760 20514 49055 54642 9660 30346 18832 55501 19420 36509 31693 19028 39905 5264 43144 36483 43444 51852 28394 25461 56803 42714 24957 34916 32885 64367 32435 25816 25565 11282 12882 59124 11076 2754 11307 40405 21329 40470 52231 33789 27154 17147 44164 61181 62889 20019 12129 52008 5069 62680 26770 62688 41006 40101 20052 26463 45900 28193 493 8787 21321 46307 21250 42925 44217 40020 60935 11691 42129 11423 48747 1380 35942 17049 61624 4288 63806 17865 53765 369 3609 63809 25885 42010 36968 39060 6581 33660 49392 34946 55300 53422 2699 42743 911 27393 44578 56053 6622 57462 24276 48205 43864 8627 33132 23199 21167 49909 43079 55571 5690 17004 56370 5707 45241 31905 54689 9101 35911 40270 53913 43736 16647 8533 31590 41752 22965
arg_in:  2 buffer long16[8] 33363 32911 44403 47485 17989 10140 11355 38685 40412 30085 41357 19450 46111 42938 39867 50036 32463 7524 38788 43270 18135 908 27967 7298 52989 41067 21079 43553 47675 41723 35400 61907 44073 8914 41197 52105 44992 49792 28547 34026 28750 1629 1899 62045 61142 35822 43224 35002 25240 51300 56585 64719 13041 18245 4346 22729 45643 46583 27964 56014 34742 45379 23420 31278 44620 36804 48714 4515 15644 9581 51664 39484 48577 15738 40187 54705 51205 37036 54326 50899 13421 63203 25439 55862 58019 19425 39305 53169 59194 41248 59204 35202 23348 46120 196 53198 62853 15796 33993 23739 8122 44441 2464 48659 21639 19199 5553 36479 63549 5312 43141 26109 15682 51022 64432 50959 6674 20232 28903 54602 32668 5510 23184 50509 4458 26425 30420 44435
arg_in:  3 buffer ulong4[8] 11162739905613768242 17117112383363843330 13409798581299763313 11652945839766945691 4490150503067201792 10665451903840802731 18135647228552175936 7670097852920762558 14410802181206217255 9926734850122482674 7770036416483927499 5874264727922124381 13593808755795837444 9525484514389357919 13840403145310496669 18396723558127108547 6042801261077814034 12862864628786255357 12036255019323866289 10841334920247644750 9408880231603980418 8465561210375917234 7245861227131105369 13512371790156158716 2946720044017676270 8241818921691843208 4043204713986763583 4112729324687541483 16667097738432923979 4198637423821995571 10915746646130005050 9814237678087045688

[test]
name: shuffle2 long16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_long16_ulong8
arg_out: 0 buffer long8[8] 53443 18277 38817 13536 51871 5361 46608 64556 62917 24472 7167 39562 18459 27238 39562 62947 46490 48396 42046 48396 33786 36020 2739 37310 28570 3420 17956 36269 59447 36864 19111 57998 2698 51851 1220 35681 34474 29803 17861 14751 46157 1616 56769 13192 19177 63366 22295 21868 20953 878 31342 14961 40712 34892 8436 878 26314 54406 32242 65494 33440 17950 41092 13470
arg_in:  1 buffer long16[8] 35028 13536 38817 64395 31985 18277 6257 56693 62548 43484 7176 53443 11346 10632 17558 46608 62947 39562 52507 24472 55087 32865 52629 49973 46786 27238 35139 6028 40630 7167 20860 34192 15898 1010 49569 52305 12295 33722 7736 36020 43934 3916 33786 3086 697 23395 43210 2739 50809 57024 14352 59355 19111 33714 57998 53429 52916 64582 59447 28570 21771 3420 22619 60306 17734 1220 44442 40463 14751 2698 22108 42025 60664 19844 35681 17427 17861 17833 19971 45593 4897 13192 27018 37297 1515 19177 12470 60050 11521 4791 57941 37359 21868 14703 44016 33676 26861 3762 22528 51910 15096 31342 1075 25486 2520 59617 878 50227 40712 34892 9962 25372 32242 17950 56034 54406 18796 23930 42790 45938 11594 16883 41092 58698 33440 54175 65494 55810
arg_in:  2 buffer long16[8] 61091 56057 16033 24448 62776 30331 56051 51871 6166 21698 64556 5361 14960 44598 26312 33808 46850 41493 34587 62917 2228 49983 14405 9833 4215 4836 18459 8873 46426 13337 15178 10091 42046 44083 14542 29420 42328 11838 17467 20141 4166 37310 25120 48396 46490 6282 65399 47488 24235 22036 23252 36864 36269 9114 18316 55109 17956 34382 42715 7490 2723 43799 8059 49272 18868 46760 18944 34434 61851 19871 16907 39635 51851 5881 13576 29803 34474 3612 17510 6883 46157 24157 238 56769 2967 29467 63366 25195 55646 1616 22295 54735 17209 44312 32516 61337 49471 5873 20953 24833 8436 30789 29235 43764 11506 22159 23938 2724 55995 14961 7626 18307 38269 20631 45892 59352 13470 25808 44696 61557 6438 26314 12321 4205 56756 11418 58954 45941
arg_in:  3 buffer ulong8[8] 13327051252592096491 4323905436821848645 13931375245164378082 5053851674026763265 4144800753886159863 5065541166337249371 4237213149445388783 3090896028647564218 8472421805104957267 3281397084643894851 18110714498201382285 4709447414903887745 561306987620625114 18095287099949513385 10312734634034023809 12706798955075167584 16599628779625532412 8453103821723592443 3975820822990169296 5475816900115183867 10037841656511129674 18113062133715942663 11134958758911469487 11985377336023465881 3569489859627556747 7911592825918432365 14986207805454365176 18199416463411330484 12595937120247645770 1734999693180129811 12354103895315693124 9658692519878125798 15097415331818216069 9385806643977715416 10540573809259871393 15524422529517383594 18161042198543645532 11984976706136298203 401469505071050796 5132179174035130532 210127887762929424 14747850659968760889 1357802680105156019 3600747873981517697 4434325749121878629 1854532955769026326 10954486376767032154 11102491251210533772 17223299508559627602 9939707036084689610 11850713092855960293 1715882700601937085 16982153877296860300 8361584674343203597 7737532308566531572 2072924631233211850 16212732718318088409 16161599299660321571 18363140816248418336 17459383183246485710 9191681643019562508 9001727519533838817 15119139456479042922 2906874514944227380

[test]
name: shuffle2 long16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_long16_ulong16
arg_out: 0 buffer long16[8] 32318 25920 44327 47686 3074 5249 62512 55575 51407 8337 37873 46000 49357 7593 49209 27399 27057 57521 62988 61286 3633 37819 27838 6672 3633 7495 37819 27057 54348 27838 57521 1906 8 25476 44767 34778 57269 44767 46169 25476 46169 25784 25784 58093 51533 54969 3381 37861 20483 95 64494 95 37252 45496 52538 19676 14808 39385 52538 19584 26609 581 62169 24633 7422 56020 543 12458 46831 41775 4550 65012 46175 56020 12458 24317 42531 46175 38843 60840 54775 61481 10646 54775 23174 18294 1806 1806 36910 33019 26457 36910 39271 3919 1806 24421 20764 15859 64599 16842 20636 17444 27086 61457 56462 31661 51337 27086 5457 17444 11291 19083 25736 52367 9326 6277 1594 12030 52367 9066 58893 54622 58748 48737 24751 19679 1594 18563
arg_in:  1 buffer long16[8] 3074 51407 27531 49209 47686 57491 8337 22426 63079 57942 28031 25920 65120 12452 64649 7593 54348 27838 35811 7454 3633 38389 48462 11854 50270 60244 51092 1906 7495 37819 24760 55151 54969 13712 46169 62845 14148 39012 49615 29977 39191 14047 51904 34002 41363 8 43243 25784 19676 27598 581 38424 37687 45496 95 27912 61791 55372 37252 4717 50156 56232 62169 64494 7422 357 31254 36985 24317 41775 5018 61187 30728 46175 42531 42902 4550 57261 29192 60840 27658 8067 10646 4260 33019 3919 12131 39271 48796 17350 58896 54775 24421 23174 51850 60632 56462 51337 11911 16842 17444 26637 62055 20636 61801 11291 6763 59783 27086 18852 21570 5457 54495 1594 457 58748 29677 48737 28103 31884 24751 9326 35348 9066 12030 58893 4703 19679
arg_in:  2 buffer long16[8] 46000 20550 44327 5249 27399 9247 62512 34246 32318 55575 14327 49357 49226 29080 42282 37873 9058 13940 57521 27057 62988 61286 38288 28211 15183 54838 61309 6672 35951 32727 58072 22476 6860 37861 34778 57269 45298 22625 40309 11292 58093 51533 3381 44767 1337 25476 43133 58820 23271 14808 18249 45076 52538 33378 14196 20483 24633 8550 19584 9043 62056 39385 26609 3153 38843 543 2983 4164 12458 4278 46831 56020 65012 28759 21238 7661 35640 18883 33913 41367 36910 45564 61481 18294 16094 21158 58110 39975 63239 26457 19933 1806 43774 41178 5568 60391 32856 20764 30295 31661 5683 61457 30824 61700 48601 57535 60765 56899 15859 19083 64599 42395 10333 31977 52367 27033 6277 1068 29014 54622 11387 40786 21440 25736 12254 6783 47373 18563
arg_in:  3 buffer ulong16[8] 13629134289971959096 101479755945380427 13294178113296013042 11227783338984230756 8765944620436956128 15405494377031803027 11038635811965268854 17283322541418516025 2508547926636256033 3033004475463007366 18342486994180478271 15012412921592119216 7677795014214758075 10540734639850538479 8533452569445652995 14927342962256559540 14314487454878234675 5801701014488971250 12648405443105666292 8306266014107777493 14461023637926180292 17981473787167024237 77752605222882977 8880248593533612411 4756058868554076228 12958389024047869292 11127413093363192205 11643216298520221139 120762840782066208 14032867361349415009 9816824048413419666 3165419867254725931 11617087470985294733 15663198704335351485 6107041817986037115 13142430879498842034 16646706530325836467 10596943324120573147 3784000960886051266 10239128546745505245 17384961012117857026 13697646724689968463 11164714474941183055 7434136083143171416 8421024893059806905 9894241711290361888 14258553316872761018 15600201012116402097 3407410240378798231 1119567424479144742 1572787362636547567 9432511923741602406 9030671650069191722 13957761980635674981 6661041231395982708 2236597773499375680 17770102950624829745 16243450061967798813 1359310849652356692 2968929571208657274 16495784783138630494 4684731938152915202 5354605211438387118 5856633442836090680 9929896269050606048 630555901358769335 17184602544595126577 12205877633591226388 672110950183134870 16557164237289151301 17157500646399138380 6762424643078244600 5291866021257384105 17864645787136234871 2326712917020102292 1755291311828577476 18238577455910102058 326231669849124873 8165089892381125936 8736711473125203311 9191120350607263435 15092862071847570 9639642237048132898 9950164709162752779 12528199913740892429 6261951071363151731 17891573988325810811 6578406591189995291 7209653170408434448 4047815646167038020 16635374699951237465 17897533906637800560 3121263058310024135 12206046895726269861 11771782009121142779 13583084071537215116 11598129512209624625 4620612404382318268 15748869221973562814 1693225404420939747 364622360447626055 2610098479515069028 17474365018151275820 11244159123988003061 820773572790351040 17487745337215757171 6693434924671533217 13587918642261942764 15509689685674543727 606643705549836260 1053408807746774153 8029056401948046973 5248878043981672251 10118436700619964050 11945859946950438921 629546651679819508 1869372396473164737 10425160998883620588 9048166869731301682 3395827549994987595 5255585801329195149 12911368597103022039 11717012475754579747 10792968757649944421 5073670225338874856 6116414245439104399 11260614194942071489 6213547331794886847
!*/
kernel void test_shuffle2_long2_ulong2(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long2_ulong4(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long2_ulong8(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long2_ulong16(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long4_ulong2(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long4_ulong4(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long4_ulong8(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long4_ulong16(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long8_ulong2(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long8_ulong4(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long8_ulong8(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long8_ulong16(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long16_ulong2(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long16_ulong4(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long16_ulong8(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_long16_ulong16(global long* out, global long* in1, global long* in2, global ulong* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
