/*!
[config]
name: shuffle2 int uint
dimensions: 1

[test]
name: shuffle2 int2 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_int2_uint2
arg_out: 0 buffer int2[8] 10375 46107 6953 6953 56841 24618 8764 2987 3896 3896 6209 55656 29566 29566 37538 26416
arg_in:  1 buffer int2[8] 10375 46107 44400 6953 56841 24618 26438 879 3896 31841 6209 55656 50170 29566 26416 3496
arg_in:  2 buffer int2[8] 17530 15657 48888 31774 53179 38498 8764 2987 3759 14867 2823 53021 1247 38275 37538 32163
arg_in:  3 buffer uint2[8] 1364202024 597181061 1415986117 2554363205 2357578260 2741969345 2477515726 671745599 717847856 318584144 3528002848 3005180397 4195478981 679494669 4045956178 775562080

[test]
name: shuffle2 int2 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_int2_uint4
arg_out: 0 buffer int4[8] 64213 54088 64213 4886 34972 34972 22628 34972 36111 36111 24579 53181 3353 41066 3353 3353 20918 13268 14240 14240 28397 28397 40132 8806 40650 24947 11737 24947 4762 36351 58793 4762
arg_in:  1 buffer int2[8] 54088 64213 38045 22628 36111 23682 41066 45417 64694 14240 28397 40132 40650 24947 58793 4762
arg_in:  2 buffer int2[8] 4886 45662 34972 50707 53181 24579 16217 3353 20918 13268 8806 64198 64344 11737 11207 36351
arg_in:  3 buffer uint4[8] 563290077 2282805572 3610511381 3973563806 1492928866 1421054686 3164642465 2190122542 892078244 50837872 3574064631 259353482 3805421451 3334610184 3197012179 3138683143 1333420678 3580059255 3879246337 2319743077 713250584 3702315276 321078933 3458376310 672566436 3782987461 658791031 2033248157 3188018165 232910555 174425908 305251617

[test]
name: shuffle2 int2 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_int2_uint8
arg_out: 0 buffer int8[8] 51873 5465 48914 51873 51873 2730 48914 2730 14416 14416 33674 33674 51628 14416 33674 6262 32840 32840 32840 32840 25395 50554 32840 25395 30518 30518 55185 30518 55185 51503 55185 30518 5946 4654 4654 35712 13579 13579 5946 4654 57234 1517 504 57234 57234 21943 504 57234 9092 9092 11422 41952 41952 11422 11422 11422 6052 60018 60018 3071 3071 3071 60018 3071
arg_in:  1 buffer int2[8] 5465 2730 33674 14416 50554 56693 51503 55185 4654 13579 21943 57234 11422 9092 60018 6052
arg_in:  2 buffer int2[8] 51873 48914 6262 51628 32840 25395 19432 30518 35712 5946 504 1517 7029 41952 3071 3969
arg_in:  3 buffer uint8[8] 1855705922 4036726032 4290769151 4216167590 1252729494 2220999901 3476960079 1141630281 498697873 144559161 1347604400 1678437076 1927735931 1015643393 826653564 1826948894 2236346702 195475306 1809155638 4199143774 2995869419 1534351940 992840626 745440499 2182622051 1973460427 544992673 2707662799 555970149 3284592944 513198985 709377095 3123124807 3321340744 959230272 3302563230 1398476161 696987057 1654076407 3519116792 1419350025 231060311 4004356834 2783006753 3636179113 14311024 623865878 1861253529 3277463141 846029241 3040554848 1950538219 2080894607 1434861528 2697901372 739607416 1648169229 786002896 3898176380 1577780458 3737199694 929751982 257997120 1516217594

[test]
name: shuffle2 int2 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_int2_uint16
arg_out: 0 buffer int16[8] 37299 13792 45133 13792 21002 13792 37299 13792 37299 37299 37299 13792 21002 45133 21002 13792 58538 37855 12869 58538 58538 12869 12869 58538 58538 58538 12869 62432 37855 62432 37855 62432 28159 14401 28159 33465 28159 50408 50408 28159 33465 28159 33465 14401 33465 14401 14401 50408 29441 36176 29441 36176 51037 51037 29441 36176 24091 51037 51037 24091 36176 36176 51037 36176 61565 12447 61565 26374 26374 12447 49546 49546 26374 61565 26374 61565 61565 61565 49546 26374 49981 49981 48377 3175 31313 49981 31313 48377 31313 48377 3175 3175 49981 49981 48377 31313 12569 5394 32885 32885 12569 5394 12569 5394 12569 13831 5394 12569 13831 12569 5394 32885 13838 29654 29654 18266 48190 48190 48190 29654 18266 18266 13838 29654 29654 48190 29654 13838
arg_in:  1 buffer int2[8] 37299 21002 12869 58538 14401 28159 24091 36176 12447 61565 48377 49981 5394 32885 18266 13838
arg_in:  2 buffer int2[8] 13792 45133 37855 62432 50408 33465 51037 29441 49546 26374 3175 31313 12569 13831 48190 29654
arg_in:  3 buffer uint16[8] 2798192184 1464473774 1097324143 924123334 3055101061 156676902 1732708268 4081044982 2878634084 1707660708 2245590360 2712999170 1839772633 977863703 1174913033 3070154794 2330676613 3889066370 4237997900 3461056693 3722183789 1171180860 895101244 3627400161 3889460605 2678236673 826053176 1694484799 2080637934 3787203555 108162338 1900383931 2278628393 1667557520 3201026437 3302987655 526078457 3702627622 3845513090 1148045965 3883135363 3788110477 259439951 2116764032 2189959459 2827677340 635592804 2574669294 786982367 138632001 1856753191 1466466985 4147067870 322900130 2115746935 1947137285 2158971940 1413459642 4114499986 91481496 3477815001 1031455909 1182617502 1946700541 1253725889 1679534248 613592149 1916566467 1968385747 2184577196 3661427314 2442965714 4237315547 2210811293 2696552811 3140589421 3172962105 3672254837 3831758546 2344674751 2336361153 2364387373 3272396248 3339808202 2649635451 2509201197 3442722875 2510759088 28420295 2079391652 1075083642 2612924626 3479305173 219812121 339695476 39222571 982931814 3885189888 1774634329 1718605777 584941258 4136585756 3575399346 2152952068 2150906462 841995255 4279937780 2279140442 1795216699 3841252214 459843308 3583394097 679356725 3148962063 1423841879 3556394936 1342821074 1640474758 529173838 2644525471 2479914564 297839592 1116246009 3206222511 1771773359 3478094314 3965202287 1365536345

[test]
name: shuffle2 int4 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_int4_uint2
arg_out: 0 buffer int2[8] 43799 22 15494 64170 33617 37368 27401 25002 6582 43406 38934 33827 32398 42867 32673 10878
arg_in:  1 buffer int4[8] 43324 62923 59661 36608 10891 11718 21319 15494 13873 6121 52917 14308 13644 15890 40580 27401 48234 47636 43689 42324 24929 31110 38934 36364 48455 6625 62643 24350 43293 47164 38532 41596
arg_in:  2 buffer int4[8] 52963 12839 22 43799 20756 52037 64170 12414 14993 33617 37586 37368 44513 2253 25002 25246 20787 32753 6582 43406 10805 33827 62017 43986 32398 24219 42867 23065 21615 32673 26739 10878
arg_in:  3 buffer uint2[8] 667608351 3632303854 3630655475 2217950670 2603774261 1618773983 2842236395 2396952230 2299809222 3089061879 3791224898 593188181 2413472412 3809924878 1377064725 3388171959

[test]
name: shuffle2 int4 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_int4_uint4
arg_out: 0 buffer int4[8] 54447 8118 28177 23356 43968 48492 43968 48492 31788 822 44308 822 6805 61597 29294 48436 37610 7155 1088 27217 7328 23157 25203 38974 26850 33539 19349 8745 47884 39160 6125 47884
arg_in:  1 buffer int4[8] 8118 16056 31147 11813 8614 35936 61759 48492 44308 31788 10337 52409 48436 22588 29294 59690 27217 1088 22185 26473 4059 25203 38974 23157 38889 19349 57895 26555 28891 47884 6125 45527
arg_in:  2 buffer int4[8] 33988 23356 54447 28177 43968 37100 10641 8302 37673 13514 43187 822 3843 60778 6805 61597 7155 37610 34655 17275 42359 27338 7328 56410 55069 8745 26850 33539 39160 29950 10851 19547
arg_in:  3 buffer uint4[8] 2321796222 45899128 4158403471 688803605 928331308 958193571 3136354756 1338161539 154037745 202987871 2669875584 3870904431 1105214894 1840550383 2031514746 3805446232 4212235445 544826460 1846130257 390157200 4171072062 3700275267 2075934553 3334414250 1907243014 4136737967 1000987801 169704709 470890281 1180666052 4003800082 4271840385

[test]
name: shuffle2 int4 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_int4_uint8
arg_out: 0 buffer int8[8] 39384 64146 39384 62976 39384 3809 62976 25997 30642 64534 52477 33190 52477 12886 33190 64534 62620 45004 62620 62620 45004 11823 18068 22904 42858 37769 53624 40797 61395 61395 3924 61395 23412 26573 65380 12958 23412 4869 12958 4869 31116 49397 49397 17827 12534 31116 31116 28911 51364 11182 11182 21161 24308 51364 28557 44962 22296 62459 10287 62459 34935 13732 10287 22296
arg_in:  1 buffer int4[8] 3809 62976 25997 39384 52477 62982 40828 30642 52447 11823 45004 5216 53624 61685 3924 42858 16104 23412 29769 65380 47463 54137 12534 615 24308 21161 51364 28557 22296 61186 10287 62950
arg_in:  2 buffer int4[8] 64146 40682 28780 142 64534 33190 12886 16867 18068 22904 9929 62620 61395 37769 40797 1117 49781 26573 4869 12958 17827 49397 31116 28911 10111 8624 11182 44962 13732 62459 50200 34935
arg_in:  3 buffer uint8[8] 694812083 3308618252 1695947283 67876353 936208715 2368630568 1374095377 496346722 845286723 4097933804 3738852560 3834509221 321891792 868135742 472236053 1293280420 2982484479 3978113146 2906803207 1499269495 1673419722 3536601777 1650651180 750333413 4231785547 1383576021 522733360 1275419454 401224228 2722963444 1509921490 26347852 1811732393 2695594053 4216493323 1883191791 1051151505 296116094 365779775 3760047374 1396691214 1041524053 1160962637 2393902692 1346780618 2594642926 2370662414 3434867919 1345814034 3752237758 1410074334 220402513 18098464 2098777466 2761376899 4222896935 876079000 682868893 3956490074 1143951221 543368199 1758857708 389770890 163462048

[test]
name: shuffle2 int4 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_int4_uint16
arg_out: 0 buffer int16[8] 31416 44618 57772 63037 44618 5884 6253 18851 6253 63037 5884 18851 6253 57772 48081 31416 22160 34753 22160 52147 17244 26333 53044 17244 53044 34753 26333 53044 28888 52147 22160 22160 33908 1865 43766 20899 59892 20899 59892 33908 20899 43484 43766 33908 43766 35588 33908 43766 21597 23416 30246 53422 23416 35315 53882 30246 49884 36681 36681 35315 36681 23416 21597 21597 7615 48978 10571 9250 10571 7615 48978 10719 7615 48978 9250 10571 10571 7615 7615 48978 65525 25620 3734 59664 62721 3734 59664 59664 46963 62721 59562 46963 62721 33212 59664 59562 51175 8806 26028 45031 7850 26028 26028 56193 8806 51175 26028 45031 7850 45031 22796 8689 38065 10456 55957 55957 27279 38065 30205 36115 55957 27279 17915 38065 11137 55957 30205 11137
arg_in:  1 buffer int4[8] 18851 63037 57772 31416 53044 25084 52147 28888 40268 43766 20899 1865 49884 21597 30246 35315 10719 38044 10571 35792 3734 62721 59562 33212 51175 56193 22796 7850 30205 55957 27279 38065
arg_in:  2 buffer int4[8] 6253 5884 44618 48081 17244 34753 22160 26333 35588 33908 59892 43484 53422 53882 36681 23416 48978 7615 9250 14954 46963 25620 65525 59664 8806 8689 26028 45031 11137 17915 36115 10456
arg_in:  3 buffer uint16[8] 1964990443 2946578262 923087426 3235565353 449427662 3092997685 782564076 3013993352 3731302348 2616251049 1995651645 3017118168 835367252 1496162770 708458959 1916997387 2647212502 1756577885 3496691566 2972516890 1273612948 3745982695 2971239672 4188741124 879423752 2275542133 2509964279 2468342504 245845891 4104265114 2864062542 2005134990 2060862597 3998497779 586654009 1129383706 4131329934 1027823658 993694854 1493322581 1471377170 467221311 3016924073 2009757813 3116117881 3299830500 3592566077 719404161 1815662169 2863952887 56807634 3135283532 3871690487 4116050979 2366573245 894337650 3844456696 403122102 3372859518 3614329187 303998606 1094285375 2571787905 2866743361 429407493 476864756 3889596506 1992989246 1238533106 2895517309 2629583892 3916344376 2176325901 944200620 1473360062 2979048442 2236060850 1600150237 3760003869 2891874860 979217622 3650738277 627338264 1431372511 3274569313 820831888 1548872447 4289028863 1085222060 3304930961 3608035602 1584804332 1499900537 1907688731 2434111791 1875420986 2093747856 1539189660 2963624782 515486599 1543017115 3026350542 896110270 3468149361 2938135188 436120920 13239358 3361280047 528627259 4001444823 3196635242 2414737549 2609958619 3007137927 2478938337 2427051593 1659592794 94045571 3092305376 3683889670 1120964889 3185775154 1206917069 783644659 693603156 842979513 3200852672 1109048268

[test]
name: shuffle2 int8 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_int8_uint2
arg_out: 0 buffer int2[8] 33052 46044 15284 1773 54482 36839 45579 19120 26619 1931 18875 44802 54399 50311 56008 10964
arg_in:  1 buffer int8[8] 33052 2020 2619 38725 21905 63620 38506 21049 45803 39497 62477 1602 11329 39597 15284 35778 43585 26612 6257 14877 61129 48324 51799 36839 18042 63174 19120 13247 23349 22194 2340 45579 29208 34608 56157 48125 22400 26619 21248 33388 30640 12761 26121 48089 61852 13215 28092 21862 33504 43709 32982 54399 19916 47346 43981 48421 10964 56008 4170 15019 51301 61647 5171 7852
arg_in:  2 buffer int8[8] 52119 36513 30224 27667 51297 29836 1403 46044 20897 48590 25587 1773 26890 1493 10993 8493 54986 12251 58473 14509 44583 63498 54482 59775 42925 59561 51298 23116 25871 32185 21713 13420 13241 3454 63206 1931 54786 35886 58697 29297 39792 64344 24756 18875 54007 44802 46187 6121 50311 29724 36314 58794 21610 55944 38610 22229 32147 38713 25298 59447 60424 3462 11090 748
arg_in:  3 buffer uint2[8] 391987312 2082033679 3982089990 1534654843 4006813502 1971821223 218870503 370956546 2686678037 4037970379 979278107 3427513085 2484900595 833285528 2746357713 471953392

[test]
name: shuffle2 int8 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_int8_uint4
arg_out: 0 buffer int4[8] 10267 43064 46766 46766 44720 39056 54117 18062 61892 48756 61892 63107 39157 31893 57903 52041 58388 33932 58388 58388 15194 20220 42926 13578 58295 1956 1304 59796 18282 15472 50340 57358
arg_in:  1 buffer int8[8] 46766 37865 43064 52270 61105 25303 14868 216 27957 23801 44018 30619 15597 18062 44720 28222 60224 61892 63986 25430 61828 41627 12678 8488 14362 50035 20464 57903 15070 13249 32551 59294 50747 27094 54756 7288 32494 23332 20371 45528 20656 15194 48746 12780 42926 16953 41939 38716 31737 58295 37035 53402 1956 64992 1304 47457 62027 18282 50340 51304 56589 7348 15593 42036
arg_in:  2 buffer int8[8] 8724 38557 1200 51891 10267 6072 52292 23802 18727 32386 50709 37860 39056 54117 35796 53869 63107 18983 46837 48756 36331 41640 56801 46625 31893 26356 3162 10570 52041 7656 39157 63212 58388 58628 12494 19638 33932 49019 28548 28999 20220 49684 4784 40716 13578 54812 63583 50842 12444 59796 40552 6823 35564 12247 53665 38576 45930 15472 4071 62800 30775 42908 57358 48576
arg_in:  3 buffer uint4[8] 3364180588 2222535794 3024637776 576401760 3213558598 134684428 1766076781 1003984437 4101728257 3815368203 1739841585 4066822712 2105919822 3192760376 2957452083 4187092556 3168929096 576251180 3590955992 4207118888 476286737 4087685416 3335542004 1360225068 4080257633 3766776596 376207510 1873156217 2788339777 1444204265 429435666 662879182

[test]
name: shuffle2 int8 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_int8_uint8
arg_out: 0 buffer int8[8] 35285 47040 38568 41359 3792 22698 35890 47788 46132 41340 46132 2657 33135 49763 15712 8022 63557 27728 48224 21165 6606 33949 51592 17386 10584 10584 5993 64463 65383 26555 20644 39189 61547 33477 24289 14501 5864 14501 14501 61547 28964 53678 61836 62243 62243 27447 32098 12458 21584 64688 16434 21584 9286 10941 21584 30756 59125 62291 34548 25972 62291 27218 3127 3127
arg_in:  1 buffer int8[8] 2745 35285 3792 54172 28656 22698 35890 41359 2657 2965 42887 55287 8022 2747 28681 58173 17386 4774 22158 47150 27728 63557 30056 20205 11229 45153 5993 10584 58378 38386 34076 55367 34206 38160 25585 21837 43124 33477 61547 59285 32098 62243 61836 30929 26279 53678 37569 28964 39169 44466 12393 38117 59696 21584 11344 57731 22274 62291 27218 59125 3127 24249 51104 22650
arg_in:  2 buffer int8[8] 47788 47040 25049 54168 29820 29403 38568 1762 2887 300 15712 49763 41340 46132 14493 33135 6606 17589 48224 33949 21165 8724 51592 26496 33108 39189 64463 2633 49665 65383 20644 26555 48833 14501 24289 5085 5864 24812 33642 13711 47488 12287 43310 21894 47898 12458 27447 6413 64688 10941 16434 9286 29792 8405 22443 30756 47558 21933 47082 28758 34548 25972 17260 7392
arg_in:  3 buffer uint8[8] 998217393 1102742553 431325742 1782960775 3578986738 2453231061 585350390 2599020328 2354880349 4230542716 4197327277 2332426416 3589808367 3359589707 4214191962 2374295988 282957397 181984276 425885002 495881612 3865896488 4056322683 1020384430 540935200 2789145571 3901447043 450383730 3885476218 77968413 1807346367 2473929246 2818631705 840203126 103852485 929107130 3995774953 3586763612 33660409 3933413161 2576670182 1724526183 1491502309 544851026 22617217 3559176993 90307358 1182546176 2493324349 2320900821 2977728824 1787441834 1467144597 3682192587 2895365337 427809429 1743018383 1804650035 49963857 1239200412 567106797 2702194097 19794274 2084985076 1565402052

[test]
name: shuffle2 int8 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_int8_uint16
arg_out: 0 buffer int16[8] 16883 8526 16883 40517 16149 57562 24035 62210 33792 33792 24035 48201 40579 16883 42008 33792 44270 23091 15813 33576 33613 42462 33576 54203 54359 23091 54203 33613 33576 31421 42462 33576 5716 65027 53979 5716 33191 59974 56721 37446 913 19075 33191 56721 47723 19075 913 47723 47132 47037 4085 24453 47132 47037 50578 32424 50578 2768 57672 50578 6745 33566 42832 57672 24805 20405 29372 41702 27879 24805 51835 37490 55200 31785 37490 1749 41702 37490 33328 24805 14979 32023 34376 36638 36638 34376 38829 3642 38829 34376 34376 12698 42449 47182 3642 16166 16737 52271 62091 18014 16737 16737 50611 62091 28165 60423 18014 4750 50611 18014 28165 43411 21842 19679 64955 29115 29115 64955 44808 55409 29115 47923 55409 4060 1343 1343 19679 1850
arg_in:  1 buffer int8[8] 24035 37976 16883 42008 4365 62210 8526 49313 52444 10489 63688 23091 120 2592 54359 21468 56721 44057 65027 9600 913 59974 11160 27571 40320 32424 6745 57672 24453 23554 42832 18249 41702 29372 20405 37490 24805 9616 31785 7402 42449 13319 42518 34376 3642 55992 36638 16166 60423 58018 58388 44468 43411 16737 52271 15763 37966 17239 64955 10336 55409 45294 4060 1343
arg_in:  2 buffer int8[8] 40579 11065 10010 16149 57562 33792 48201 40517 31421 42462 33576 15813 15351 44270 33613 54203 5716 37446 35868 53979 19075 33191 56645 47723 2768 47037 50578 40757 33566 4085 30773 47132 43918 11745 51835 63564 27879 1749 55200 33328 47182 24844 32023 10755 12698 14979 14743 38829 24379 51021 162 28165 18014 62091 50611 4750 29115 21842 23299 4106 44808 47923 1850 19679
arg_in:  3 buffer uint16[8] 3993849490 3444394998 686060578 2938974607 1439838363 3148044508 1663836656 1428992821 1706753709 1881934397 2436437904 4046911054 1832519912 2949747314 761053043 2252180701 524546749 2413484259 4227520187 182675722 444100638 1743314521 2285537098 29815359 2850993398 885637651 1638479279 3684524638 1611117866 2927420824 858256153 3311148682 4073390968 2504581250 2385470683 1983158872 1718558349 3232419125 3399786000 3764950569 2114802036 2812502156 2728121453 2233654672 2429761455 1043193436 3971552804 822525455 3274944287 3414830873 3638085373 695494948 332744239 2139698025 1464280810 3109428113 1857581674 899308792 2482780163 2837425866 2541010178 3862883260 4122298086 3951793619 3861515844 4140376546 3629937905 2216742496 1346363868 986780644 1165995834 1968641459 301122606 3182031430 221771603 799125549 3466980512 2578470179 2710390159 3550242948 4194193805 2619591434 1843535299 3832857558 996474678 730042531 1003229727 3969099092 814479199 3314291587 2222639747 3043406796 848631216 5934040 1639630116 1491401959 302453317 721898806 1135931613 3104319100 1594977445 998577957 1380464590 3063236461 1428993995 2459965008 3150530636 1308622079 4276289006 211428076 1581117195 2195359028 1750326473 770593359 2160498482 960373400 614651448 1028827490 1226946924 2477956644 2949962600 3869422253 3505538788 2038905414 3202081079 1173454711 1378668383 81414958

[test]
name: shuffle2 int16 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_int16_uint2
arg_out: 0 buffer int2[8] 23536 22821 55360 33113 41743 26959 28126 4549 54584 56861 4299 32190 51535 16961 50830 35776
arg_in:  1 buffer int16[8] 39464 23339 23536 59926 48121 28609 55338 45027 52544 26485 39691 31060 31888 36853 52336 55197 24532 14908 50083 53301 47039 47622 10296 33640 33113 19090 1437 20766 44907 41039 21144 13433 58201 20390 60494 33335 56437 38877 55436 26959 45650 3499 26808 13679 34694 22555 49288 53234 22779 3536 63090 27438 28126 10887 49212 29193 58617 36892 36057 31710 17729 47842 61769 5083 28651 35978 53968 56689 50445 36547 51397 60510 63988 64458 56861 58681 43695 52000 49212 65370 30653 11576 39376 45386 26981 32706 58341 14343 25069 13765 46774 17751 56771 29517 17796 33950 35092 6947 38592 32475 27264 7505 55653 59011 30380 43013 5811 3967 16961 51535 16686 60634 23991 9664 383 45156 17674 42691 43710 26893 34812 4583 41424 47167 40510 26751 18605 26859
arg_in:  2 buffer int16[8] 59773 46389 49691 65478 33755 36849 29113 47537 55210 48103 44642 22821 35813 7030 19644 17616 55360 58114 52743 43937 35049 64324 25687 55680 24976 23177 32169 52864 14893 10190 46386 41928 64962 23993 41743 47354 41433 5521 25410 2866 29985 14829 50046 42070 64436 24628 21398 64946 4549 8509 13667 3936 6575 10474 5120 52681 35500 53179 13248 43753 20396 27326 7888 22147 34578 54584 28182 17351 39721 41938 29185 38283 35939 13495 41518 44050 4459 30422 38196 55262 56758 49029 4299 62538 3990 10763 25705 53777 19956 31698 50843 39845 32190 63353 42390 45848 33860 39620 39501 24169 53203 32639 38153 27983 17499 53636 45729 6557 48005 60758 14168 17150 19342 19454 28097 46971 4278 522 24421 189 8191 9367 52855 45692 35776 15927 32074 50830
arg_in:  3 buffer uint2[8] 3051876578 3154051643 4125509872 529251624 3443889298 2806711879 274648772 3980321552 1356655121 3722207658 2294659442 4238332668 1542404461 2985862508 3053885663 989258300

[test]
name: shuffle2 int16 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_int16_uint4
arg_out: 0 buffer int4[8] 30362 63453 30362 60341 52143 14753 14417 11213 26071 35120 43496 46545 58640 46534 55611 46685 30039 2239 30039 43369 28388 9709 8700 5571 18855 52903 35044 17512 43923 12353 48321 48561
arg_in:  1 buffer int16[8] 5381 30062 31041 41065 48527 56640 351 18014 51949 41150 12787 6688 5753 8171 61428 35707 50846 21690 22476 64007 28341 17208 57240 45287 39358 60891 42198 52143 60191 37176 13623 5144 3173 43430 7656 46545 43496 12949 39208 58357 35120 29897 43703 42017 26071 7744 33457 18387 64057 14275 9053 58640 34381 46685 49211 46803 35104 39605 55611 44608 10553 14664 31603 26129 51070 23457 748 2239 34457 54454 61462 30154 49719 1384 34546 50135 30039 53998 10790 7797 60533 28388 29967 10725 22639 35935 9709 15135 38362 8700 57021 17012 54605 47012 5571 12526 2541 18855 30927 21879 54592 62142 12509 32802 37837 35542 52903 33955 10094 56102 19174 2510 12353 3124 32626 19950 53678 4069 55942 26358 22720 57676 469 64883 30124 33777 62894 14701
arg_in:  2 buffer int16[8] 11997 57950 27509 56940 65392 8244 35483 63453 52373 33209 36560 39276 46327 60341 30362 29949 14417 11213 57475 28006 24904 36809 14753 22919 4262 32140 46451 54211 5138 38651 1085 7487 8764 35088 61271 5459 31810 10293 23268 54902 36250 62309 47068 27204 39550 52935 8679 30600 64837 20253 8918 9923 10291 47287 46534 46016 29448 64922 10893 31659 17041 9913 30654 16654 37690 60865 63892 36640 43369 37589 54672 40866 11838 24703 60522 24651 38941 61739 54716 4536 58005 57562 55152 17737 42867 58403 62166 33333 25050 12107 16850 6975 55776 36578 30900 54703 27483 26769 29782 61469 49924 33695 484 5870 24696 28232 13337 35044 17911 35363 34391 17512 23406 42465 43146 22011 48321 64235 36610 48561 37751 38398 16296 43923 6486 21630 36642 1786
arg_in:  3 buffer uint4[8] 1193034974 1024710711 2895417086 3998870333 3110345515 1214161750 4264553104 4287602001 602068652 2617256712 1306378404 2113733891 519153699 3089221782 2572319882 552198821 1093849772 123585731 3209709740 2828746388 2962714913 2666804646 2753160169 1336594574 3751665153 3487938218 4043074267 654372607 3158172347 842094848 3310931060 847789431

[test]
name: shuffle2 int16 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_int16_uint8
arg_out: 0 buffer int8[8] 30363 56984 22538 53622 62146 30363 62146 30157 28126 35492 3054 32148 57930 12417 58392 58392 28065 16777 37840 10148 64300 13235 47251 39696 46191 55425 43402 30249 18982 8697 27145 3261 42368 64269 63600 65262 24479 38391 6257 4474 16734 47905 521 933 35606 14393 61937 802 53543 2565 28031 7516 37122 56141 19523 35743 49616 17642 15576 48364 37321 15235 8567 7435
arg_in:  1 buffer int16[8] 61244 40325 23605 1244 57432 40269 48722 18300 30157 39796 28161 12303 30363 44359 14087 39559 22236 65466 52671 16638 9885 15935 58017 32148 12417 21981 2525 37630 9518 13933 12170 63696 21959 47149 39696 26141 18753 16710 40370 30855 28065 16142 21697 16777 408 37840 40149 24067 3261 18982 14347 31002 30249 46191 38982 44647 63895 39385 8697 1333 27145 64475 48313 17450 63372 56323 34222 24222 24479 6257 18852 8900 4474 28010 42368 40554 27507 22984 24696 63600 29564 35606 52140 14393 47905 51579 49044 18882 3647 22525 25905 18654 16656 16734 41650 16401 26574 37122 7516 21596 44066 42835 61353 5742 35743 51194 53543 59041 56141 50438 40067 54477 1214 26528 55356 30123 8567 11042 7435 4574 49616 31172 17882 46274 37321 31445 38715 193
arg_in:  2 buffer int16[8] 56984 50782 50436 35488 53622 55208 59968 49567 8844 57754 22538 24905 62146 35241 15680 56204 1040 15629 58392 59663 59357 48972 19261 39184 35492 50790 62158 2319 50375 57930 28126 3054 55865 4961 64300 65282 48981 2894 64663 30818 13235 47251 31675 16086 55322 47698 10148 47627 44623 57267 52812 60097 32987 2142 14341 55425 13100 57 43402 46720 34844 18587 43509 15198 21611 61473 38391 44552 45268 26368 23455 39421 9903 1889 64269 27678 38998 65262 48053 13652 61937 23503 521 50697 802 64645 38686 8659 5748 36196 18660 54300 20458 933 55618 31781 40928 42668 7902 28502 23151 22547 5900 28031 9778 46120 50589 19523 58786 37751 2565 40142 45772 16511 48364 24655 51138 11100 56245 15235 49178 15576 23676 17642 19289 56578 22545 48796
arg_in:  3 buffer uint8[8] 1653761740 895761456 796359546 61302292 3307357820 1037601516 4077011036 2594083368 2953445374 614412728 292338079 3090605991 511983709 1142307464 3739285842 2314569426 1871484232 3820912363 2743715949 3876542302 186250674 3091882968 3788013561 3113825186 3516751461 2306274903 673421850 2349180100 3214542593 3744056938 4164899148 53674176 985918730 1924794842 2799789679 1745540541 4291505924 2096718514 1712327173 700289416 3562568429 2132123844 2352874898 4176104509 1943625697 2780111075 3879121456 295333940 3323988842 2325723326 1500456951 558654146 2013481857 937560524 3482743483 651624680 2746936712 1014187195 407352313 3153334642 731497644 667701815 3643347524 70887526

[test]
name: shuffle2 int16 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_int16_uint16
arg_out: 0 buffer int16[8] 12254 59591 13650 44481 63200 21592 37523 51052 17192 46221 12254 63200 13892 48954 40669 53949 47211 48369 50428 47211 37404 64077 39326 36553 17226 17226 17341 62600 62331 60092 64369 1264 16808 38805 13795 46183 38247 40573 61203 33489 48275 49662 44781 13573 44819 64708 38247 44781 41927 64692 54865 21146 16626 49871 21040 41927 49068 52980 16626 20500 36391 29806 55668 30608 56892 39942 33078 46815 1773 33078 4020 33078 50572 23775 35777 21828 49308 11699 42555 39942 47060 6712 7366 8102 8102 20789 14621 39467 35495 35495 52495 38965 54939 2782 17430 35601 33059 62423 51569 30727 62423 65027 65027 31438 21148 35494 30727 5412 57363 57363 62885 5412 59065 42646 61300 35492 30177 36389 59065 12211 33418 35492 55687 2531 12211 55687 55687 51531
arg_in:  1 buffer int16[8] 62640 43907 40669 37055 46136 20319 13892 21592 59591 41296 16193 36894 53949 62409 46221 46159 56602 62331 17226 12284 50428 17341 47948 39326 36553 47211 25052 22913 24311 64077 7008 15473 49662 60199 40281 13795 25278 13318 33489 17770 61203 16808 59729 64708 13573 44781 46183 2876 52980 21146 23550 16626 32217 56619 34320 33574 21040 29806 30608 4466 49871 39849 35930 41927 25592 49903 11699 56682 36048 30272 5106 50572 49308 56892 16100 27587 57761 3925 60282 4020 2782 9557 16640 12169 35601 19109 39160 12325 52064 6712 17213 41793 49615 52309 17430 39467 27729 56335 37509 16484 50411 31438 8059 35494 28500 29856 62423 62885 21148 29196 63274 33059 28413 29752 30177 59065 60011 55648 22517 37370 44748 62079 16241 13599 19210 39293 55687 16276
arg_in:  2 buffer int16[8] 34227 57346 37523 43666 13650 44064 10408 48954 17192 47114 44481 51052 50571 63200 5614 12254 31771 64369 13313 18608 62332 1264 4669 62600 12157 37404 29829 51222 60092 48369 9438 28240 15152 3599 40573 61591 44819 535 38805 38247 48275 36932 32757 50429 63673 57919 1259 39672 36619 64692 48130 20500 65088 63395 35072 5920 11317 56227 54865 24070 49068 55668 36391 35279 35777 1773 7543 3022 33078 10969 21828 23775 24374 46815 42555 42422 53847 43758 31201 39942 14621 12785 30419 907 38965 17129 54939 47060 14292 8102 51293 20789 35495 7366 23886 52495 40165 30727 42003 8835 28283 4719 4150 2622 13201 51569 57363 65027 64656 59534 5412 59171 61300 55483 28124 50995 51531 49790 36389 6377 33418 12211 42646 2531 35492 56482 16848 27523
arg_in:  3 buffer uint16[8] 2516185439 1965968200 3913535796 2196524378 1460138845 2092654983 637897426 2105334331 1104813304 583429518 4118054239 1387786269 4210830502 2864368151 3112758114 1695889804 3358571785 3487177437 193982436 251192873 3233490425 1000292109 2381320775 1675881704 1474184098 1398893122 2747004805 3888210167 1557504705 3754249660 3845651889 2445268757 929745833 2372210614 1466780483 4288517262 79683831 3927865170 3926761064 3466042758 4100144120 1660778496 2667823213 4287399884 3512824564 3306087691 922786647 3059768461 1807783855 497600785 4120133082 2150541889 1544786179 3880596076 1679268104 4154099983 4077542812 2991228352 3256452515 3295359539 278092574 259615849 2988911357 1117964458 522953705 1751310399 1342204756 606078233 2909380913 487540244 1350429135 2689408724 4152653767 2885579927 659463024 3010272278 1827970216 3172671746 203897594 1546728543 4141967767 1087315401 3234624541 1144970745 2887384569 3492940347 3601976976 3418649615 3479029468 2917586332 1015198047 608142004 2920162038 613709312 4093310094 3667471684 559192175 872613322 1206720697 3649381137 697406410 1265709755 1611147195 2713893317 750081356 125344871 3158196305 675815742 629242458 4170674170 2295600267 1597435998 3337181987 4140781178 2825412560 1478284732 687956578 2670662358 2364336995 1003056217 1719224056 3349163388 2082355822 788457787 3180713401 1530059662 3436385006 1232182004
!*/
kernel void test_shuffle2_int2_uint2(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int2_uint4(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int2_uint8(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int2_uint16(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int4_uint2(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int4_uint4(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int4_uint8(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int4_uint16(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int8_uint2(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int8_uint4(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int8_uint8(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int8_uint16(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int16_uint2(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int16_uint4(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int16_uint8(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_int16_uint16(global int* out, global int* in1, global int* in2, global uint* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
