/*!
[config]
name: shuffle2 half ushort
dimensions: 1
require_device_extensions: cl_khr_fp16
[test]
name: shuffle2 half2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_half2_ushort2
arg_out: 0 buffer half2[8] 45669 45669 15486 20321 23400 13395 18123 18123 64156 64156 57787 32448 47638 32398 24013 10849
arg_in:  1 buffer half2[8] 45669 38297 64842 63052 2880 10304 38210 6700 36773 64156 57787 22395 32398 1708 65288 6172
arg_in:  2 buffer half2[8] 45025 58306 20321 15486 13395 23400 54469 18123 6886 53729 53759 32448 21801 47638 24013 10849
arg_in:  3 buffer ushort2[8] 8124 17084 18939 38366 30147 24462 33023 24671 717 281 56076 14019 44543 26744 26934 7851

[test]
name: shuffle2 half2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_half2_ushort4
arg_out: 0 buffer half4[8] 31897 45966 36943 36943 6332 6332 54389 54389 46625 6972 16433 6972 26211 38403 26211 42672 32115 32115 1458 32115 10022 41003 36079 41003 60969 60969 1425 1425 6627 6627 48296 6627
arg_in:  1 buffer half2[8] 2877 36943 16210 42578 46625 12214 26211 42672 32115 33164 36079 41003 60969 1425 38334 48296
arg_in:  2 buffer half2[8] 45966 31897 6332 54389 6972 16433 38403 62926 1458 40277 10022 15250 30917 64753 6627 6217
arg_in:  3 buffer ushort4[8] 49319 24910 41181 54861 63958 49310 16291 58775 18464 13774 3935 35674 3344 64466 12552 46989 12876 16596 7538 27032 4794 23293 9208 61561 52844 59876 24221 42553 26770 27562 57653 58006

[test]
name: shuffle2 half2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_half2_ushort8
arg_out: 0 buffer half8[8] 26720 1940 60574 60574 1940 1940 60574 31146 3523 3523 41233 677 677 41233 3523 677 35560 35560 31338 49882 31338 31338 31338 31338 2604 18870 16472 16472 2604 2604 18870 12967 4347 57584 24257 2156 2156 4347 57584 57584 43109 38074 6377 47645 43109 43109 43109 38074 30626 15766 30626 7514 7514 15766 15766 27069 63290 63290 63290 24035 44067 16860 16860 44067
arg_in:  1 buffer half2[8] 26720 1940 677 3523 31338 49882 2604 16472 4347 24257 38074 47645 30626 7514 63290 44067
arg_in:  2 buffer half2[8] 60574 31146 43337 41233 35560 47231 18870 12967 2156 57584 6377 43109 15766 27069 16860 24035
arg_in:  3 buffer ushort8[8] 12496 15357 46706 37254 18077 36269 33238 4335 45249 49829 60879 41172 20180 22875 18581 55484 25798 32062 11616 18045 61992 35364 11960 23912 3284 19922 40761 65129 31700 24212 48994 6679 30732 57159 64553 4082 1074 14260 29283 6903 2339 47288 28318 6993 61795 6387 32099 33732 17560 43662 39764 29065 57633 810 1234 33703 58648 43596 49232 54323 42921 32934 4178 13617

[test]
name: shuffle2 half2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_half2_ushort16
arg_out: 0 buffer half16[8] 28835 15487 2322 28835 2322 15487 2322 44639 44639 28835 44639 28835 28835 2322 15487 44639 22336 17342 63262 22336 17342 57722 57722 57722 17342 63262 17342 57722 57722 17342 17342 22336 451 31948 24095 24095 451 20913 20913 24095 24095 24095 20913 20913 31948 20913 451 24095 12717 14332 8315 14332 11883 8315 8315 11883 12717 11883 11883 11883 8315 8315 14332 11883 17217 17217 61433 33516 33516 61433 17217 61433 61433 61433 33516 61433 38731 33516 17217 38731 53169 56045 1344 1344 1344 1344 1899 56045 1344 56045 53169 1899 56045 1899 1344 1899 65148 65148 14732 14732 17564 65148 30168 65148 17564 65148 17564 17564 17564 65148 65148 14732 63235 36748 36748 26923 63235 40218 63235 26923 26923 63235 36748 26923 26923 26923 63235 40218
arg_in:  1 buffer half2[8] 2322 44639 63262 57722 24095 31948 12717 8315 17217 33516 56045 1899 14732 65148 36748 40218
arg_in:  2 buffer half2[8] 28835 15487 22336 17342 451 20913 14332 11883 38731 61433 53169 1344 17564 30168 26923 63235
arg_in:  3 buffer ushort16[8] 56090 56035 32792 30774 3096 52479 49524 18925 44285 15138 32333 10210 27254 48044 57255 17869 23518 15319 10524 63146 7039 43309 9481 63969 12207 53124 14131 29173 13069 46091 36919 55278 39790 34565 16672 5384 53530 42591 14667 42980 43340 52612 26159 10635 22921 46167 21474 4672 41432 8194 54669 1126 51867 16597 12629 64003 28540 47943 37527 1219 62433 49877 4218 3419 49636 6580 30859 35905 33353 60759 37560 15027 27639 53603 15801 59435 44126 21941 58604 35922 8666 41472 61623 32207 10723 36811 25325 11868 62575 3588 5322 39725 24828 14409 49207 38365 64381 15553 37088 23064 41194 8165 12431 2417 64514 28077 43294 53586 31726 2933 31825 30932 63927 63112 43236 24242 42523 31233 63055 7374 43994 7063 3736 43430 2050 64838 55735 38689

[test]
name: shuffle2 half4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_half4_ushort2
arg_out: 0 buffer half2[8] 7395 9433 47255 50872 3467 63694 64591 48525 43739 36785 6464 64902 46764 62163 5703 1688
arg_in:  1 buffer half4[8] 2212 9433 11053 55822 2287 35679 3312 1877 28927 5609 43145 3288 34457 64591 53710 33964 3728 63513 36785 56992 64902 65010 53230 53697 28613 40870 62163 46764 46828 22917 45777 29550
arg_in:  2 buffer half4[8] 7395 15389 3445 45157 19845 47255 38476 50872 60229 58750 63694 3467 15928 55276 3085 48525 40138 43739 54680 7303 6464 39440 19691 36391 64161 44053 26784 29704 5703 1688 46353 18887
arg_in:  3 buffer ushort2[8] 59324 54529 28429 20303 52319 55622 641 29951 54949 2122 29564 31784 43507 64066 15916 20541

[test]
name: shuffle2 half4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_half4_ushort4
arg_out: 0 buffer half4[8] 12239 55109 21604 34683 48406 57381 48406 60240 33485 11732 43417 11732 53255 16630 65416 61625 27454 16043 27454 27454 54989 43030 15783 14841 5038 961 1740 1740 11308 18281 58499 11308
arg_in:  1 buffer half4[8] 34683 63484 64399 42649 37935 56530 45509 16398 60589 42929 43417 14781 65416 16630 18972 38785 39811 52312 22415 26211 26743 54989 43030 19863 4869 1740 3785 961 50305 57135 31247 58499
arg_in:  2 buffer half4[8] 12239 3680 55109 21604 57381 48406 37701 60240 33485 55460 1392 11732 41660 61625 20139 53255 63872 16043 16047 27454 15783 2142 14841 19993 13805 5038 31705 15231 14615 11453 18281 11308
arg_in:  3 buffer ushort4[8] 24996 40854 64991 22936 34965 24468 25901 2071 43468 26159 60570 46511 8615 62241 59840 47677 4495 25453 9271 27791 62465 20690 15012 58710 3293 1611 14673 27065 12127 51926 3955 18447

[test]
name: shuffle2 half4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_half4_ushort8
arg_out: 0 buffer half8[8] 46970 46970 38344 23484 7210 48664 48664 23484 30029 27099 15653 54873 17693 54873 15653 42359 45981 29290 2722 17284 62802 2722 51201 34080 29334 20188 38545 29334 35590 29334 35590 29334 6556 47051 59183 47051 59172 6556 59183 47051 49209 30449 19031 55954 47644 30449 15547 19031 60919 1906 60919 1484 19801 6999 10106 49452 43320 47494 59292 11821 47494 37202 37202 11821
arg_in:  1 buffer half4[8] 48664 38344 32182 4890 15653 42359 30029 27099 34080 51201 45981 29290 29334 15567 20319 38545 59183 47051 48588 59172 30449 47644 44234 49209 1906 19801 49452 60919 47494 61443 37202 11821
arg_in:  2 buffer half4[8] 13835 46970 23484 7210 46964 54873 45937 17693 32231 2722 62802 17284 56717 31463 35590 20188 6277 62181 62414 6556 52635 19031 55954 15547 6999 1484 10106 26430 17361 43320 36413 59292
arg_in:  3 buffer ushort8[8] 19165 38341 43425 44414 27759 35840 45736 11974 4794 52027 62360 60173 26047 9749 62472 15993 34306 61011 32493 55671 47750 52941 36257 5584 16040 43087 16411 22944 7638 10088 30814 30064 61663 63753 13104 46377 12931 43487 26184 58961 11787 11800 15829 62854 19145 61688 38679 11589 59139 17384 34123 17189 24889 9660 5454 5034 40573 36584 63095 30795 59584 26466 47818 49747

[test]
name: shuffle2 half4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_half4_ushort16
arg_out: 0 buffer half16[8] 28048 8006 55869 55869 8900 8006 22450 8900 8006 18158 18158 18158 28048 27780 9515 8006 3079 3079 27109 3079 65349 24590 65349 46774 3079 39853 30440 30440 39853 46774 3079 24590 38324 63456 19439 63456 20714 19439 11715 63456 20714 38324 51521 35989 63456 51521 11715 63456 31209 31209 14015 13606 13606 14015 14015 12558 48133 14015 46861 30818 46861 12558 14015 46861 27039 27039 53391 55126 53391 24867 27039 14717 27039 55126 53391 53391 47601 47601 27937 60603 29980 24454 24454 49536 1071 49536 52237 1071 23729 24352 24877 1071 24454 1071 1071 52237 21463 47289 21463 5661 6973 5661 49981 49981 6973 5661 21463 5661 6973 19520 5661 47289 61725 9135 56411 46464 61725 47386 34099 9135 47386 34099 9135 3099 9135 47386 9135 9135
arg_in:  1 buffer half4[8] 28048 55869 18158 9515 30440 55803 39853 27109 38324 19439 20714 35989 46861 14015 18871 48133 55126 14717 27039 47601 49536 24454 24352 52237 33710 19520 5661 47289 3099 34099 61725 42095
arg_in:  2 buffer half4[8] 22450 27780 8900 8006 24590 3079 65349 46774 51521 63456 8567 11715 13606 30818 12558 31209 53391 27937 24867 60603 24877 1071 29980 23729 1650 49981 21463 6973 46464 56411 9135 47386
arg_in:  3 buffer ushort16[8] 55632 1799 53705 53353 46070 42423 44028 55686 48863 47066 56546 44634 16264 16117 55155 10759 31141 16141 40083 10013 33214 36148 24998 59527 17981 36626 1336 62464 39970 12367 13581 39548 12096 25253 33833 31797 42370 38353 26719 13509 59098 61688 47372 17043 54333 14212 50887 53877 13575 7999 31713 57348 42564 37601 53041 63326 3923 2121 4248 31005 48552 43102 31833 20152 61354 61938 396 36160 6916 3286 39042 18057 10274 56512 54588 43036 53099 26515 32021 34735 10774 36713 56761 21064 17229 23048 21795 32805 34823 42602 52508 40157 23841 13949 44661 61387 24870 17227 60438 61554 32559 37570 8685 7989 41639 41738 30302 3698 24063 62393 42946 59195 32226 45134 11517 38076 13986 38367 13481 20054 1095 64441 20926 63832 58974 32391 22094 31422

[test]
name: shuffle2 half8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_half8_ushort2
arg_out: 0 buffer half2[8] 11453 60207 35239 47639 19314 59955 46738 45029 52932 38723 7708 25229 35244 62413 31660 43953
arg_in:  1 buffer half8[8] 22914 52850 2766 17704 32404 60207 50384 48299 64828 8206 43547 13458 27540 61029 15189 2373 59625 123 19314 64677 26847 9443 17382 56104 2377 22733 53292 46738 49036 45029 7502 32617 35471 19626 40576 20830 38800 38723 57671 3267 3333 45038 53640 7708 25229 44530 28839 42385 35554 9367 12236 19086 42735 21977 45331 17582 2517 34873 43953 42381 17753 10274 40988 13526
arg_in:  2 buffer half8[8] 40474 5168 11453 63802 4090 47256 13253 36763 52331 47639 20669 13533 19625 38512 35239 2337 47586 43117 64325 44110 22817 29651 59955 25002 48242 3384 9378 15081 8261 49719 30403 64622 11951 52932 64410 29958 146 51850 22567 48569 43828 24842 39927 5055 11079 41894 63186 5616 21761 33641 8974 50288 62413 19524 35244 50517 19115 6243 23595 36215 16677 52403 1706 31660
arg_in:  3 buffer ushort2[8] 58170 10853 8014 27241 22338 48318 21747 24997 3081 62069 60627 48964 45294 61692 8623 56834

[test]
name: shuffle2 half8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_half8_ushort4
arg_out: 0 buffer half4[8] 18958 18958 4245 36785 40664 26607 8899 39626 44479 19267 8334 1474 8750 5882 30601 4678 27902 45518 45518 62359 33813 44852 21402 44852 46423 24614 6931 18896 60404 34350 43038 20304
arg_in:  1 buffer half8[8] 64622 58401 61186 52898 18253 51290 56388 4395 51003 35456 4641 38728 26763 7464 40664 39626 49014 44479 25138 32430 19267 35048 55255 8334 8750 52737 24218 58336 34814 4678 41966 1502 61387 8045 1334 45518 48494 7022 33003 17335 33813 13269 35621 34736 42361 49873 57678 18774 43127 29998 18896 39924 6931 25826 35343 53409 34350 4119 43038 29314 60404 11885 59272 16298
arg_in:  2 buffer half8[8] 43687 27392 18958 8767 44565 5970 36785 4245 8899 832 26121 26607 13657 16589 10543 7893 62011 1474 13867 54627 60732 58035 10903 52282 30601 57985 5882 61264 42990 39701 57690 7120 47832 62359 62783 29920 27902 10815 39092 35384 5220 44852 11498 43897 64392 20821 21402 30025 5975 52121 23564 34360 46423 24614 28917 10716 26030 26978 18820 17057 20304 17117 27573 51079
arg_in:  3 buffer ushort4[8] 56266 39082 32127 7934 63526 17707 45768 13159 55009 13316 9911 42553 32736 30314 12744 4949 4956 40307 53875 45097 12384 2889 3038 16105 6780 34029 45092 48514 33028 13376 9474 29564

[test]
name: shuffle2 half8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_half8_ushort8
arg_out: 0 buffer half8[8] 13397 6769 14057 39241 7822 48946 39241 57822 30458 36500 44517 50762 36500 50762 17654 15710 45818 10093 50888 45818 54707 54707 36181 7279 53104 60834 13292 60834 63612 15138 13292 57165 61664 7965 25121 48701 7965 43548 26160 61274 7898 51728 16739 10897 14162 14162 54991 24188 4042 31429 5646 27648 64208 19367 4042 31429 47876 4422 15203 34250 13209 4492 13209 4492
arg_in:  1 buffer half8[8] 39241 34693 6769 51398 17469 13397 40274 6883 15710 30458 17654 7537 57921 8754 44517 15738 45818 41844 7279 54707 10093 35984 50888 33895 57165 13292 48847 45820 43002 47576 50636 28178 18554 56568 59703 63649 61274 64682 43548 7965 24188 16739 18538 7898 57508 47568 54991 28398 31429 40084 41781 39012 19367 64208 36992 42039 22657 13209 34250 15203 4422 17469 33660 19418
arg_in:  2 buffer half8[8] 7822 3806 23882 4606 14057 5607 57822 48946 5617 1150 36500 34994 50762 6321 21312 49992 36181 10457 34539 9713 61344 21961 31560 63087 34105 63612 60834 15138 53104 23867 42522 51045 26160 46941 48701 5323 61664 25121 35086 8078 12858 7715 34399 10897 37728 54756 51728 14162 999 2909 63591 4042 51930 20659 27648 5646 11008 61481 30584 51841 47876 36569 38348 4492
arg_in:  3 buffer ushort8[8] 61253 23490 48876 12096 25320 20655 47168 15838 65521 64074 12390 8524 45770 34476 16226 20560 22480 38964 31158 5456 52963 16003 48920 18802 22748 45210 46545 55274 48889 363 21969 61056 24828 5143 40381 23306 22439 18518 1496 29316 27267 9086 10705 60283 62319 13935 10982 49456 56059 24064 19007 25534 50309 27476 1067 59472 59644 49460 46547 50194 11681 24703 8145 41215

[test]
name: shuffle2 half8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_half8_ushort16
arg_out: 0 buffer half16[8] 22832 36766 36766 36766 19712 13738 46990 11201 22832 19712 40863 13738 39354 47864 46990 11471 33452 56408 31079 64138 56057 23493 47116 64138 60974 56057 15687 55955 47116 60974 64138 15687 32542 30298 30298 21175 36569 60080 54764 35602 38164 3248 38164 28747 25959 54764 30627 57448 45994 40074 40074 33537 2446 53479 9223 65028 24953 628 32776 628 24953 45994 41063 36441 19635 40882 61374 5650 1147 29432 54981 17987 58405 58405 2423 29010 2423 2423 29432 11989 9067 9067 49673 23494 16476 9507 55142 27376 55142 5010 5293 27376 25958 49673 14286 30012 10628 10628 26579 59476 10628 5666 36553 9372 54826 26579 20614 54826 26579 54826 10628 26579 32244 47531 689 61980 63848 32244 20717 42745 4320 48652 63848 20717 17703 47531 20717 61980
arg_in:  1 buffer half8[8] 11201 13122 42339 46990 33349 22832 8593 47864 4883 55955 31079 56057 23293 45435 33452 23493 21175 32542 3248 28747 30164 25959 57448 17610 45994 51772 53479 2446 14551 9223 33537 36441 3185 19635 61374 38460 58405 1147 12435 17987 9067 27376 10296 5010 7495 14286 5293 30012 5666 59476 9372 58165 33390 13926 36492 20614 17703 48652 50910 4320 689 47531 28135 63848
arg_in:  2 buffer half8[8] 60914 36766 25802 13738 19712 11471 40863 39354 56408 60974 64138 25359 39303 50293 47116 15687 30627 60080 55825 54764 38164 35602 36569 30298 628 40074 25196 41063 44478 65028 32776 24953 29432 23017 54981 40882 5650 11989 2423 29010 47182 55142 25958 9507 49673 23494 16476 26506 36553 54826 63528 57188 26579 10628 6620 41724 42745 1933 62440 51348 37204 32244 61980 20717
arg_in:  3 buffer ushort16[8] 29077 47817 23753 11529 42764 44667 50355 54608 60165 47436 3438 11659 9167 58775 35939 26013 62886 63512 38850 26938 57043 9591 28590 60010 4777 29395 16047 47473 42974 36185 53002 42319 26321 60975 20015 11888 26206 27401 60523 30525 32684 21378 56508 10547 29509 24171 59880 12262 31184 44121 36233 3894 17443 2530 23909 9725 7599 30776 46670 59848 53263 64176 36715 24375 40113 61659 57394 64684 25253 40952 21034 27591 23508 36548 16382 57311 46286 61950 57288 13789 53280 36816 23292 51693 7966 2171 34553 43649 23289 40595 59462 45105 43770 54300 52485 10887 23405 20445 32524 14753 40781 32624 8568 62098 64921 1436 38439 21257 2316 64825 13885 19676 52589 39157 29748 62782 48487 52685 40607 5256 5603 1361 47479 15647 24352 35365 655 34462

[test]
name: shuffle2 half16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle2_half16_ushort2
arg_out: 0 buffer half2[8] 54501 35901 59874 59874 24309 14152 62006 35557 53797 45008 13335 42947 44816 13530 36902 44744
arg_in:  1 buffer half16[8] 4228 55231 54501 476 8237 55657 35901 25919 32141 40208 14646 9628 48172 52809 6734 45525 30239 37453 49949 842 60880 41671 16730 12720 3415 49191 16410 37915 429 48266 39721 59874 24309 16041 36048 18797 63001 38944 3157 14637 31053 56404 53673 7116 50509 45596 8292 46163 27821 46160 20352 52968 62501 27725 2825 61391 34146 62006 32241 39634 37110 22564 7140 20930 22228 21133 44209 30063 40799 6027 58943 18633 45008 6240 19481 55547 26395 59407 53797 24873 48134 41131 38230 51501 30812 55468 41514 7502 18205 22833 12386 53058 62265 31047 1755 54299 9706 63585 40175 23634 10280 61061 45103 53914 46638 44816 13530 3729 58703 58407 5870 12021 1443 17732 8963 49504 34891 36902 19050 36747 65500 64410 58079 49152 46887 44744 46337 20678
arg_in:  2 buffer half16[8] 51518 9972 61502 41599 62954 8540 9007 30998 9099 46656 36681 22517 25759 53736 10055 49737 1895 25444 42564 21626 7943 12275 51926 5675 47312 10354 20935 10903 37539 57453 1687 14052 21772 14 27844 39282 12641 42790 22140 45905 31633 5552 52638 49645 12962 14871 49203 14152 8017 60123 10521 46623 30179 57090 35557 6051 2429 17697 49667 28233 58009 19494 42350 37678 39869 5969 2102 10151 30113 13078 56194 8071 44024 14084 44452 36474 43622 61186 2931 33478 43741 42947 44630 11314 17376 19751 36644 41185 17364 55126 41431 13335 60400 49304 20019 48612 25841 64680 51201 27338 22183 43128 64757 40635 11745 24482 31350 41924 29426 1744 31142 14419 13073 1357 42863 61599 2471 18535 21771 65124 16333 43783 9651 36416 30314 7462 4780 23085
arg_in:  3 buffer ushort2[8] 8322 26790 64463 20879 20800 13119 16489 14230 3310 36904 39099 28657 26345 16138 16517 41581

[test]
name: shuffle2 half16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle2_half16_ushort4
arg_out: 0 buffer half4[8] 52607 29460 32340 31741 58105 10910 36366 7124 3191 64763 17394 181 17432 55467 36424 55467 36356 32495 36356 61500 43981 6094 16223 13588 303 40987 49558 32176 10725 42777 28971 65053
arg_in:  1 buffer half16[8] 12020 15591 53696 8861 20960 21621 9594 32340 19626 23882 38608 45768 26043 3855 41897 57233 36366 38861 65025 60185 59334 50728 8869 10910 18334 15048 30789 7124 14725 11904 54810 48247 13595 46111 62489 50166 61955 27312 4799 51575 59381 27659 39634 64763 60872 48290 4607 51152 29114 2432 36731 22058 49639 55467 46655 37387 13771 38778 36424 29156 53983 48016 46186 60924 61500 32495 65442 22536 55648 38357 9967 59918 43293 19875 14591 36292 19980 36356 21425 44599 32426 59118 59086 33349 13588 38578 43981 3959 1087 3874 62158 44184 6971 52502 1898 6094 7037 9637 12169 37509 44912 6575 41701 7134 40987 31396 51011 20411 47247 6981 35206 8565 46398 58097 9302 59866 30810 44642 32116 55128 52405 36442 16370 42777 59896 48725 59044 30976
arg_in:  2 buffer half16[8] 4065 57250 34431 59841 47484 52607 33292 31741 62965 1069 35120 41155 29460 24029 41592 20116 54982 40974 24737 8545 58105 65239 54109 62687 6645 35700 27268 871 4673 40103 20831 39447 16818 19997 63210 46149 28406 3191 17394 62793 181 78 30776 4771 56745 8503 43178 51094 8544 41451 20008 17432 4253 53393 56252 28669 2878 19574 59307 31335 36039 3167 43642 46669 39567 32006 43290 65326 23074 11985 5479 40491 28470 60024 57701 17055 3246 39972 23216 15195 54660 58890 57023 9177 16223 40124 17822 8325 26417 38417 20732 5796 32957 16896 59145 26620 32176 9364 56356 215 43745 303 35458 41833 24970 65167 39652 52776 49558 58838 11945 6503 34228 1055 58932 31506 59542 31238 48268 40351 65053 28971 10725 7569 5909 44558 27637 6766
arg_in:  3 buffer ushort4[8] 25781 55100 65063 6359 10548 1799 39904 18891 17237 47755 10678 14200 43059 45253 9962 9989 27533 32161 57037 18784 4742 37007 1300 57988 11317 55304 2300 53392 23834 29739 42809 5496

[test]
name: shuffle2 half16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle2_half16_ushort8
arg_out: 0 buffer half8[8] 62245 1476 12911 19099 43129 13500 29356 13500 28649 60026 60026 47345 59564 35292 37372 59743 4818 9328 14098 34830 23582 37669 34830 34598 18215 62352 58270 45708 11506 62352 60167 60167 42308 20965 53831 36557 3469 2065 44018 44699 63409 49895 23610 46847 40792 8236 8236 60332 15900 10629 54332 1277 22965 22455 22965 32303 49112 19369 63109 49112 4414 27852 23673 54100
arg_in:  1 buffer half16[8] 48671 13500 13317 28014 44523 64302 43129 486 19099 27769 39070 47714 34039 14491 48574 1476 59564 34631 10136 37372 16338 47357 59707 1596 10139 55869 22142 2012 43520 60026 62603 32843 23582 4724 17424 48781 9013 46018 25386 40834 24484 14098 42874 21344 19599 64623 19732 34598 60167 37371 59502 55205 23196 54900 51937 26567 11748 12076 23126 3817 51159 33293 30905 42204 62239 22031 2043 42308 44018 28151 2379 53831 3469 2065 27643 28177 8103 49459 62142 37358 6706 14748 65121 5167 22042 16166 60332 40792 5207 49857 45957 45648 49895 36111 49669 61111 32303 61539 32180 37458 53962 50104 22455 15900 11427 1996 6930 27390 39827 15219 31038 22965 51584 8739 38510 27852 15947 14304 54100 3678 23673 63109 36772 43368 43623 51682 42204 19369
arg_in:  2 buffer half16[8] 44973 23852 6718 46817 62245 37311 12911 20251 51853 29356 40983 16932 422 20870 44962 6485 35292 50231 52234 39863 62454 21012 59743 42586 62010 29008 28649 23098 14446 685 47345 30132 34830 24451 36151 4818 50460 21953 20342 53653 47811 62002 9328 56402 25523 24362 37669 51126 62352 59358 23002 44091 50033 60815 48371 631 58270 44336 45708 36355 11506 11648 18215 46151 13396 36330 44699 17603 51233 24407 5333 59500 36557 31603 49938 24805 21300 39668 20965 60058 32614 12284 46847 25117 24964 63409 49308 6344 3874 8236 31063 5112 23610 59392 51881 1046 10629 24414 28816 19885 34836 41709 17202 8339 22491 13115 1277 29740 36358 31871 35128 54332 22144 36609 37671 34507 33205 27684 4414 64639 12831 3810 45081 15985 58684 4951 49112 30211
arg_in:  3 buffer ushort8[8] 40116 21231 65334 18536 1766 24897 30297 28065 55066 17581 45485 3198 12928 25264 5507 41398 50067 38714 937 56592 60832 8350 15504 15055 2526 5808 58744 32026 35964 63792 31648 8736 24195 14974 56647 61656 50792 61641 15076 54514 38101 34156 7196 24754 29735 37337 41785 57990 35431 58832 16127 54522 38223 10310 35791 6784 31742 48879 1801 49214 58230 27555 47496 34086

[test]
name: shuffle2 half16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle2_half16_ushort16
arg_out: 0 buffer half16[8] 2799 2850 17949 1042 2799 50758 52781 33242 44426 2799 25149 55290 36831 46501 9445 8038 4413 48821 31611 48821 17335 1488 8002 49106 46569 58221 8003 46569 969 34979 58221 969 60743 52368 52368 48217 20987 52074 62499 11473 24316 62717 62479 52368 26947 57554 4171 478 64131 30698 7680 15286 14172 37413 50463 30698 48874 34283 22721 7680 27891 37413 13351 21802 65249 135 34320 7048 27920 65249 31727 64246 65287 20586 7048 717 3258 43629 717 64246 23237 15384 32049 60929 32049 14862 12644 14862 43010 21718 52516 11767 14862 13324 50702 50702 8508 26231 26648 15697 14235 28784 42291 27186 53399 41309 14235 28021 27186 6008 8512 16133 41973 23222 31501 12072 31501 46419 35432 61415 36185 2320 23222 65058 6541 23222 20344 61415
arg_in:  1 buffer half16[8] 33420 2850 9445 47657 7356 64625 49272 2799 8590 13289 44426 215 6599 52781 46559 36831 29482 1488 61837 44170 969 48821 8003 8833 54573 13040 24306 20491 58241 57548 25147 9769 62717 45094 34274 55309 63313 42996 62499 42898 65329 4171 47277 48217 57554 15882 19840 52074 14331 29769 52227 34283 60773 41161 13351 27891 64131 14172 33978 27383 38013 21802 15286 7680 5349 43902 9892 31727 15875 44173 49933 31224 52507 7048 135 717 45996 333 49970 4100 56748 22243 32049 3708 26934 14840 15384 6111 41837 44747 39989 11767 50994 23237 2845 31988 53399 44105 41309 37284 27186 28021 49401 16133 38924 61852 8508 62844 42291 31947 48295 28784 3507 31501 12072 3454 23222 42388 19119 23263 65493 20968 49025 32591 46419 20344 11361 47632
arg_in:  2 buffer half16[8] 43486 17949 33242 27572 44264 50758 25149 11676 55290 46501 1042 24459 54463 24557 8038 27397 4413 32159 58221 22635 8002 46503 49106 5751 17335 34979 1364 62818 42114 31611 46569 3778 62479 478 46845 36900 26947 21035 2686 24316 39934 34783 20987 24309 54664 60743 11473 52368 22721 44463 59121 30698 41563 50564 31853 7926 50463 37413 48874 60900 14915 39633 38674 60720 43629 40848 34320 45132 27920 41338 3258 64246 61249 46001 27238 20586 42594 65249 65287 43423 24877 2862 6293 29306 60929 50702 52516 14862 13324 24070 43010 33227 12644 21718 9522 1340 49549 55804 26231 15697 6008 48083 889 8512 1835 27074 14946 14235 59504 54507 27282 26648 57710 41973 6541 23251 36185 5135 4507 2320 61415 44734 65058 37955 6420 35432 58554 47447
arg_in:  3 buffer ushort16[8] 28263 59489 64017 4794 10983 24053 45 10610 10154 27975 23094 42424 2351 13465 31202 11134 43088 52389 17053 46117 57016 57377 37332 47446 1598 3122 4422 6110 9572 31321 13586 22468 20925 16415 62303 51019 50778 18959 27110 39102 11159 11040 16080 24031 12980 55308 36649 45233 7464 61043 30607 58190 44905 20441 29016 1523 1082 53987 65488 20847 60775 42041 27046 20653 9341 10826 58802 43689 48020 50813 31395 32727 45694 57179 7497 49803 566 11920 21227 53687 55629 23430 59298 27892 20578 12791 20092 57271 36410 16221 14294 64747 62839 13368 3605 56085 19530 24050 32031 51347 58491 29199 16396 52004 38176 42338 16891 60261 30916 24532 25783 8263 21969 6436 51041 63938 39937 28972 16541 36728 52244 11575 34532 49242 62642 13924 11021 3832
!*/
#pragma OPENCL EXTENSION cl_khr_fp16: enable

kernel void test_shuffle2_half2_ushort2(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half2_ushort4(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half2_ushort8(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half2_ushort16(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half4_ushort2(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half4_ushort4(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half4_ushort8(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half4_ushort16(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half8_ushort2(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half8_ushort4(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half8_ushort8(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half8_ushort16(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half16_ushort2(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half16_ushort4(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half16_ushort8(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_half16_ushort16(global half* out, global half* in1, global half* in2, global ushort* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
