/*!
[config]
name: shuffle2 float uint
dimensions: 1

[test]
name: shuffle2 float2 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_float2_uint2
arg_out: 0 buffer float2[8] 9325 41992 46132 62884 37658 37658 844 59120 8778 22503 8254 30304 6856 37099 17924 34341
arg_in:  1 buffer float2[8] 9325 6462 30517 46132 37658 18016 844 59120 8778 44885 30304 53779 37099 183 1296 17924
arg_in:  2 buffer float2[8] 47257 41992 62884 19474 43667 1027 25367 41019 22503 57593 8254 28307 6856 60679 8606 34341
arg_in:  3 buffer uint2[8] 3534861736 4152453055 2957577581 2599550934 1478124824 996247432 1173538844 4152914149 280149676 3714242114 988900074 249941372 116800062 68419532 1256872021 1746783719

[test]
name: shuffle2 float2 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_float2_uint4
arg_out: 0 buffer float4[8] 48661 9017 9131 9131 59846 62781 56981 39053 10833 54930 10833 54930 59852 59852 49510 59852 43949 37518 37518 61509 37533 37533 33920 54021 34309 18364 34309 34309 62875 3996 62875 24717
arg_in:  1 buffer float2[8] 48661 9131 39053 56981 24679 10833 59852 42205 37518 61509 37533 33920 56539 34309 24717 62875
arg_in:  2 buffer float2[8] 9017 12569 62781 59846 54930 93 49510 30829 43949 1423 38035 54021 18364 19941 12889 3996
arg_in:  3 buffer uint4[8] 1095089576 3801103638 2136679233 2270168841 3761063179 2065450958 1342967193 309411136 2584302421 4294000442 1417270065 1850011998 1099528088 2190523896 500282346 3435818968 34862782 891477516 2234111904 525148089 1731558340 2870287480 345816177 931417571 859409313 1421966214 1070520385 1410483597 3780165109 783870899 187943825 4191515004

[test]
name: shuffle2 float2 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_float2_uint8
arg_out: 0 buffer float8[8] 5352 61056 59967 5352 5352 41199 59967 41199 34046 38621 34046 38621 34046 17152 34046 34046 39658 43307 27057 27057 39658 27057 39658 43307 34595 19976 34595 28850 34595 19976 37279 34595 20476 29239 29239 10980 29239 8422 8422 20476 25039 21878 33358 25039 30015 25039 25039 30015 16356 2282 36323 36323 28868 2282 16356 16356 44440 15921 10047 27696 44440 15921 27696 15921
arg_in:  1 buffer float2[8] 61056 5352 38621 51213 4819 27057 19976 28850 29239 10980 30015 33358 2282 16356 15921 10047
arg_in:  2 buffer float2[8] 41199 59967 17152 34046 43307 39658 37279 34595 20476 8422 25039 21878 36323 28868 44440 27696
arg_in:  3 buffer uint8[8] 747087801 3182519688 2814636251 720738285 1167229869 2404037534 4247384515 1630667350 3453877843 1948968972 2300969459 1222810100 1509683795 241797298 1430795131 98610799 3333005487 24443234 541868541 2429427233 3478149283 1552151365 4229950859 3969415750 3475053139 139348768 307833463 2068375985 779075575 1026396280 2933190846 795321351 1534639838 194151836 2916762532 266685149 1854615120 2577171715 2324412223 3775399394 1476586458 719638267 673237561 361924682 3448201200 2344121494 2476565886 4254491872 3455512889 4034701380 69359114 1168596822 3673590963 8597964 17793437 1574715109 1130229626 3095025560 1676819781 752515907 1719153910 2290496412 4189497523 4101463792

[test]
name: shuffle2 float2 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_float2_uint16
arg_out: 0 buffer float16[8] 33134 40463 53002 13287 33134 53002 40463 13287 53002 13287 13287 53002 33134 53002 33134 13287 27271 27271 58959 27271 20571 58959 58959 7163 27271 27271 20571 7163 58959 27271 20571 58959 23972 25972 13347 13347 23972 13347 26362 25972 25972 23972 26362 23972 13347 23972 13347 23972 19052 57693 19052 19052 60630 63221 19052 57693 19052 60630 63221 19052 19052 60630 60630 60630 31294 31294 31294 61187 31294 31294 61187 7055 31294 52201 31294 7055 31294 7055 61187 31294 45800 41101 37543 21855 41101 37543 37543 21855 45800 37543 45800 45800 37543 41101 21855 21855 32268 7953 7953 32268 36718 14599 32268 7953 7953 14599 7953 32268 14599 14599 7953 14599 16728 16728 24032 14354 17791 17791 17791 14354 24032 16728 17791 24032 14354 14354 17791 17791
arg_in:  1 buffer float2[8] 33134 40463 20571 27271 25972 26362 19052 60630 31294 7055 37543 45800 14599 36718 24032 16728
arg_in:  2 buffer float2[8] 13287 53002 58959 7163 13347 23972 57693 63221 61187 52201 41101 21855 32268 7953 17791 14354
arg_in:  3 buffer uint16[8] 3028299444 2258524653 2742106579 2588005414 1434649372 3819280495 1559852801 467888458 2523693359 759006382 730935238 27112231 3221889720 289713959 3045855332 1098467310 2203638789 2025783757 1510695826 844029705 2123727212 1928655954 3837436934 217626199 843433893 2216326025 3324269616 2330250179 1257812494 2439209125 3084523628 1751843686 319413303 139981572 1915518326 1462673678 3254182831 707048950 3203360789 1663432024 1294182836 3609111739 388734397 238200367 2724650898 2198563919 3545546282 1552390935 2785438792 941318906 1540557904 1605182476 2756724061 423693135 1374902216 2639397254 661364700 1232757361 324681847 3301323288 1507484752 1645510025 1068944977 1587418253 1685293804 2458494376 3799705156 285916218 3160522120 1574316872 2162803282 2398557549 3589154184 1937274539 718636480 1956535373 3760837560 2218437405 43326822 1647375896 630403281 510662974 86149164 1180906287 1938933426 2379679372 2701109308 1495212615 2306184381 2549811004 1488222521 3339060569 3422834128 3814592430 3641046171 660284851 3274957606 3390360807 3947720711 600062498 3790635357 1742534332 2588461274 1707193315 3106110039 1017713640 1268047035 2905189366 935812516 1463443752 2758136515 3155106268 4214436625 1900296561 3735765616 2578372099 1081408366 2466689830 2002176094 2257116787 1867851228 1511491009 1440096110 2927669792 1112834655 4206670231 73265866 443534222

[test]
name: shuffle2 float4 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_float4_uint2
arg_out: 0 buffer float2[8] 24320 50512 12068 30304 59949 56150 17176 24679 25963 53184 55317 37498 27106 65011 51803 58843
arg_in:  1 buffer float4[8] 53055 37407 24320 49823 44735 30304 59254 12068 47930 43044 56150 27171 26204 24679 44820 34849 47754 25963 12905 53184 63297 28328 55317 53324 27106 45074 4716 9092 54907 49761 13015 58843
arg_in:  2 buffer float4[8] 36560 20830 50512 24854 10313 17870 63251 63776 59949 29615 52926 1126 11537 22080 17176 4160 35684 20473 27519 64013 12979 43035 37498 36786 55581 46262 65011 42025 29830 43044 60151 51803
arg_in:  3 buffer uint2[8] 3438583594 3466504254 758618867 2095075497 316074444 2897184234 4067753382 3442993433 2173043881 3461281915 3958460674 3053345750 4120991464 1352149894 3705647551 1836462611

[test]
name: shuffle2 float4 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_float4_uint4
arg_out: 0 buffer float4[8] 17768 55572 17768 8572 30372 30372 3279 12375 50399 38703 50399 5090 17688 2659 2659 17688 51581 6307 6307 64056 34386 65257 16323 16323 60666 35978 60254 39640 58014 10117 58014 41054
arg_in:  1 buffer float4[8] 15753 55572 55149 18232 18059 12375 53494 30372 50399 40625 38703 58251 17283 55145 17688 44913 18805 13955 61996 6307 56605 16323 34386 39533 60666 39640 28690 60254 23226 58014 41054 19212
arg_in:  2 buffer float4[8] 17768 8572 45969 12897 15821 3279 35903 893 5090 44749 18088 46553 6865 2659 825 13969 65238 65211 64056 51581 19948 17958 63576 65257 28602 39305 35978 58368 30639 3214 10117 22932
arg_in:  3 buffer uint4[8] 2078842212 3116052537 1508820988 3880416485 2722595963 418535747 1400273629 4096075745 3831393864 3725782658 3806453160 3118061700 1210592498 3116568085 641145581 1471363602 1630014591 3115317179 2847292507 2389041478 1906174962 529133927 3521762425 1727700729 3713291680 3770893910 1816025707 2884205441 2569534633 3081962462 2586313017 366672138

[test]
name: shuffle2 float4 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_float4_uint8
arg_out: 0 buffer float8[8] 55213 43586 23651 55213 23651 4599 4599 14829 21058 3433 3433 6809 17421 21058 38165 3433 36235 47544 36235 55996 31385 25110 55996 55074 1009 35810 35810 56622 51452 1009 27909 51452 27976 6238 12421 13784 27976 5208 5208 6919 49215 43723 43723 43723 7444 49215 14712 53475 15428 62945 1315 15428 16875 16875 62945 26622 51090 22764 57790 22764 44391 44391 51090 57790
arg_in:  1 buffer float4[8] 14829 23651 4599 43586 21058 17421 3433 6809 15063 31385 25110 55996 27909 58265 56622 1009 12421 27976 15981 6238 12492 7444 49215 53475 1315 26622 39011 62945 10820 51090 41436 22764
arg_in:  2 buffer float4[8] 55213 63731 28481 32173 1830 22824 10177 38165 47544 36235 19897 55074 51452 24259 35810 35182 5208 46853 6919 13784 43723 29231 556 14712 15428 16875 31772 37238 37693 33069 57790 44391
arg_in:  3 buffer uint8[8] 1594727188 3979065875 2920375377 1363802644 1411528089 1386870602 3515837906 3136895776 3120739408 1256121674 1370141314 181794643 3201538097 118685936 1523378775 1534673258 1166720837 3586773212 3431551925 4151677467 307088649 2777226474 1886277995 762553743 4179305171 3263295862 2025888414 2890129642 1474533380 553803683 1051776392 3279526820 3699806345 40266091 3080471168 1640974719 3393460481 3784327516 3053531316 1933971054 1958865810 1969488956 1050533372 1794347580 720873561 2644983234 1838493111 3556920643 3376024292 909064683 1354778984 1798368716 587598029 2330393125 3531025059 320811193 311764145 1307302763 1220244926 3670566483 3725629191 1729292559 842617265 2056174862

[test]
name: shuffle2 float4 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_float4_uint16
arg_out: 0 buffer float16[8] 16088 61243 60493 21236 21236 30853 21236 30853 21236 61243 19144 61243 60493 16088 19144 21236 65493 44859 4127 4127 45870 44859 44859 58854 45870 11457 58854 30779 65493 65493 45870 28948 56647 57337 46369 45752 56647 45752 34111 57337 16472 34111 16472 45752 34111 50575 34111 57337 45571 27263 34198 50458 35485 27263 34198 58233 58233 58233 45571 27263 35485 585 585 45571 31481 14906 14906 31481 21901 14906 31481 14906 21901 47127 19091 19091 41918 45228 41918 37180 59181 41127 10159 15617 41127 10159 15617 41127 45572 41127 10159 59181 59181 15617 40265 40265 56026 24393 24393 328 24393 36680 36680 56026 24393 55673 56026 50493 328 3871 21293 21293 43034 15608 51496 15608 15608 7494 39204 51496 39204 39204 30681 51496 51496 10938 43034 43034
arg_in:  1 buffer float4[8] 21236 19144 64283 16088 65493 11457 45870 30779 16472 46369 56647 45752 35485 54121 27263 50458 45228 41918 19091 47127 59181 10159 41127 23100 36680 3871 56026 21293 18792 51496 30681 10938
arg_in:  2 buffer float4[8] 61243 30853 50825 60493 44859 4127 58854 28948 50575 31435 34111 57337 45571 34198 585 58233 21901 31481 37180 14906 26767 45572 40265 15617 55673 328 50493 24393 15608 43034 7494 39204
arg_in:  3 buffer uint16[8] 3603301531 4241172700 1756263567 494265072 1659415352 2621810341 1874450416 724992381 2127911352 2406216340 4149531081 1875662020 2525723063 3758693803 2736118593 4142611616 347668048 1853263292 3374265629 1019863245 133420018 3830201940 2567380340 2792217390 3895657594 1217031393 2043997566 2632719475 1269049224 1033942320 3105034778 838174639 2557607058 3794795487 3333251169 1230697739 2884349762 2799575771 1831140510 722221359 1364040472 3523338774 4288227192 2066173571 1950612374 2007607636 3680139166 1985642711 3666392180 3229799546 2130453637 3880725467 806375208 2780276322 2686785125 76255671 1953275383 3033016599 2064887500 382638826 337888360 1352263366 49424878 3098259260 1853986877 1085320983 2021819751 1577007245 2895195772 3561843199 1341072693 1732040887 779521420 428443835 1791204330 1579595146 4152944745 1517865504 625304785 3357264430 1121321512 880996554 544526345 3558489447 4010702586 336928721 2252409191 4136334674 4008760085 1459107234 2165148593 4037532704 4111312240 591307015 1106771358 3545241246 3631186682 1024310007 2978697639 1477213221 4052988167 239825208 3211684320 2638942018 706183479 3928622396 1113142834 1696930638 1601071237 3279443929 2003048675 3105143491 884535485 3704749172 1642910505 1277761436 2962248268 774241150 465295975 3543040537 3857256895 1117288279 1996273738 1398561521 1892694449 3096893835 326869965 4168581165

[test]
name: shuffle2 float8 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_float8_uint2
arg_out: 0 buffer float2[8] 57865 30810 34752 59903 27442 12920 23669 26078 837 1931 8858 14791 12767 48545 47930 39084
arg_in:  1 buffer float8[8] 13085 14279 37322 30810 59401 57865 47680 35618 35524 47083 47873 3990 53850 45872 41657 598 3098 22457 13709 39396 34994 27442 39799 25835 30992 8136 19116 18639 54348 15311 23669 60216 46247 33749 49925 44530 40074 27288 45261 53079 32599 28910 59599 8858 18174 9673 65180 32494 533 17507 33758 747 45970 2172 11873 13369 2085 19374 65405 41698 49518 24635 47930 55516
arg_in:  2 buffer float8[8] 35152 5711 63516 43726 43908 60012 63357 41107 4227 39438 51500 59903 42178 33257 42976 34752 12920 23400 49502 53401 55694 28918 28597 46683 31832 26078 54763 3716 26039 37711 65211 28149 26188 43735 43918 53489 837 1931 62008 48687 14791 54820 51426 44121 62165 1785 22713 22596 18110 49369 6851 48545 42086 38641 14457 12767 13054 35269 1052 57283 52715 15399 11994 39084
arg_in:  3 buffer uint2[8] 2872570437 1563308243 3187833711 1746828587 1731822085 2931647544 1256486118 2862890185 1732013708 1623957133 1648224083 405253832 4285502063 3021061291 2086387894 3626808671

[test]
name: shuffle2 float8 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_float8_uint4
arg_out: 0 buffer float4[8] 5500 27096 57019 33907 17841 30576 27395 17841 53961 22340 39691 50784 3200 9477 22973 31087 2325 52938 48562 20421 63179 38746 9037 64043 38322 24024 47642 38322 8007 5299 28730 57889
arg_in:  1 buffer float8[8] 20004 41816 5350 33907 5500 13876 40645 3351 22040 27395 42594 30515 25967 42082 11347 30576 246 35835 17390 22340 50784 9533 50483 53318 6021 31087 27631 23990 48203 52717 51243 9477 36665 8444 2325 52370 48562 32910 4145 57253 13702 63179 40111 1077 32994 9037 56364 38746 57504 47642 10528 18614 12006 38322 3994 45341 39906 50952 58984 2941 35135 5793 57889 33148
arg_in:  2 buffer float8[8] 15341 12963 27096 50376 57019 50838 4810 2491 18267 65528 20561 58428 17841 46872 13756 53769 25033 39691 21212 28180 48851 44973 53961 60273 3200 20560 61711 22428 40794 22973 57700 49449 20421 35888 31040 1874 1515 52938 36314 25711 45708 61587 54269 20468 57785 31738 64043 12539 2588 49869 24024 3129 18341 27882 6141 30692 8007 58824 55503 5299 64790 49625 452 28730
arg_in:  3 buffer uint4[8] 271035940 1126811530 4087087372 790266067 4236323148 3672176551 1389609841 238718252 2814548638 1568681555 849013161 1544328868 3435665880 1520569703 3152521997 2251252113 4015555170 2972908525 2914197588 50614424 4005459633 3776693927 3349939429 3649596478 956818485 11316026 2983563041 4186620853 4029463592 2413764779 47806751 2383333654

[test]
name: shuffle2 float8 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_float8_uint8
arg_out: 0 buffer float8[8] 25387 7985 10748 33938 7985 30755 25387 25394 23006 47305 38779 45259 47305 628 17877 45259 30254 33110 5390 25071 6272 12426 52518 21345 14543 48127 16774 44769 48127 193 52144 61209 25551 20928 11363 11363 25741 48390 27391 53391 19204 30003 8298 61854 59188 60399 32754 22507 44793 36721 35878 55595 47207 35878 55595 52345 4368 25525 22190 22190 19889 55837 30483 44365
arg_in:  1 buffer float8[8] 52857 9383 11265 25387 35123 25394 40615 8482 47305 45259 48800 51068 17877 44749 18387 11056 40500 25071 33110 19531 30254 38479 31709 6272 14223 29722 52144 193 61209 14543 29337 9216 2642 25551 49487 25741 54860 16661 51299 27391 61854 59188 4569 8298 19204 49697 38337 28686 47207 63531 36721 55595 44793 35878 4835 55339 28621 25525 12435 51880 22190 18047 4368 55837
arg_in:  2 buffer float8[8] 18719 7985 33938 15724 44685 43892 30755 10748 628 27801 17282 41973 61373 40233 38779 23006 5390 21345 52518 51182 18222 25925 12426 51149 44769 12629 19118 16774 46225 26325 40014 48127 20928 3025 48390 57915 32104 16701 11363 53391 30003 22507 37796 52811 11797 60399 12797 32754 22261 45604 42214 11191 40709 52345 61272 28554 61539 30483 6635 44365 19889 11837 14129 66
arg_in:  3 buffer uint8[8] 987455507 3552146809 289508399 237767018 2587417257 1723046942 2406162291 467759637 4249037535 844117696 1816262094 3945945345 2958631968 3350561768 802225556 1755179745 2937062292 3070870418 349049048 3294504465 4119711575 1160442750 1526017338 4018769305 3461823637 1510728511 414915211 3680895464 2603809711 3711507411 1826924818 1683919444 3520906081 1544820840 1093446974 1170564926 3693423555 584926538 4188119575 2973524943 232529284 271046072 549985779 669892912 2776223617 587283437 1031060735 390157273 3892680116 2828519074 766645493 1924993107 230824656 3412894677 2741358595 2395983341 3783576374 3660950577 4170146580 1769562468 205170716 1378867863 1777189065 1222089083

[test]
name: shuffle2 float8 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_float8_uint16
arg_out: 0 buffer float16[8] 21905 59492 2347 64092 59492 23072 44498 40200 34816 44498 59116 42462 40200 49081 58462 4845 55800 6146 55800 7797 253 58574 2968 7797 28768 2968 7797 52602 7797 4314 2273 46618 54092 17451 57292 38925 49183 30858 51129 51129 30858 7655 31804 17451 7655 54092 18085 30858 41443 8793 55530 35579 26189 26189 8793 11622 41443 35579 22867 8793 22867 64601 22867 11622 51688 11264 51688 13494 11264 64313 44194 51688 25919 17774 17774 43457 32078 64313 22605 17774 35650 11251 46394 24770 62612 17451 46394 24918 16475 19900 16475 24918 54042 54042 11251 17429 15623 33033 15621 32271 5546 5336 15623 32271 5336 48646 18742 15621 15621 11482 14812 40270 57710 54459 8697 45033 55918 50467 5925 55918 54459 11338 57710 15393 54459 5925 11338 4566
arg_in:  1 buffer float8[8] 1116 64092 40200 42462 21905 44498 2347 23072 7797 2968 4314 53269 18000 6146 58574 2418 59497 6979 17451 54092 30858 17665 49183 57292 41658 61308 64601 22867 35579 7021 8793 24766 51688 22605 32078 25919 17774 43457 44194 54567 54503 50290 17429 54042 2303 17451 16475 19900 15621 32271 14812 33033 29354 5546 18742 55053 11338 55918 13250 45033 50467 46582 35347 15393
arg_in:  2 buffer float8[8] 49081 33254 34816 20463 4845 58462 59492 59116 253 46618 55800 52602 45628 28768 2273 5549 29401 63191 18085 51129 38925 31804 7655 21597 53309 26189 11622 41443 55530 55958 45138 58670 40859 41764 12213 11264 64313 13494 46012 8471 35650 24918 62612 52867 24770 11251 46394 24311 15623 5336 11482 48646 6473 40270 24550 347 57710 8697 13454 4566 27508 4144 54459 5925
arg_in:  3 buffer uint16[8] 3676863796 92120958 2726160502 3663106257 3272471086 2395911799 3106186933 1569295250 2270234586 2440097957 3321755711 3389391491 2395223762 3705520904 4182337101 4053441004 3076121738 1850800469 3021778858 2543397648 863728424 278376998 667003713 621946080 2220784237 2755775921 1609915712 1487220715 1798823104 4118023842 1132025838 3318949609 1750791827 3930514946 1779640311 234685116 1386104662 429739236 2079928555 3511640011 985427316 360474846 906940557 4282590354 3790091758 662023539 374951322 1754558340 427039387 1981676966 702584556 2827657412 1550203641 1207622249 663084710 3676626154 1664187947 1973627924 1876599827 2973054278 1776640419 387650978 2349233107 3430500666 2577798592 3794097595 4063522816 810647949 3292847499 690823148 318813350 4207202928 895803987 2410995492 2654827604 798905605 413807922 971387548 533756849 2659927684 937374392 2409801261 2704241870 1986556028 1987214682 4249094613 2104254238 1099808969 3148036998 1206301287 4110901654 3624705161 2027620723 3195296755 1145961309 2667129314 449962088 534537507 2897095056 1507244337 3410735493 3869748809 3592603912 3897192241 543701849 1134631003 1698492406 242280736 3865231504 4139600938 3965689186 3001891005 230147032 1964873102 544235113 540055171 2425227217 3153226404 3132629999 3270950785 2792681758 1442789952 4210156728 3057240727 1658783454 373581007 1513145232 1791634859

[test]
name: shuffle2 float16 uint2
global_size: 8 0 0
kernel_name: test_shuffle2_float16_uint2
arg_out: 0 buffer float2[8] 45235 29454 45691 61665 44 16560 55752 10238 9597 51798 21842 21842 5678 5678 30179 33377
arg_in:  1 buffer float16[8] 27343 29854 33355 37079 33044 38514 45235 62495 54360 47789 51629 41864 11821 9729 2664 51689 21800 25958 44103 56994 33610 14234 60432 3693 63088 56554 35906 13484 59042 22525 56852 13001 2714 539 25142 20471 27233 37433 42439 46161 16560 56853 22309 62701 53673 41842 7294 54158 63446 19003 5487 52412 10238 9955 137 47701 62405 64047 20154 50773 59846 50160 1502 15654 14883 35261 38619 32067 16759 44058 51798 10350 32711 27013 557 16495 789 37783 34465 34094 34076 29615 216 2384 23166 53116 24556 7541 43673 17967 16877 40338 2091 49148 60106 17702 39841 37731 55923 40571 33167 38636 50624 14880 20137 17041 32057 9990 52989 17415 33987 61893 26488 35872 50576 56599 30179 15179 35416 60808 12016 10701 25121 31677 45193 59103 41960 46203
arg_in:  2 buffer float16[8] 24901 29454 4263 65383 3684 3221 39062 29832 61263 47903 50365 51926 788 34902 42075 38427 25024 61347 13825 28103 41699 45566 51242 61665 44045 61785 45691 2182 22243 51043 39345 53198 44645 2699 14090 34181 24705 30863 11662 5123 56035 45371 42854 214 46752 44 1154 30443 32965 3753 40826 10784 12424 35672 34239 55752 49463 44986 60992 10200 32835 8218 60673 61409 9597 23666 38929 27512 52270 63609 29420 64275 16230 5041 58921 39744 18192 61150 41423 6346 21842 41041 26827 48690 54521 8586 22905 29328 43083 42065 53815 13184 22272 20597 64616 27554 43108 18910 6965 29863 56104 23231 5678 47174 21147 3175 55880 41023 41779 65343 13060 22110 33377 3923 2733 36871 33362 60929 61739 6970 46028 1333 17549 14844 360 63395 7839 65453
arg_in:  3 buffer uint2[8] 4174275526 2197463569 1535024762 4175336279 1111832989 1621214472 4257709431 3358184932 4274016944 3254826950 586878320 1198475280 1913787542 272659542 2247238308 3374810128

[test]
name: shuffle2 float16 uint4
global_size: 8 0 0
kernel_name: test_shuffle2_float16_uint4
arg_out: 0 buffer float4[8] 6859 22594 62539 38972 56453 15678 60348 35371 33776 55059 43168 32460 38981 47429 21085 27730 61071 21047 60462 54510 24548 10857 50786 19613 1891 33352 50605 45336 3159 14275 9234 16661
arg_in:  1 buffer float16[8] 12130 52255 44806 55724 25059 13038 37346 25119 22594 62539 38951 62867 62614 60397 5029 60382 56453 35371 44153 45675 40673 53044 59283 42799 54358 38858 8871 4718 2181 4188 28158 16406 60148 9826 59911 16990 10519 28252 30006 25311 18217 2077 6001 43168 27001 3868 63291 13793 22954 9103 34378 33784 64779 46348 25052 38981 40022 19757 14296 55919 40780 64674 64460 5684 47067 27836 21047 61071 43014 40141 15909 37711 17260 50599 11032 54510 53312 40811 26927 11266 51643 8035 11966 57141 23350 58928 50786 24548 29134 53696 55248 45648 36820 14930 47714 24700 30199 15771 13467 16775 17227 39921 5078 49272 15186 12536 50605 59742 33877 33276 57061 34233 20203 25898 31538 8599 14275 47195 61277 9234 6563 43568 9775 3159 10125 42973 55644 10620
arg_in:  2 buffer float16[8] 18313 6859 5539 16938 7724 12311 31170 31008 38468 2495 25139 9896 44469 38972 35605 52018 15678 60348 26211 33739 30523 55635 31093 19856 1346 33124 29310 59689 57474 28564 4905 250 32460 41887 37539 33371 7183 36937 33776 19431 5606 38722 4069 37603 58100 54150 15634 55059 27730 47429 24729 39634 9161 21085 48794 22902 51594 14005 40568 63236 30500 2379 31152 308 52259 60462 6056 53753 29926 48341 22531 25909 17847 15420 34324 61835 48282 48571 38328 21529 17963 17799 31656 19613 41665 60033 10857 28196 43220 53700 26281 879 45744 27278 57569 54248 1891 36329 57548 2534 33234 16998 58125 38875 50312 59256 14222 50586 33352 53192 45336 60429 47768 48598 62472 46686 16661 45635 47285 42701 14983 34227 19256 20262 17967 18452 59751 39839
arg_in:  3 buffer uint4[8] 2057256529 989640232 4172046537 3918853533 1131059328 3631757008 2838576305 1401504897 4232514582 2909648767 2293176907 149004688 2723659527 1549244081 606357269 2439909328 1964812003 4167894306 2706292177 3196024363 3230894919 1456779094 2189184710 228352595 97739504 32297980 499745930 855491646 2096640267 240238916 202336071 788913364

[test]
name: shuffle2 float16 uint8
global_size: 8 0 0
kernel_name: test_shuffle2_float16_uint8
arg_out: 0 buffer float8[8] 63314 31306 44741 16203 62465 29014 32677 26401 57848 31335 20533 57848 58012 35706 14370 49483 22955 23338 29439 29439 62525 23338 53985 8987 54248 14248 21070 31877 20827 16134 22769 59054 63818 7748 63408 61491 63122 63827 2118 50723 40812 14026 5737 25356 35904 23519 58029 30424 60045 46991 64041 243 243 22883 243 46991 48299 51895 28557 23264 28557 34951 48299 25868
arg_in:  1 buffer float16[8] 545 8607 28718 45665 32677 46391 25586 29014 34158 38298 31215 44741 7835 50783 25239 31418 31911 25533 18163 28823 7275 22776 29315 7575 57056 51771 46081 64631 51418 22121 14370 12822 62525 3032 22190 34624 27561 23338 21477 53985 11456 13787 61376 23459 13147 22955 4992 30310 33444 12376 32937 9197 4213 1991 19464 16134 44083 39976 22769 11678 1178 59054 27322 54248 23795 63827 46729 22885 20042 34204 65243 420 29116 61491 63408 62036 7961 18059 54607 8399 15408 39709 49760 7700 29577 7244 22166 39953 30424 35904 4777 38201 20740 54300 28656 23519 14874 42905 24327 42915 58377 64041 46991 6788 56761 46839 19564 498 548 44794 40152 697 3412 26323 12271 16518 34706 41263 48299 62354 56934 62508 56136 25868 61156 52349 51895 57786
arg_in:  2 buffer float16[8] 31480 41488 62465 63314 62792 31837 10763 16203 42139 26401 47890 2040 20663 31306 10683 35550 53086 11372 31335 3620 3543 51168 38306 35706 62479 58012 20533 57848 49483 16419 5691 39185 23669 29439 59330 58557 339 60218 10699 27310 39268 61990 26406 8987 18003 8187 43589 59918 49431 20827 12389 60356 32191 13547 21070 37128 14248 11661 50845 23751 15096 31877 21757 49321 31098 56321 63818 48915 2118 10904 63122 57605 7748 60981 50723 53909 59873 12346 10049 24644 3200 41564 25356 5737 1788 15816 58029 62798 28515 60102 58578 19722 40812 11534 14026 25308 38386 18265 23907 243 8836 40890 3280 47905 29071 44418 60045 59294 25183 22883 8702 53756 44816 1157 23264 64627 8099 10307 27424 28557 29117 60553 54278 48520 40093 34951 64286 16342
arg_in:  3 buffer uint8[8] 2180666355 2941663421 2650624395 1928706775 2132614162 526997543 3746436 4011751737 3344408539 2352466834 1299711002 2548667419 1834881945 2448669591 236141230 2577829436 1826473389 3377025381 1261047793 2329287377 268051776 276960421 3503707367 3835410427 3696681263 2531943448 3546398070 964552701 887095921 532234759 530443978 612598189 2313183794 2313407736 2165432682 2781977705 4232010166 3488376033 1779253716 2931951098 4246471164 1119152670 4108378643 492051474 443109865 1088996655 3671743830 866593864 161367386 2676528486 3777463845 1994058739 3413638323 3876247101 3785850291 4031668102 646375878 294394638 2978353367 347637842 3592382903 3994368701 3089661190 581484235

[test]
name: shuffle2 float16 uint16
global_size: 8 0 0
kernel_name: test_shuffle2_float16_uint16
arg_out: 0 buffer float16[8] 47636 2569 2569 63827 41820 26674 19956 57806 63827 64502 19956 63827 41820 23118 64502 4342 14021 19863 59809 62807 21668 19138 47124 9189 13806 21668 6740 16584 21804 59732 59809 39914 28094 49973 27889 16456 5534 32361 29586 54706 21307 16456 16456 41500 49973 29586 29092 24090 41028 7275 6288 47747 13699 7463 28664 54903 61617 1761 3863 47436 7275 52266 61617 30867 13693 45842 35766 42573 52308 44318 58576 9723 9723 47219 49342 27473 55576 42573 21150 55576 39218 6469 20038 31080 48702 41323 52497 41323 51878 20038 46887 40085 5081 56753 41323 51878 54304 39303 23461 10592 20320 1690 54304 48015 59589 53611 10602 59589 50893 20543 39918 10592 55307 25262 10364 50243 25262 15803 23619 21420 7945 53810 15803 25262 5861 7945 21320 53677
arg_in:  1 buffer float16[8] 36215 22105 47636 10743 20274 61096 51664 9919 55239 49075 4342 19956 2569 15116 15698 8171 54639 29374 57694 59062 62807 9189 19138 6123 11640 58583 16584 21804 39914 14658 26340 14021 58478 28061 28094 46792 36234 10912 32361 30405 29586 42425 34520 8235 15676 6316 41103 27889 13699 22915 51344 7275 61190 3863 14076 7463 28664 47747 35249 47436 40628 31448 22731 7425 17319 44318 34219 35766 27473 52308 9723 47219 58576 56823 41261 13693 55576 61397 50180 45452 63126 39218 10083 6046 46887 48702 53614 20460 41323 33266 20038 46619 6469 52497 41101 37534 60380 22232 16754 20320 14216 51791 15278 17299 34108 34348 57153 23941 23171 36042 54304 23461 50243 10364 56188 5861 60074 15013 15896 15803 62612 24955 17850 10918 18449 21420 7945 8814
arg_in:  2 buffer float16[8] 29778 26099 60110 23118 124 33769 26674 63827 47938 41820 49868 6907 36814 57806 64502 30342 27275 59732 6740 3683 19863 12998 50819 62402 36258 34194 21668 41379 59809 47124 13806 61170 47706 21307 16456 41500 59952 32610 49973 39233 29092 5944 56728 54706 65241 57305 24090 5534 41028 29641 63571 30867 18756 29652 52266 61617 6288 4777 1761 33224 54903 6438 11370 43137 55072 33018 6607 6447 49018 7714 20544 45510 64481 45842 42573 22264 28525 21150 42539 49342 56753 16164 47912 5081 28169 1279 57223 31080 51730 35634 42390 40085 41373 30865 18828 51878 58665 10592 48015 10602 31933 38481 50893 10535 1690 39303 60602 20543 53611 59589 39918 46922 21320 53914 14033 35118 45403 23619 14376 62661 12113 41229 55968 28545 55307 53677 25262 53810
arg_in:  3 buffer uint16[8] 1785048450 1729362636 1592779564 383553719 1838215801 2769803606 1482908171 3789956349 426040247 3406533054 1244269643 362833015 2441587161 1090550419 1532420542 3948848490 686921903 2241037140 4250838076 1237601892 3951017210 3603732358 2270066141 1395618725 4145988222 1138204826 1347789906 1976319050 2103502923 3792781009 1416974908 1384616524 487044162 3317546582 902975183 3064219666 2680066143 948705414 2729142248 1689365531 295827857 3559008082 1128855602 152841267 1243394838 3106856744 3288565304 2480373406 3664508304 2368068291 2502059256 3935086985 2650679584 251381127 554216296 600518428 2602325879 30894842 514492229 1529613067 2265560259 1097750806 2761142455 677589395 175334699 1909329113 4139252707 1205890138 3020580805 417622593 2771623880 1971907142 612525926 60803847 1531826911 1974945284 1335621068 2653436602 3130032221 1218234924 4147887009 766339468 3067691402 3223425527 1911591493 176030344 3791409517 4049087592 1808280831 2683543658 3864727684 3959067099 2807188883 3431142320 1205371880 1757075999 3214564878 1718028889 2022939695 1667737969 133355043 1936781592 325530894 938744242 1823967101 2690249756 2509226707 4095821533 2643482934 2452816667 3954247902 2975804881 1189644028 332989246 2836052577 1727201568 166928702 1291175719 3128322101 3092213677 2546888558 4052931007 1449311687 1174469598 2670559363 2696947374 2378058800 537233405
!*/
kernel void test_shuffle2_float2_uint2(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float2_uint4(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float2_uint8(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float2_uint16(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float4_uint2(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float4_uint4(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float4_uint8(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float4_uint16(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float8_uint2(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float8_uint4(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float8_uint8(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float8_uint16(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float16_uint2(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float16_uint4(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float16_uint8(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_float16_uint16(global float* out, global float* in1, global float* in2, global uint* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
