/*!
[config]
name: shuffle2 double ulong
dimensions: 1
require_device_extensions: cl_khr_fp64
[test]
name: shuffle2 double2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_double2_ulong2
arg_out: 0 buffer double2[8] 32047 32047 40071 64262 38103 11679 9892 54514 46814 18953 47822 27856 6980 40739 4196 4196
arg_in:  1 buffer double2[8] 26455 8936 571 40071 13709 11679 9892 37571 46814 18953 47822 27856 40739 6980 17597 24761
arg_in:  2 buffer double2[8] 30852 32047 31449 64262 38103 30516 54514 43745 20723 29846 28790 53703 51814 10879 4196 29594
arg_in:  3 buffer ulong2[8] 8319796580817401951 13126034975760456767 12880336022000781245 1210144535966482543 12532393771027016474 16173332762085110417 17760606336629196008 14868834623426015162 10868767762943668288 6714045856785959545 1232184069089524536 9917308245995096001 13056445795308240277 13591743973762177840 11713465856363256258 18033895821964357010

[test]
name: shuffle2 double2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_double2_ulong4
arg_out: 0 buffer double4[8] 51853 51853 59004 59004 16944 25299 25299 16944 45306 30452 12484 30452 13343 13343 61695 36889 16225 26655 48163 26655 17353 17353 20485 61849 48238 35492 23849 35492 9440 55713 29479 9440
arg_in:  1 buffer double2[8] 6013 59004 25299 52775 45306 30452 13343 36889 16225 48576 57339 17353 35492 23849 9440 3296
arg_in:  2 buffer double2[8] 21699 51853 2740 16944 32404 12484 61695 51725 26655 48163 20485 61849 48238 48378 29479 55713
arg_in:  3 buffer ulong4[8] 13046477389791282139 10145873517506740251 10130130423575905633 15097629718875698561 5800704346039522631 7009333367151576116 11578249626420076756 5648571735232481551 15434972081683697280 623799618138634669 8329187700516533835 15037266752639179461 17773035772446804456 2274798523653544536 9242924872299930718 13915242507268047717 13588789410334007616 2478788298426335318 5128331987850573623 14096552025442606406 7109407341833952689 7451623913768801501 17486332761880180702 10229454827404387079 469612159605773362 4538394246117157444 1412470984159884513 6453385816134469912 4345478618576370196 4582494036447433735 9980273173426217014 3359644347735205516

[test]
name: shuffle2 double2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_double2_ulong8
arg_out: 0 buffer double8[8] 38393 65013 65013 58869 65013 53657 53657 58869 39568 39568 5073 39568 62907 62907 62907 5073 31501 46202 61182 31501 61182 63298 31501 46202 60877 370 370 370 36141 36141 25816 36141 54040 54040 3636 20603 21611 21611 54040 21611 9249 28395 47132 28395 9249 28395 9249 9249 60205 2275 60205 8926 2275 2275 60205 60205 25861 21492 45759 45759 46092 25861 21492 45759
arg_in:  1 buffer double2[8] 38393 53657 5073 49995 63298 46202 370 25816 54040 21611 47132 9249 45979 60205 45759 25861
arg_in:  2 buffer double2[8] 65013 58869 62907 39568 61182 31501 60877 36141 3636 20603 28395 60699 8926 2275 21492 46092
arg_in:  3 buffer ulong8[8] 12406125214690082528 8032720872388911690 9799335417293907218 12930763624978638503 1248991338696869894 4976754129133169165 10063129696134055177 12476906468129805971 6357792144525558627 4122844040683362563 1216731449503709764 2996879700483235219 2140047141832883118 5383709468191823666 17860859513093758938 9280340610611261620 646355208728788119 7245923992726674953 5722075445579915934 4390200869970995051 3590278603426289246 13898194815605167052 7082864548522420131 14768873340518081793 1874600909389053430 13341806307250042052 2786253067273905004 924533664330089884 15821961703184232743 6043458782131826271 11186442355455963669 3640308101759975319 7972276087694181600 15797249431257282384 3659174148620476934 8833547652212361575 2554899936986723821 8428811711638147717 253615350993349636 8846868555747978373 12696948338360223977 16709585671050161142 9107100389130575228 5569622260196712574 11370731368139645133 48904802665097594 13740536236276178717 8910862543574389861 2342482924772026113 5019920827374380459 12695764768208437697 11092292202753039226 9882994664878410703 6470637915205381003 11761869909082813529 16057434213798960177 5552731613430296253 12667178459161802082 13437512889208330024 17210234080458868324 3846776751033656311 6394902670545726365 407599745556354706 13853868404700618100

[test]
name: shuffle2 double2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_double2_ulong16
arg_out: 0 buffer double16[8] 54124 44470 4116 44470 54124 54124 44470 54124 44470 4116 54124 54124 54124 4116 44470 54124 24805 15374 24805 15374 37746 37746 46553 24805 46553 24805 37746 15374 46553 37746 15374 24805 19094 62706 22322 2264 22322 2264 62706 19094 2264 62706 22322 62706 19094 22322 2264 19094 8727 18336 8727 18336 15548 8727 63931 63931 8727 8727 63931 18336 18336 15548 15548 15548 11193 3792 11193 904 40482 40482 3792 11193 904 3792 40482 11193 904 904 3792 11193 65489 65489 2781 33447 33447 33447 65489 33447 65489 65489 54615 2781 65489 65489 65489 33447 23251 23251 23251 36175 23251 42790 25371 23251 36175 23251 25371 25371 23251 23251 36175 42790 49008 28262 49008 28262 28262 23902 49008 28262 28262 23902 21064 21064 23902 49008 23902 49008
arg_in:  1 buffer double2[8] 54124 44470 37746 15374 2264 19094 8727 63931 904 11193 65489 33447 23251 36175 28262 21064
arg_in:  2 buffer double2[8] 4116 27198 24805 46553 62706 22322 18336 15548 40482 3792 54615 2781 25371 42790 23902 49008
arg_in:  3 buffer ulong16[8] 3874190197130047164 12843221354698591821 16584339804948140482 5828595941127489177 11842429178215354728 10382708583433076960 11108752001814011269 7184935306624367976 4042672651120443721 11892962221839491098 16179543013163434824 8525817469484066852 18315146228680867752 16126736923413448910 2994626259152581761 5941797076651600388 7352536031873911954 3956086705502672569 10550688251769844662 8986629214321419765 8211512830730591856 7130350364566460196 2101548875255482155 3311712790340623326 9969800171297930579 7520144001968148166 10956330116536994940 2316130340210931881 3476070041860469527 17075123242907271512 3497153784621500117 15288955155397875866 8912445413916779221 16401105704971424318 17929657769800370087 13041354152564699384 13724090893821596875 16108053297863007452 14097155260877928966 18232988671737379113 12447222849073976568 6738435073623626866 3979598686645195459 10636249115896815734 21279260138698869 18022004982863208719 618695277090601288 3112198839892208225 13760140597985830656 17043076591113531030 14528954999723558440 4621729561491864198 17876689783787638775 630583833557810660 6025666895457976405 16558137326076910357 2743299621236799420 12198473798807190844 1350217899377446517 14369993129206723182 5423147186351800146 9830203303396185239 12625297979793732731 14106231934619521179 12879082138787918209 9908353504827351863 17079224185869887613 725737945566571472 14674686350549282238 803189201443067154 8747328727832486003 13719667504312830813 10840240141162744272 12895001084570830655 1651190862916982510 13074469754383467085 7548999680988890240 9079822083073917480 2031663622943360695 3859947434364961441 17214203702779217752 172483442713574440 11227828960147337531 8464081042502020873 7244847171486865149 2321674319803187761 13757968010276771796 16774844899701555109 5384272612420605328 7704869818553307632 296546029316211178 18221027395329961007 7870719129098339836 13519183917275869036 7086056404601409932 3759789777313646925 14613149144848746776 11888837529779453752 3214998197508983144 3066885845153370941 17815226442053898868 10221483516685009975 11704079552584191034 14997200144716580496 5652842939823030837 1385874123743943300 3567909697008280502 456704238576860306 4670956147838998120 9714806592163948768 5983507734964431017 6733268036506744031 14349321987866322179 6509066149324734012 2448366011338566427 13076787134151383152 7722446106004666140 6579810877048087542 3374075694128764151 298964554694592432 12114294490096029076 3365382633886623130 5134915503401877981 14533285123013617401 995923917185594610 10696893952882980075 10301485465001148114 10167214929945575695

[test]
name: shuffle2 double4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_double4_ulong2
arg_out: 0 buffer double2[8] 20446 20446 2791 20968 13535 46932 11410 60089 17019 48500 56116 21890 17680 41426 45160 1909
arg_in:  1 buffer double4[8] 27154 13519 6097 51598 14552 4145 3211 2791 40717 61037 48001 2241 11410 6577 30645 31425 58586 48500 25116 17019 12159 59474 56116 37560 9615 46141 57454 11969 22202 45160 30450 28058
arg_in:  2 buffer double4[8] 30632 18162 20446 6518 6352 4856 20968 57785 52012 23211 13535 46932 29509 59915 60089 33808 17918 7089 30294 51160 6864 23324 55465 21890 41426 17680 59757 100 51417 45632 1909 22389
arg_in:  3 buffer ulong2[8] 15204478941437940270 17727766987281365030 15422017436462585019 15888068283844444302 10753642449433345430 16229263481931213295 10608336403642251224 3233391937191726974 12331983918802760771 443465402666226833 11790622408045496810 6069297485966810487 5916813743087800517 7327784421147884420 11861445853551187481 3022564514557983142

[test]
name: shuffle2 double4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_double4_ulong4
arg_out: 0 buffer double4[8] 64606 62286 52090 26868 10043 15470 55257 54547 18910 29895 9142 57083 24964 53559 49063 24964 12015 33277 41640 16792 41795 36923 57314 57314 41370 15928 43896 33196 18375 47877 18375 46383
arg_in:  1 buffer double4[8] 38970 52090 26868 62286 62007 54547 29362 15470 47974 18910 29895 31797 24964 8758 33536 53559 33277 788 23685 12015 33174 41795 30109 57314 57018 40240 15928 33196 47434 47877 14708 46383
arg_in:  2 buffer double4[8] 64606 56220 36721 11861 10043 2763 55257 19450 59914 9142 63551 57083 45161 41185 11242 49063 41640 23125 10586 16792 10837 36923 584 56331 6832 45075 43896 41370 57766 60615 5712 18375
arg_in:  3 buffer ulong4[8] 2874738652363473580 4724902661267002195 15370672780218878745 13552419757717066554 7229162998573816164 490159119052201051 9032755535190598878 5028363114506973337 2945546931181193705 3975193094847304746 17757031258845844517 9315009794951949375 3249887388841966408 2137328013979316507 13150588342410309527 18167930565901135032 831544627506548667 13384826287024390784 7966619711002388796 16925995386444519975 15246940016182144849 12371002852726340493 10368838677455490683 17165275498138046587 641722939698779727 5463276700107497922 4002635665789914070 4844019888558826971 18397296484337601383 4613986477204985097 13254639440066724111 4018830944424778475

[test]
name: shuffle2 double4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_double4_ulong8
arg_out: 0 buffer double8[8] 35576 34972 7373 7373 35576 35576 57683 7373 14723 57806 32599 32599 61350 14723 32599 14723 7836 17887 24089 15992 50850 24089 47812 6688 39473 4996 59095 59095 4996 39473 59666 53920 57887 14925 3574 53570 53570 53570 50349 53570 37824 50941 34036 18071 28760 25234 1001 37824 38608 61423 34570 38608 41554 49315 50293 49315 21902 48197 21902 21902 21902 58073 41560 21902
arg_in:  1 buffer double4[8] 7436 57683 35576 30941 61350 32599 57806 35622 47812 50850 15992 17887 28666 4996 59095 53920 57887 33521 5360 3574 28760 34036 25234 18071 38608 49315 34570 50293 48197 56435 58073 21902
arg_in:  2 buffer double4[8] 7373 4156 34972 56936 46016 61656 31307 14723 28918 24089 7836 6688 59666 39473 37826 39834 14925 53570 14289 50349 37824 35060 1001 50941 61423 13934 29707 41554 41560 11128 65236 65379
arg_in:  3 buffer ulong8[8] 7353826884644140962 2395004285992542094 4679348222692656484 9586862851028477356 7769757097371574466 6246277952118747306 14609458117889595689 5954474805034255068 6663983066231440735 3432308638067922570 3665764307728094969 17244913106755092625 2298659615485216680 10941575084493466591 15393937881391909161 16428878122833324063 1772000211656828750 8907268200458195003 11536223775776708581 18156754483476185362 13316964886195759329 10070827824253274773 13413384870198763360 2971625844060924223 2877188381791558173 1891642999110237337 14657780093319255706 7074723191969741090 7436108606626460529 12379821077496801613 3299537253492899268 16565343199377082067 14649872267345372016 11803599021862838796 13889521061796090547 14672892723234734125 5118962590829942261 2853093909580850573 10112440172302558495 5294218480346810045 5899772075380357068 13990151145243508551 14095459209744019505 10766642920961615499 1817840344320861432 13840789954294984770 9917405615725242046 5486245287210217124 7863017365203738016 14757078765483079356 11888302741169285482 17524281625107178976 16566070099812417359 831209931402039121 12493998085980541643 10223755353295242817 6186877751170154755 6974402766858353024 14783571820020823003 2362340018617600987 3819180626186845819 3209826109882754498 176790938773754108 16771211544822256971

[test]
name: shuffle2 double4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_double4_ulong16
arg_out: 0 buffer double16[8] 7344 29260 46304 7344 7344 33921 56726 7344 47083 7344 46304 29260 56726 7344 47083 47083 24120 27455 27455 49884 49884 27455 51713 51713 24120 5631 51713 8579 24120 5472 52209 8579 17166 17095 27418 27830 24134 10209 17166 27830 17095 10209 27830 17095 36226 35746 10209 17095 28405 53072 55093 53072 51695 55093 51695 19542 28405 51695 50990 19542 50268 51695 35010 19542 59919 38016 42878 5162 47812 42878 59919 47812 19546 47812 19546 34219 42878 42878 19546 47812 51949 35012 2179 20508 51949 2179 47553 65214 35012 2179 20508 65214 2179 3825 35012 2179 45939 33339 26959 13404 2893 33339 20399 30285 2893 13404 32039 13404 30285 26959 13404 2893 31285 2827 57954 6540 57954 57954 6540 57954 58814 31285 6540 5476 6540 2827 31285 5476
arg_in:  1 buffer double4[8] 29260 47083 18281 7344 5631 8579 51713 27455 17095 27830 35746 27418 50268 28405 19542 55093 38016 59097 5162 19546 2179 35012 51949 65214 13404 20399 30285 32039 31285 49732 57954 18412
arg_in:  2 buffer double4[8] 33921 56726 58815 46304 52209 24120 5472 49884 24134 17166 36226 10209 50990 51695 35010 53072 42878 59919 34219 47812 40897 20508 47553 3825 33339 2893 45939 26959 58814 6540 5476 2827
arg_in:  3 buffer ulong16[8] 12558172613017197843 9245971224774483656 14415161162641395655 8700596643430804179 1383591137337303139 555600374794650540 8537629705623828373 5810938676358272715 10882159958680046441 8947539508028772563 206770779297110311 10778720996977347688 15938332838567794893 12152270183343382563 13015854762854758297 8041986720362849593 5109032555798565725 7769458130453797771 8624677580304240067 14716637135247644927 9509016433833014351 73487708736415827 9878305200801515954 5396787334860838954 4384167687545676789 14568771154284718320 13365151765270882658 12073748791352308257 12325801600789902869 14709940333959689974 1227220248370002788 9908939727282533617 8822772293994327021 12027274793062377208 5975339473976513315 12911024469701419649 16900008850987467940 1685327919368575471 2457804253801084973 13979150785943932985 9771982501371432944 14376855542165491431 12153553308423726521 17688966041067997048 9911772266049204518 4781480815706861714 427275133320560023 15446923070273422576 7584937353846764417 16011265674537159815 11059105432293822219 9798864786972370927 7796909487718383901 10047996631760600995 10128311091771092461 10631226571242032938 11996558781249071057 17398209019872206333 1640742828553118204 5247685738609669834 8181453848668989800 8014818687481581957 4973119832478536494 9226147158687825834 11712100105248336429 16083382941260092448 12018477225071084356 670102963420260914 14550399116408529391 7691575091907590572 11924758893436964453 12838748057721169815 15226651260630968635 2155676919168417063 2111186400118502659 3002012086207365958 4747259758625787700 4334623377782057956 12447363935625185587 10116243182943620767 8099253163197809762 3848059756273156689 5880185859222234720 641443585565642861 6980198581937336922 16000893389183921320 5532268865806846086 10262186327991977227 5243317513308377305 3940222417045180952 16522226810344877101 12195712618322211035 4883222610280557768 13652967685138814615 4552811693118146417 15822087371885490176 8683177731319570398 10595594042270486004 9729628134607730615 2065708809420374656 3916741028301540021 15291586215736009204 6934374813783846569 7874983803785742826 7281939375071624157 5696294201358351904 10834279842788921883 17137314475909902560 4566589229588895850 6803220788734404671 3796899088830095024 2330353105395056197 7176337548919202096 13960895473249693287 1685479114986252730 6709367568108448109 1401740582764441026 4789170021706178194 17931114541291955301 1474842134644630794 7538910319476076084 11712148094425682688 15603588687580867661 16576676680931712942 11704192358474347389 7440500787375948879 9471473671661902648 15267319485625439534

[test]
name: shuffle2 double8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_double8_ulong2
arg_out: 0 buffer double2[8] 509 10503 55409 56906 40061 49302 19522 27269 37102 39381 54825 44930 22929 2894 49377 560
arg_in:  1 buffer double8[8] 27784 43362 11054 10995 48060 43079 509 49151 56906 54764 23448 17799 64721 14914 39129 31698 17381 55198 48358 61441 36922 13046 39213 55720 23830 39195 42076 31375 31199 42782 27269 37897 13696 39381 42804 32231 53529 8742 40000 42793 39218 54825 44945 9647 12468 23153 45721 52539 24100 39368 38124 36416 49103 31863 10545 37550 25879 1655 50961 11000 44542 26003 560 37040
arg_in:  2 buffer double8[8] 10503 23031 43007 60515 43417 25163 61869 8159 26395 58538 52258 32420 54839 21425 55409 49369 12873 49302 63986 8158 40061 1571 53587 30795 58827 19483 19756 11623 13562 65284 32256 19522 54958 55858 37102 21799 17682 41818 34198 57783 11375 41855 59092 33374 136 16398 1733 44930 30091 45689 58637 22929 2894 52226 13261 23646 49377 60823 61109 39515 37597 14241 7593 49986
arg_in:  3 buffer ulong2[8] 12657031044594449942 17816376689487372472 1150076632437431774 14530376946649600016 965055800663362300 13133733190750948281 1550394798234802591 7476846195667091238 15110918813082765434 12283303837574761633 7874842203015988561 16250009351028121375 597623939021381051 1799051422961637452 9842275313769067784 12262400220189601094

[test]
name: shuffle2 double8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_double8_ulong4
arg_out: 0 buffer double4[8] 22783 1015 48423 21171 644 8258 40181 226 64615 26362 6751 16160 54117 42982 2670 42452 33904 28836 5954 54941 56233 60706 46001 13648 58909 13220 28801 65394 8534 34138 13024 6692
arg_in:  1 buffer double8[8] 6900 19940 48423 33956 21171 52240 7178 22783 26872 48230 644 44224 42001 8258 36581 26914 65079 6751 28211 64615 33173 9537 18528 22116 13687 2670 28010 55313 24974 56110 34165 42982 28836 29639 24343 5954 36442 50242 35937 50364 60706 59531 36048 46001 13648 19907 19235 25909 51124 43287 3404 13220 55539 58909 43732 63699 36279 34138 44148 19797 13024 42448 45708 8534
arg_in:  2 buffer double8[8] 32739 1015 6075 36288 23686 64137 53131 37772 40181 226 23805 50917 17884 57869 28725 59521 16160 29185 19774 26362 18391 14868 6762 31381 42452 54183 45450 54117 61802 61451 57215 59077 11472 9955 572 60623 54941 14487 40934 33904 62761 12520 8843 56233 40922 60569 48306 14178 5072 28801 31438 58471 14676 65394 63080 29116 9492 6525 5460 6692 10088 55849 57515 11194
arg_in:  3 buffer ulong4[8] 5950606252743128631 17273279686392426009 13302380590116047490 1853058328641967892 6915542308428500754 3142098898154913029 743839566283681832 17158209586627303705 11661278412434651411 3529898088497728107 15178054133188817201 11463263325848583976 4025715950636142619 17983587853020952935 7642490055307400913 13500286259995741592 613792147172614943 1143820722395192144 11042848087833815075 3592665691866392508 1841446078138692027 9055217491978167648 230064399300575395 10230729649805092692 12238980007901774485 1342679847772047283 12568962613620026361 484506910386021517 15686677694446271959 5834396902565601905 11621322199254983076 6367646271901930875

[test]
name: shuffle2 double8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_double8_ulong8
arg_out: 0 buffer double8[8] 52982 241 59557 12360 4675 13102 53146 241 25802 63435 42141 22861 16974 22861 23605 10497 14008 55315 31466 14008 15616 14655 15616 31466 14880 21040 14880 49469 60561 14880 29578 59596 3628 21356 22602 9928 28101 59819 20038 18099 22523 60604 22523 33141 40976 23192 53154 53154 27889 11625 61444 33933 33933 62023 18113 38030 21515 62734 12887 12887 4430 21515 54443 44537
arg_in:  1 buffer double8[8] 52982 46178 59557 12360 50786 13102 241 15040 16702 22861 59026 59976 20724 16974 25802 29563 56984 52706 58317 45104 41267 14655 31466 46717 49469 1925 31773 37870 13897 40847 33467 20678 58113 54899 29878 22587 22602 59819 9928 51425 40976 15865 29763 30817 12785 23571 52585 23117 15654 38844 17421 61444 27889 25506 30200 25756 25197 34333 21515 62734 44537 16052 54443 62238
arg_in:  2 buffer double8[8] 53146 3490 50429 54590 4675 3002 63038 56508 42141 62049 49111 40021 10497 23605 10912 63435 14008 36483 55315 61068 15616 23323 43413 14151 50441 40516 14880 21040 29578 59596 60561 4709 9173 28101 62354 3628 18099 38492 20038 21356 46088 33141 16619 53154 60604 23192 15071 22523 49748 38030 9429 33933 11625 28493 18113 62023 51014 16627 54012 44755 65076 4430 12887 49864
arg_in:  3 buffer ulong8[8] 17902179138914110704 2228161362933212182 2581045082332311778 3267989484712216883 3995761618049163004 13566878336204162053 2006701188727690744 61070879353065334 2791028201904031990 7775522943649081855 8440590131570510472 9228163766798418705 16675517079595436965 18188161778225474353 2656431660780552541 976757074944433516 11119708229083113352 6984663091458000186 16882515911012860614 10284362960577903688 13110581522268206492 3328182607537174165 4859094225134980460 2924234191139845958 17826091395849605242 5216128096825661163 4994119148359286250 245588024225781136 17485459402148224702 6341819440032791546 16662698515019825484 12856962981732410365 17042498302765144747 18194676202098562335 14931111718577649636 9191816716318447238 11738820602370768297 5987290179825922453 10655413551590375630 10177117596875888108 9095608675516354399 10320828275304266828 7061609702752480895 10781920866818789481 17084391135266200592 10680604838124009917 15444716651923541947 11354385977933982811 13703961265882639876 930099867704800316 2935217479072889539 8666280439108576299 7153967276241989995 15619387425786887343 8910126804885615278 4433172669691987481 8058303777067877234 11921657197624601859 3131826272050155038 12890301649539599262 9913202312055491389 8119900579865487906 11683854131524886918 11232438531217389428

[test]
name: shuffle2 double8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_double8_ulong16
arg_out: 0 buffer double16[8] 14429 61209 43286 61209 16700 11380 20076 11283 38061 43286 38061 58828 17720 47174 46672 58828 13627 17544 20234 2725 17544 45271 58830 17544 59603 52889 17544 59603 2725 20234 56047 45271 55071 29716 22492 40357 55071 22492 34047 43709 40393 29716 12145 40393 20313 47034 40393 55071 23119 25727 51036 1164 1164 23119 28661 37 45525 21173 18537 23119 33290 37 28661 23119 40851 40851 63718 40054 42192 742 13695 38872 58621 61488 48507 64132 20695 42192 61488 61488 32108 22725 13066 22837 44284 44284 11396 64705 44284 21724 23884 54197 64705 32108 11396 23884 1022 60967 20263 55060 63230 37388 24763 46261 37388 23710 23494 39823 16562 63230 20263 63118 3804 18538 14180 13143 9121 13143 35610 63006 8469 5448 40787 64028 17360 63006 3804 5062
arg_in:  1 buffer double8[8] 17720 11380 50618 20076 43286 61209 60921 47174 58830 29362 36758 25646 59603 15049 20234 13627 62137 12145 43709 47034 34047 55071 35961 31237 37 21173 20626 27105 1456 25727 45525 56040 1577 20695 61488 742 48507 64132 40851 13695 22725 44284 11396 21724 22837 52004 35553 35482 11125 37388 20263 39823 24763 41593 23494 55060 3804 5062 17360 35610 18538 14180 13143 58084
arg_in:  2 buffer double8[8] 46672 14429 38061 46777 49335 16700 11283 58828 38759 17544 45271 13820 52889 56047 40555 2725 20313 45517 40393 29716 22492 41806 40357 65359 41167 18537 1164 33290 28661 51036 23119 49863 40054 63718 47708 22804 42192 38872 27262 58621 24799 20030 23884 64705 32108 54197 13066 33961 1022 23710 63230 16562 63118 46261 50530 60967 40787 64028 63006 64194 8469 33430 5448 9121
arg_in:  3 buffer ulong16[8] 13622524252965228521 1648056543701413509 11959923612066399124 11164710521582898469 10782375865464991853 1049035019664953009 10400159492039974963 4851469383400051102 4900794983699696906 2534225937037614372 5113389090285348442 8174457547421990623 12239422087086332128 16481131172675823175 1106416174460519848 17389994430186280447 3905466066932853367 11550492012556626249 14023321487640352598 5772578146024086623 17860459495420388409 17679001200083246746 15386255700178781152 1683919282045072489 10241968626024930916 2482042006926389372 10919515522944338249 10655904461544677876 14555151506240187007 6700585297158407910 13996979714088972701 10806902765502736474 13809738691064079493 1252677821586715403 888662246263455196 14272814055249300126 14440376794056899557 12033734630115858268 1987090423915119604 9332877128729559538 15361314642324359258 3827321922385316187 5009256063598652673 13809182163058869802 1224321765146765816 13517256462571561059 4200890795992708650 8610989237122905989 8486848632184798574 11105639526122346421 3741964069331011565 12707187876725217386 16639268047244533066 6646843034006223102 8882924243499958252 2386200401231571216 9163860924778371094 8000973153391568689 1829968663229999817 17804634420414422494 5582528676721052843 2971084813823828832 14046298713011595644 7437249161537703966 653492260407617574 17631038261553249302 2655810497313641209 7598296793244851000 11764946437136895484 6937629621522291827 13417376642970687511 3231998564265874957 2145941325217640959 7048022258418572530 4428214163450396068 13763643718579996453 2746075988423293377 12236621550074046732 3903764044350916530 3905133567292487586 12420660914587353180 15133524873889710000 6777420329393846414 14205344252876024260 2787746341085596161 3004001911917767473 15987321574419671474 6829673830724788507 18364582082353302097 7088248219227069747 11337565753352925498 5337957101456027021 16199410529313467195 8285143032857457180 13197975372419496130 6020270045172542570 12752633054481264536 13922081755737343695 9281934889234838450 6680175973465469751 15895903665154570426 16988250631361178497 6278851527166923796 9097454529479504717 1856021963149597777 9832681514069558681 18081320497993442262 5683859460320421507 13978204174002190747 2676952364787022234 13284849151822095746 6112360405904758716 3452807552154325184 10223929562720548884 3958715959556048325 4277589437457953446 6159254384958358671 16906638653383923542 852101088938311715 12552106169516207274 3507775265987698444 17996004880026375486 461086323349891464 11608215593458384601 797532264241059458 8867191426876242170 10787806497820513424 10680839079710620017

[test]
name: shuffle2 double16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle2_double16_ulong2
arg_out: 0 buffer double2[8] 9642 51185 31362 25237 26878 28993 19726 39652 60601 603 58846 15438 459 28322 44381 49070
arg_in:  1 buffer double16[8] 28930 5438 42651 51185 36615 40499 19845 29054 40278 26660 39101 38429 55331 43553 56340 59292 33423 15850 58520 56261 61843 61305 10399 62657 34131 63216 4403 63770 30299 37073 46547 29692 5369 1384 15101 51420 23331 51158 19453 3315 35764 51588 5915 45768 5403 62595 28993 26105 41405 38445 25687 29096 20739 53950 58532 46959 24369 21800 19726 50824 16514 14836 1170 46600 48890 13855 18493 58586 16194 36782 14567 31631 10230 30600 603 60601 2038 22120 6612 8428 15276 29062 40785 28328 49268 58846 52414 20060 33724 19103 30916 24373 3211 14646 15233 25275 55927 52777 39264 18449 28322 44509 44873 51257 459 49489 39527 64867 12892 57584 15617 58449 53581 62721 572 26626 27231 57252 21248 38847 49070 1770 63059 47289 19245 57082 6759 8064
arg_in:  2 buffer double16[8] 16952 43005 44523 37874 32931 10983 45731 37458 6024 39494 16603 9642 59732 8450 46336 5502 26833 5847 13405 13806 47876 2616 34730 6121 31362 37120 61689 25237 65356 26261 10521 56303 25314 26878 17977 47253 33141 62283 59162 21687 29399 50093 4405 12197 43351 28497 37355 20042 12719 56928 39652 19169 28355 20563 13684 1239 2539 410 34242 22325 64078 4402 3563 41710 60056 40101 45578 32493 9366 16076 34161 38145 24769 33151 49260 19139 1773 14317 33207 18164 52454 42224 26576 48049 18441 16047 46945 29414 40345 1286 31369 54440 15438 56345 4044 51423 22493 57376 26158 55197 27693 10840 6261 35711 39778 43155 50871 10456 21734 15588 31081 41201 23972 44381 54785 32411 20139 32283 4753 11662 62605 16789 53151 56430 5595 15106 21404 27411
arg_in:  3 buffer ulong2[8] 5784470970671157979 838639428554805379 16851481745088577400 3470587268543812379 3241482667708303729 11281289232530316814 627715388161491466 18426869002085054098 6600072452856033355 16746431756220360746 14944387024396284933 5363132850627074076 1165404448675325704 14608156225028630724 2698109503441920337 13286532850792130440

[test]
name: shuffle2 double16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle2_double16_ulong4
arg_out: 0 buffer double4[8] 24423 43296 64492 3644 9796 57428 51393 15145 32902 15750 30459 60674 43895 8128 10984 43895 28048 15293 12245 50191 60939 6815 18911 60939 6189 6797 51889 20426 50640 5342 2308 44191
arg_in:  1 buffer double16[8] 28573 29477 34198 51700 46466 51297 36410 23809 43296 59404 4803 56709 46711 54761 34629 58622 25971 60332 55628 62002 18615 1932 31097 17385 18335 24582 9796 57428 41524 8083 59052 51393 43298 11434 30459 32902 10995 60674 18044 55708 19021 62179 4009 29780 52880 43780 29353 45172 34165 30834 43717 34901 48359 10906 65480 8128 24399 33602 42427 23040 38923 48422 59050 31532 28048 4861 51198 24980 51700 45190 19321 20492 14268 29218 34722 21032 15423 11789 53583 44327 13157 53034 11005 22552 60939 21706 31507 18911 53022 55457 47010 23634 6815 19081 24454 14178 10088 31023 45804 64400 35758 12301 51889 63235 31005 20426 22575 33555 44968 6797 28669 38223 56772 1608 24806 47107 2371 59532 50640 36821 58450 2308 26053 53026 59996 14976 24426 24542
arg_in:  2 buffer double16[8] 59052 9480 64450 64273 40270 64492 39429 24035 10173 6798 29800 3644 50941 24423 3412 4021 59450 15145 27170 61427 55613 21869 49987 53571 25184 36979 54587 16255 5522 15430 4020 46722 62417 15750 63039 7820 28036 35557 54376 37772 25920 21293 59527 62131 41933 57735 45802 64395 21116 32192 46630 1850 8783 273 63600 53238 10984 9469 53142 2725 59486 43895 36248 27777 58688 15293 19342 57262 1555 59670 3824 12357 38169 8471 50191 28241 38520 12245 41158 10169 28561 38379 14951 60133 21238 1498 25071 43850 46527 25505 64408 24431 40003 47429 64959 43820 57245 6468 65213 26286 47181 49229 49023 38496 42977 43220 33277 6189 50397 57469 63347 50104 265 44191 61739 27918 22360 29288 54032 56655 28888 5342 6081 54615 61866 37725 63068 2618
arg_in:  3 buffer ulong4[8] 17807718664179769821 3216586574011930728 10905501995728864885 4046327393671903451 11239965358430506026 8120430061579435019 10182693074961311535 667452857244188145 2312237734207490339 2596652561083095185 2183948293117305122 15103021353090972805 6067604536053624925 2297359150154721479 14808171974116903224 9918551540550751165 2296930269304300448 11697128298173774961 4460991406780438589 10058461706998075162 5146583847279776164 87138119950393292 17600414624989088551 14715995166914774244 8379219083234742011 9497012752131130797 10029457105305086982 1554967935756008521 6747825560244044358 4945368466691937369 2654572182441460617 12224002853885922065

[test]
name: shuffle2 double16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle2_double16_ulong8
arg_out: 0 buffer double8[8] 1010 14367 12308 51802 64846 62598 3925 4301 47656 25884 39452 36784 24507 51417 6124 18376 3793 50679 9742 27296 20314 8018 27296 35628 51376 1574 41650 40434 58380 58380 55548 58380 13849 28500 65249 25726 17812 4814 25726 36384 39128 17410 54991 19716 30211 39979 30211 65051 56247 28298 6388 8482 48946 52483 8296 37779 27633 50705 62352 14188 5459 14188 35832 35832
arg_in:  1 buffer double16[8] 4301 2756 22691 12637 59734 51782 57478 52770 39721 2625 8027 2633 22110 30336 61265 3925 14116 14189 55773 34942 19396 11332 47656 57464 36784 5092 5110 17312 59193 17982 5253 25884 58293 49001 46818 9764 41606 25359 34846 10661 1033 35653 3542 62376 21552 3793 2844 3103 38583 51376 41741 23060 7569 46192 46543 10723 55548 26806 39811 40434 56794 33770 32195 55398 27987 48336 51304 49686 17608 63406 24039 1965 23731 14075 64145 17812 61302 15057 40616 28500 34861 65051 39128 3998 48341 16047 39979 543 47545 6967 19716 24705 42639 45389 37579 16353 18595 40715 8296 39419 10151 48946 28298 39861 8482 52483 37779 43133 46009 63368 50817 50686 63695 56351 55141 27230 54223 20897 36214 29327 29340 54750 4495 60737 30611 16080 14188 36148
arg_in:  2 buffer double16[8] 48373 45841 14520 56609 1010 5313 64846 22343 62598 63184 14486 51802 12308 11594 55666 14367 37050 7370 18376 51417 6124 31430 13976 39452 63841 30957 27021 21061 31795 41842 40481 24507 30438 5459 9742 49158 39647 3534 20314 27296 8018 50679 36549 40071 63001 2619 35628 39541 58380 1574 346 34680 39303 24690 17479 20785 34038 47663 24433 53138 7901 41650 39498 31912 13849 9897 57658 5236 4814 27786 65249 15994 63658 25726 15879 26411 9128 36384 49963 59060 29352 58487 62671 13961 54991 29081 50704 28704 26894 30211 7389 17410 18599 12491 36264 62569 20999 44898 6388 48622 50745 36215 47463 20015 29447 41850 38240 46006 5738 56247 33338 16972 22931 50705 62352 23957 35832 33297 55964 30023 58400 5459 43086 27633 57088 383 36692 62542
arg_in:  3 buffer ulong8[8] 11868040156120972532 1424937994907491775 15059806072066099420 4561238363709873371 16254427491697203670 7945586290541717496 1466072287926964879 15568827579247358528 13497739290627380614 8287915946338857167 4696776939240884919 8240942259810024040 7119524856389016191 13073844115509546899 1450955814170965972 14589241133434438482 15983694149972222797 3073826470198872249 10924200443015771250 12532445814595254615 9585299044793863286 13677586776511368536 17525611122700300727 6853926916944799998 1571149067809878049 9885710182876887825 2127220169283691869 6847376370547760715 7164844782835309680 2589612830346282768 11900846354587916936 12953631961144926512 16258440159835330608 10072536387734204271 14876567122323106230 4256880497821353977 17705225273491506507 2610411325615719348 13526355544552501081 5431922752227199133 17737233750935903426 808211579795087931 1075284206465268948 1048225816237591818 9314132450313944601 9914691711544202406 2501642839305739641 2168504804975870465 9404574153703912797 4688124919410619686 11712919535770323506 2089713219730302888 4899210573990368645 13209286633022727881 682666433243059426 11127503457273517770 1936828386750830779 12684287202817245329 2568059243983383026 4242076804148449230 165049223065432377 15895364589647668558 15617350188886226196 17365388851001249332

[test]
name: shuffle2 double16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle2_double16_ulong16
arg_out: 0 buffer double16[8] 26696 42715 49258 47036 51754 38666 48540 45875 45875 46849 38666 1516 46849 22761 33724 48540 56947 56947 27399 59460 21706 58430 19243 56947 39868 9176 5058 18152 31287 20123 15183 8909 27425 3117 65486 30413 15861 18418 27425 33493 39225 45455 3117 18418 30413 15861 57766 47875 33618 52344 21746 49383 49383 30497 30722 14875 49383 59321 14702 52344 38579 57920 30722 42381 52861 29263 62434 59029 36014 29435 23202 28840 51874 41724 29435 4178 51874 7384 51602 51602 5430 34457 47551 33131 43985 47551 24164 18509 38081 59760 19480 64671 24164 19480 33131 13952 63235 61602 38262 31201 61650 40593 36550 61602 61650 54587 62738 42559 61650 1948 61602 48406 27775 2023 11982 24590 37973 36143 11982 13286 32871 36272 24590 61322 27440 13286 12961 6824
arg_in:  1 buffer double16[8] 1516 47036 18746 42715 48540 24079 65494 9769 61457 17496 49258 29444 6290 45875 10068 22761 53181 2868 15632 21293 21706 64543 25403 27399 58884 16955 19243 5058 15183 56947 58430 1855 22575 65486 25962 33493 35972 13719 47875 52128 1341 8455 45455 33016 27425 18418 1960 56437 30497 512 64999 955 26603 36274 49383 46469 35266 24881 39148 59321 9501 18356 62163 30722 24842 31401 41724 13722 29435 23215 49232 52861 65101 51874 29465 51257 29263 36564 7384 14448 5430 21661 64671 24164 40254 57841 47910 21903 59522 33131 43985 60528 59760 18509 6888 43511 39600 1243 38262 62738 61602 47171 48406 40918 48769 56624 34177 36550 15151 43776 36509 48449 36143 27775 47224 24590 2023 61322 13286 51093 29562 60822 12961 27801 6824 36272 38934 50270
arg_in:  2 buffer double16[8] 5836 35464 29556 58941 19060 64889 46849 29238 26696 29052 46480 46603 51754 38666 33724 49808 20123 18152 31287 38226 52131 59460 42042 17395 16847 39868 8269 48891 9176 8909 5839 61878 30905 62816 3400 3117 31956 8340 15861 2839 1274 3392 43368 57766 30413 39225 6024 39843 57920 53956 33618 45544 42381 21746 52344 34609 27625 14702 48515 34274 14875 60495 23696 38579 16388 4178 51602 40007 28869 36014 28840 31999 15311 23202 3932 50921 59029 62434 60651 16612 3091 38081 13952 18851 34457 24681 1706 6484 57771 10526 12213 61780 14082 47551 19480 50542 40593 10244 65053 31201 1948 37906 11733 63235 61650 19600 23603 18704 30396 54587 39595 42559 6392 45771 21286 61845 12466 32871 39686 7691 1908 27440 63068 37973 41794 28648 11982 2235
arg_in:  3 buffer ulong16[8] 4289755950144499704 16641039276122902403 928112664322033034 3167072153013935201 17636132851261050396 1775728506031333245 10477917066629524068 11553387108034341645 3152769413757569325 14086913246139900566 2381594300532078109 8000083234438786752 7579181314297523510 7923183418591562799 1257148254130354878 3216636763868016004 11581105179988347405 9974135131091176877 1618562740865362887 14497052720332591221 15483088521014028420 12775632658118662830 12424245435063469738 13496833944653818637 8311524380326609849 350320726659495132 1075303727556152683 5528138872002252689 2365123961824100082 15827348357346850800 10886761007005493164 8072456802809982653 1800850989998869484 8953179638373778003 551720081007044673 10695859741454034140 16610089403755973078 6228658641937270253 4629981284947500332 3197550971545581571 10041208684456404861 8255868246297402090 5776719063382379251 3315963300534682861 2861118003492608572 14892938794320590262 7540507115282886523 8026639516145907142 1431314706167296146 8816589483627315254 14852612312266624149 17618129014815404038 17698000771747276454 12725812831057482624 15286269053346798479 2824169058340223740 16776205977595208902 17012541220892426059 9933252255591507321 10761240569694664566 4465981817851957343 1645713990991889744 4349270622726625263 3367128486601011508 6220880573086437383 6353630535059873004 15968167853868807229 13979460479881429276 12125086273622813749 14286702339032410276 10996996761923899641 9098486431331379638 6550035749518577225 17461502759674022210 7616875688302721252 4538632191326849457 3410171145708245993 13827974058384179790 2168413845998750290 2220413397276509266 3682648441681233280 5309221754048306516 15794227015825234109 15237199001454100361 17259055919058901770 129457788089171933 18133451454294613059 13455357981379256013 11811799469483053489 8173580958882121260 11645577501595819806 11094022228700985698 18042912001770852707 4348522256487582174 12997027417095065897 15202694537403970642 999629618613697623 17079266711671045348 9387290025703143490 7444596490014609587 10169758553940340984 17660667832149330224 5644670539595840491 5732196794672103716 7260616226820556760 1899365279991915421 18380767959901065027 5934084904659155711 9881254950683563608 14255485938040324884 6880525729002566788 16954767178344689542 16344608365460928737 18181196063367254660 7018688164380043998 9492103349044211651 13603860246729996091 10544578831686412800 6967928851541273630 784804812532492870 13962496833012557173 9654136041809877869 10335322995832674115 4002776946523024805 8046223327256839033 16478993309843154086 11093746639238421706 6397860196342561772
!*/
#pragma OPENCL EXTENSION cl_khr_fp64: enable

kernel void test_shuffle2_double2_ulong2(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double2_ulong4(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double2_ulong8(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double2_ulong16(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double4_ulong2(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double4_ulong4(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double4_ulong8(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double4_ulong16(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double8_ulong2(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double8_ulong4(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double8_ulong8(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double8_ulong16(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double16_ulong2(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double16_ulong4(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double16_ulong8(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_double16_ulong16(global double* out, global double* in1, global double* in2, global ulong* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
