/*!
[config]
name: shuffle2 char uchar
dimensions: 1

[test]
name: shuffle2 char2 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_char2_uchar2
arg_out: 0 buffer char2[8] 50494 50494 5306 9665 63691 61884 39755 62468 28631 41444 18254 36941 34143 12429 12225 1840
arg_in:  1 buffer char2[8] 50494 55125 5306 33936 63691 53075 39755 62468 46930 28631 18254 36941 18316 12429 32834 19262
arg_in:  2 buffer char2[8] 40651 12945 9665 43279 61884 13199 46372 56907 41444 26801 62522 58024 34143 8163 1840 12225
arg_in:  3 buffer uchar2[8] 204 0 252 170 124 166 32 97 113 122 72 229 46 41 163 250

[test]
name: shuffle2 char2 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_char2_uchar4
arg_out: 0 buffer char4[8] 14294 4321 4321 4321 9055 16359 9055 16359 43614 43614 11773 17068 37703 19601 5064 19601 10518 51287 51287 10518 41555 30867 31733 31733 54974 38054 24100 38054 36072 24475 59056 36072
arg_in:  1 buffer char2[8] 14294 39511 38153 16359 43614 26634 37703 58325 12010 50449 41555 31733 38054 24100 24823 24475
arg_in:  2 buffer char2[8] 4321 34086 62459 9055 11773 17068 19601 5064 10518 51287 36127 30867 28206 54974 36072 59056
arg_in:  3 buffer uchar4[8] 252 182 42 166 59 249 171 97 124 8 138 59 112 190 87 170 218 31 51 74 112 23 37 13 63 96 61 200 46 189 59 18

[test]
name: shuffle2 char2 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_char2_uchar8
arg_out: 0 buffer char8[8] 23634 2835 2835 57156 25505 57156 25505 25505 61227 8000 8000 24244 8000 8000 8000 24244 13227 13227 13227 27600 5161 5161 62814 13227 26129 26129 51285 51285 8006 2986 8006 51285 46996 13303 34096 34096 13303 13303 55786 55786 9175 61632 22206 34068 34068 34068 34068 34068 28944 9433 28944 7608 9433 26661 7608 7608 45913 39460 39460 20736 20736 21227 45913 45913
arg_in:  1 buffer char2[8] 2835 25505 24244 16239 62814 27600 8006 2986 55786 13303 34068 9175 28944 9433 39460 45913
arg_in:  2 buffer char2[8] 57156 23634 8000 61227 5161 13227 51285 26129 34096 46996 61632 22206 26661 7608 20736 21227
arg_in:  3 buffer uchar8[8] 175 128 60 226 89 6 241 209 159 182 198 128 78 6 234 40 171 23 143 69 122 246 180 147 183 67 158 198 212 41 0 98 171 81 122 114 229 193 212 16 205 214 23 84 228 32 132 80 228 249 0 19 253 166 159 239 25 212 96 42 66 7 205 213

[test]
name: shuffle2 char2 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_char2_uchar16
arg_out: 0 buffer char16[8] 36007 444 444 2863 2863 2863 36007 2863 41441 444 41441 2863 444 2863 2863 41441 27987 15175 1873 59372 1873 59372 15175 27987 27987 27987 59372 59372 59372 59372 27987 59372 309 12816 17487 309 33618 33618 309 12816 309 17487 33618 33618 33618 309 17487 17487 15584 15087 45488 45488 15087 45488 15087 15087 15584 24963 24963 15584 15087 15584 15584 15087 39638 26019 20242 39638 26019 39638 20242 36491 26019 20242 26019 26019 39638 39638 26019 20242 5544 2434 36697 2434 5544 5544 36697 2434 5544 5544 2434 23884 2434 2434 23884 23884 5329 62338 62338 62338 62338 62338 26966 26966 13130 62338 62338 26966 26966 26966 13130 13130 34035 34035 51995 34035 41250 41250 41250 34035 34035 51995 10662 41250 51995 10662 41250 34035
arg_in:  1 buffer char2[8] 41441 444 27987 1873 309 12816 24963 15584 26019 39638 36697 23884 13130 62338 51995 10662
arg_in:  2 buffer char2[8] 2863 36007 59372 15175 33618 17487 45488 15087 20242 36491 2434 5544 5329 26966 34035 41250
arg_in:  3 buffer uchar16[8] 187 21 253 234 222 190 91 106 192 149 4 70 77 138 170 172 188 47 173 18 21 138 83 76 148 184 202 66 150 58 244 122 24 157 91 36 154 206 168 153 212 55 50 246 242 172 175 63 245 59 254 218 19 154 171 79 85 192 44 33 43 101 113 31 197 4 50 201 148 229 250 111 216 42 188 112 133 85 220 98 183 58 32 14 231 103 60 254 203 131 106 21 110 74 53 101 234 193 185 77 53 249 75 207 216 253 165 255 255 103 112 4 174 162 164 18 75 131 79 194 150 240 33 43 20 33 115 66

[test]
name: shuffle2 char4 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_char4_uchar2
arg_out: 0 buffer char2[8] 50289 58797 43331 43781 18468 4709 46238 46238 63204 61116 13301 13301 33352 64685 34341 50352
arg_in:  1 buffer char4[8] 5325 39380 2003 58797 43331 21061 19506 60389 48669 50099 4406 11881 10008 55884 27014 37966 54767 63204 50930 30614 2684 31 23851 39641 33352 43605 8601 64685 34341 39689 53486 50352
arg_in:  2 buffer char4[8] 50289 8160 21468 16688 31319 37629 43781 7278 4709 63088 54770 18468 64465 10698 19840 46238 53888 4611 61116 50683 60146 6164 13301 61720 19840 2651 4255 17393 42455 13800 45438 25555
arg_in:  3 buffer uchar2[8] 196 251 56 30 239 172 63 151 65 198 150 62 96 19 200 227

[test]
name: shuffle2 char4 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_char4_uchar4
arg_out: 0 buffer char4[8] 59699 10294 59699 24966 63722 5240 15909 3850 1306 23318 3493 45278 47946 12252 12252 14869 19095 55319 55832 27260 54478 48382 38438 48382 24509 59512 58552 4024 54659 33845 62481 65093
arg_in:  1 buffer char4[8] 48703 24966 59699 46734 9874 5851 5240 63722 33473 3493 28308 30101 12252 55064 40017 14869 19095 55832 55319 11014 13731 54478 8247 13003 54416 20467 4024 58552 56503 54659 3949 65093
arg_in:  2 buffer char4[8] 42532 33106 10294 46203 9218 15909 47088 3850 45278 45597 23318 1306 30211 47946 9242 18781 27260 423 26842 16146 941 38438 48382 3230 30521 18597 24509 59512 14731 62481 45147 33845
arg_in:  3 buffer uchar4[8] 66 14 106 185 171 242 149 151 167 94 41 52 157 80 192 75 64 114 161 124 121 94 149 190 214 23 67 10 201 39 37 67

[test]
name: shuffle2 char4 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_char4_uchar8
arg_out: 0 buffer char8[8] 55080 18649 18649 54624 18649 56585 39241 22903 39063 44615 11082 46473 44615 46578 44615 46578 11337 38630 7583 48399 11337 11337 32513 11337 54686 58862 1104 60556 60556 58862 1104 60556 15002 42030 39473 39132 48705 39132 39473 39473 61720 55601 11934 20476 12131 20476 11934 11934 65231 53124 20169 36303 36303 30456 14700 53124 15837 15837 52268 58479 15837 24298 52268 24298
arg_in:  1 buffer char4[8] 55080 39241 54624 18649 55337 39063 46473 11082 32513 58302 48399 7583 49339 53559 1104 54686 42030 57841 26737 48705 38444 61720 11934 24308 14236 36303 14700 20169 58479 52268 24298 55273
arg_in:  2 buffer char4[8] 56585 22903 32500 59434 44615 18686 46578 60612 11337 63345 26691 38630 241 58862 60556 1019 28669 39132 15002 39473 20476 55601 61791 12131 65231 30456 53124 36711 2833 15837 35399 5314
arg_in:  3 buffer uchar8[8] 0 131 203 202 227 52 129 181 145 100 43 18 36 134 156 174 60 127 83 34 212 148 144 68 107 53 210 206 142 149 226 190 70 80 63 61 195 205 239 71 153 181 242 212 111 244 250 162 252 30 227 153 73 253 26 110 13 181 241 200 5 34 41 202

[test]
name: shuffle2 char4 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_char4_uchar16
arg_out: 0 buffer char16[8] 5397 15224 15224 47353 51057 15224 57576 841 15224 47353 15224 47353 841 5397 28856 51057 29712 29712 6526 35432 50901 38342 50901 50901 35432 26773 35432 29712 35432 490 4361 490 25061 47659 30674 25061 24478 18439 25061 24478 30674 11096 30674 13822 11096 18439 18439 13822 7469 50348 60410 7469 50348 60410 50348 43279 30548 50348 22724 60410 38997 43279 60410 7469 11354 53927 55274 22053 43344 46277 11354 57051 46277 46277 55274 53927 53927 55274 11354 37280 41428 56440 19401 60069 19333 19401 60069 59585 59585 58627 41428 41428 58627 56440 60069 41428 64251 28235 33390 16937 27376 24487 27376 33390 28235 28235 28235 33390 24487 28235 62344 28235 5741 64481 44196 56005 56005 5741 56005 5741 34848 50970 5535 34848 45766 64481 5741 44196
arg_in:  1 buffer char4[8] 841 47353 5397 15224 490 35432 38342 29712 18439 37738 25061 13822 56887 60410 43279 50348 22053 43344 55274 57051 19401 58627 19333 41428 16937 27376 24487 58212 45766 50970 56005 64481
arg_in:  2 buffer char4[8] 51057 28856 25715 57576 26773 6526 50901 4361 30674 11096 24478 47659 7469 22724 30548 38997 11354 37280 46277 53927 60069 7070 56440 59585 64251 33390 62344 28235 44196 34848 5535 5741
arg_in:  3 buffer uchar16[8] 26 83 179 1 148 3 71 32 219 113 203 113 232 98 173 52 43 163 165 233 166 130 14 22 97 188 41 107 177 96 103 128 154 159 196 130 246 176 122 22 156 37 4 235 253 224 24 211 252 235 225 60 43 41 123 50 78 211 109 225 39 218 201 20 92 127 250 112 65 142 180 163 222 54 146 103 151 226 236 133 139 118 8 60 50 88 212 127 111 145 3 219 25 62 196 139 60 183 117 144 113 122 33 157 167 119 191 245 146 87 70 7 167 187 12 66 202 79 90 39 69 105 254 109 120 67 119 196

[test]
name: shuffle2 char8 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_char8_uchar2
arg_out: 0 buffer char2[8] 34569 53599 63034 40461 22130 22061 19670 49350 46708 2225 40732 44255 55397 34399 37981 57044
arg_in:  1 buffer char8[8] 46329 17372 65334 14157 3409 47004 64120 59716 40461 1656 28845 21369 64841 63034 41149 10324 33968 18015 52671 25043 41473 38237 50343 7756 27349 5018 41308 32716 44979 57828 29611 34092 45111 21277 39964 2225 46708 7626 19820 46323 2881 64370 8037 3219 31649 5893 1630 29592 42817 8722 8179 45210 55397 17806 28380 58846 57044 18619 46928 40888 23191 43098 53560 50157
arg_in:  2 buffer char8[8] 1262 53645 34569 60640 5497 16068 53599 51157 22454 407 18117 19420 10439 43260 31113 23104 32347 2880 22130 22061 10287 55990 13586 59966 19670 5249 33092 44597 49350 3573 4760 65056 11746 46971 38369 19766 60046 30952 46636 21270 53046 44255 35368 64528 51457 1937 40732 37778 61461 4578 34399 5020 59758 51781 15730 52924 45428 65012 6704 2711 35789 4492 33281 37981
arg_in:  3 buffer uchar2[8] 106 174 197 128 106 59 168 124 180 83 78 169 4 26 79 176

[test]
name: shuffle2 char8 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_char8_uchar4
arg_out: 0 buffer char4[8] 21559 24678 24678 22286 62968 44740 62968 18449 36530 32841 5035 22784 52178 56968 16621 14424 36757 44861 33841 5450 5651 5651 20359 5651 65141 25494 40120 18629 45180 35975 16434 58743
arg_in:  1 buffer char8[8] 47604 38166 38459 42336 64862 52908 56492 22286 132 18449 5714 57919 16495 44740 1221 62968 33764 24596 9207 55558 36530 22784 22263 8295 20630 14424 50423 56968 34833 40815 37350 1787 56191 36757 33841 41671 44861 24902 56583 18573 776 20359 50350 47309 60834 4766 53954 29924 2056 47477 20777 25494 46461 65141 2508 32662 31729 35975 24266 55047 10213 58743 31029 58937
arg_in:  2 buffer char8[8] 13162 24678 21559 57736 8549 55934 51739 35632 33120 57306 46683 42960 11878 40241 3949 64555 1437 32841 26579 52153 50675 57096 51021 5035 60989 46475 16621 36483 43006 3185 52178 62092 17739 5450 10680 45538 47319 588 9092 25005 14524 61748 5651 41226 3327 41261 51465 16419 36055 53269 18629 19331 52979 40120 7844 21353 16434 17557 63031 6122 5697 50759 23621 45180
arg_in:  3 buffer uchar4[8] 42 41 89 135 103 133 167 129 132 233 79 229 78 19 90 17 161 36 98 233 122 234 81 170 69 243 29 42 175 1 40 53

[test]
name: shuffle2 char8 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_char8_uchar8
arg_out: 0 buffer char8[8] 46179 44014 44014 4823 4823 15577 95 44014 2978 3125 63296 31795 23933 22887 3125 2516 6846 5789 46908 5789 29678 5789 22284 10147 21446 18087 40598 60673 47616 57764 59459 50660 59471 59471 4022 4022 738 19513 23680 738 1788 3432 14667 2796 45978 6187 52922 1788 65015 6779 6779 18065 59831 65015 57181 42310 53445 12545 46995 43727 9574 61785 46995 32197
arg_in:  1 buffer char8[8] 56063 46179 59189 44014 49553 47455 15577 17840 41535 2978 23933 16397 2516 44287 25341 5785 54242 8131 40796 51054 6846 22041 46908 10147 53507 7078 57764 46527 33531 40598 59459 54031 23680 4022 59471 34622 24968 50811 8400 46872 12622 16169 3432 45978 2796 23211 52922 1788 42310 59831 65015 62460 10544 6779 52682 34372 3643 12545 10497 43727 46995 12908 61785 4334
arg_in:  2 buffer char8[8] 20220 37628 4823 95 49373 44261 20560 19252 21044 22887 20837 31795 43027 3125 63296 52180 5789 29678 31495 36906 43066 22284 31219 46148 29627 21446 55148 60673 47616 18087 50660 1765 21252 738 51105 22539 19513 2557 3298 42378 484 5004 6187 14667 19358 20073 49790 3465 54884 57181 43636 32500 18065 47713 28398 52479 9574 17012 53445 45952 12655 56562 57152 32197
arg_in:  3 buffer uchar8[8] 241 195 115 202 122 246 203 35 129 141 190 11 242 121 141 20 164 200 54 24 73 200 13 215 201 221 53 235 236 82 86 174 242 210 81 145 57 188 176 73 183 242 27 100 131 90 166 151 194 21 149 220 17 210 137 192 106 177 68 67 56 182 84 15

[test]
name: shuffle2 char8 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_char8_uchar16
arg_out: 0 buffer char16[8] 9983 10200 17598 55761 50884 50884 22181 2774 27273 9983 2774 9983 53086 18127 9983 18127 64624 46789 20049 3895 21557 43847 43847 17767 27192 17767 59706 46789 43847 30552 46789 43847 37753 20751 20751 20751 51654 34310 61954 37753 64261 34774 51654 34774 20751 5125 34310 43488 18827 39643 18950 39643 9023 30116 61770 49301 18950 9023 49301 40008 30116 49619 39643 23726 20186 40128 30100 644 644 14000 53737 62667 12090 51543 63214 14000 644 20186 12807 53254 34954 47115 4721 38888 7432 11190 26859 49264 34954 18490 1374 49264 49264 22103 22103 26859 45518 52999 41727 59326 924 61992 47469 64270 64270 26018 14174 45518 15125 14174 14174 52999 29707 44963 3379 20846 674 10214 53595 53595 65239 21864 10214 35973 3379 63770 31678 44963
arg_in:  1 buffer char8[8] 56436 52218 60754 9983 10200 55761 18127 22181 20049 27192 21557 29917 3895 17767 64624 46789 37753 43931 15529 53591 34310 20751 44888 43488 18950 49301 40008 30741 49619 45419 51152 61770 40128 53752 53254 12807 20186 19352 644 14000 26859 14573 34954 22103 49264 11190 4721 1374 15125 47469 63006 41727 14174 59326 48377 33277 63770 29978 20846 10214 22020 3379 21864 53595
arg_in:  2 buffer char8[8] 27273 57433 53086 34619 2774 17598 50884 22457 57797 7032 49158 11376 53108 43847 30552 59706 5125 62907 13343 35217 64261 51654 61954 34774 23726 30116 47752 20911 39643 18827 59889 9023 8977 62667 51543 53737 12090 34803 63214 30100 14532 38888 18490 47115 12340 18170 7432 17931 26018 924 4333 52999 64270 14030 61992 45518 44963 12783 674 31678 29707 65239 40828 35973
arg_in:  3 buffer uchar16[8] 115 4 253 181 174 46 39 156 216 115 188 195 74 118 147 102 246 183 144 196 66 61 205 181 241 117 191 183 221 142 183 205 144 53 245 149 61 228 78 176 124 95 173 255 117 56 196 199 237 236 112 204 159 249 119 161 0 47 241 162 201 116 220 24 20 208 47 134 102 167 91 57 92 186 14 119 22 4 195 2 66 59 102 41 238 101 0 212 34 90 119 116 212 195 243 0 223 107 195 21 137 14 177 188 172 232 68 47 128 52 52 139 12 72 69 194 106 163 103 215 61 54 243 63 229 240 91 232

[test]
name: shuffle2 char16 uchar2
global_size: 8 0 0
kernel_name: test_shuffle2_char16_uchar2
arg_out: 0 buffer char2[8] 32567 50532 18578 38224 39308 24589 19942 52302 41121 15028 31593 57272 37582 40452 28774 62563
arg_in:  1 buffer char16[8] 44540 16892 54554 33349 49444 10295 43986 30613 59480 32567 46012 62986 53776 3134 58589 787 53065 58468 29357 56293 31596 33189 62551 62271 18480 29918 57790 37161 47182 63725 19504 11476 24589 39308 16089 7732 20330 44932 4808 43835 21018 61420 51157 24593 53932 65024 25172 21956 51235 6177 44428 24594 42998 24012 56890 19942 64676 27967 57852 4313 31846 63931 41639 25741 67 5707 8161 17585 31830 58093 29359 14293 55774 37538 44321 64674 25184 21392 48842 46731 57428 51225 57527 41618 61416 8824 19213 28806 14850 20417 51649 60801 27527 48218 6108 2788 53233 27174 11477 54045 53922 27586 542 17875 64187 40452 49826 8656 10260 64584 2004 26732 54964 47187 40905 10972 3045 31342 3655 48170 20103 61047 33868 14442 58609 36497 28774 50163
arg_in:  2 buffer char16[8] 50339 44534 29924 34587 11662 5768 20288 41357 63575 8296 62841 56976 41869 50532 3183 15282 56917 17508 18578 4079 15585 56330 32490 4166 35650 34624 50370 15129 45065 38224 48986 24843 7812 44400 1828 21158 64940 2877 33797 43460 18044 45094 13018 54742 8868 32967 13656 9841 16811 63605 4542 29280 45524 12689 28438 23224 30166 52302 26398 57538 45667 20704 35281 45683 26318 28320 61044 41121 16838 36283 59 10915 43002 40417 42371 4601 11084 1850 38326 15028 21821 36084 26399 45396 58863 11653 54344 53631 16083 10534 60680 42484 22824 38871 31593 57272 37582 4108 3002 1077 35296 9984 41040 41539 37674 6348 32612 18352 34022 7351 50936 54866 36814 29548 33222 40992 64159 58826 16106 55529 49082 22221 6721 30279 62563 50292 4011 31259
arg_in:  3 buffer uchar2[8] 41 157 50 93 65 224 7 185 211 63 126 255 144 137 206 220

[test]
name: shuffle2 char16 uchar4
global_size: 8 0 0
kernel_name: test_shuffle2_char16_uchar4
arg_out: 0 buffer char4[8] 26537 19044 54705 46240 32499 63707 16884 8174 14735 53026 53026 51943 5943 46921 55806 1058 29506 62842 38954 45744 39046 37310 28362 22066 43288 27145 59121 27145 15117 55819 41356 52861
arg_in:  1 buffer char16[8] 61698 7648 21526 46832 26537 32665 19811 29007 39431 19044 24416 32820 3571 23756 30491 54705 20557 31896 16884 22020 32499 39241 2757 60408 26186 8174 54007 21995 49940 50843 27851 50437 64642 13505 16616 11267 1527 10714 1382 31854 51887 59032 36148 54060 45258 51943 33849 10044 20672 31807 27511 5943 7033 8786 58491 32635 59062 17627 37900 1768 19364 46032 46921 48106 38974 33227 17513 2949 62842 26162 52023 44482 62066 39507 57720 18261 62317 38784 43499 45744 49899 51886 52595 39046 30833 24747 56534 28362 34754 21942 18384 62371 44789 33944 56809 39538 59796 6836 25470 33684 60138 9014 2395 26379 13528 33600 137 28387 24248 22752 47235 35084 1181 2161 2706 21951 40685 30950 51517 65510 47615 46493 11509 56614 15117 3241 22569 1870
arg_in:  2 buffer char16[8] 35722 46240 27343 50325 25796 41847 24179 23437 65051 19811 53436 29712 360 7098 57165 4109 17766 11169 54961 40672 43482 24781 8056 44450 18110 41434 35964 63707 63078 43330 35333 10210 60117 20916 14113 33940 53026 58692 55217 20846 54939 16567 14735 14606 24382 63213 38562 13108 55806 34370 36192 14501 46621 9795 1058 5360 1943 18152 16104 53490 50470 63089 3545 41063 18407 11151 51385 29506 6384 27425 54056 3618 6182 52349 17365 38954 53306 53047 7179 58417 19058 16661 27173 22066 11702 61551 37723 35110 33123 27739 52840 1178 6756 9196 1344 37310 20251 18461 17640 15009 43544 842 42378 19052 43288 8201 11290 48892 27145 33275 59121 43491 63593 61672 11056 10599 41356 57508 50291 52861 62919 55819 9702 28747 18838 52377 41076 19423
arg_in:  3 buffer uchar4[8] 36 73 79 17 196 59 34 137 154 180 244 205 163 238 176 118 19 196 187 175 3 127 39 243 56 188 222 124 12 57 20 183

[test]
name: shuffle2 char16 uchar8
global_size: 8 0 0
kernel_name: test_shuffle2_char16_uchar8
arg_out: 0 buffer char8[8] 54813 23569 63326 442 16666 47940 62575 36604 42960 37720 57891 30335 48317 50498 46219 30335 22672 31925 8969 59707 31925 8969 22963 59707 62891 58153 61434 50325 54507 6719 51076 61434 61153 22010 26045 26045 26412 15077 41180 7137 40485 34881 7696 17068 3784 25899 25095 25899 38988 51300 18788 36401 36401 17052 51404 5406 2336 16540 48571 23854 16540 19040 2336 31466
arg_in:  1 buffer char16[8] 5209 47940 23569 44683 35292 63706 63326 54930 170 30953 62575 45122 21065 5726 62945 21612 50498 37720 63398 27922 3577 59537 22728 57891 41320 42960 56352 18885 56299 51307 31093 48317 49936 38694 31538 27704 33412 31692 48767 59707 31216 44266 19197 42212 31925 18864 33646 22672 15039 58575 62891 26845 23792 46915 32646 11638 65107 27563 38501 51076 35839 26481 46392 53308 41330 2718 5678 25177 25821 21437 60074 10608 32879 37718 63758 55021 41180 50510 7137 15077 7696 43862 20933 34881 57425 40485 54377 63139 49148 28886 11753 10509 11959 2297 43375 12552 30792 2647 5406 12514 40906 11990 51300 16828 25930 36401 38729 20807 24078 29624 17944 17052 29925 33800 65012 39778 19040 35561 26795 10280 17871 53340 23854 26066 2253 46065 62880 16540
arg_in:  2 buffer char16[8] 35501 10690 36604 28911 533 18799 27149 442 54813 16666 19067 63565 5382 41778 28834 22859 59850 41498 58011 30335 36089 24739 13157 45849 64244 35672 46219 37057 28556 37452 51441 8582 22963 49226 14915 12478 18150 60400 18898 55385 34288 25569 23283 8969 34742 57736 42867 49305 6719 45131 51120 50325 16497 19915 4559 40028 58153 54507 27542 61434 26666 51305 11498 12788 52705 15938 61153 22010 4231 26412 30541 31550 12469 49542 53279 9130 27868 26045 28638 64459 11908 25095 13059 17068 25599 56575 51760 34353 61779 3784 45979 45268 26988 4543 25899 57742 28212 27792 919 18788 31011 59472 61845 11981 36184 38013 51404 43128 38988 11623 16316 65056 48571 11581 30159 17838 53655 31466 2336 63559 37081 18871 48517 19082 15172 42135 41968 9907
arg_in:  3 buffer uchar8[8] 184 98 102 151 217 193 202 18 73 225 39 147 79 96 250 179 79 76 219 135 108 59 80 71 226 216 91 19 153 240 43 187 50 51 253 125 21 15 44 238 133 131 192 83 121 62 81 254 124 6 115 73 73 79 90 34 54 143 48 138 239 132 214 21

[test]
name: shuffle2 char16 uchar16
global_size: 8 0 0
kernel_name: test_shuffle2_char16_uchar16
arg_out: 0 buffer char16[8] 33794 13416 21567 21994 43628 2140 57652 21994 14583 31701 18528 2140 32222 37839 21567 13416 33618 24454 40606 16082 55766 48236 50887 16082 50887 26271 58347 41900 55171 33618 16082 50887 48799 37400 11099 48224 24445 61283 33197 986 42410 18999 45165 48799 3043 40144 37131 45165 34303 25917 37528 65196 52973 35144 61712 60199 52973 50448 64427 52973 13358 17418 61210 65196 10317 26742 42283 11502 64271 43309 44922 36561 57157 16243 25873 376 1561 4089 44922 25236 12590 37117 49934 12665 12665 55293 54068 38687 37165 52499 50627 13836 56057 2038 47792 62915 44220 4883 39853 48453 51758 7508 59288 16308 17 20186 39580 63584 16308 44220 86 22272 43205 49084 58946 60453 20446 23992 8627 40956 8627 40956 1946 43437 55635 14042 43437 14042
arg_in:  1 buffer char16[8] 9796 18528 59180 7682 45486 43628 33284 53450 51181 2906 38860 31701 27826 11684 18873 32487 27918 59372 41900 1400 32831 55159 16930 43501 50887 26271 39090 12443 58347 35347 31051 34317 40144 11099 48224 18999 58974 3442 50635 58628 6811 37400 55557 61368 25513 21013 986 34968 14021 50448 33698 25931 63543 61712 34699 52973 17394 65196 35144 22542 2037 27230 44418 34303 14321 4089 57157 40650 42283 25236 43309 53779 16713 16243 32763 46856 61915 57856 22775 46404 56057 57194 53757 47792 13836 11507 59353 17172 12590 2038 50627 62915 31122 51551 12665 55293 7508 38840 22337 39501 36511 16308 44220 17 18933 199 12211 44473 44267 59288 26004 31819 49084 60453 34278 22440 58946 52471 1946 13533 620 14042 43205 27226 40956 15078 39483 12127
arg_in:  2 buffer char16[8] 13416 37839 7985 32222 14583 21567 58270 21702 21720 60980 33794 21994 57652 3572 49612 2140 16082 13165 40606 10861 49995 27349 33618 50310 30084 60701 48236 24454 55766 1096 55171 30632 37131 45457 41135 61984 61283 33197 45165 35758 21470 24445 29129 60591 42410 3043 48799 62163 37528 32400 2754 13358 60199 23883 25917 50944 43485 17418 4315 64427 54256 61210 57784 48200 1561 25873 26742 8928 64271 17239 11502 53077 36561 27244 10317 56108 2991 62544 44922 376 25910 38687 54903 58835 37165 8415 5097 11281 45368 49665 54068 49934 30435 37117 63531 52499 86 57006 37818 63584 20186 52308 56562 51758 39580 61562 48453 39853 54885 22272 45437 4883 55635 57560 57785 40679 8627 29721 43437 30282 49379 3150 44414 20446 23992 65157 9060 13053
arg_in:  3 buffer uchar16[8] 90 16 117 91 5 223 220 91 148 203 225 159 19 81 245 80 54 59 242 144 156 154 200 16 136 169 236 34 30 150 112 232 158 105 193 34 217 20 21 46 188 3 150 158 29 0 16 22 79 86 240 41 71 10 69 52 39 33 59 103 51 249 221 41 58 242 228 86 52 70 190 216 66 41 17 127 48 193 190 165 200 157 123 46 78 207 186 145 180 191 10 4 0 73 131 107 70 95 59 250 247 64 141 133 71 20 88 179 165 102 48 253 74 128 164 97 59 124 180 204 52 140 198 182 16 169 118 201
!*/
kernel void test_shuffle2_char2_uchar2(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore2(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char2_uchar4(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore4(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char2_uchar8(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore8(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char2_uchar16(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore16(shuffle2(vload2(get_global_id(0), in1), vload2(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char4_uchar2(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore2(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char4_uchar4(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore4(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char4_uchar8(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore8(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char4_uchar16(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore16(shuffle2(vload4(get_global_id(0), in1), vload4(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char8_uchar2(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore2(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char8_uchar4(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore4(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char8_uchar8(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore8(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char8_uchar16(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore16(shuffle2(vload8(get_global_id(0), in1), vload8(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char16_uchar2(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore2(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char16_uchar4(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore4(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char16_uchar8(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore8(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle2_char16_uchar16(global char* out, global char* in1, global char* in2, global uchar* mask) {
    vstore16(shuffle2(vload16(get_global_id(0), in1), vload16(get_global_id(0), in2), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
