/*!
[config]
name: shuffle ushort ushort
dimensions: 1

[test]
name: shuffle ushort2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_ushort2_ushort2
arg_out: 0 buffer ushort2[8] 34060 34060 55777 43412 15546 15546 37334 37334 54466 54466 64855 41621 7063 7063 2243 64687
arg_in:  1 buffer ushort2[8] 16832 34060 43412 55777 15546 51438 552 37334 39265 54466 41621 64855 40255 7063 2243 64687
arg_in:  2 buffer ushort2[8] 16741 16027 4269 27540 32788 29756 15685 29253 24981 38705 56777 38624 60607 62683 54840 28015

[test]
name: shuffle ushort2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_ushort2_ushort4
arg_out: 0 buffer ushort4[8] 583 26714 26714 26714 47990 47990 47990 28308 40305 40305 21763 21763 4384 4384 28489 4384 57033 57033 57033 57033 27934 27934 44465 44465 16923 38433 38433 38433 11461 11461 16994 11461
arg_in:  1 buffer ushort2[8] 26714 583 28308 47990 21763 40305 28489 4384 57033 53569 44465 27934 16923 38433 11461 16994
arg_in:  2 buffer ushort4[8] 7751 43372 6594 16962 8749 14409 14561 6146 15607 19249 49426 39986 3985 57817 13426 24989 1614 30576 21606 1052 57357 34635 38110 23746 51556 41341 13793 21875 15644 18996 62107 20428

[test]
name: shuffle ushort2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_ushort2_ushort8
arg_out: 0 buffer ushort8[8] 1322 4435 4435 4435 1322 4435 4435 1322 38927 28476 28476 38927 28476 38927 38927 28476 34050 15559 34050 34050 15559 34050 15559 34050 33807 33807 33807 33807 58973 33807 33807 58973 29167 63615 29167 29167 63615 63615 63615 29167 57231 35358 57231 57231 57231 57231 35358 57231 59789 39651 59789 59789 39651 59789 39651 39651 58215 58215 28729 28729 28729 28729 58215 28729
arg_in:  1 buffer ushort2[8] 1322 4435 38927 28476 15559 34050 33807 58973 63615 29167 35358 57231 59789 39651 58215 28729
arg_in:  2 buffer ushort8[8] 54982 13877 54807 51389 26292 15999 47699 31768 2596 8963 2703 53358 46785 26332 26868 43179 57103 14284 5999 64409 56726 40129 35810 51031 36488 50182 20226 16392 2177 9020 22668 5529 41615 47726 61271 57151 26570 52572 7958 46801 50297 60046 52765 33205 14449 22783 37564 22461 53046 33749 18248 10582 40763 57034 39795 56937 358 65244 26825 37245 26613 1739 40304 12769

[test]
name: shuffle ushort2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_ushort2_ushort16
arg_out: 0 buffer ushort16[8] 47478 53284 47478 47478 53284 47478 53284 47478 53284 47478 53284 47478 47478 53284 53284 53284 50097 47951 50097 50097 50097 50097 47951 47951 50097 47951 50097 50097 50097 47951 50097 47951 50144 27555 50144 50144 50144 50144 27555 27555 50144 27555 27555 50144 50144 27555 50144 50144 1051 1051 1051 40968 40968 1051 1051 1051 1051 1051 40968 1051 40968 1051 1051 40968 13388 13388 13388 7686 7686 13388 13388 7686 7686 13388 13388 13388 13388 7686 13388 7686 54685 54685 54685 14455 14455 54685 54685 54685 54685 54685 14455 54685 14455 14455 54685 54685 44055 44055 54345 44055 54345 44055 44055 44055 54345 44055 54345 44055 44055 54345 44055 44055 28787 28787 44586 44586 28787 44586 44586 28787 44586 28787 28787 28787 44586 44586 44586 44586
arg_in:  1 buffer ushort2[8] 53284 47478 50097 47951 50144 27555 40968 1051 7686 13388 54685 14455 54345 44055 28787 44586
arg_in:  2 buffer ushort16[8] 43791 45590 48425 19253 40962 44499 11020 33367 44896 35941 36920 19905 54081 51922 28932 13704 30130 35271 58704 16958 37308 18144 36183 6193 1232 31325 47420 43704 15294 59149 7802 35847 20126 63859 28358 29872 43708 12012 13945 34425 64302 61369 39991 55132 47634 24307 11922 15388 16507 52867 35671 11256 37974 21819 61995 54365 32227 49007 35864 35507 43166 22907 33983 28472 12893 38199 50673 52472 44412 60939 12495 9086 31904 21661 59975 24825 47207 34840 4713 17888 996 48228 58234 37453 40773 43126 23450 1946 38892 21430 3427 57708 58131 15771 57332 61974 10787 4623 60944 57257 29518 36123 16763 62671 58508 11287 46332 54281 40583 65062 62011 59125 41068 40516 10881 15041 13946 9953 32279 55648 57833 8954 60994 2968 23365 18575 53895 43379

[test]
name: shuffle ushort4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_ushort4_ushort2
arg_out: 0 buffer ushort2[8] 21846 43979 12692 12692 59717 47910 4897 19962 40883 39186 27178 61891 52429 52429 38716 38716
arg_in:  1 buffer ushort4[8] 21846 43979 20625 31888 63026 51386 22203 12692 47910 20885 59717 12699 19962 43526 4897 15016 39186 40883 35966 22811 27178 51478 61891 2607 35324 52429 14696 38929 48460 50060 37827 38716
arg_in:  2 buffer ushort2[8] 10444 58853 29543 37927 62118 2716 31258 2364 14381 2912 43948 55534 18721 39125 5139 13495

[test]
name: shuffle ushort4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_ushort4_ushort4
arg_out: 0 buffer ushort4[8] 40273 61423 61423 61423 47406 47406 47406 33343 40843 55293 40843 54878 63239 31223 63239 63239 59594 37580 12772 37580 32926 16934 36888 32926 13904 14615 13904 13904 25803 25803 41676 41676
arg_in:  1 buffer ushort4[8] 12857 40395 61423 40273 18369 56162 33343 47406 34004 54878 55293 40843 63239 57268 31223 23497 59594 37580 17577 12772 23859 16934 32926 36888 36307 13904 41523 14615 561 25803 8578 41676
arg_in:  2 buffer ushort4[8] 5895 34926 63726 56026 15747 22339 33683 25558 30371 41134 23583 4901 6868 150 25616 12416 6508 64901 11999 40181 25758 46689 55919 20950 31529 21767 59505 50417 26401 7033 56003 64595

[test]
name: shuffle ushort4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_ushort4_ushort8
arg_out: 0 buffer ushort8[8] 10076 22590 22590 53346 19667 53346 22590 53346 53931 41434 22191 22191 41434 41434 41434 53931 38051 47270 38051 47270 54672 54672 47270 38051 54646 53395 54646 53395 53096 54646 53096 53096 1346 1346 1346 11244 29433 1346 1346 11244 42557 4686 4686 42557 4686 4686 62394 44143 63400 37042 42504 9345 63400 37042 42504 9345 24166 8825 8825 38742 8825 24166 8825 24166
arg_in:  1 buffer ushort4[8] 19667 53346 10076 22590 22191 41434 21006 53931 47270 55371 54672 38051 27091 53096 53395 54646 29433 60365 11244 1346 62394 4686 42557 44143 42504 63400 37042 9345 8005 8825 38742 24166
arg_in:  2 buffer ushort8[8] 35806 31923 11483 12417 24904 4457 39771 57241 33571 11069 4280 2476 17001 30649 11037 55695 17179 46040 10031 27132 30014 62010 11908 29239 60675 20706 60003 49098 32765 18251 14833 40053 63711 7735 52803 28482 56596 59447 16511 50598 5122 421 32417 47958 4057 17241 11692 13879 28897 21574 50904 48715 27085 9386 53624 26091 18855 30481 61693 53810 39205 46271 20649 36163

[test]
name: shuffle ushort4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_ushort4_ushort16
arg_out: 0 buffer ushort16[8] 31269 31269 49053 38923 38923 52036 38923 38923 38923 31269 49053 31269 38923 49053 38923 38923 17929 26086 17929 17929 31908 31908 17929 31908 31908 31908 54146 54146 31908 54146 26086 31908 53072 53072 53072 22096 22096 36939 53072 22096 53072 53072 53072 36939 22096 22096 22096 22096 5462 4555 41681 41681 44621 5462 5462 44621 4555 4555 5462 5462 41681 4555 41681 4555 38047 17687 63863 24591 63863 24591 63863 38047 24591 17687 17687 38047 17687 63863 38047 24591 5944 27396 5944 5944 27396 5944 27396 21713 48429 48429 5944 5944 27396 21713 48429 27396 55537 29879 60390 60390 16778 29879 60390 55537 60390 60390 16778 55537 60390 29879 29879 16778 23724 63224 23724 23724 63224 18865 2718 18865 23724 18865 18865 2718 18865 23724 23724 18865
arg_in:  1 buffer ushort4[8] 38923 52036 49053 31269 31908 26086 54146 17929 53072 36939 27030 22096 5462 41681 44621 4555 38047 24591 63863 17687 5944 21713 27396 48429 60390 55537 29879 16778 23724 63224 18865 2718
arg_in:  2 buffer ushort16[8] 5243 52739 17398 8128 26536 50113 27656 62588 496 52855 16266 34159 60712 6634 41260 63392 7115 63553 18011 17803 46232 59808 42883 7948 10972 25912 122 10830 54244 35594 27173 15124 44228 30720 43800 62667 51395 25201 30240 51311 9288 63512 63528 2253 57459 25847 227 25827 29712 40483 21869 12001 63506 51512 51204 22758 3743 8123 10196 12948 64885 12479 9453 26871 51436 42111 35954 7237 62462 42777 12802 44644 34001 2571 35415 7868 4415 52858 45696 713 61884 45994 24356 32012 24310 21624 36070 57477 60259 18019 28344 35428 24486 16217 29103 18294 10929 35330 58888 61656 45247 1162 18860 25625 45956 32332 5691 2437 33756 24574 4842 57471 34060 46977 13864 49232 35441 42338 52639 44694 49308 46166 41590 25315 39842 64120 25784 6198

[test]
name: shuffle ushort8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_ushort8_ushort2
arg_out: 0 buffer ushort2[8] 46749 36522 53194 35820 33219 29218 41276 41276 49644 57104 13866 19358 42638 35189 63043 50765
arg_in:  1 buffer ushort8[8] 5774 36522 46749 20498 62131 39825 50227 32234 3205 19673 35820 22713 53194 39871 34590 2464 45499 14303 48093 45046 42864 29218 31138 33219 2376 21781 41276 27335 34657 45078 32062 51319 45167 49644 42002 43321 57104 53027 38366 30598 13866 36534 11200 44779 60215 19358 63936 10915 33558 27886 21406 15507 35189 42638 2086 44671 78 20131 47146 63043 13386 31872 50765 30259
arg_in:  2 buffer ushort2[8] 34666 6673 756 45274 35199 41917 4042 234 50841 31500 60376 63485 38261 16612 50555 3566

[test]
name: shuffle ushort8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_ushort8_ushort4
arg_out: 0 buffer ushort4[8] 8453 44274 9416 12163 17369 17369 25318 13429 32720 25270 48275 26281 45327 184 31187 45327 18264 61325 29692 27611 65387 61853 20995 27267 34617 5309 34617 64130 6466 45151 16191 63777
arg_in:  1 buffer ushort8[8] 28533 29843 55402 8453 12163 40740 9416 44274 17369 56267 15081 14772 27832 13429 22834 25318 26281 48275 10262 32720 35952 25629 25270 36007 10349 27669 62856 31187 9272 45327 184 40087 22570 27611 2342 61325 45272 29692 52702 18264 48126 20995 64954 9773 27267 65387 47506 61853 54680 33398 23021 466 64130 34617 5309 9346 4209 45151 63304 57203 63777 16191 26417 6466
arg_in:  2 buffer ushort4[8] 48491 51023 34054 45140 44464 18384 43103 19653 15899 46774 11969 35440 46013 52342 13635 41117 18551 51075 37085 33193 46877 21271 7417 14540 25413 62022 12149 41204 29023 33377 58061 22060

[test]
name: shuffle ushort8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_ushort8_ushort8
arg_out: 0 buffer ushort8[8] 62028 56109 26678 56109 17130 62028 63097 17130 27551 27551 47155 65239 27551 65239 4340 65239 52045 4697 34369 52856 18831 52856 4697 52856 41992 22124 60500 60500 17929 46042 17929 46042 14221 38334 57923 41815 38334 43527 41815 52150 23130 13933 65207 13933 50604 57899 13933 23130 58004 45636 45636 29119 16801 45636 23901 22643 5863 29289 29289 61581 61581 5863 38177 61581
arg_in:  1 buffer ushort8[8] 56109 26678 59600 24525 63523 17130 62028 63097 47155 4340 27551 21549 8580 41202 49658 65239 52045 52856 4697 41657 18831 20942 34369 21371 22124 60500 13091 46042 29370 52989 41992 17929 58267 14221 52150 49173 38334 43527 57923 41815 50604 59757 13933 16497 65207 63460 57899 23130 28084 22643 14727 45636 16801 23901 58004 29119 29289 53497 61581 23575 5863 34946 38177 12376
arg_in:  2 buffer ushort8[8] 2790 64432 36241 55920 5181 32910 62655 5549 61954 63154 44104 62383 55458 36119 4993 9431 11488 29914 24646 28297 35900 41441 22922 53105 29894 31888 11569 3001 47991 1723 23615 40403 52713 62212 7878 18999 47756 16165 40103 19082 50207 55042 63884 61506 42432 22238 32730 45063 41726 22515 53275 50103 43716 42819 53413 18737 58092 10432 39832 50218 25618 3292 57566 28994

[test]
name: shuffle ushort8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_ushort8_ushort16
arg_out: 0 buffer ushort16[8] 43442 40081 43442 80 31531 1168 31531 31531 40081 8083 31531 31531 80 8083 80 38323 11038 47440 2840 7774 45965 9040 2840 47440 47440 2840 36732 45965 7774 45965 36732 2840 10002 57341 32241 45165 10002 43772 57341 10002 43772 32241 35200 18974 45165 45165 10002 32241 44566 60663 44566 44566 44566 56071 60663 60663 692 52100 44566 50421 52100 60663 60663 15304 47051 9714 64269 14901 14901 43866 47051 14901 9714 51759 34150 49648 14901 9714 51759 51759 13257 53094 77 45240 23539 4373 77 7538 13257 53863 13257 77 13257 77 53863 4373 38109 63309 46407 63309 46407 38109 63309 20793 46407 38109 63309 46407 23470 46407 39116 38109 56579 56579 13264 35109 56579 35109 35109 56579 22718 22718 4800 56579 64760 22718 60006 60006
arg_in:  1 buffer ushort8[8] 40081 1399 1168 38323 80 8083 31531 43442 47440 45965 11038 36732 2840 17851 7774 9040 43772 10002 35200 18974 45165 32241 798 57341 44566 56071 52100 50421 60663 15304 692 57916 34150 14901 47051 9714 64269 43866 51759 49648 13257 77 23539 53863 53094 45240 4373 7538 20793 46407 23470 59932 38109 63309 40991 39116 13264 47621 22718 64760 4800 60006 56579 35109
arg_in:  2 buffer ushort16[8] 48391 25496 927 48892 32358 15138 26982 50214 40360 22317 3902 54950 48860 60053 23332 53291 38786 25592 35076 45166 40961 49263 54940 14808 49496 26892 4715 27329 64294 44209 29899 32732 64361 62487 32717 14364 17513 19640 35567 41553 16872 5493 49202 21755 49204 60892 5281 33669 61328 48332 40072 51152 56640 8465 55004 61492 39886 32570 2384 54539 38482 58668 63236 50621 43482 45883 16708 45217 40353 60405 18706 26849 40259 11158 59960 18343 32945 15283 21550 47110 62576 5324 24089 54965 26346 35158 1217 45943 128 41779 43096 12953 25176 11785 50123 5486 50796 37693 32225 16541 12993 45372 27453 24816 54017 21236 57285 2545 36010 32897 11175 300 59254 38662 36208 48031 5326 54903 4271 5550 25850 226 18996 11286 26387 51834 53373 41397

[test]
name: shuffle ushort16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_ushort16_ushort2
arg_out: 0 buffer ushort2[8] 63680 14170 4555 4555 10582 65221 44846 46555 6843 54619 20202 26104 60869 50650 38886 54494
arg_in:  1 buffer ushort16[8] 14170 13194 31710 41381 10980 23514 23521 30856 63680 12277 56627 30364 43855 35550 50048 58185 14335 21 53589 10580 45171 38590 7554 6154 48716 23931 12953 32378 47039 4555 43474 30947 29335 41536 11726 10582 7170 12956 42105 65517 51163 52942 65221 44879 47059 6086 17295 58767 12205 44740 17896 54161 44846 4097 58213 53369 22611 46726 61158 60960 31378 46555 1698 28824 9974 32285 11766 23348 54619 57808 31509 39477 14121 606 64643 7677 2064 20408 6843 62748 17598 25442 56880 19253 5192 26809 21591 2900 27348 8809 20202 603 26104 52565 62587 1216 60542 52477 35527 2927 57585 22894 63666 25961 9723 25418 60869 4017 42502 50650 15414 52177 23849 50449 55440 40845 23175 54106 35013 15779 54494 11519 45861 1206 63082 38886 51135 57885
arg_in:  2 buffer ushort2[8] 65016 46624 62477 32013 3539 47530 30116 32477 40350 33236 56474 57292 36410 36941 16605 3224

[test]
name: shuffle ushort16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_ushort16_ushort4
arg_out: 0 buffer ushort4[8] 7171 55586 29906 2309 38474 34014 32160 34014 2389 49109 29159 28427 16311 34137 34137 47890 39635 18356 36072 51758 51686 56958 65255 8015 28941 18659 19595 2833 45059 40410 28365 31138
arg_in:  1 buffer ushort16[8] 31724 17729 65201 26800 64880 65533 7171 61825 5815 2309 13188 29906 10116 31652 19845 55586 39877 18577 28050 34014 60194 38474 36764 19309 33432 29683 54636 27055 32160 5219 17814 36043 47191 29159 34619 28698 2389 9851 64629 35285 28427 3981 46777 49654 55021 57705 49109 56069 34137 36655 38096 44458 38080 482 434 47890 16311 49227 46418 65332 62889 47979 20452 20707 2375 51758 32119 13897 18356 26319 39635 36072 60951 33841 29656 39655 8061 18942 29978 46189 43853 26284 63349 15282 65255 33135 26554 51686 53658 5633 56958 8015 49836 9264 60777 27156 42865 2833 18659 58008 60207 55097 4692 17113 19595 28941 64312 9628 5993 8973 3739 337 42564 8581 47434 5934 28365 61630 9264 26190 40523 40410 3850 29116 63564 23405 31138 45059
arg_in:  2 buffer ushort4[8] 7030 8079 59259 41529 49365 6083 5660 2067 24244 9374 31617 63992 31320 7696 28896 57991 1430 16436 5735 22097 59351 31002 61972 12539 41897 56322 58136 31457 32415 8777 35060 49246

[test]
name: shuffle ushort16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_ushort16_ushort8
arg_out: 0 buffer ushort8[8] 61217 23632 51384 37810 42252 37810 709 23632 59123 47986 59123 59123 13832 33210 11590 11590 53569 34765 45593 53592 13416 2438 8293 41655 39356 42408 1703 1703 1633 26478 4627 1703 23085 957 13553 23085 23085 64657 47079 1006 29219 32939 63348 32939 51467 56465 38681 12293 65105 2837 47581 599 4468 25124 599 6153 42441 53636 30113 53636 13853 65127 57843 11786
arg_in:  1 buffer ushort16[8] 63373 51384 23632 37810 38366 34320 709 27811 29460 30258 61217 903 11699 51995 42252 8922 65120 1307 47986 59123 64914 6500 36026 35598 26518 22666 33210 33074 11590 13832 53475 49429 8293 45593 34765 34686 56317 58443 58768 53569 53592 54774 33253 13416 19535 54917 2438 41655 24036 52426 39356 4627 42408 1633 3942 1703 32506 48027 26478 9755 27111 5523 28316 24344 45432 36584 54904 13553 64657 19831 55792 957 47079 23085 62706 43704 1006 97 34880 27616 23149 51467 62189 64342 26618 29219 48175 63348 47515 56465 38681 57144 32939 37199 64219 12293 6153 599 35100 51061 51577 25124 7531 49307 2837 42599 65105 32319 47581 43346 8097 4468 29160 57843 53636 65127 36282 37032 11454 2326 33448 11786 13853 31057 42441 30113 21543 64328
arg_in:  2 buffer ushort8[8] 54042 15522 46321 6163 12270 20147 16310 14322 50275 63506 50611 22851 41949 64954 3228 25308 40503 43250 31345 22248 50459 38798 35136 13647 51106 45220 10631 34631 49029 27274 56515 45415 12057 295 62707 3353 31961 9572 38392 14796 33045 56780 6887 33116 13953 49401 27466 49007 27418 19960 59932 9121 49327 15957 23777 14784 58636 27538 22845 40994 20602 547 39265 57129

[test]
name: shuffle ushort16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_ushort16_ushort16
arg_out: 0 buffer ushort16[8] 23497 9659 24633 65001 6028 65001 50685 60217 6028 14671 24633 23497 14671 9659 65001 54474 51177 11634 52941 15225 3842 4967 18031 11634 3842 51177 15686 28815 52941 28815 52941 27225 35091 21613 53221 42037 31424 31424 41155 41155 54598 35091 31424 24924 9927 41155 21613 31424 37876 3412 51486 36753 51339 29208 8183 38356 29208 3412 29208 51486 57075 38356 8183 10095 5788 5788 6452 2514 2514 63973 12380 819 14800 26884 37390 53527 32416 2514 2514 30961 12419 14 50973 1372 63381 57639 28557 63381 27501 57003 44473 14 63381 50973 54553 1372 54622 52729 2251 52083 42536 2251 42275 2251 24755 42536 17080 52083 24755 19951 28503 947 39273 41608 50543 23307 25578 50543 25578 25578 32562 31626 41497 41497 32467 14280 39273 50543
arg_in:  1 buffer ushort16[8] 54474 6028 25191 9659 65001 23497 30136 60217 60534 1651 51515 14671 34362 28137 50685 24633 11634 13214 15686 52941 27225 40925 1946 15225 47541 28815 3842 51177 4967 18064 13597 18031 9927 58449 48175 28301 21613 35091 10657 54598 42037 38109 41155 15053 31424 24924 53221 53676 18559 10095 31402 29208 38356 57075 37876 53721 6499 8183 51486 51339 36753 3412 52758 13366 819 14800 2657 37390 5788 2514 50245 18764 63973 12380 11915 6452 53527 26884 32416 30961 14 9488 12419 28557 27501 57639 48708 44473 45679 1372 57003 50973 49683 63381 54553 42873 19951 947 28503 27431 52729 52083 17080 64243 35018 5849 54622 42536 24755 2251 54361 42275 23307 15218 31626 41608 51775 41729 41497 23958 25578 32562 49184 14280 50543 32467 39273 1048
arg_in:  2 buffer ushort16[8] 24005 39443 47455 42276 44097 53620 57918 23975 45713 11227 32415 47893 47435 26211 5108 42752 12347 49120 32947 3143 11114 36172 17743 57648 36170 38651 9602 10121 18275 15705 8579 32052 7333 17028 44094 12600 9980 18412 22938 45850 17559 34149 62172 36397 32032 442 38612 28076 45766 25613 50154 64668 42923 33475 1673 19012 34755 30205 39859 39306 18405 32436 42569 19889 11332 14068 65483 44229 11205 30568 38553 21008 5217 36141 2003 3516 10334 40277 33973 41679 55858 54928 17771 14857 54509 58949 46899 39501 62388 13418 58199 55872 14749 57307 13758 40025 58378 34788 21821 51205 17243 53485 25087 18077 21164 12187 30118 25573 48044 39040 38866 60273 64446 5427 44828 36352 38536 56364 65496 2600 36969 55826 2470 25350 10317 31499 37438 29468
!*/
kernel void test_shuffle_ushort2_ushort2(global ushort* out, global ushort* in, global ushort* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort2_ushort4(global ushort* out, global ushort* in, global ushort* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort2_ushort8(global ushort* out, global ushort* in, global ushort* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort2_ushort16(global ushort* out, global ushort* in, global ushort* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort4_ushort2(global ushort* out, global ushort* in, global ushort* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort4_ushort4(global ushort* out, global ushort* in, global ushort* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort4_ushort8(global ushort* out, global ushort* in, global ushort* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort4_ushort16(global ushort* out, global ushort* in, global ushort* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort8_ushort2(global ushort* out, global ushort* in, global ushort* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort8_ushort4(global ushort* out, global ushort* in, global ushort* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort8_ushort8(global ushort* out, global ushort* in, global ushort* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort8_ushort16(global ushort* out, global ushort* in, global ushort* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort16_ushort2(global ushort* out, global ushort* in, global ushort* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort16_ushort4(global ushort* out, global ushort* in, global ushort* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort16_ushort8(global ushort* out, global ushort* in, global ushort* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ushort16_ushort16(global ushort* out, global ushort* in, global ushort* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
