/*!
[config]
name: shuffle ulong ulong
dimensions: 1

[test]
name: shuffle ulong2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_ulong2_ulong2
arg_out: 0 buffer ulong2[8] 59133 47891 5380 5380 59658 59658 3484 30956 29410 29410 46680 46680 28198 18109 57991 34512
arg_in:  1 buffer ulong2[8] 47891 59133 5380 41288 60207 59658 30956 3484 29410 30358 62176 46680 28198 18109 57991 34512
arg_in:  2 buffer ulong2[8] 2174189330881321319 14119892647271273430 7996177615111053932 13298384646675274546 16484755897561285171 10624476757328740339 8290123776167161679 8564984565015276298 877162917778133594 14052751592682975722 14548074338554625725 11228039753685842451 1160982845925550616 5382253343139815665 9441810875516063750 13896956782560684615

[test]
name: shuffle ulong2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_ulong2_ulong4
arg_out: 0 buffer ulong4[8] 37523 50047 37523 37523 3534 5734 3534 5734 49992 45674 49992 45674 62690 3968 3968 3968 16275 34783 34783 34783 47518 5899 47518 5899 24688 24688 24688 31606 64047 24809 24809 64047
arg_in:  1 buffer ulong2[8] 37523 50047 3534 5734 45674 49992 62690 3968 16275 34783 5899 47518 31606 24688 24809 64047
arg_in:  2 buffer ulong4[8] 8905719262572192186 8448295644962443821 16254566661796159344 12189221351471527178 18246779745283881292 9960179496899259065 5183649471772235356 9900304703111797305 13240381878737884925 10019830560122339522 5691124681143459155 13987350132832051390 12586536941118845426 7647488571144625249 8307804083020301377 11232092800294670885 12760520170389322988 9371976427117315383 1734690363340132547 1312513829315963871 11768797618741984715 118914944048917066 7568840598366454409 13015805369831421814 9952229878658798115 3983928907219989283 14954911239659406013 14405425545301000052 12702698986253657133 6348497779889039528 15247445829972940614 4278850141529961885

[test]
name: shuffle ulong2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_ulong2_ulong8
arg_out: 0 buffer ulong8[8] 35813 5410 35813 35813 5410 35813 5410 35813 56434 4346 4346 4346 56434 56434 4346 56434 21220 21220 5435 21220 5435 5435 21220 5435 8549 31620 8549 8549 8549 31620 31620 31620 53388 53388 50218 50218 50218 53388 53388 50218 9960 30178 9960 30178 9960 30178 9960 9960 28160 28160 7627 7627 7627 7627 28160 7627 19617 19617 19617 3564 3564 3564 19617 3564
arg_in:  1 buffer ulong2[8] 5410 35813 56434 4346 21220 5435 8549 31620 53388 50218 30178 9960 7627 28160 3564 19617
arg_in:  2 buffer ulong8[8] 9530282333672753619 5398224226219691246 6848481788266708517 15708522636458249621 14145312504845406150 8423526395565875067 8656632901305571156 4773839256271604733 3478631968504206594 17273167942822710553 16026134407660780737 6185384370521949913 9225241671724811940 13775063603346277762 562495557200163633 417780114157223190 9750300929397247194 16153643355525323112 12200805501760247813 5768000173735389288 18442591469064876171 9032003027300111153 7945741030814551624 2148696316604086799 402243920002183128 735891497929220025 9741209162189653340 3691134896364343004 17482575986966247108 4597850044151116245 11468252170051318787 5943089952271154677 807212583258466522 16220945652045842434 678223433923963063 15446725655883463105 2302020430410741733 1413998060386676522 4868856785748865032 13525075829374779815 15264953349536034601 6254431686342362592 15890645671945390397 13668817979620793986 4655155189877413869 10325262587636546422 551554146712023491 8370757996410251751 5251929390647752281 8628853130424742483 14988632226581594658 17392061825670764614 2327307663602850134 14310429436088906352 6666439355234448703 14925239584927404370 598498404679381983 8277117362337557111 3346104117610145085 14925726759851844662 6591227916658676726 1145403994179010550 15489232376855189861 11068868234021102398

[test]
name: shuffle ulong2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_ulong2_ulong16
arg_out: 0 buffer ulong16[8] 32522 1825 1825 32522 1825 32522 1825 32522 1825 1825 32522 32522 32522 1825 32522 1825 23367 23367 23367 45061 23367 23367 45061 45061 23367 45061 23367 45061 45061 23367 45061 23367 44158 61168 44158 44158 44158 61168 44158 61168 44158 61168 61168 61168 61168 61168 44158 61168 50360 21961 21961 50360 50360 50360 21961 21961 21961 21961 21961 50360 21961 21961 50360 50360 20545 20545 20545 58958 58958 20545 20545 58958 58958 20545 20545 20545 20545 58958 20545 58958 6045 6045 11045 11045 11045 6045 11045 6045 11045 11045 11045 6045 6045 11045 6045 6045 32544 32544 60681 60681 60681 60681 60681 60681 32544 60681 32544 32544 60681 32544 60681 32544 20724 19746 20724 20724 20724 19746 19746 19746 20724 19746 20724 19746 19746 20724 19746 20724
arg_in:  1 buffer ulong2[8] 1825 32522 23367 45061 61168 44158 21961 50360 20545 58958 11045 6045 60681 32544 20724 19746
arg_in:  2 buffer ulong16[8] 9403453817336707555 10636769490150304904 14841314851044529558 297895129350126841 2616513537228616140 6763349895446703577 7770721541932576634 13293033563500028155 3232031212798221736 7383709823450761320 17993754848663374693 12413463973023594555 17615652855219827999 5694695712923019600 2681337164223122185 17342759743625036808 12275966547928345610 16302784984034340702 16956614630644973818 7459419973014974221 11339141868552732322 8611402455524746060 5784491776956687871 17975957917110626621 11115398615497849924 11860060438983408563 16403684823951960036 4523144783848896257 10839180445976011635 8878144696665081006 116446146735095829 2755504175403639480 13081849040433572335 9130594864549414894 9464556533553381823 3573129818377486797 3625079982566309271 4816521974494101868 16481666133003161831 13656554029475592464 934697411373410217 10961578455296906196 9519047795174081040 14277629286382179322 1511008069091897870 10476323423167724672 13247928110182466969 4333376047818670950 12114423764570188519 8227088567733423276 13758329829525261768 14706570819460072161 5558472955983781949 6055658407818341563 1023062786392990270 11702286503757284476 2137150348469166842 6894206239444470180 1819748160984968306 16407549285486874113 11336124887435975068 13939168515759664310 5294652549421439443 14179075558151730797 10545912435109896726 7067411744599034278 4591083720572305756 1759651594567029901 7238281775643147217 17408236773123753898 10559152946499061740 13574339147176483533 15999571915667835451 9289169364181126496 11961915961393400040 17941704629232949768 3945591862046107016 3086520179965848267 10073745204695568972 16152674326908491907 6898371272401136413 10307839106276099425 7075425598632767566 2193280775776755688 2625939775045142572 17146496064910439905 7045051462673475644 6833153660017833115 14065835814853260576 14252645423834961382 14561488791083183914 4664988194311073799 16280654889690851645 9931031134891941012 11117356519799354285 4371046800643358405 5896096019629006011 12477693318815771421 7766412057452699044 11074023843407308998 8599280844951730470 11630645651651156468 9694242786087608096 2972346039053657564 6185165698176170263 11156853066575058468 13074323414603892531 314674500520547937 10717006330768562284 16680661164304355965 9316788934490976474 3422823557393926467 6057955530383380930 3823983766093735307 6307888464078812916 9534222605462853008 1816263826437940966 13375384281944224151 10261225485243921919 663788099016947283 2931665703367189360 1451508366278611559 9939270847439045974 8975740138949996985 7448771792485816183 3107590282877309746 585521632346436431 16942348395710666854

[test]
name: shuffle ulong4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_ulong4_ulong2
arg_out: 0 buffer ulong2[8] 43035 64013 37498 55581 29830 65011 60151 51803 13567 23151 9645 9645 49679 24118 5056 5056
arg_in:  1 buffer ulong4[8] 27519 64013 12979 43035 37498 36786 55581 46262 65011 42025 29830 43044 60151 51803 54264 33797 47950 23151 13567 22372 63936 55965 9645 16614 8037 24118 49679 26363 17191 1351 56588 5056
arg_in:  2 buffer ulong2[8] 5807439577810358639 13991845050774621789 16602267381955747172 2565988265984111798 11565827576793116874 7093135739539064540 14398090577323047072 2432485499144099749 14872451104376398558 18071587919335905661 12625206106866680482 5563817131224824930 4037831687387068918 14696055485254517885 14195564486589375823 2703872368802600495

[test]
name: shuffle ulong4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_ulong4_ulong4
arg_out: 0 buffer ulong4[8] 45969 15821 45969 45969 893 893 893 35903 18088 18088 46553 18088 825 2659 65238 825 51581 65211 65211 19948 65257 65257 65257 63576 30639 39305 58368 39305 63441 10117 3214 10117
arg_in:  1 buffer ulong4[8] 8572 45969 12897 15821 3279 35903 893 5090 44749 18088 46553 6865 2659 825 13969 65238 65211 64056 51581 19948 17958 63576 65257 28602 39305 35978 58368 30639 3214 10117 22932 63441
arg_in:  2 buffer ulong4[8] 13383343742622398077 1426632323326171459 10609318660462237441 16455711346380352021 5108432954536947330 13391973029128672570 8041447126114774258 308497986340720149 6319458551237821989 12229028201261159501 2501276358716809542 15125854442096947973 8485966762775060217 16195866020160295300 12758790402146726759 11036067217453224309 8676753138597427466 12712844350383798372 10118341227548072192 16891061129041005775 4417182785629567338 7968957948691782550 1748113042490974146 2249201352971211673 10617527294948167291 185167503064241112 16871538191166907158 7190308336214621700 12073721835141085287 8969447525268763545 257662546755882088 16216220450305385793

[test]
name: shuffle ulong4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_ulong4_ulong8
arg_out: 0 buffer ulong8[8] 55074 36235 19897 36235 55074 55074 47544 19897 35810 24259 35810 35810 51452 51452 51452 35810 13784 5208 5208 13784 5208 6919 5208 5208 43723 43723 14712 14712 43723 14712 29231 29231 37238 37238 37238 16875 16875 31772 16875 37238 33069 33069 33069 44391 33069 44391 44391 37693 48667 10312 48667 48667 10312 48667 10312 48667 71 43076 39966 39966 43076 39966 39966 71
arg_in:  1 buffer ulong4[8] 47544 36235 19897 55074 51452 24259 35810 35182 5208 46853 6919 13784 43723 29231 556 14712 15428 16875 31772 37238 37693 33069 57790 44391 48667 30673 10312 32933 41619 39966 43076 71
arg_in:  2 buffer ulong8[8] 5956563882289882995 13403473700071370637 2009562362366846282 780802048271037889 509752217833419483 6493591576383384151 5011027839882230424 14346168398234580610 15405073646324381238 3111767241755546549 17831318947359130690 17606367834754287382 8101502300335257884 11859692966639196580 3275143391074236432 6945379849041338602 8081531492590837667 14085460438481793284 172941545529337716 13303253442277352991 146721965695119540 4261557752360734318 8413264594248283348 4034301970383897660 14350453526196924380 12166971180547365464 7706664174394268267 3096128372502984683 7896267785838976380 1556012561431738859 7723934822102657013 14157019851761002793 11107495725789242123 10008962261905443067 2087078728968907427 3417997882863595705 222327028179084465 17839793807286747746 5240912052719045717 314188230206461703 13937576966695166833 8831203788345227297 2988788591878797837 10867273960934930591 16846729469653900345 16829451627931367523 7101465920723216435 2686911737656984124 1429801787373044192 5162338739776524742 7885082951268306616 12706871761869999992 13526019809127216174 15626052020950849320 16613207684061245842 12615565981990958240 4074173913381160427 4424105755366129506 12789668347398357501 10640122274682841369 5232675801930987866 3767221860486002809 12259935231060243945 17945855092043381467

[test]
name: shuffle ulong4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_ulong4_ulong16
arg_out: 0 buffer ulong16[8] 15608 39204 43034 43034 39204 43034 15608 15608 39204 7494 39204 15608 43034 7494 7494 43034 2391 2391 44303 2391 50726 59376 2391 44303 50726 2391 59376 2391 2391 2391 59376 59376 15083 14661 53596 53596 37452 37452 15083 53596 15083 37452 14661 14661 15083 14661 15083 37452 50641 40151 40151 57203 57203 30573 40151 50641 57203 40151 57203 50641 57203 30573 50641 30573 39289 65229 22125 22125 65229 22125 22125 40909 22125 65229 40909 65229 22125 39289 39289 22125 20382 51211 20382 64938 51211 64938 64938 51211 20382 64938 63583 51211 20382 51211 20382 64938 57240 41900 41900 41900 41196 6568 57240 41196 41196 41900 41900 6568 41196 6568 57240 41196 43375 43375 65424 6107 65424 65424 44095 6107 43375 44095 44095 65424 6107 43375 44095 44095
arg_in:  1 buffer ulong4[8] 15608 43034 7494 39204 50726 59376 44303 2391 53596 14661 15083 37452 50641 30573 40151 57203 39289 22125 40909 65229 63583 64938 51211 20382 6568 41900 41196 57240 65424 6107 44095 43375
arg_in:  2 buffer ulong16[8] 2744988245252848800 13473081953238130447 8478986068176090397 11026814596911761073 16731721964772504155 1367013049865235681 11307444048857304704 9082103180709603208 13336022826171080163 3599932665143358130 16298522512168448147 5285806541464351684 17638249058845191089 12024086382123284966 6434409817865256094 18252354793669706557 17060518808478903039 5858509220418286051 18417795548043701550 8055438468268379779 8377816357314445860 12735631114520965189 15806077362804004283 15747034511447171894 9150228696588527732 2476128072559963099 11941195877455398069 11247592664592786279 11539654246284633347 1648518712976445879 13026707102718928745 13166113449916474501 1643421244085949394 15343272663175475349 212278234980530604 2179844361362845500 7962813008117535767 11018473168580636019 8683649709644876586 9535063050942690740 12434771157274643206 17301129646021372559 2179446035748693301 3348019006519970029 10363717721200568326 7693164017860261745 14067824253365263722 10599793558387442675 17836761862909601192 2685663604214938046 5186059720629930542 4816039226069036063 17310842446118121827 2338722845279800509 1013244125565056762 13847223146965375876 17341070923869350587 2539644293546515990 15595828046857859919 12793408947198187232 15957246008599609635 17407451628740311597 3033034948560834976 16873304713363468073 14322505186971211460 7288261594755105119 4873936624337971333 5274385306382522329 13336489743751774151 3799050984185266369 9550936034665380685 15911776536140591038 1277407770364924713 5487943582677039831 3913973473934179198 14271797941208222711 15217243237954906001 9322364688817335960 8573930420264248772 260329299332848369 3381327115564013963 11252714891789968874 13448086199036112635 16229099265360505609 16704598603925704066 11515600860302336477 13806981958650573285 10118636469119317034 3160672972658700143 13078431484941190245 11493251524588888552 2154942740958677830 8474679840394957439 4749836501283250970 6267135819446008179 7470221205608828421 8387836603346127699 2557856883613027241 9173338105569161557 17813134566105755501 13143848013765124598 17076981322173361276 1881594660275032171 2726686015276511438 11109576521909628566 6745618553207539689 803875981833545961 6179558505505564348 5785354841375036206 13449180463482855908 5936087882451107247 17943367650259258618 13766959877863440959 4480078400234237539 523072562556938956 9177651814871851861 6155185776706853260 11825095446137882768 13262064324460387114 2081657547201723969 17777381916052021435 12855914359125404366 16703780318519019218 15123970092215446232 10980615676545208329 6832139777526346775 14987655677671425666 10479068222327858082

[test]
name: shuffle ulong8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_ulong8_ulong2
arg_out: 0 buffer ulong2[8] 35269 39084 47708 14801 38344 32577 49777 49777 20004 41816 40645 27395 246 25967 31087 50784
arg_in:  1 buffer ulong8[8] 35269 1052 57283 52715 15399 11994 39084 47157 14801 47708 58043 51739 27603 53308 21369 52851 18949 51258 38344 33044 33954 6016 52856 32577 7466 49559 23153 50299 49777 29649 12367 27932 2943 35854 63671 26326 14385 20004 41816 5350 33907 5500 13876 40645 3351 22040 27395 42594 30515 25967 42082 11347 30576 246 35835 17390 22340 50784 9533 50483 53318 6021 31087 27631
arg_in:  2 buffer ulong2[8] 6784040236757636184 15473359799621535374 6834533663567432065 8057735363308352152 5645247532090377042 16581603026315652663 8093069298736646020 17439933805184640412 16235604463268218397 14019490772688115054 8301397012371514131 815293005633136830 2159141882544663373 13626819798490065129 8024824620916590966 677044172846509025

[test]
name: shuffle ulong8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_ulong8_ulong4
arg_out: 0 buffer ulong4[8] 53769 18267 65528 46872 44973 39691 21212 60273 49449 22973 22973 22428 52938 1874 1874 31040 64043 64043 64043 12539 18341 49869 49869 24024 5299 8007 5299 452 64922 20840 8271 6645
arg_in:  1 buffer ulong8[8] 18267 65528 20561 58428 17841 46872 13756 53769 25033 39691 21212 28180 48851 44973 53961 60273 3200 20560 61711 22428 40794 22973 57700 49449 20421 35888 31040 1874 1515 52938 36314 25711 45708 61587 54269 20468 57785 31738 64043 12539 2588 49869 24024 3129 18341 27882 6141 30692 8007 58824 55503 5299 64790 49625 452 28730 20840 24651 45817 8271 64922 34387 48174 6645
arg_in:  2 buffer ulong4[8] 14156483991257098983 9647943472044263456 18194869380017879265 5968328821574428061 6737435979491614389 12020029185522963777 13813968907475348978 14756072596475497143 8797843562204106087 9669054201919465573 12768544892927461421 16220776905287282539 6419385935490180149 48601965357946659 4128013746295480491 10236340103582589394 7438972730372380590 18297139993864376470 14741064990958232750 3573981654111370751 15871472285351288316 6868073163610505825 2587823895883475417 2001745344412627994 17317344565776158155 10535354738992544688 10377882484336353483 16052733279650120382 9976456244056046124 9507227876135443152 10292439728562733675 7219805564681482551

[test]
name: shuffle ulong8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_ulong8_ulong8
arg_out: 0 buffer ulong8[8] 38337 49697 59188 38337 38337 8298 49697 28686 55339 4835 63531 55339 35878 44793 47207 36721 51880 18047 22190 18047 18047 25525 51880 4368 44685 43892 15724 44685 7985 7985 18719 30755 41973 23006 17282 628 628 23006 17282 40233 52518 52518 21345 12426 52518 51182 5390 21345 16774 40014 40014 16774 16774 46225 12629 40014 57915 57915 48390 57915 57915 48390 3025 3025
arg_in:  1 buffer ulong8[8] 61854 59188 4569 8298 19204 49697 38337 28686 47207 63531 36721 55595 44793 35878 4835 55339 28621 25525 12435 51880 22190 18047 4368 55837 18719 7985 33938 15724 44685 43892 30755 10748 628 27801 17282 41973 61373 40233 38779 23006 5390 21345 52518 51182 18222 25925 12426 51149 44769 12629 19118 16774 46225 26325 40014 48127 20928 3025 48390 57915 32104 16701 11363 53391
arg_in:  2 buffer ulong8[8] 7432501788127949414 3132997516144494565 1575075099939382609 8623349063675154918 4290115166088037174 2799260308309723859 12221737303706788461 9411886508858975 1243429109840730687 15557497416838324638 8734426404050492073 10334388348840301863 7892077023334593045 18249477254697301924 4620795322783774400 15812975956580817962 16947706212395155563 14390553220487306749 8124467722551623060 13189288018099241789 17694026484651943405 15058169927159289617 14868419307550798571 17271377333525060830 18392683047906096412 15809325639892231437 12972998658954179235 13852839013284602836 18213157534953973785 1657676789287011169 6634954989558790392 2426571212398046526 15863133382232935635 464633740977611287 12771192386236069754 9662335618990254560 7134902605572462008 14464306626191432455 11923789642033878250 2201078969221069805 1675712731421209826 12148396920066239290 10905028595343149585 8267782439747572798 14658271026400754978 3454426320420065283 16250336790322909160 7600212928721425057 881201519463201499 14676795065069465070 5248832648062471502 5976003774551176011 330328895425962387 18311537244105583436 607144844871866041 2533342186499667870 8243682711612921043 982210334795549435 13288614702333974442 8063230324467802467 17526783611586352299 3218309296347023986 1237556230725206409 15865641639694302433

[test]
name: shuffle ulong8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_ulong8_ulong16
arg_out: 0 buffer ulong16[8] 54042 17774 17774 17429 43457 43457 50290 50290 17774 43457 54567 44194 17774 17774 54503 17774 15621 19900 17451 19900 17451 16475 32271 16475 16475 32271 2303 15621 32271 14812 32271 19900 55053 45033 11338 13250 11338 55053 55053 55918 29354 55053 11338 5546 18742 13250 55053 29354 20463 15393 20463 46582 46582 35347 20463 50467 50467 34816 46582 15393 33254 50467 15393 49081 59116 46618 253 253 4845 55800 59116 4845 58462 59116 4845 55800 59492 253 4845 4845 5549 29401 28768 51129 5549 63191 29401 45628 45628 51129 51129 5549 51129 5549 28768 29401 26189 38925 41443 53309 21597 26189 21597 53309 53309 53309 38925 26189 11622 11622 7655 11622 58670 40859 40859 45138 58670 12213 55530 40859 45138 40859 40859 12213 41764 55958 58670 12213
arg_in:  1 buffer ulong8[8] 17774 43457 44194 54567 54503 50290 17429 54042 2303 17451 16475 19900 15621 32271 14812 33033 29354 5546 18742 55053 11338 55918 13250 45033 50467 46582 35347 15393 49081 33254 34816 20463 4845 58462 59492 59116 253 46618 55800 52602 45628 28768 2273 5549 29401 63191 18085 51129 38925 31804 7655 21597 53309 26189 11622 41443 55530 55958 45138 58670 40859 41764 12213 11264
arg_in:  2 buffer ulong16[8] 15997390576445842191 11277595604240415536 1616025062938780856 911118594921053438 3455119568146710849 14050953418759414465 7664509825465111485 395656503389103245 13340971292590724152 10480140925890747713 5948308775231685251 17963001072858553490 7949127486826074600 8484509373813041936 11775507705894519492 1195620105357672440 12344271114601664692 12792483431304607779 2671238076720676801 6914535333525285979 6387564335335169097 6904001680073035426 14254780028909563165 7643496934416609962 11326864074598391698 1007964901571325525 15441617137120217424 13142795064054949596 1845715967992425437 14188003115680837550 8933225125507973181 4232378095720651851 15015889243858582539 18393585513438450175 11644847349903126356 17048832112627622030 7535770689280552492 2480767342455560859 11884628759863912291 3017577693607084629 9601894819520003832 9691875574500771659 6083277267248259268 5186698066990142241 15077952740626273954 2847927146739227430 8476667391856283363 17605954698715838672 12769170893637567391 13586334021369478099 12803466083499796143 13871135844063636041 10089879368835100777 7542735613485205818 11071560652093230839 4454576329256628224 14142672320400691408 11864848458480094518 2967062830799432713 13823698617767877491 1369292915371582861 5152990925726995056 10355146789073648131 4820197380403852372 3431273450233334123 16283013453972892173 4770145844192490140 11424302413807753548 1483243785262412472 10353262850143246294 16908261440008832707 16871170006914392464 5181024580388160017 3327435007325833587 13723695066784840904 9272774590302642694 1929381960086006242 2295821111830112396 6873845433566636432 14648997398639502016 16620444582640171579 16738313224579790644 1180725791984991065 7294969337146274919 988473977542760979 9232782675500321453 2337472012416871772 10416271585299833032 5930043054764276288 5233336555660757655 4548163551277376719 2756668419348245931 4694313785657083423 5420461488429735579 7650610653115503313 7266211831587797628 17007903263700745141 9598274464838913936 17522569632195651967 13572480201335836228 12699441904198727147 5053402580377754789 15004355246963771891 1829734341442940636 15181031219612289820 16110396330751329780 10842371825277911776 3139773390484321397 10332892937999297406 8929301209345663918 10339649582289276666 10723785553457326830 11223848641508865203 8422582464285439572 17093078044004784340 13816010770849322506 5435192500478206291 17066173311806364894 7290053545784324280 10427665438861183380 78438967137178266 11723916805622139420 12455783354477273828 3455995077698926422 14111487728380175493 2375307391521120281 10422003121681076891 17734467319771161894

[test]
name: shuffle ulong16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_ulong16_ulong2
arg_out: 0 buffer ulong2[8] 20137 9990 4263 31677 25024 38427 14090 39345 56035 30863 49463 10784 5041 18192 8586 64616
arg_in:  1 buffer ulong16[8] 40571 33167 38636 50624 14880 20137 17041 32057 9990 52989 17415 33987 61893 26488 35872 50576 56599 30179 15179 35416 60808 12016 10701 25121 31677 45193 59103 41960 46203 24901 29454 4263 65383 3684 3221 39062 29832 61263 47903 50365 51926 788 34902 42075 38427 25024 61347 13825 28103 41699 45566 51242 61665 44045 61785 45691 2182 22243 51043 39345 53198 44645 2699 14090 34181 24705 30863 11662 5123 56035 45371 42854 214 46752 44 1154 30443 32965 3753 40826 10784 12424 35672 34239 55752 49463 44986 60992 10200 32835 8218 60673 61409 9597 23666 38929 27512 52270 63609 29420 64275 16230 5041 58921 39744 18192 61150 41423 6346 21842 41041 26827 48690 54521 8586 22905 29328 43083 42065 53815 13184 22272 20597 64616 27554 43108 18910 6965
arg_in:  2 buffer ulong2[8] 3269598922182850853 15209658176524312152 13809165876834104751 5880010634832065448 12362015088171352237 4697396794532773532 5189214869057357647 8689086128011334219 12956601562446580373 15914244027269420914 50799000394249109 9438034166829503040 4775286327951385398 14876117155934911225 6963063140273560514 18356762999128353563

[test]
name: shuffle ulong16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_ulong16_ulong4
arg_out: 0 buffer ulong4[8] 36574 58404 12130 30616 22594 25119 44806 25059 16406 28158 59283 44153 59911 63291 63291 30006 14296 55919 33784 14296 40811 61071 26927 40811 50786 23350 23350 57141 33276 33877 13467 12536
arg_in:  1 buffer ulong16[8] 51528 64968 17910 30616 20903 36574 406 58404 5956 8320 28462 39307 58193 36907 12130 52255 44806 55724 25059 13038 37346 25119 22594 62539 38951 62867 62614 60397 5029 60382 56453 35371 44153 45675 40673 53044 59283 42799 54358 38858 8871 4718 2181 4188 28158 16406 60148 9826 59911 16990 10519 28252 30006 25311 18217 2077 6001 43168 27001 3868 63291 13793 22954 9103 34378 33784 64779 46348 25052 38981 40022 19757 14296 55919 40780 64674 64460 5684 47067 27836 21047 61071 43014 40141 15909 37711 17260 50599 11032 54510 53312 40811 26927 11266 51643 8035 11966 57141 23350 58928 50786 24548 29134 53696 55248 45648 36820 14930 47714 24700 30199 15771 13467 16775 17227 39921 5078 49272 15186 12536 50605 59742 33877 33276 57061 34233 20203 25898
arg_in:  2 buffer ulong4[8] 1375709415444809045 1425007840217373095 2577449577355299454 2383886349029721299 4386904198110478742 3538016925485346501 10152371181655492352 2206600031374182578 3688889956130093869 4295865178703744524 2794565440468846436 14714979957973317984 4020065851932717280 14280189230351979980 14499109611783568588 1010981297653136116 17552342084889346456 11557460755602356441 14549154069164450321 3902718491690117848 9638166114448234731 6867157311800949025 10079059108909384636 334951127979119307 12795188263238923828 16164726742446198418 15458091520636023410 3646396126594189905 18198974421045900459 3968328932620320538 7557727351190992128 13539898829321577399

[test]
name: shuffle ulong16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_ulong16_ulong8
arg_out: 0 buffer ulong8[8] 53192 33352 57548 57548 33352 2534 50586 50312 17967 34227 16661 34227 48598 45635 39839 20262 25637 30201 25637 34517 29297 37853 48835 29297 29722 53278 53278 29722 61309 24851 53278 42770 45990 30111 34333 45990 34333 4775 30111 45990 6968 22024 11683 55636 15251 17921 31280 17921 8607 1605 7331 63984 545 33333 545 6174 31215 38298 44741 25533 34158 32677 44741 31215
arg_in:  1 buffer ulong16[8] 1891 36329 57548 2534 33234 16998 58125 38875 50312 59256 14222 50586 33352 53192 45336 60429 47768 48598 62472 46686 16661 45635 47285 42701 14983 34227 19256 20262 17967 18452 59751 39839 29297 62782 45293 25637 26148 30201 16907 46281 106 48835 4530 28055 34517 37853 1945 20510 42770 61309 21884 16968 53232 59556 24851 53278 39900 4547 34033 35926 29722 58457 47279 16220 18504 45990 24900 58158 59961 26284 34333 38121 38286 4775 30506 9902 30111 12459 46379 54257 31280 44457 11573 22760 17921 6968 19355 55636 11683 7707 2982 65481 55287 985 22024 15251 48637 26107 45180 63984 65216 17357 7331 40116 6174 33333 30944 24075 1605 545 8607 28718 45665 32677 46391 25586 29014 34158 38298 31215 44741 7835 50783 25239 31418 31911 25533 18163
arg_in:  2 buffer ulong8[8] 16153918955600176845 7286123161508140988 17944505051405152834 13172686947797404482 3022728652888638044 17068758803837399507 3301566157292580971 3230701856087966712 4265767573742715292 4635493817123608633 9290475427962007956 15649092160536028313 14838489727431018497 16253916581707860629 10685352423422451743 15291166851161314731 16543227465436858899 17841999043926543509 13717745808446370227 17240471621012532860 14251046129693644464 11234476629292646397 16769111328962150537 5622954842298991008 672307478492668828 4033022080398439991 14342366762610295767 12194186155101308524 8215906125188539569 16101537514674184262 17668468281490257031 15998108036173165920 1727023614043252753 13759488194645319804 8797349641310134774 11495589517565796593 15508084974847564646 10370129317181987977 5839020840160510076 8837203253162829809 6739963052453952885 2908155301862195934 5003312290310457528 9498011919609244039 498633868876238527 9268979130167702244 5025255947798438000 8164494616382318196 9556551319628783390 17093056576113908828 18017707402549259670 3331194732950972835 14444231072041802317 18199505743813405561 47839844518464957 15176675239447655704 3716323864822879639 16769686360279346550 13636926152371001384 15192549621402631406 4530542157290114677 1641165274089797089 3062032493038444216 13750556796670910087

[test]
name: shuffle ulong16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_ulong16_ulong16
arg_out: 0 buffer ulong16[8] 2118 59873 48915 63122 2118 10904 12346 2118 56321 63122 10049 60981 56321 57605 2118 12346 19722 25308 60102 1788 14026 25308 14026 28515 15816 19722 62798 19722 28515 58029 15816 1788 22883 53756 44418 59294 25183 60045 23907 53756 25183 3280 60045 8702 243 8702 29071 40890 10307 48520 34951 29117 1136 8099 1136 29117 16342 23264 27424 64286 8099 60553 60553 27424 65082 58859 41648 16082 50497 58859 9431 5468 50497 50497 45810 10299 6290 59967 50497 35879 51236 16735 39664 7206 34726 20746 55739 7206 34726 7206 7206 7206 55996 52714 4238 17566 1017 18529 31017 53883 8180 1017 31017 44296 36369 10412 35142 48426 40030 60914 36369 10412 16242 16242 35 14028 52325 16242 63174 7239 52325 16187 14028 52325 63174 29435 18695 16187
arg_in:  1 buffer ulong16[8] 56321 63818 48915 2118 10904 63122 57605 7748 60981 50723 53909 59873 12346 10049 24644 3200 41564 25356 5737 1788 15816 58029 62798 28515 60102 58578 19722 40812 11534 14026 25308 38386 18265 23907 243 8836 40890 3280 47905 29071 44418 60045 59294 25183 22883 8702 53756 44816 1157 23264 64627 8099 10307 27424 28557 29117 60553 54278 48520 40093 34951 64286 16342 1136 59967 54799 45810 9431 58859 10299 65082 50497 16082 5468 114 35879 41648 57168 6290 15643 4238 39664 45557 52714 25703 55996 34726 16735 51236 41396 7206 38862 54618 17566 55739 20746 53883 38484 60914 44296 10412 8180 1017 35142 8452 48426 31017 37309 18529 40030 36369 5992 64961 14028 29435 63174 27072 20406 16242 535 22281 52325 16187 7239 18695 33392 35 17816
arg_in:  2 buffer ulong16[8] 9935048748063626579 14802488198931806715 9300462555108889186 18176345259440737733 7641836521810956291 18238454776636398404 9866868462962527932 5829902987230765587 2113344992275957376 16106877573091589973 4677205019299308189 3724354198371249224 693067648945531568 8348947261052982630 16224083678669968931 9572292164817247292 15134681888750735722 8564417072604311806 16648354532045282296 5624221225055649203 17315882648601554621 17217248166447974350 1264415342644422973 2237699550699983063 1493093165818642948 17155682940837565962 7927203020849839366 17827851816241155034 5096897507981387031 12157747380925234581 10533726196763721780 12417346052917751427 17085016039963740348 15267158167064256942 16386616765923501336 1150096095245316266 8839361933866318491 16455882838351360777 8244889662988747985 5617399570302574446 3707087544052292523 16446951455497774597 3949318578770366201 14719380865064728141 1535758987360007026 10193556161620540253 4858271199066385639 1928051117832687652 17246937825259406452 15134891531360697322 4960862308491447676 16820422165233256935 7361775779642402911 12809725279628144003 18346527247846612575 7821647453811041879 6396804833458057742 11962746519684070513 2879567826156722613 4681865713649509661 7388352357353198643 14407392428324437608 2357923374053415336 13703381737241268501 11627267782253800614 1458638785916014052 12799827498415350236 3512207156633477688 14525029499954529703 4190916458900831924 5885703985781887075 18380236685745955001 8135528360074324263 948615319657278999 9614388118417480306 5823641110493421797 10943368338170471886 11642610615266932784 2315977265879186983 4589514042000298011 10249228206605384824 12745335379723052311 12573928936745402177 11928743574778988666 12801624966521554886 16729461562386371135 2639700385120652270 14399961645010208506 247975107232473334 906115499293113546 10045445306147932554 907347784823786650 9303651703027086325 17647037859127282419 3964523340024809600 5015085669438525485 5641495111552573926 7301249339287301420 1490783932664143818 4494304949122192928 15978683628193669461 14035077505807124438 3000626927619698266 13920920151410639491 3324161252029212158 1704859473172152500 14771874953625097431 17329053545791060649 12878101217691596349 7573103928768156210 7427555965811601758 1647350682295978308 11896215906429806806 15204539007261935478 3223773722452922814 1558355935339219761 3465073544047077849 4683878387850815270 12017118408450153379 16960175122089971755 5315459652281725481 9749859835863376522 13975197195006465937 4888552504484239849 17111187734435434195 8488225686756071698 8950998251880141372 5946882691682944746
!*/
kernel void test_shuffle_ulong2_ulong2(global ulong* out, global ulong* in, global ulong* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong2_ulong4(global ulong* out, global ulong* in, global ulong* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong2_ulong8(global ulong* out, global ulong* in, global ulong* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong2_ulong16(global ulong* out, global ulong* in, global ulong* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong4_ulong2(global ulong* out, global ulong* in, global ulong* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong4_ulong4(global ulong* out, global ulong* in, global ulong* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong4_ulong8(global ulong* out, global ulong* in, global ulong* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong4_ulong16(global ulong* out, global ulong* in, global ulong* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong8_ulong2(global ulong* out, global ulong* in, global ulong* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong8_ulong4(global ulong* out, global ulong* in, global ulong* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong8_ulong8(global ulong* out, global ulong* in, global ulong* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong8_ulong16(global ulong* out, global ulong* in, global ulong* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong16_ulong2(global ulong* out, global ulong* in, global ulong* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong16_ulong4(global ulong* out, global ulong* in, global ulong* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong16_ulong8(global ulong* out, global ulong* in, global ulong* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_ulong16_ulong16(global ulong* out, global ulong* in, global ulong* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
