/*!
[config]
name: shuffle uint uint
dimensions: 1

[test]
name: shuffle uint2 uint2
global_size: 8 0 0
kernel_name: test_shuffle_uint2_uint2
arg_out: 0 buffer uint2[8] 34873 2517 42381 43953 17753 10274 40988 40988 5168 5168 63802 63802 47256 4090 36763 13253
arg_in:  1 buffer uint2[8] 2517 34873 43953 42381 17753 10274 40988 13526 40474 5168 11453 63802 4090 47256 13253 36763
arg_in:  2 buffer uint2[8] 1714784639 3005096372 3855170163 1261987264 1412862918 3885358621 2183502062 1964613732 110897011 494179697 4008052241 4276490339 2694433465 391618404 3914781803 981667816

[test]
name: shuffle uint2 uint4
global_size: 8 0 0
kernel_name: test_shuffle_uint2_uint4
arg_out: 0 buffer uint4[8] 22567 51850 22567 22567 48569 43828 48569 48569 39927 24842 24842 24842 11079 11079 11079 11079 63186 63186 41894 63186 21761 21761 5616 21761 8974 33641 8974 8974 50288 62413 62413 62413
arg_in:  1 buffer uint2[8] 51850 22567 48569 43828 24842 39927 5055 11079 41894 63186 5616 21761 33641 8974 50288 62413
arg_in:  2 buffer uint4[8] 1154895341 3445784682 55927137 3241216931 355650302 2451048409 2526638256 4229022136 819113655 3546599682 3904217210 2021528134 3537844077 1847731085 1671286209 3459009457 876983155 2556264249 1298472270 3566157591 4207189239 4167584327 1810611198 286735993 1911557539 4186080256 49235349 43737767 1589071302 1081466073 3381215669 434812159

[test]
name: shuffle uint2 uint8
global_size: 8 0 0
kernel_name: test_shuffle_uint2_uint8
arg_out: 0 buffer uint8[8] 42361 34736 42361 42361 34736 42361 42361 42361 49873 49873 49873 57678 57678 49873 49873 57678 18774 18774 18774 43127 18774 18774 18774 18774 29998 18896 29998 18896 18896 18896 18896 29998 39924 6931 6931 6931 6931 6931 39924 39924 35343 25826 35343 35343 25826 35343 35343 35343 53409 34350 53409 53409 34350 34350 53409 53409 43038 43038 4119 4119 4119 43038 43038 43038
arg_in:  1 buffer uint2[8] 34736 42361 49873 57678 18774 43127 29998 18896 39924 6931 25826 35343 53409 34350 4119 43038
arg_in:  2 buffer uint8[8] 960588739 3360877870 2688662779 2456409177 287279836 4251226947 3269613771 2966484427 2708600234 447525264 3116764540 2634621525 2436795543 454418210 3833429246 3410239531 357297164 2007500928 3619172914 4283086789 2147820248 2514858456 2669828592 2057278240 2691499642 354404735 1159472558 376780159 3952696279 682265291 3417978303 195815684 772175968 4108249311 2174342271 2288867233 616716957 665322311 903533616 2265233076 1052763991 4058735544 4293751269 431224311 2610760824 3029440703 417599187 3414286351 1477755836 3620415945 222178182 1589721524 438316251 3441242607 1285863572 221822830 572427667 2421967921 3662010552 286862426 515718918 2958743583 1792648901 1667529605

[test]
name: shuffle uint2 uint16
global_size: 8 0 0
kernel_name: test_shuffle_uint2_uint16
arg_out: 0 buffer uint16[8] 13292 13292 57165 57165 13292 57165 13292 13292 13292 13292 57165 57165 13292 57165 13292 57165 45820 48847 45820 48847 48847 48847 48847 45820 45820 48847 48847 48847 45820 48847 45820 48847 43002 43002 47576 43002 47576 47576 47576 43002 43002 43002 47576 47576 47576 47576 43002 47576 50636 50636 50636 50636 50636 28178 50636 28178 28178 50636 50636 50636 50636 50636 28178 50636 56568 56568 56568 18554 18554 56568 18554 56568 56568 18554 18554 18554 56568 18554 18554 18554 63649 59703 59703 59703 63649 63649 63649 63649 59703 59703 59703 63649 63649 59703 59703 63649 61274 61274 61274 64682 64682 61274 61274 61274 64682 64682 61274 61274 64682 64682 61274 64682 7965 7965 7965 7965 43548 43548 43548 43548 7965 43548 7965 43548 7965 43548 7965 7965
arg_in:  1 buffer uint2[8] 57165 13292 48847 45820 43002 47576 50636 28178 18554 56568 59703 63649 61274 64682 43548 7965
arg_in:  2 buffer uint16[8] 3649632403 548526927 3546909408 1801945152 4283650705 1369084962 634650109 2167071639 1377545909 3823500073 4112987410 498194982 572450471 2415345690 256312505 3603270994 2997001815 183744754 1603889535 1196059492 3006814084 207142572 3771705182 1131783435 2067241639 3486304658 1993410842 3587112476 782086475 3411513044 1595866617 4079162908 1149726122 421335470 4060296031 3817758888 32766479 2083755365 3321614887 3441241590 2675310704 185018282 2014630943 1698740115 1198311011 3701005977 2007144660 676829911 518998622 2901194832 2758803412 1499795576 531703196 4183130905 1276786776 3113632741 2289685009 3037616728 616112902 2247562216 1811242502 2000714236 2777509497 2851823756 3699080407 960645407 297743175 3013208278 3275053982 1620603271 622825922 3384971239 2451934009 1954418068 3572963942 2674397502 382792727 266908658 367055346 1092803504 2757726751 4291397548 2479286502 3922170282 1836898441 3107985169 2461055693 2181644925 1066364704 941993650 2372976752 1882474679 1507145737 2283166932 2192756176 1194118509 643430920 3196724148 37617222 589408901 897066957 245602648 173465702 185677132 2750434059 456355769 4137456566 4178949506 141565923 1557501987 2394993236 1996043463 2980439415 450180157 375895027 1848377865 2446436086 830971576 2560743274 2201783072 1003597901 1829304078 2591173541 20593914 1345567689 1074012504 4147118105 754226923

[test]
name: shuffle uint4 uint2
global_size: 8 0 0
kernel_name: test_shuffle_uint4_uint2
arg_out: 0 buffer uint2[8] 11989 11989 29010 47182 9507 49673 63528 36553 26579 57188 1933 42745 51348 37204 20717 29077
arg_in:  1 buffer uint4[8] 40882 5650 11989 2423 29010 47182 55142 25958 9507 49673 23494 16476 26506 36553 54826 63528 57188 26579 10628 6620 41724 42745 1933 62440 51348 37204 32244 61980 20717 29077 47817 23753
arg_in:  2 buffer uint2[8] 3177938158 1463680162 4201899140 1554406733 4202303184 3482535953 2771714459 882710205 936857441 3931792584 963218966 3681030393 1408176424 1736799701 862507408 4191728001

[test]
name: shuffle uint4 uint4
global_size: 8 0 0
kernel_name: test_shuffle_uint4_uint4
arg_out: 0 buffer uint4[8] 27401 26206 11888 27401 56508 32684 30525 30525 24171 24171 24171 29509 36233 44121 31184 12262 17443 2530 17443 2530 9725 9725 46670 30776 36715 64176 36715 36715 61659 61659 24375 57394
arg_in:  1 buffer uint4[8] 11888 26206 27401 60523 30525 32684 21378 56508 10547 29509 24171 59880 12262 31184 44121 36233 3894 17443 2530 23909 9725 7599 30776 46670 59848 53263 64176 36715 24375 40113 61659 57394
arg_in:  2 buffer uint4[8] 2644871826 2748663901 2683987884 770330082 536822303 3814650741 451851632 763243864 71147934 2182496510 4021917346 2286921109 3634893327 2903528818 1069040413 2034844264 696551557 3999409502 644752989 2057269282 2430720956 172242620 44614459 512737450 4207347815 3309015034 1129282903 1785912559 1176410274 2850511986 3690603936 315506391

[test]
name: shuffle uint4 uint8
global_size: 8 0 0
kernel_name: test_shuffle_uint4_uint8
arg_out: 0 buffer uint8[8] 52809 6734 30239 45525 30239 30239 52809 30239 37453 60880 37453 60880 37453 49949 49949 842 3415 16730 41671 3415 12720 12720 3415 16730 429 429 16410 49191 37915 16410 37915 429 39721 48266 59874 59874 24309 59874 24309 24309 16041 36048 16041 18797 16041 16041 18797 36048 38944 38944 3157 31053 31053 3157 3157 3157 53673 7116 50509 7116 53673 53673 7116 56404
arg_in:  1 buffer uint4[8] 52809 6734 45525 30239 37453 49949 842 60880 41671 16730 12720 3415 49191 16410 37915 429 48266 39721 59874 24309 16041 36048 18797 63001 38944 3157 14637 31053 56404 53673 7116 50509
arg_in:  2 buffer uint8[8] 2728626704 271721021 2387985455 3780240162 666913635 2048046811 3374038272 3565620079 3637337012 1216023247 233977160 3448797267 985134360 3872307705 3100059493 4183211582 3916472915 1577285685 1817576760 4253605559 3292600294 2040300270 3475378971 3375215189 2621028259 4219175639 336885849 1477956416 2836744542 2719247509 1923612646 3509010691 393909045 2544859964 1622157282 3389789538 624261771 2146320930 4165699047 1466203607 2206991820 1688154457 1363145656 295149998 2696765572 3983924016 1760827762 4017050357 2293850520 833764904 4071393725 3274894643 2966058743 3400997729 1550341101 2582368149 460482141 482638 1402154451 3815481266 1036556865 4006321709 1626777878 487304200

[test]
name: shuffle uint4 uint16
global_size: 8 0 0
kernel_name: test_shuffle_uint4_uint16
arg_out: 0 buffer uint16[8] 14152 14152 14152 8017 10521 10521 8017 14152 10521 14152 14152 14152 8017 60123 14152 14152 57090 46623 30179 57090 35557 35557 35557 46623 30179 46623 57090 30179 30179 35557 35557 30179 2429 49667 17697 17697 6051 17697 2429 2429 2429 17697 2429 6051 2429 2429 2429 6051 42350 58009 58009 19494 58009 58009 42350 28233 19494 19494 19494 42350 58009 58009 58009 58009 37678 5969 37678 39869 2102 2102 37678 39869 39869 39869 37678 5969 39869 37678 37678 39869 30113 13078 10151 30113 10151 13078 30113 10151 56194 13078 56194 30113 10151 10151 10151 10151 44452 44024 8071 44024 8071 8071 44024 14084 44024 44024 44024 8071 44024 44452 44024 44452 61186 36474 2931 61186 61186 2931 61186 36474 61186 43622 2931 36474 36474 36474 43622 61186
arg_in:  1 buffer uint4[8] 14152 8017 60123 10521 46623 30179 57090 35557 6051 2429 17697 49667 28233 58009 19494 42350 37678 39869 5969 2102 10151 30113 13078 56194 8071 44024 14084 44452 36474 43622 61186 2931
arg_in:  2 buffer uint16[8] 2392929280 1407295620 3797145872 3937741825 2955308171 568989083 3885408889 1615614628 2270793155 2178800716 3095457208 4187029968 2940755577 2369159114 2477889532 802252440 3959161430 964255372 428385865 3158523538 3442113347 2793197887 2514594887 2293555744 4275863349 3179316596 272726558 3585665473 684183365 2704437223 2554672691 2628560229 2617270113 2658925067 541258386 2627566110 1759524332 1059718790 782594225 126322405 1191658501 2130754282 1944266597 290631744 493118225 3804483437 390100145 1580958328 3728918911 1690022189 3545100337 1298731534 2152876297 1582368685 954026619 3417801848 1626601482 451280778 1193571006 1768926947 3817442465 3259418893 2015259237 2144420325 1823492676 326622282 1418630356 478144369 3650860871 3382142123 702069184 1062542801 3982933861 1092794797 1264142756 129749514 3169002601 1447825568 2725055996 3975115801 199703705 315808114 3093149472 1471690229 3506603268 2286480370 1343093781 3002563380 668835103 3600849054 3318877459 280685065 2565841092 3821115032 1052405224 3393493932 3706511311 2547894329 3627669936 2714407105 2754050864 133225000 1128257505 1555971706 1090918077 2063259305 1150825937 1362912568 3681595761 1342661407 280016845 1773056523 2410420018 28557308 682609263 3095196130 1512231994 2167840407 569973258 3576789492 2558646 3011116173 2395620583 1674272480 1358276000 3728754888 3827550393 94306734

[test]
name: shuffle uint8 uint2
global_size: 8 0 0
kernel_name: test_shuffle_uint8_uint2
arg_out: 0 buffer uint2[8] 36039 36039 60024 11985 57701 58890 40124 9177 16896 16896 303 215 1055 6503 48268 48268
arg_in:  1 buffer uint8[8] 59307 31335 36039 3167 43642 46669 39567 32006 43290 65326 23074 11985 5479 40491 28470 60024 57701 17055 3246 39972 23216 15195 54660 58890 57023 9177 16223 40124 17822 8325 26417 38417 20732 5796 32957 16896 59145 26620 32176 9364 56356 215 43745 303 35458 41833 24970 65167 39652 52776 49558 58838 11945 6503 34228 1055 58932 31506 59542 31238 48268 40351 65053 28971
arg_in:  2 buffer uint2[8] 351446186 193642866 905619063 1805526523 208378176 2967101711 1307578219 564832161 4060293955 3309226099 326442331 2800001833 1869005759 155395725 4287334692 2161781220

[test]
name: shuffle uint8 uint4
global_size: 8 0 0
kernel_name: test_shuffle_uint8_uint4
arg_out: 0 buffer uint4[8] 29739 42809 13500 53392 43129 28014 19099 28014 34631 34039 34631 59564 55869 47357 37372 55869 2012 23582 32843 17424 24484 40834 14098 48781 34598 19599 34598 19599 23196 11748 55205 26567
arg_in:  1 buffer uint8[8] 53392 23834 29739 42809 5496 48671 13500 13317 28014 44523 64302 43129 486 19099 27769 39070 47714 34039 14491 48574 1476 59564 34631 10136 37372 16338 47357 59707 1596 10139 55869 22142 2012 43520 60026 62603 32843 23582 4724 17424 48781 9013 46018 25386 40834 24484 14098 42874 21344 19599 64623 19732 34598 60167 37371 59502 55205 23196 54900 51937 26567 11748 12076 23126
arg_in:  2 buffer uint4[8] 125082730 3521889395 1382965294 3111381792 66971899 1442389840 2390751997 3867429984 3475269934 483290521 169328310 1505950149 1634990814 1627569058 2016518008 1768255430 521038016 2723034605 2942578204 1305061959 2513092141 1690325860 3290877206 3381587176 4206831748 468721553 3451948956 2067963753 2615163105 1429462797 2537611792 2149324828

[test]
name: shuffle uint8 uint8
global_size: 8 0 0
kernel_name: test_shuffle_uint8_uint8
arg_out: 0 buffer uint8[8] 51853 12911 23852 51853 62245 62245 23852 23852 44962 20870 44962 20870 44962 422 44962 29356 62454 21012 62454 39863 42586 59743 62454 42586 28649 14446 29008 23098 30132 47345 14446 34830 20342 47811 21953 53653 36151 4818 21953 36151 24362 62002 25523 51126 51126 56402 62352 56402 23002 60815 48371 631 23002 58270 58270 631 45708 18215 44336 36355 45708 11506 11648 18215
arg_in:  1 buffer uint8[8] 23852 6718 46817 62245 37311 12911 20251 51853 29356 40983 16932 422 20870 44962 6485 35292 50231 52234 39863 62454 21012 59743 42586 62010 29008 28649 23098 14446 685 47345 30132 34830 24451 36151 4818 50460 21953 20342 53653 47811 62002 9328 56402 25523 24362 37669 51126 62352 59358 23002 44091 50033 60815 48371 631 58270 44336 45708 36355 11506 11648 18215 46151 13396
arg_in:  2 buffer uint8[8] 576842831 2996399981 174758880 1197928903 2978574067 2638488083 2234400584 2339014336 686992373 2906852884 3197162277 3518171428 1615730077 126961803 3599637061 167518272 1700062307 348313476 4020523107 651619378 3940826198 3516054013 2536462659 4222822510 974536457 2758275611 1199609912 3554213458 1088079662 4142301237 3078196675 3886338807 2166817221 4174794503 2575827300 989983622 3928253657 2140865682 3465225716 919649241 576102660 104820248 2488506531 4246073798 1854426998 3972134714 2474282039 3784712058 190326377 1037063740 792847445 1856238606 2838182793 3698739783 2484463919 1248514206 235820625 2916665429 1369236336 1161012410 528453681 1252501499 3754346396 1040137933

[test]
name: shuffle uint8 uint16
global_size: 8 0 0
kernel_name: test_shuffle_uint8_uint16
arg_out: 0 buffer uint16[8] 27555 49214 27555 2850 34086 58230 47496 49214 33420 58230 27555 49214 47496 49214 49214 2850 49272 9445 49272 2799 8590 8590 7356 47657 9445 7356 9445 7356 13289 64625 8590 8590 36831 215 6599 29482 29482 52781 46559 6599 29482 1488 215 46559 215 215 46559 1488 8003 969 8833 13040 969 969 8833 61837 13040 61837 8003 61837 44170 13040 54573 48821 58241 25147 57548 57548 24306 62717 9769 9769 45094 62717 57548 20491 57548 45094 24306 57548 34274 34274 65329 62499 65329 55309 55309 42898 63313 34274 55309 42898 42898 42996 42898 42996 57554 19840 52074 15882 47277 52074 29769 57554 47277 14331 19840 29769 48217 52074 47277 19840 64131 27891 27891 60773 52227 41161 13351 52227 14172 13351 41161 27891 64131 27891 64131 60773
arg_in:  1 buffer uint8[8] 1801 49214 58230 27555 47496 34086 33420 2850 9445 47657 7356 64625 49272 2799 8590 13289 44426 215 6599 52781 46559 36831 29482 1488 61837 44170 969 48821 8003 8833 54573 13040 24306 20491 58241 57548 25147 9769 62717 45094 34274 55309 63313 42996 62499 42898 65329 4171 47277 48217 57554 15882 19840 52074 14331 29769 52227 34283 60773 41161 13351 27891 64131 14172
arg_in:  2 buffer uint16[8] 1113405795 1245623513 4154621875 251684647 1438602709 1039662698 2934057276 2835394145 2448115222 230965842 3916812395 10918553 134363724 4088259801 882599081 504106471 1370916876 2547666672 4041161772 1670977253 3073566662 1749786918 4082988874 918200841 278811968 943213818 1032231104 760956194 3793537119 687108683 2257452366 1521076606 4237345813 2417700865 3488222962 2236050110 1450472894 824103331 3106391020 34164258 1784658902 144626591 1907806849 1523810884 2498406009 1146204665 4158154620 2899670487 15694332 3243185722 883017645 1308582727 796560898 2576164714 4250315741 744524864 3299566047 1361949312 1043780780 1653573536 1601521929 3698573783 2888662862 1124600627 914889794 3437147076 4285814779 892548923 2139342568 3968718702 93786357 960299589 3575563727 487015470 3535717139 1409377345 414343491 43916351 2364767344 514360771 29138504 887165240 2654496054 4101345724 4232105086 893984273 3503143697 2344810229 1185730018 76048976 3430334761 1161047445 4077749501 2097714131 2982517261 2937977819 3656967842 347685076 2157663589 1390171763 2561523008 364856637 1716689663 2252620650 1868306600 1223318102 52371676 3061124079 200243129 445216789 3428042808 3209298708 1671804702 621254693 3972222245 2413997298 1482206728 2186249483 3515157788 669825088 3070981383 2560164852 2686375387 4197389069 2895824462 354770893 4096621086 1072414266

[test]
name: shuffle uint16 uint2
global_size: 8 0 0
kernel_name: test_shuffle_uint16_uint2
arg_out: 0 buffer uint2[8] 566 20578 16396 56085 8263 16541 62642 44400 53179 3759 38275 38275 36861 13552 29682 64213
arg_in:  1 buffer uint16[8] 57179 7497 49803 566 11920 21227 53687 55629 23430 59298 27892 20578 12791 20092 57271 36410 16221 14294 64747 62839 13368 3605 56085 19530 24050 32031 51347 58491 29199 16396 52004 38176 42338 16891 60261 30916 24532 25783 8263 21969 6436 51041 63938 39937 28972 16541 36728 52244 11575 34532 49242 62642 13924 11021 3832 10375 46107 44400 6953 56841 24618 26438 879 3896 31841 6209 55656 50170 29566 26416 3496 17530 15657 48888 31774 53179 38498 8764 2987 3759 14867 2823 53021 1247 38275 37538 32163 19256 41632 27342 2824 18224 29270 29469 43212 39935 38532 15840 50791 839 13552 45543 27129 49748 20500 24701 35122 35874 21906 36861 36527 29831 43109 40485 9722 58578 3837 29682 61217 20418 20736 48745 60795 23668 5357 54088 64213 38045
arg_in:  2 buffer uint2[8] 2286404643 1183309499 3328225197 156048422 3813580998 1661594061 4289742691 3640287737 685442923 288582559 2303164596 367255828 563290077 2282805572 3610511381 3973563806

[test]
name: shuffle uint16 uint4
global_size: 8 0 0
kernel_name: test_shuffle_uint16_uint4
arg_out: 0 buffer uint4[8] 59000 17909 22314 65281 405 7914 1139 50217 21766 9620 9620 55518 7107 2730 49261 5323 51873 9092 51628 21943 51459 41952 3969 7029 41125 7223 29340 7223 39972 102 38632 30994
arg_in:  1 buffer uint16[8] 32459 17909 45560 4004 43367 59000 30590 63533 30893 65281 22314 27224 1437 1551 3298 32503 7914 32695 59756 37082 59645 25019 26855 48331 40692 50217 58705 1626 1139 30232 52428 405 22287 6803 21766 40629 17751 9798 54888 55518 49688 20525 9620 64539 29310 20104 6257 48663 62049 12124 49261 7107 51328 5323 60228 9315 55855 5465 2730 33674 14416 50554 56693 51503 55185 4654 13579 21943 57234 11422 9092 60018 6052 51873 48914 6262 51628 32840 25395 19432 30518 35712 5946 504 1517 7029 41952 3071 3969 56631 50895 57482 57249 51459 42721 35912 20684 38230 36136 27862 38596 26554 65509 34839 14588 15219 30393 29340 4411 13618 41125 7223 51221 38632 39972 58829 36988 30994 3823 25227 22389 102 55754 22451 63741 42169 49731 49706
arg_in:  2 buffer uint4[8] 3673545173 2208784177 3832721242 27298553 169128703 2167339952 3447210604 868934137 1735675362 3193075930 3284389354 619671959 2472950563 728098842 4163107458 2231834357 1804750249 2689588358 1376364396 283023859 2996744941 4155288150 236344504 1804902597 2283970462 2087295167 3075973403 38815103 1910834562 1702242569 2002078641 2995485061

[test]
name: shuffle uint16 uint8
global_size: 8 0 0
kernel_name: test_shuffle_uint16_uint8
arg_out: 0 buffer uint8[8] 14141 51535 19038 14141 51535 51535 9923 9923 59412 43901 43788 22571 46284 43901 22571 11713 45411 4505 17547 23986 4505 46271 21017 17547 36176 18266 28159 36176 58538 12447 49981 24091 26374 62432 49546 48190 50408 29654 37855 50408 24122 52610 53368 14263 24122 18511 44692 18511 65446 42476 65446 42476 45975 4378 52113 38304 9313 1013 9313 59389 35822 1013 1013 675
arg_in:  1 buffer uint16[8] 7051 50217 50593 55554 42853 14141 49827 1275 436 51535 19038 11920 9923 56800 4714 28408 16692 25818 46284 59412 59525 51072 63503 43901 35385 43788 7555 32540 11713 22571 49874 50298 61581 23986 4505 13701 21017 34863 48150 3912 17547 28373 37123 7873 34683 46271 45411 37299 21002 12869 58538 14401 28159 24091 36176 12447 61565 48377 49981 5394 32885 18266 13838 13792 45133 37855 62432 50408 33465 51037 29441 49546 26374 3175 31313 12569 13831 48190 29654 26534 26352 44692 18511 33487 10105 28202 5361 53368 54771 4781 4316 52878 24122 14263 52610 32294 42476 52113 65446 37133 61611 25329 56145 38304 29842 3176 35855 7730 30883 4378 605 45975 675 2846 12706 59389 20157 35741 22571 27316 56896 8386 37670 35822 36605 25209 1013 9313
arg_in:  2 buffer uint8[8] 3330768693 2698226985 248783242 229497557 3981755673 4242501673 2667696012 4293326236 2744789171 584227543 2242365641 3207014157 3396377074 2056279511 1112847149 1532137052 3506602142 1016716834 4150658152 302914513 526493858 2051614957 924206772 1176832712 2586866358 373095965 4047629764 2041337014 3589282258 4285262999 784988522 4241437989 251570632 4248051138 3093977575 2001256461 2782540771 4290355854 2991981841 792581203 3354769388 1213856206 529754375 596379741 3629383612 374668882 1688392337 377923810 2120113954 1536543648 3334217234 2832595296 550070671 2396970685 2685988705 725416695 2053124015 356068206 3247102751 3026874339 3007637995 4206557534 4178313678 638885936

[test]
name: shuffle uint16 uint16
global_size: 8 0 0
kernel_name: test_shuffle_uint16_uint16
arg_out: 0 buffer uint16[8] 44635 39351 53406 34268 48749 48749 43726 52391 14662 43726 63457 53406 34268 52391 48249 867 25409 7768 41256 46176 39981 6708 25409 29989 10366 53901 46176 53901 38703 29996 29297 7768 19433 17850 19433 17850 44298 44298 44298 54785 13890 12583 31568 49214 44298 25695 46184 49214 14033 14033 14033 43661 46103 35326 20975 14033 63891 28651 46103 43452 63891 55795 36952 35326 40979 9540 2081 59179 2081 58486 2081 10894 50063 40367 63773 9540 59179 58486 40979 2907 24330 16767 62923 8503 53002 8503 34065 9089 48579 54070 37661 9089 62923 62706 16767 62706 15494 15890 47636 52917 6121 40580 13873 14308 59661 15494 15890 15494 36608 15890 36608 48234 36364 38532 6625 6625 43293 48455 48455 31110 38532 31110 42324 47164 62643 42324 24929 31110
arg_in:  1 buffer uint16[8] 23049 53406 43726 14662 44635 35432 48249 867 39351 63457 52391 32808 57302 11132 34268 48749 6708 38703 10366 25409 1196 29297 29996 29989 46176 39981 54157 6100 52447 7768 41256 53901 18295 6296 17850 44298 46184 2567 12808 12583 13890 25695 18472 16158 31568 19433 49214 54785 30866 18006 43661 36952 35326 63891 14033 15827 46103 45917 20732 20975 55795 21966 28651 43452 59179 9540 44861 40979 51870 40367 17806 33636 50063 2907 10894 3291 63773 16149 58486 2081 62706 48579 9089 17821 34065 53002 16767 37661 54070 8503 24330 21352 41672 23327 43324 62923 59661 36608 10891 11718 21319 15494 13873 6121 52917 14308 13644 15890 40580 27401 48234 47636 43689 42324 24929 31110 38934 36364 48455 6625 62643 24350 43293 47164 38532 41596 52963 12839
arg_in:  2 buffer uint16[8] 4172602836 2712714264 4189958673 406795646 1101585407 2962606959 1458631442 3851228922 827291619 3960830898 3339100425 1108470689 1404673742 1070649018 356455814 3908450551 3246935251 2377508333 3609857038 3233995784 306000633 4151922256 1926773859 2908701975 416608498 4083302655 1020654952 2023725951 3951623681 1717362502 959925861 3889047405 2692219997 3561825858 4047345661 2156591570 758828291 1897118163 4061557251 1569090591 1113747016 1784140471 3709744428 348684622 3987324131 2933941513 125933524 222986798 234477110 2369209766 566084582 240140514 1804504712 879838724 1283199787 3348966006 2319615381 2321796222 45899128 4158403471 688803605 928331308 958193571 3136354756 1338161539 154037745 202987871 2669875584 3870904431 1105214894 1840550383 2031514746 3805446232 4212235445 544826460 1846130257 390157200 4171072062 3700275267 2075934553 3334414250 1907243014 4136737967 1000987801 169704709 470890281 1180666052 4003800082 4271840385 2714765496 2063617031 4095896578 3359955567 4249876944 2330410790 1718616000 3190745413 3139696075 3756971167 527712936 975487127 2563342876 20152454 1683123065 2101952272 3761474469 4672827 1087581669 325371793 1336846827 2437656129 870758974 3525342245 4266144268 1019616839 2550085351 366430778 449992694 4240975318 694812083 3308618252 1695947283 67876353 936208715 2368630568 1374095377 496346722 845286723
!*/
kernel void test_shuffle_uint2_uint2(global uint* out, global uint* in, global uint* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint2_uint4(global uint* out, global uint* in, global uint* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint2_uint8(global uint* out, global uint* in, global uint* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint2_uint16(global uint* out, global uint* in, global uint* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint4_uint2(global uint* out, global uint* in, global uint* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint4_uint4(global uint* out, global uint* in, global uint* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint4_uint8(global uint* out, global uint* in, global uint* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint4_uint16(global uint* out, global uint* in, global uint* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint8_uint2(global uint* out, global uint* in, global uint* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint8_uint4(global uint* out, global uint* in, global uint* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint8_uint8(global uint* out, global uint* in, global uint* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint8_uint16(global uint* out, global uint* in, global uint* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint16_uint2(global uint* out, global uint* in, global uint* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint16_uint4(global uint* out, global uint* in, global uint* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint16_uint8(global uint* out, global uint* in, global uint* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uint16_uint16(global uint* out, global uint* in, global uint* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
