/*!
[config]
name: shuffle uchar uchar
dimensions: 1

[test]
name: shuffle uchar2 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_uchar2_uchar2
arg_out: 0 buffer uchar2[8] 64642 64642 11267 11267 10714 1527 1382 31854 51887 51887 36148 36148 51943 51943 10044 10044
arg_in:  1 buffer uchar2[8] 64642 13505 16616 11267 1527 10714 1382 31854 51887 59032 36148 54060 45258 51943 33849 10044
arg_in:  2 buffer uchar2[8] 80 124 107 23 27 34 228 127 230 68 148 6 75 179 183 187

[test]
name: shuffle uchar2 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_uchar2_uchar4
arg_out: 0 buffer uchar4[8] 38974 38974 33227 38974 17513 17513 17513 17513 26162 26162 26162 26162 52023 52023 44482 52023 39507 62066 39507 39507 57720 18261 18261 18261 62317 38784 62317 62317 43499 43499 43499 45744
arg_in:  1 buffer uchar2[8] 38974 33227 17513 2949 62842 26162 52023 44482 62066 39507 57720 18261 62317 38784 43499 45744
arg_in:  2 buffer uchar4[8] 194 202 205 152 120 96 220 110 135 85 71 243 174 132 221 154 233 26 99 131 234 35 9 103 52 131 0 110 94 88 184 137

[test]
name: shuffle uchar2 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_uchar2_uchar8
arg_out: 0 buffer uchar8[8] 2161 1181 1181 1181 1181 2161 1181 2161 2706 21951 2706 2706 21951 21951 21951 2706 30950 30950 40685 40685 30950 40685 30950 30950 51517 65510 51517 51517 51517 65510 51517 65510 47615 46493 46493 47615 46493 46493 46493 46493 11509 11509 56614 56614 56614 11509 11509 56614 3241 15117 3241 15117 15117 15117 15117 15117 1870 22569 22569 22569 1870 22569 1870 22569
arg_in:  1 buffer uchar2[8] 1181 2161 2706 21951 40685 30950 51517 65510 47615 46493 11509 56614 15117 3241 22569 1870
arg_in:  2 buffer uchar8[8] 139 180 106 196 100 163 94 91 254 77 208 116 1 27 223 16 69 43 214 158 169 96 31 173 70 161 140 248 246 169 138 39 234 81 55 132 207 229 215 81 214 64 57 57 95 246 150 51 217 134 141 56 182 38 4 20 7 70 62 208 197 246 13 160

[test]
name: shuffle uchar2 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_uchar2_uchar16
arg_out: 0 buffer uchar16[8] 18407 11151 18407 18407 11151 18407 11151 11151 11151 18407 18407 18407 18407 11151 11151 11151 29506 51385 51385 51385 51385 29506 29506 51385 29506 51385 51385 51385 51385 29506 51385 29506 6384 6384 27425 27425 27425 6384 6384 6384 27425 6384 27425 6384 27425 6384 6384 27425 54056 3618 3618 3618 54056 3618 54056 3618 54056 54056 54056 3618 3618 54056 54056 54056 52349 6182 52349 52349 52349 52349 52349 52349 6182 6182 6182 6182 6182 52349 6182 52349 17365 38954 17365 17365 38954 17365 38954 17365 17365 17365 17365 17365 17365 17365 38954 17365 53047 53047 53047 53047 53047 53306 53306 53306 53047 53047 53306 53047 53047 53306 53047 53306 58417 58417 58417 7179 7179 58417 7179 58417 58417 7179 7179 7179 7179 58417 58417 7179
arg_in:  1 buffer uchar2[8] 18407 11151 51385 29506 6384 27425 54056 3618 6182 52349 17365 38954 53306 53047 7179 58417
arg_in:  2 buffer uchar16[8] 74 65 106 86 45 240 147 137 129 108 206 4 26 35 5 145 79 72 68 58 170 3 165 74 169 32 44 190 106 129 230 169 248 240 43 41 161 224 196 206 245 218 37 112 73 204 160 75 36 73 79 17 196 59 34 137 154 180 244 205 163 238 176 118 19 196 187 175 3 127 39 243 56 188 222 124 12 57 20 183 20 187 92 174 137 248 247 214 0 120 244 176 82 22 245 84 197 147 247 109 13 232 88 226 161 167 220 73 219 200 121 188 195 151 123 108 130 123 190 233 121 172 74 164 124 73 131 88

[test]
name: shuffle uchar4 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_uchar4_uchar2
arg_out: 0 buffer uchar2[8] 62891 26845 46915 23792 65107 38501 35839 46392 25177 41330 21437 21437 63758 32879 50510 50510
arg_in:  1 buffer uchar4[8] 15039 58575 62891 26845 23792 46915 32646 11638 65107 27563 38501 51076 35839 26481 46392 53308 41330 2718 5678 25177 25821 21437 60074 10608 32879 37718 63758 55021 41180 50510 7137 15077
arg_in:  2 buffer uchar2[8] 30 171 81 136 224 158 212 246 191 112 45 41 46 8 169 49

[test]
name: shuffle uchar4 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_uchar4_uchar4
arg_out: 0 buffer uchar4[8] 5406 2647 5406 30792 51300 11990 51300 11990 38729 36401 38729 25930 29624 17052 24078 29624 33800 65012 65012 65012 19040 19040 10280 10280 23854 26066 17871 17871 16540 62880 2253 46065
arg_in:  1 buffer uchar4[8] 30792 2647 5406 12514 40906 11990 51300 16828 25930 36401 38729 20807 24078 29624 17944 17052 29925 33800 65012 39778 19040 35561 26795 10280 17871 53340 23854 26066 2253 46065 62880 16540
arg_in:  2 buffer uchar4[8] 138 41 142 112 2 73 106 1 214 65 74 248 21 163 112 89 233 162 226 118 140 96 51 179 250 139 180 144 111 146 200 33

[test]
name: shuffle uchar4 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_uchar4_uchar8
arg_out: 0 buffer uchar8[8] 49226 14915 14915 49226 22963 12478 12478 12478 18150 60400 18150 55385 18150 60400 55385 55385 23283 23283 8969 23283 8969 34288 23283 23283 57736 42867 49305 34742 57736 57736 57736 57736 51120 6719 50325 45131 45131 6719 45131 51120 19915 16497 16497 16497 16497 19915 40028 4559 54507 54507 54507 54507 54507 27542 54507 58153 26666 51305 51305 11498 12788 26666 12788 11498
arg_in:  1 buffer uchar4[8] 22963 49226 14915 12478 18150 60400 18898 55385 34288 25569 23283 8969 34742 57736 42867 49305 6719 45131 51120 50325 16497 19915 4559 40028 58153 54507 27542 61434 26666 51305 11498 12788
arg_in:  2 buffer uchar8[8] 205 62 238 85 16 103 119 123 48 193 208 35 108 101 111 251 46 98 51 66 99 220 202 134 241 14 179 176 105 17 101 225 110 108 3 73 121 232 241 46 141 148 200 168 152 45 63 254 189 45 117 69 209 122 9 248 144 73 189 74 59 164 163 38

[test]
name: shuffle uchar4 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_uchar4_uchar16
arg_out: 0 buffer uchar16[8] 26244 38691 25115 25115 25115 38691 47119 26244 25115 38691 47119 38691 25115 26244 25115 26244 55554 51742 4650 49656 49656 4650 51742 51742 51742 4650 55554 51742 4650 55554 51742 49656 10106 18707 37721 10106 57786 10106 10106 18707 37721 37721 37721 37721 18707 57786 57786 10106 24645 45865 45865 24645 20324 45865 64130 24645 64130 64130 20324 20324 45865 64130 24645 64130 20361 34717 20361 56281 56281 19477 19477 19477 56281 56281 19477 34717 34717 56281 34717 20361 20680 15305 18257 15305 27734 15305 18257 20680 18257 20680 15305 27734 18257 20680 15305 15305 5021 5021 5021 23523 55550 23523 55550 23523 55550 5021 5021 5021 55550 23523 57860 55550 11178 48060 61629 11178 11178 39174 48060 48060 61629 48060 61629 61629 61629 61629 61629 48060
arg_in:  1 buffer uchar4[8] 47119 25115 26244 38691 55554 49656 51742 4650 18707 57786 10106 37721 20324 24645 64130 45865 20361 19477 56281 34717 27734 15305 20680 18257 57860 55550 23523 5021 39174 61629 11178 48060
arg_in:  2 buffer uchar16[8] 50 51 253 125 21 15 44 238 133 131 192 83 121 62 81 254 124 6 115 73 73 79 90 34 54 143 48 138 239 132 214 21 38 72 231 30 177 170 130 208 199 11 151 123 108 45 73 126 109 231 163 5 128 215 66 169 198 102 152 48 227 138 121 134 156 43 188 74 230 13 197 229 26 146 217 239 99 82 3 136 54 197 131 101 248 241 135 206 67 254 137 88 7 106 173 133 55 15 223 158 165 98 169 210 65 63 127 183 241 226 88 181 218 223 209 186 54 44 231 67 49 7 197 245 121 201 49 215

[test]
name: shuffle uchar8 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_uchar8_uchar2
arg_out: 0 buffer uchar2[8] 38840 38840 18933 12211 13533 60453 620 27226 32222 21702 60980 57652 27349 10861 55171 48236
arg_in:  1 buffer uchar8[8] 7508 38840 22337 39501 36511 16308 44220 17 18933 199 12211 44473 44267 59288 26004 31819 49084 60453 34278 22440 58946 52471 1946 13533 620 14042 43205 27226 40956 15078 39483 12127 13416 37839 7985 32222 14583 21567 58270 21702 21720 60980 33794 21994 57652 3572 49612 2140 16082 13165 40606 10861 49995 27349 33618 50310 30084 60701 48236 24454 55766 1096 55171 30632
arg_in:  2 buffer uchar2[8] 145 177 160 242 239 129 176 139 83 95 113 236 165 11 190 242

[test]
name: shuffle uchar8 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_uchar8_uchar4
arg_out: 0 buffer uchar4[8] 32400 37528 32400 25917 17418 54256 17418 57784 1561 64271 17239 53077 62544 44922 56108 10317 54903 25910 8415 58835 37117 52499 30435 49934 20186 63584 57006 51758 39853 61562 22272 39580
arg_in:  1 buffer uchar8[8] 37528 32400 2754 13358 60199 23883 25917 50944 43485 17418 4315 64427 54256 61210 57784 48200 1561 25873 26742 8928 64271 17239 11502 53077 36561 27244 10317 56108 2991 62544 44922 376 25910 38687 54903 58835 37165 8415 5097 11281 45368 49665 54068 49934 30435 37117 63531 52499 86 57006 37818 63584 20186 52308 56562 51758 39580 61562 48453 39853 54885 22272 45437 4883
arg_in:  2 buffer uchar4[8] 217 224 225 158 33 116 169 118 192 12 173 79 93 254 35 50 90 16 117 91 5 223 220 91 148 203 225 159 19 81 245 80

[test]
name: shuffle uchar8 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_uchar8_uchar8
arg_out: 0 buffer uchar8[8] 13973 39558 37070 51273 51273 4234 62075 15298 7844 59609 60464 7844 35022 43492 8888 8888 5591 11984 8918 49494 11984 40548 5300 5300 5649 7602 48345 40479 153 4337 48345 153 61568 20425 18252 22182 10649 18252 18252 18252 13121 13121 56732 56732 10070 8561 56732 8561 62073 55329 58416 62073 48825 55329 62073 15090 32520 49563 32520 17039 12354 32520 10583 49563
arg_in:  1 buffer uchar8[8] 13973 15298 62075 37070 40011 39558 51273 4234 35022 43492 60464 8888 7844 38497 28803 59609 40548 26981 49494 8918 55567 5300 5591 11984 48345 926 38612 40479 7602 153 4337 5649 20425 22182 61568 10649 18252 2650 17688 13320 10070 8561 15179 26446 13121 63862 56732 10525 15090 62073 58416 22027 13352 18113 48825 55329 17039 10583 4599 32520 12354 49563 48727 42486
arg_in:  2 buffer uchar8[8] 200 157 123 46 78 207 186 145 180 191 10 4 0 73 131 107 70 95 59 250 247 64 141 133 71 20 88 179 165 102 48 253 74 128 164 97 59 124 180 204 52 140 198 182 16 169 118 201 17 215 138 81 134 23 137 40 171 213 3 136 116 91 129 189

[test]
name: shuffle uchar8 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_uchar8_uchar16
arg_out: 0 buffer uchar16[8] 22407 22407 14864 26115 5587 5587 14864 26115 14864 65198 26115 9692 26115 37376 53478 5587 43174 30697 20799 680 20799 20799 53023 43174 53023 20799 22542 43174 3937 33823 680 43174 25942 4138 45435 4138 4138 47869 24834 4138 59491 45435 24834 45435 25942 47869 4138 4138 62900 54891 50467 54891 15339 29890 47668 29890 62900 54891 2188 50467 2188 50467 29890 62900 51420 24666 64793 20165 64793 56212 21200 21200 1938 51420 54182 1938 51420 21200 54182 51420 33121 33121 39427 39427 20745 290 20745 49974 49974 20745 8279 49974 28137 33121 58292 58292 20214 12942 23117 33634 33634 23117 12942 52157 33634 55204 52157 32806 23117 12942 33634 24193 41303 33686 55619 60830 64289 55619 15724 55619 60830 60830 41303 60830 55619 55619 15724 33686
arg_in:  1 buffer uchar8[8] 14864 22407 65198 26115 9692 53478 37376 5587 33823 680 3937 20799 43174 22542 53023 30697 25942 4138 24834 59491 58935 43876 45435 47869 15339 2188 54891 47668 24385 62900 29890 50467 1938 24666 64793 54182 51420 21200 20165 56212 49974 58292 28137 33121 8279 20745 290 39427 24193 12942 20214 32806 23117 52157 33634 55204 41999 55619 64289 60830 15724 32873 41303 33686
arg_in:  2 buffer uchar16[8] 129 145 192 11 255 103 216 139 208 18 11 212 43 142 13 15 252 199 179 241 227 243 94 12 182 107 157 220 34 112 49 84 232 65 254 161 225 79 250 129 251 174 114 22 184 135 201 49 157 66 71 74 32 174 99 22 13 250 241 39 25 71 238 69 132 41 154 182 66 239 189 21 168 52 51 56 156 157 187 92 3 243 207 207 109 46 213 136 248 221 252 192 74 219 105 217 98 137 36 70 238 164 185 149 230 175 125 83 236 65 174 112 254 79 49 227 162 89 44 161 83 139 182 59 57 193 164 167

[test]
name: shuffle uchar16 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_uchar16_uchar2
arg_out: 0 buffer uchar2[8] 11698 22250 19817 39600 34973 27711 29645 29645 38796 17561 44287 64799 8219 23244 41472 963
arg_in:  1 buffer uchar16[8] 40591 43683 197 24801 39639 24451 22250 20844 62290 31554 10401 34027 13863 6683 49656 11698 51258 60799 63522 18456 18436 7563 14816 19817 15694 52960 12309 36872 10726 13063 28430 39600 52816 22557 59324 34973 44265 22882 52911 34195 23226 21212 11229 27711 46868 59748 11900 43517 55618 39621 60117 7374 18353 45762 22984 65470 29645 30298 8543 16469 57668 56912 13045 47280 29450 15870 42252 17561 26126 31046 41216 65087 45019 63071 35382 38796 2388 23618 35597 25652 14437 40865 57634 22805 14376 6363 59679 49255 55028 41615 44287 29719 43367 64799 18983 3414 63155 18324 183 11016 2454 18129 14337 7203 42091 40872 25400 8219 6280 30114 23244 47165 50176 48255 54883 27499 51398 5195 29224 963 58448 1411 54382 20115 26367 8311 16949 41472
arg_in:  2 buffer uchar2[8] 143 150 231 175 211 251 168 136 155 227 170 205 171 206 143 7

[test]
name: shuffle uchar16 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_uchar16_uchar4
arg_out: 0 buffer uchar4[8] 24951 62563 17014 61200 32521 56888 13090 24076 24705 64001 64001 58194 8166 45018 57042 42554 38920 8586 45202 60057 51060 3116 59529 20931 55204 3494 39036 58285 49311 3631 10804 49311
arg_in:  1 buffer uchar16[8] 28056 61200 39161 52843 56173 17014 23447 62563 24951 22388 25292 10214 35478 21471 24242 63564 15911 63080 32521 56888 24076 15234 7130 5011 11779 12382 18001 19286 27507 47068 47999 13090 12556 49370 64001 16464 43994 26629 29331 58194 37614 12510 18394 54836 12523 24705 17072 23321 34827 36126 42554 22170 58404 44044 13112 11841 51944 1509 8166 24721 45018 57042 32535 43371 56031 16240 43019 8586 63139 64643 38920 32114 50281 7742 45202 43459 22153 11769 36186 60057 814 20931 18512 44269 59529 8861 51060 35623 61370 37123 3819 53015 3116 59720 14587 17278 39397 43195 39036 20388 64120 58285 906 42551 20345 54277 3494 39152 23383 20535 10257 55204 59352 18174 55070 44509 17331 47130 22088 10804 12179 31759 14727 26505 62700 25097 3631 49311
arg_in:  2 buffer uchar4[8] 168 135 181 129 226 19 159 228 221 114 242 7 202 172 109 178 150 83 90 143 102 60 180 193 79 154 130 85 207 14 39 95

[test]
name: shuffle uchar16 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_uchar16_uchar8
arg_out: 0 buffer uchar8[8] 6337 8833 10075 28302 20918 28302 28302 34101 2205 11487 24655 43831 40606 26119 9603 48850 9291 13165 19541 1900 43086 5027 36694 36694 23003 56619 56446 51562 23003 5731 553 1110 28820 46697 22971 53133 28820 22434 26344 53133 42407 25847 64545 59994 27834 26218 44340 25847 36137 29094 29094 16873 54406 50146 21273 65233 29392 14914 39758 10255 52373 29847 10255 21655
arg_in:  1 buffer uchar16[8] 51161 53964 10266 10075 32763 8833 28302 42469 59336 12862 22222 20918 6337 57396 34101 28023 7979 64697 9603 2205 6393 24655 22457 64562 26119 38129 11487 19705 48850 107 43831 40606 29646 39818 1596 54081 46404 9291 43086 36694 45347 13165 39373 19541 46151 5027 1900 52491 1110 56619 30599 56446 60951 38522 553 23003 59546 8853 1794 5731 11913 16693 51562 50287 22971 28820 14091 3907 5359 51708 53133 37091 22434 49845 3447 41791 55045 26344 46697 32251 4226 54420 64545 6251 26211 44340 59994 24122 25847 27834 4676 26218 15621 38490 42407 43247 39944 18859 23658 54406 36137 7243 50146 14484 65233 21273 49806 29094 53742 50744 16873 58007 47532 6030 29847 28288 52373 63731 29392 10255 14554 20091 21655 39758 3692 41830 14914 17197
arg_in:  2 buffer uchar8[8] 92 213 131 6 187 70 22 110 227 138 213 30 127 136 98 172 53 137 251 190 150 29 135 55 183 145 99 174 119 123 102 96 193 62 128 86 177 200 13 22 222 56 130 102 153 43 53 216 180 91 75 62 147 150 89 248 150 126 123 39 244 98 183 218

[test]
name: shuffle uchar16 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_uchar16_uchar16
arg_out: 0 buffer uchar16[8] 18409 18475 13539 37146 37146 35201 18475 52566 40838 13539 63454 16996 13539 8217 16996 46037 6427 6427 30312 14798 14056 51628 60763 55749 5980 38256 14798 4080 38256 14056 6427 38256 19059 19541 19541 54054 29796 38791 19059 21371 21371 44781 14207 19059 44781 24497 32164 19059 13621 41222 13481 43875 62589 62589 27364 43928 13621 64681 5417 62589 43928 64681 13394 32489 43879 44601 44601 43879 5012 59003 8702 8702 33321 33321 33321 34125 5012 8702 44572 33321 44992 2884 26390 15573 46251 31785 2344 51616 26390 51616 2344 26390 51616 26390 2884 46251 37572 31774 56894 12153 38250 29230 12153 10860 12153 38250 18792 10860 6649 47377 25820 38250 1424 6510 8514 28024 8514 12036 60403 1424 21850 20688 36048 50014 60403 36048 59363 48471
arg_in:  1 buffer uchar16[8] 35201 42953 13539 18409 60762 46037 16996 8217 60412 52566 63192 41797 40838 63454 18475 37146 5980 53827 8694 60763 23266 8931 14798 51628 30312 38256 14056 55749 38706 4080 6427 52988 54054 48205 29796 32164 21371 14207 15291 19059 38791 46967 63622 32270 56633 19541 24497 44781 23774 2852 43875 19637 13481 41222 32489 13394 13621 62589 64681 37546 43928 11876 27364 5417 52951 33938 44572 28805 44601 34125 8702 59003 16687 5012 12694 57573 36832 43879 33321 58153 2344 44992 42112 31785 46251 47452 46979 49177 26390 2283 51616 40396 52494 2884 15573 41190 3171 56894 18792 12153 16388 6649 38250 25820 47377 31774 10860 29230 56745 41600 37572 2717 8514 60403 36048 50014 28024 21027 59363 1424 20688 344 21850 6510 12036 48471 7117 29416
arg_in:  2 buffer uchar16[8] 115 254 130 159 191 160 254 25 124 66 109 118 50 71 54 21 46 222 232 230 202 7 163 107 64 153 150 205 25 234 126 201 135 157 61 160 130 136 231 228 52 159 165 39 223 174 3 55 168 53 100 2 9 9 158 236 56 10 255 121 140 154 135 102 205 228 244 157 169 7 150 54 174 46 78 197 233 134 178 142 113 93 232 238 132 243 48 42 88 26 128 184 170 184 29 196 174 89 145 243 22 155 163 138 163 38 178 10 229 88 183 150 135 251 0 228 80 124 177 119 58 24 194 227 193 18 166 13
!*/
kernel void test_shuffle_uchar2_uchar2(global uchar* out, global uchar* in, global uchar* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar2_uchar4(global uchar* out, global uchar* in, global uchar* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar2_uchar8(global uchar* out, global uchar* in, global uchar* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar2_uchar16(global uchar* out, global uchar* in, global uchar* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar4_uchar2(global uchar* out, global uchar* in, global uchar* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar4_uchar4(global uchar* out, global uchar* in, global uchar* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar4_uchar8(global uchar* out, global uchar* in, global uchar* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar4_uchar16(global uchar* out, global uchar* in, global uchar* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar8_uchar2(global uchar* out, global uchar* in, global uchar* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar8_uchar4(global uchar* out, global uchar* in, global uchar* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar8_uchar8(global uchar* out, global uchar* in, global uchar* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar8_uchar16(global uchar* out, global uchar* in, global uchar* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar16_uchar2(global uchar* out, global uchar* in, global uchar* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar16_uchar4(global uchar* out, global uchar* in, global uchar* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar16_uchar8(global uchar* out, global uchar* in, global uchar* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_uchar16_uchar16(global uchar* out, global uchar* in, global uchar* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
