/*!
[config]
name: shuffle short ushort
dimensions: 1

[test]
name: shuffle short2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_short2_ushort2
arg_out: 0 buffer short2[8] 60189 60189 32773 32773 23078 23078 13460 52460 34646 34646 13722 13722 7653 1375 33767 55457
arg_in:  1 buffer short2[8] 1662 60189 32773 27813 23078 60976 13460 52460 7307 34646 13722 17980 7653 1375 33767 55457
arg_in:  2 buffer ushort2[8] 37341 8943 43714 63126 44364 34798 43828 30333 6197 31205 57960 2338 50150 41771 5588 26601

[test]
name: shuffle short2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_short2_ushort4
arg_out: 0 buffer short4[8] 31963 31963 31963 31963 41019 3947 41019 41019 31586 31586 19620 31586 64545 64545 64735 64735 23552 56821 23552 23552 58550 34400 58550 34400 22539 22539 22539 5028 47276 47276 47276 47276
arg_in:  1 buffer short2[8] 14966 31963 3947 41019 19620 31586 64545 64735 56821 23552 58550 34400 22539 5028 47276 38734
arg_in:  2 buffer ushort4[8] 44777 35933 30017 51257 717 7774 13141 17793 43267 21629 2538 5449 21316 20306 10295 18291 19803 24468 53405 50979 2454 48397 37776 45125 2094 31096 1310 48179 48148 44872 11308 48622

[test]
name: shuffle short2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_short2_ushort8
arg_out: 0 buffer short8[8] 47874 47874 8482 47874 8482 8482 47874 47874 53665 24605 24605 53665 53665 53665 53665 53665 33071 47303 47303 33071 47303 47303 47303 33071 19701 27892 27892 19701 19701 19701 19701 19701 24313 17685 24313 17685 17685 17685 17685 17685 14621 41772 14621 14621 41772 41772 14621 41772 12591 21691 12591 21691 12591 21691 21691 12591 33477 33477 33477 46881 46881 33477 33477 33477
arg_in:  1 buffer short2[8] 47874 8482 53665 24605 47303 33071 19701 27892 24313 17685 14621 41772 12591 21691 46881 33477
arg_in:  2 buffer ushort8[8] 61336 34376 58543 24238 51767 54865 47236 12766 41578 19623 34005 23504 44060 58670 10604 49042 48997 35136 46114 19457 54266 27122 26178 20671 60258 55955 32011 206 47916 17888 4042 57814 53630 12415 6844 50899 37931 26125 56475 403 30052 52947 63570 64710 55729 52857 53090 8001 40628 23075 21934 41997 15972 58887 20861 51112 29859 16481 33487 2330 59982 41105 62897 45629

[test]
name: shuffle short2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_short2_ushort16
arg_out: 0 buffer short16[8] 28710 28710 40929 40929 40929 28710 40929 28710 28710 28710 40929 28710 28710 28710 40929 40929 3744 64379 3744 64379 3744 64379 3744 3744 64379 64379 64379 3744 64379 3744 64379 64379 35553 35553 35553 18010 35553 18010 35553 18010 18010 18010 35553 35553 18010 18010 35553 35553 27133 27133 27133 27133 48995 27133 27133 48995 27133 48995 27133 27133 27133 27133 27133 48995 37605 2035 37605 2035 2035 37605 2035 2035 37605 37605 37605 37605 2035 2035 2035 2035 56574 29703 29703 29703 56574 56574 29703 56574 56574 56574 56574 56574 29703 29703 56574 56574 28924 28924 28924 876 28924 876 28924 876 28924 28924 876 28924 28924 28924 876 28924 17441 17441 17441 17441 17441 50718 50718 17441 17441 50718 17441 17441 17441 50718 50718 50718
arg_in:  1 buffer short2[8] 28710 40929 3744 64379 18010 35553 27133 48995 2035 37605 56574 29703 876 28924 50718 17441
arg_in:  2 buffer ushort16[8] 33226 26154 16429 51143 62967 47340 61553 17700 4034 51934 55509 45216 40588 18678 38027 65369 34114 52059 31602 60547 26482 23961 65088 59768 4949 53745 26541 38334 55749 13598 40515 35427 21375 19749 27435 40282 17089 21474 45495 27412 20864 7862 13729 16579 33080 37566 37167 24343 8006 36572 48640 14136 54219 34152 43822 34165 14112 7415 3890 44758 55594 63426 41630 30001 15639 55738 55293 10960 32780 45067 19694 5286 1213 16521 50655 47847 3694 48834 43894 52300 14564 13767 25303 27687 42304 52748 18915 5378 10880 4282 46458 27238 53963 15185 53946 27156 44353 11865 13511 18012 35825 30886 22433 28230 50421 57047 26080 26645 1495 36769 54874 28205 13335 47573 43643 32929 30601 65376 27792 6705 14179 34788 56649 13297 4907 13096 42968 43336

[test]
name: shuffle short4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_short4_ushort2
arg_out: 0 buffer short2[8] 12823 12823 39716 39716 19553 62938 5189 5189 62471 7102 12753 32440 13371 22895 62389 59076
arg_in:  1 buffer short4[8] 15008 37095 12823 31527 39716 8506 12677 51323 62938 19553 42554 29489 17098 31196 18077 5189 7102 61298 62471 30818 55615 32440 28504 12753 43572 22895 38713 13371 58874 59076 26459 62389
arg_in:  2 buffer ushort2[8] 34322 62782 24984 59336 20937 28048 52951 45975 56362 34360 51195 21909 17155 64249 14407 30725

[test]
name: shuffle short4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_short4_ushort4
arg_out: 0 buffer short4[8] 40052 45255 36244 40052 58466 58466 51835 58466 47228 41275 37925 37925 4581 4581 55894 2874 53347 6324 6996 39421 50066 50066 59380 3442 55148 55148 13915 55148 45749 44436 5826 45749
arg_in:  1 buffer short4[8] 45255 36244 970 40052 58466 27751 51835 29457 37925 41275 3200 47228 4581 55894 3315 2874 6324 6996 53347 39421 59380 43465 3442 50066 13915 55148 35841 5722 44436 5826 8189 45749
arg_in:  2 buffer ushort4[8] 15531 1824 12877 4511 27820 53984 36650 13200 14195 23681 15936 20380 31340 30324 63317 34067 52446 26752 6697 63967 9851 29951 17048 51618 60061 8697 32276 29921 15523 20372 56885 64339

[test]
name: shuffle short4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_short4_ushort8
arg_out: 0 buffer short8[8] 4841 33597 33597 55097 4841 55097 55097 4841 20338 51182 20338 64647 51182 20338 64647 18198 6321 40202 50635 50635 62889 50635 50635 6321 30321 59791 30321 59791 43527 30321 59791 43527 44565 39174 8409 8409 31110 44565 8409 39174 56930 39808 31448 56930 39808 39808 31448 39808 38272 42240 38272 42240 38272 49885 38272 41938 39751 27221 12512 27221 27221 39227 12512 39227
arg_in:  1 buffer short4[8] 55097 33597 25160 4841 51182 20338 64647 18198 6321 40202 50635 62889 59791 55162 43527 30321 8409 39174 31110 44565 39808 31448 56930 35700 38272 49885 42240 41938 27221 12512 39751 39227
arg_in:  2 buffer ushort8[8] 25571 13313 31785 53556 21475 41380 27896 54835 60925 32084 35989 47782 51440 8673 62454 57671 12680 21841 15794 34950 34727 1130 51150 51516 26067 3252 21343 7920 54518 55779 43664 55962 49783 5325 34992 62056 1858 11299 4644 19789 31010 21520 43541 55734 18316 38256 63761 32344 9788 35310 19276 25374 32300 17629 1736 3635 57906 36192 39529 2664 49940 61179 22013 5043

[test]
name: shuffle short4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_short4_ushort16
arg_out: 0 buffer short16[8] 21907 1209 21907 46439 46439 21907 46439 52358 46439 21907 46439 46439 21907 46439 52358 46439 60577 41078 60577 60577 3422 60577 3422 12009 60577 3422 60577 12009 3422 12009 3422 60577 30429 33935 7747 33935 33935 49417 49417 7747 49417 33935 7747 33935 33935 30429 33935 33935 21720 59012 56741 64016 59012 56741 21720 64016 64016 56741 56741 59012 59012 56741 56741 56741 28333 28333 28522 28522 28522 14417 28522 28333 12414 28333 12414 14417 12414 12414 28522 28333 42167 36343 42167 30269 30269 42167 42167 36343 52408 36343 30269 30269 36343 52408 42167 30269 36574 11353 36574 11353 36574 11353 11353 41765 11353 7782 36574 36574 11353 41765 11353 7782 3003 24311 14082 24311 3003 14082 60165 24311 14082 60165 3003 60165 3003 24311 60165 60165
arg_in:  1 buffer short4[8] 21907 1209 52358 46439 12009 41078 3422 60577 30429 33935 49417 7747 56741 59012 64016 21720 28333 14417 12414 28522 52408 42167 36343 30269 7782 41765 36574 11353 24311 14082 60165 3003
arg_in:  2 buffer ushort16[8] 62656 46449 32788 57011 22719 4872 23119 21030 56391 26048 39415 6711 7164 30147 3114 48439 33783 59613 36983 36571 43386 49075 17134 8744 57799 14894 12763 20124 21554 44296 54374 28431 32916 46141 46391 33281 1425 8278 55118 14563 55118 60221 9711 13065 59721 19216 50053 24197 53531 4453 45116 55802 36493 37052 18495 10970 58130 41100 24708 5777 28837 58260 53524 17884 4464 25792 37191 27003 34759 7229 48031 37288 50342 17224 4822 25285 39382 27134 58743 38584 421 5526 56125 57191 1355 21825 13533 48106 54924 30214 35231 52635 46418 20340 11961 42935 28178 5499 51558 49243 36498 43175 25595 30997 4783 64384 32366 26914 36827 21061 24139 59136 30347 5724 10273 30372 51891 52081 55410 3616 19077 37774 40435 5834 26743 39068 63726 50098

[test]
name: shuffle short8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_short8_ushort2
arg_out: 0 buffer short2[8] 45707 5806 37904 40666 64058 26790 10496 20228 64131 44594 61836 64627 9163 9163 33699 33699
arg_in:  1 buffer short8[8] 14792 45707 11701 60005 47677 29343 5806 13255 46945 60433 25016 40666 37904 12991 385 8921 57037 26295 64919 26790 64058 53128 61967 21102 20228 572 59611 9694 54106 41952 23486 10496 44594 59687 25281 64131 55034 6687 20661 32819 38242 38590 57105 253 64627 9016 61836 38167 61197 48060 62892 9163 40399 27598 54852 60734 46102 57995 18970 63137 47332 8436 33699 27419
arg_in:  2 buffer ushort2[8] 17753 37494 10628 23227 556 59747 63287 36416 23763 680 56990 46132 39555 57307 6254 4294

[test]
name: shuffle short8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_short8_ushort4
arg_out: 0 buffer short4[8] 6115 12006 6115 27509 6182 2396 8783 2484 2347 28692 20784 2347 8056 8056 8056 19868 7363 7363 34242 29932 19641 10489 32498 39179 55494 20696 55494 20696 20056 14532 15794 24425
arg_in:  1 buffer short8[8] 6077 32592 55473 12006 6115 49206 61577 27509 15342 35048 2396 22783 62146 6182 8783 2484 32960 19078 57372 20784 28447 31344 28692 2347 8056 58859 64036 43503 19868 9420 8089 6284 7363 29932 52636 34620 1266 64797 34242 13162 19641 10489 48532 41732 26297 27708 39179 32498 20696 24289 46361 8829 13264 37390 54321 55494 33326 20056 14532 48740 52200 15794 24425 6453
arg_in:  2 buffer ushort4[8] 53540 4067 35644 41335 30925 2218 7246 4343 2855 30598 42931 14687 11968 37320 33536 61164 7552 13976 55486 30649 34712 35537 14511 17694 15463 48536 47423 35032 47921 7074 8213 53566

[test]
name: shuffle short8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_short8_ushort8
arg_out: 0 buffer short8[8] 38184 928 43968 36675 18064 38184 38184 64146 21202 23065 26800 21202 23065 30586 21202 9924 7668 26448 46832 46832 60537 49666 49666 60537 3225 58018 61226 46073 46073 61226 3225 3225 50992 13991 13991 13991 31328 50992 55576 17396 48935 8960 49175 24823 36982 27207 27207 24823 8262 24013 24013 25342 6376 49507 24013 8262 6087 46880 44513 44513 47823 54427 47823 54427
arg_in:  1 buffer short8[8] 38184 47488 36675 928 18064 64146 43968 28901 26800 9924 55597 45511 9562 21202 23065 30586 11638 37540 49666 7668 46832 28210 60537 26448 61226 13348 58018 25775 46073 41041 44749 3225 55576 13991 41366 50992 55329 49014 31328 17396 48935 49175 50830 36982 24823 27207 8960 49371 27196 24013 25342 6376 44176 49507 8262 13596 6087 47823 20031 21514 46880 60506 54427 44513
arg_in:  2 buffer ushort8[8] 39328 37899 42238 56042 22404 59192 18080 60813 18293 53638 46184 41573 15982 3935 18989 46841 42659 26671 16028 37948 47558 6338 12298 57398 30207 2162 59632 62388 8596 31104 9967 26839 27139 25937 46673 48689 958 38931 36672 1263 44440 7782 45161 21596 53835 10261 56829 19044 59726 62361 41177 1762 49115 3037 10793 61014 63720 908 32439 7639 14265 49646 13041 53710

[test]
name: shuffle short8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_short8_ushort16
arg_out: 0 buffer short16[8] 28446 16703 62473 4139 16703 50630 28446 50630 4139 39829 16703 21772 16703 21772 50630 16703 60561 25044 59326 60561 23361 1447 60561 5939 60561 23361 61690 23259 59326 1447 25044 23361 13024 22303 44304 5321 59509 13024 13024 50911 22303 5321 22303 63533 44304 22303 22303 50911 4102 58658 6119 62871 29540 29540 62871 35039 6119 58658 29540 55632 35039 58658 35039 35039 3025 3025 63688 42909 3025 43879 50103 43879 3025 63688 63688 25466 25466 42909 43879 3025 13877 33588 23816 57269 57269 20470 20470 50273 50273 28446 38568 50273 13877 50273 38568 50273 19566 48447 64203 48447 13688 51998 19566 48447 13688 34627 64203 13688 19566 53892 64203 8233 46622 927 53934 55335 46622 34230 48110 46843 46622 46622 46622 53934 53934 52313 52313 46622
arg_in:  1 buffer short8[8] 16703 62473 39829 50630 732 4139 28446 21772 23259 60561 23361 59326 25044 1447 5939 61690 63533 50911 35128 59509 44304 13024 22303 5321 58658 63603 62871 35039 55632 29540 6119 4102 42909 50103 63688 30856 3025 26173 43879 25466 20470 38568 23816 57269 13877 33588 50273 28446 8233 48447 51998 19566 53892 64203 13688 34627 55335 46843 48110 52313 46622 53934 34230 927
arg_in:  2 buffer ushort16[8] 27310 59976 48097 28157 12120 41515 1662 49179 54853 26658 55720 32551 54960 41711 15203 2208 27137 39052 9779 28057 39554 11221 26873 20958 30857 56954 42647 38416 20491 31509 64764 914 17221 63686 8700 399 40323 58101 35085 25889 18398 44671 39974 17808 24244 42422 52878 38777 45887 59104 63150 54346 23261 59493 27434 34611 54982 57320 64293 8084 44923 64408 44955 6419 42380 64804 47826 57512 8828 12254 37129 38750 57196 44738 59650 14615 45423 58576 54054 4316 52204 46061 850 46443 3011 61648 55792 28894 7726 39999 25521 28502 15044 53070 15465 7038 34387 41777 44533 6689 59182 19578 2379 53281 32806 63199 35701 29238 38499 21252 32317 26360 64316 31815 31957 35488 45284 24694 42722 19537 8236 50388 25380 26941 27341 49971 21395 63716

[test]
name: shuffle short16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_short16_ushort2
arg_out: 0 buffer short2[8] 38042 3805 15501 45931 13844 13844 60205 243 4980 39510 11679 44015 49668 13462 24973 25160
arg_in:  1 buffer short16[8] 39508 10426 12514 40334 28631 3805 7147 45777 11432 59004 38042 40868 64536 49380 36096 29166 48710 14312 42531 51476 48386 15501 19085 62270 50417 45931 34956 19578 17917 9974 20103 12252 33747 5862 28802 46652 51071 45683 13844 61606 3276 26553 53828 2710 54027 55734 31991 13807 10527 44170 54401 40172 28100 64661 60542 22622 37598 61465 47739 12837 243 44635 45531 60205 19792 35893 6706 8219 59197 23712 64724 39510 19954 20980 9226 31579 21192 60320 4980 15863 46182 44015 56038 45834 29697 14753 53871 63638 11679 61300 39803 3968 44716 62817 15528 39189 13462 48691 5450 23798 40714 23877 44577 62592 29365 49668 44267 1778 48839 44396 58503 26768 59927 54576 41462 56428 56177 62651 24973 20927 62943 6669 25160 5589 64940 168 20905 13686
arg_in:  2 buffer ushort2[8] 21418 27765 14693 15913 56118 24774 2815 21132 49518 21047 15608 55169 43961 29536 59910 7818

[test]
name: shuffle short16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_short16_ushort4
arg_out: 0 buffer short4[8] 60010 19158 11185 19158 7923 17138 31272 51606 19617 56148 19617 40053 4212 29934 25623 4212 4342 27250 51246 11598 44726 57457 59198 26159 34486 10970 33131 31888 23279 55611 64963 23279
arg_in:  1 buffer short16[8] 14578 14390 26101 13796 13645 11185 10390 1237 23585 33348 60010 19158 40525 38485 29209 42218 36450 17138 64926 21780 43166 26178 31272 16618 51606 62182 49697 7923 23869 2514 36902 12897 6237 56148 4443 19617 27698 40053 10038 25335 2581 58971 49626 57296 62031 27136 35966 9802 46324 64444 56005 43428 2300 4212 15087 61675 57628 25623 58665 979 33027 32211 5428 29934 41453 36252 4342 51246 48073 27250 31931 24746 41402 2311 13800 6457 11598 28712 46434 13919 51322 35817 26159 24486 57457 59198 60098 28693 12280 23812 16296 44726 24143 9539 34010 56775 39801 27110 17456 14228 31888 27603 40597 33131 6327 14021 19431 65435 34486 17654 10970 14597 26330 32559 29114 17226 59335 25875 65142 64963 13468 47512 55611 23279 179 53720 16754 17209
arg_in:  2 buffer ushort4[8] 51146 48299 26021 26763 47003 29665 65494 6536 54195 60817 5507 42101 26389 41327 21385 3733 42626 64309 9587 52748 40283 23380 29525 2194 62316 15118 26999 58484 38027 39930 38055 939

[test]
name: shuffle short16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_short16_ushort8
arg_out: 0 buffer short8[8] 9692 10498 8194 46006 11964 3276 46006 9692 60750 43732 3128 3128 41011 3128 24935 63892 35133 19883 3827 32487 19883 1571 23296 19883 33451 35128 35128 62463 38926 43038 4398 51291 27369 54656 57998 49523 49523 54656 35905 27578 4136 9345 2906 40615 12449 13807 2906 62606 29688 4536 61187 16674 62010 48626 62010 48626 50604 30282 54560 60458 4982 44158 18686 54560
arg_in:  1 buffer short16[8] 46006 35410 11964 2004 3276 61377 6163 19576 11238 7170 33656 40767 9692 8194 10498 29353 4525 41011 43732 60750 3128 63892 52973 37982 3399 31276 46653 45927 42117 22369 55002 24935 51776 6909 3827 35133 27991 39177 19883 1571 52685 33778 32487 2511 5231 23296 59325 19535 29379 43038 38926 51291 10222 62463 28847 35128 34578 4398 47949 39031 33451 30591 40246 43556 38313 35905 49523 63597 14683 10091 54656 25838 23031 27369 35938 48694 57998 57797 53756 27578 58271 44834 12402 28432 62606 40615 13807 2906 4136 9345 30669 55405 42038 12449 11935 63264 38740 64945 61187 7821 40570 62010 48626 62129 16674 29688 6482 58914 31511 32766 29716 4536 37163 14382 50604 44158 54560 45291 18686 50303 59894 16889 54362 20724 30282 4982 48976 60458
arg_in:  2 buffer ushort8[8] 59500 14894 43165 34016 17026 38980 4736 25612 38323 34258 31172 10628 60129 14852 63839 42069 23619 40086 13650 442 26662 28951 47581 23478 48892 43607 30311 40629 25426 7169 49609 33635 37929 50774 35308 11042 7554 54 17361 29855 104 16713 37767 22597 21037 63750 4919 65124 40793 31279 46866 15704 27541 28918 20117 20310 36658 62524 40116 58575 38669 25251 44982 27044

[test]
name: shuffle short16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_short16_ushort16
arg_out: 0 buffer short16[8] 17353 29172 51009 62682 45640 56420 29172 28563 40232 51009 56420 29172 60602 56687 29172 45640 27653 23062 23062 6673 23062 54071 2002 33032 54071 33032 53597 6165 33032 2002 33492 63125 50429 32601 26948 53331 43347 39221 21522 59231 50429 51332 26948 26948 19395 2928 19395 59231 15199 53781 15199 1905 37023 15199 8862 53781 19297 43958 1905 14659 32546 44689 64584 1905 29060 36242 45765 5952 48879 51730 33551 44715 30782 16657 45765 64054 36242 48879 5952 22821 11269 29690 29764 60647 12790 50371 29690 64957 54357 29764 41428 29690 26639 26639 29690 54357 40588 24323 24479 64879 31199 25820 31199 24323 24323 40588 31199 64879 44632 63056 44632 40588 20098 44030 15773 42343 53081 48094 11193 64224 2085 2085 53081 42343 44030 64224 45945 9682
arg_in:  1 buffer short16[8] 17697 60533 62682 21410 29172 56420 51009 36324 28563 45640 40232 60602 17353 56687 49386 58841 53597 27653 6673 33492 6581 63125 6165 54071 22827 3640 2002 33032 23062 9024 4173 35751 43565 2928 39221 51332 13449 49697 53331 43347 26948 32601 21522 58119 50429 41165 59231 19395 12783 37023 59326 15199 17897 39806 32546 44689 53781 43958 8862 47615 64584 1905 14659 19297 17872 33551 36242 16657 31375 21216 45765 44715 29060 30782 5952 25547 64054 48879 22821 51730 61444 64957 26639 58644 50371 39592 29764 15849 60647 54357 35701 41428 11269 12790 19733 29690 64879 23578 7701 60254 24323 63008 16971 3406 31199 24479 25820 4143 44632 45814 63056 40588 43150 44030 42343 11193 39654 53081 9682 64224 41702 45945 56526 12342 15773 2085 20098 48094
arg_in:  2 buffer ushort16[8] 31724 3204 10374 13522 40265 55845 50340 38136 42202 62550 7781 30900 35803 43277 54228 42793 7361 10780 10204 5122 41052 17639 6874 39611 34647 29227 42240 28150 27131 18170 58675 49413 20364 10585 34600 49222 42983 43154 38410 56942 43388 25539 2280 55528 18991 41249 9631 17294 30307 16872 63363 40765 6065 58355 57834 19272 50847 11225 31165 59950 54614 42887 29436 5773 2744 36050 52614 18938 28733 30095 54385 22951 19129 6595 31638 12764 530 31245 15098 8334 5420 25167 32470 20168 28477 44068 53343 53521 10745 48390 11547 41263 50882 16066 42719 6825 9807 6372 38537 39024 4728 22250 14104 48932 46228 37295 22488 59504 55836 24846 31964 12255 16078 54417 20844 65266 59477 23375 3 12295 2285 63037 20149 27122 43025 6679 11225 33494
!*/
kernel void test_shuffle_short2_ushort2(global short* out, global short* in, global ushort* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short2_ushort4(global short* out, global short* in, global ushort* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short2_ushort8(global short* out, global short* in, global ushort* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short2_ushort16(global short* out, global short* in, global ushort* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short4_ushort2(global short* out, global short* in, global ushort* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short4_ushort4(global short* out, global short* in, global ushort* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short4_ushort8(global short* out, global short* in, global ushort* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short4_ushort16(global short* out, global short* in, global ushort* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short8_ushort2(global short* out, global short* in, global ushort* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short8_ushort4(global short* out, global short* in, global ushort* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short8_ushort8(global short* out, global short* in, global ushort* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short8_ushort16(global short* out, global short* in, global ushort* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short16_ushort2(global short* out, global short* in, global ushort* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short16_ushort4(global short* out, global short* in, global ushort* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short16_ushort8(global short* out, global short* in, global ushort* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_short16_ushort16(global short* out, global short* in, global ushort* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
