/*!
[config]
name: shuffle long ulong
dimensions: 1

[test]
name: shuffle long2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_long2_ulong2
arg_out: 0 buffer long2[8] 26630 14930 36826 36826 21283 44119 12453 38626 60655 60655 64597 32225 49168 49168 59893 22890
arg_in:  1 buffer long2[8] 26630 14930 36826 59365 44119 21283 12453 38626 60655 20795 32225 64597 49168 13747 59893 22890
arg_in:  2 buffer ulong2[8] 538352123605667286 2702575780751605641 14393301523032662788 9859528074393486130 14333087498279851591 8386949594346214844 17940778069451249216 88221628511349603 7384011096524809628 6845519101232560750 6118149219474068921 14759161218500655932 14529341753669334302 3876689021329949452 2227535496550798334 9826496202503775293

[test]
name: shuffle long2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_long2_ulong4
arg_out: 0 buffer long4[8] 1939 1939 47680 47680 39958 39958 30129 30129 16971 23388 16971 16971 55339 55339 55339 918 16963 56994 16963 56994 63243 63243 63243 63243 17184 17184 10744 17184 3540 10707 3540 10707
arg_in:  1 buffer long2[8] 1939 47680 39958 30129 23388 16971 918 55339 56994 16963 17477 63243 10744 17184 10707 3540
arg_in:  2 buffer ulong4[8] 9654356680584872266 7366714015483533392 10244045251404690231 4161046127195777543 18213529963941395366 12377064525112510004 2830451094719365623 3180107552692748663 5843768886529383545 11371883024997853280 3158708916767205877 16061002130772875029 15019083107878283093 1738652487252623993 15316628597926608103 14812013326112467920 1864324762402494921 9765459157184203762 3319187729749230561 3588920511009026894 829013816368949819 12772977476277492081 10915650149288887259 9808690358032645239 12063656749996130105 10995268070703735405 6902065094260097210 5557332587501869091 10886779043132428781 14885629646052043680 16906933968603605449 17359537687461276342

[test]
name: shuffle long2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_long2_ulong8
arg_out: 0 buffer long8[8] 55616 55616 54872 54872 54872 54872 54872 55616 26799 26799 62602 26799 62602 26799 26799 62602 13219 13219 13219 47946 13219 47946 47946 47946 3818 3818 22898 3818 3818 22898 22898 22898 30402 15870 15870 15870 15870 30402 30402 15870 55288 55288 55288 55288 55288 55288 55288 55288 21528 21528 21528 21528 1138 21528 1138 21528 6556 6556 26215 6556 6556 26215 26215 6556
arg_in:  1 buffer long2[8] 54872 55616 62602 26799 47946 13219 3818 22898 15870 30402 61604 55288 21528 1138 6556 26215
arg_in:  2 buffer ulong8[8] 8591151321751647367 17367600374726010145 2611887166063310932 4501439323434137110 6163774766167356196 5318483865247749064 3644095625002011832 8834936539155034525 4645711628332728039 8926798519544361671 16230339172519411870 8675853598141303321 2474759797176534246 16723958456919929851 17659953171375256495 15186014453546581146 17095165086239442839 2670626107280162095 14395884584602723491 6277519894176282482 2419629473791957201 14732901064561915378 11747710465042539148 183317183322450776 17276332592804138236 13440409329067874568 10169176444942952211 15908077167469751898 13539979297112926472 7721739203683314621 14686965594547452585 1900858541107652919 12873398718511787275 11981280337840472232 6211051355581422940 5369281197624785828 12748997935941354990 16863570015952801007 10955388399040881803 5846690873880621840 16447726921513258029 5783652632823273845 2019757941719835397 5384044082585585507 9908812163346727303 13824571875525692583 16302549411582440943 7085777649458664087 5655540793763999852 8590630755592680350 9985189000730367782 6511957169400340824 10530630350888554533 14608714597926011482 13500685041059057097 6902274169747119024 13694038253077625190 14066328485682950398 8677160123900288645 4126751165145209526 8249966478764231130 15911495177055222997 16610707502592818375 1088618455163931108

[test]
name: shuffle long2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_long2_ulong16
arg_out: 0 buffer long16[8] 51204 52704 51204 52704 51204 52704 52704 52704 52704 51204 51204 51204 52704 52704 52704 52704 22756 47393 22756 22756 22756 47393 22756 47393 47393 22756 47393 22756 22756 22756 47393 47393 50948 24631 50948 24631 50948 24631 50948 24631 24631 24631 24631 50948 24631 50948 24631 24631 53293 53293 53293 53293 53293 53293 64309 53293 64309 64309 64309 53293 53293 64309 53293 64309 57915 57915 32167 57915 57915 57915 32167 32167 32167 57915 57915 32167 32167 32167 57915 32167 56688 18678 18678 18678 18678 56688 56688 18678 18678 18678 56688 56688 18678 56688 56688 56688 52034 52034 52034 52034 52034 52034 52034 52034 6833 6833 6833 52034 6833 6833 6833 52034 46600 46600 23719 23719 46600 23719 46600 46600 46600 46600 46600 23719 46600 46600 46600 23719
arg_in:  1 buffer long2[8] 51204 52704 22756 47393 24631 50948 64309 53293 57915 32167 18678 56688 6833 52034 46600 23719
arg_in:  2 buffer ulong16[8] 7584696977997288988 5699068798758399941 15322664085250689156 8632130735211077453 14473313421156699986 14509631589828572273 9123452693813076361 12245905401378548575 14509972514469809285 9525875134547381190 12071465639642309758 17996930771368345156 4672861426810872509 6855332036747784869 12382432717336084639 10339947524095962805 17397580343017971520 1102037412536188889 5937254346095708494 3727674617387998156 4662371092651220058 539630820115968863 7088926375390805262 8499353701436887181 18420545459074114303 16635845508852750814 9567717428045389661 18083278998954094646 16538346637152185988 9553412613229429110 3389735039679440199 153522742727882259 9112848669037068889 9753449481893239184 16336786197508184681 8633875645339864718 16692334383038304747 3245198272345514808 15028514650407604953 17063640099853231276 14656116839768986784 9359264279495432398 4698465727547845850 13909176271529384865 9283507327919898682 14809630217690430567 10738195553190198762 17790064053074149470 14721752310808926199 7413775993752864481 14242711252784360503 12450224215564933941 6911296867109809739 13666041925638388949 15089865533884645928 15653067386445441839 17696872099237120808 16740475902030015384 13392511522744817888 7363856109706018451 9000532031814130407 14259673738051987734 10928304051740773671 16538927510224579282 7231462295156033048 5951436673414662942 5383200652786792465 11171478251184059238 15367280499882714130 13064938125086340134 5338256688116721877 14753164147426251373 575216239147261819 6873752885043203338 15488125823240274200 5388159725532164331 683406224581363045 4227556340554639055 17471768363005790542 18212411922021317437 11793269389276530655 9598618143730749922 17551230026232062078 10065192589919320518 16774395215394484432 4244230058640395415 15576890825516160757 1923546362791245096 3613683493882896554 11248092887011398706 18293048023007722515 5612840128056155287 12268214499915846930 9303759083104575273 5696934578512921657 11054094849280781115 10693018698511409577 13476903410208482901 15527564412792014715 2131018559708231381 13293699881750642541 1041059151922779661 15557637838393546691 684986246405796035 7755189555486639148 2394501442015921968 13084450873576520048 16957886253902322877 14206367253159452622 1018237851161929290 5225843095882623932 13840749748153133563 11411630961665552424 8349240357224125706 2561182529771534203 8006834150127448521 15163577061675126978 3148310109487086253 17589725061582154150 97645932335487666 9135557537606479796 13867979294341008544 3163400051996068784 6717778504170785351 6004042324183299132 17313627187194960790 8498619329291298884 4973112761956686511

[test]
name: shuffle long4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_long4_ulong2
arg_out: 0 buffer long2[8] 4634 50801 57624 6704 710 62694 4836 4836 36002 36440 34867 64841 34476 34476 1173 1173
arg_in:  1 buffer long4[8] 50801 4634 62823 41764 9397 6704 38450 57624 710 49184 62694 32156 5278 29200 54959 4836 36440 27806 36002 53948 64841 34867 30754 18644 62432 29899 14381 34476 1173 26702 28134 31970
arg_in:  2 buffer ulong2[8] 12934149861970184301 13224236313532660084 6423144427255088595 12920362237015230825 3709185015387917128 2140486874245533202 5830141395944608615 14414831844845960075 14989552432428496902 3006649086170227128 12944805409817619393 1569993175516692608 7820441734228986487 13299614235671077383 13024135082259713896 3173989791265038568

[test]
name: shuffle long4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_long4_ulong4
arg_out: 0 buffer long4[8] 61609 61609 49530 49530 22471 3937 22471 3937 44728 57893 57893 24299 59408 7319 59408 7319 50818 43571 31732 43571 13166 13166 39630 39630 26100 26100 64660 26100 52428 62121 51801 51801
arg_in:  1 buffer long4[8] 61609 11338 49530 50383 22471 29738 3937 52758 12947 57893 24299 44728 646 7319 59408 38027 50818 17576 43571 31732 39630 13014 46550 13166 44082 64660 16891 26100 62121 51801 52428 50724
arg_in:  2 buffer ulong4[8] 10512934270221227928 17149591946651586992 1972781074318460146 11974367680069996062 11933056240952282984 660789224222534470 3061225112864096648 13925152162451914854 7882836990580068811 9810574140690444217 16523497549109178409 10086047701897399754 5577292626889975622 1658932802842886001 2057305776355441774 6806595344345806041 5134857770670098680 515558505348657242 1489423085502274275 985396835050073262 729288624187912047 14633091981309087559 13806981372367075992 385392068217666828 7410579999248207491 2309571785309808567 6530545983576528597 7383845934576658119 15683582328937880190 4760731315409125128 16362099112912608809 1007528475073473217

[test]
name: shuffle long4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_long4_ulong8
arg_out: 0 buffer long8[8] 59561 56042 56042 56042 13804 59561 5461 56042 46427 62889 46427 14369 62889 14369 14369 62889 37938 37938 37208 37208 50054 37938 50054 37208 31147 31147 60396 60396 60396 60396 50746 31147 2865 61592 8743 2865 30742 2865 2865 30742 45192 45192 45192 45192 42996 45192 42996 42996 42543 42543 29100 36478 17321 42543 36478 42543 3960 21114 33196 33196 3960 33196 3960 3960
arg_in:  1 buffer long4[8] 59561 56042 13804 5461 14369 62889 45919 46427 37208 50053 50054 37938 50746 31147 60396 62817 8743 30742 61592 2865 55826 45192 37235 42996 17321 29100 36478 42543 21114 3960 33196 1672
arg_in:  2 buffer ulong8[8] 8058894937836407616 1143428071533397293 9174317181030270517 2028392616675282909 16754641121369925882 3683844619063741224 10130984016711529399 10520503834605257965 929714140308018487 15903740928592395349 9333281939073504135 2828770879853570184 17958683488899105589 17186467457297358196 5750421715253612892 13660911264933868401 16764371098284790031 9901416538090941819 7757444302820774080 17110020759057918964 12053192382384983590 16259053687451154611 9912728522083120350 9432369346463337736 9399492064093425105 13810114254756908273 950939000024302210 10825957601595967410 8737885293410797298 8669806056566503962 9950637612835401924 13722087587497356725 8243949163727524143 7722808769976864902 2744246581137170904 9936540507395861803 9163360799481688493 5685519775924053435 14235874842365417579 2958189243811561853 11590500151255311725 9694926881941560541 5665775720945830305 3862898308629097701 319554343585931243 14761192595741108045 5097166292427363059 12000948609481771667 510225030624865339 11737259695696052679 7343362347417259813 5788102636477079874 17251430085155378156 16983712017864862987 11970750457636725750 6244311084987000067 16375765452590789185 8364824701565874220 12030750291857931166 12671073451950376150 3902045680788444221 7084201404138288106 2586213061751313653 10379681661670003789

[test]
name: shuffle long4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_long4_ulong16
arg_out: 0 buffer long16[8] 53637 34199 63600 53637 34199 27674 53637 34199 53637 63600 27674 63600 27674 27674 63600 34199 4430 43768 4430 34106 34106 29764 4430 34106 43768 34106 43768 29764 34106 4430 29764 29764 32948 32948 32948 29112 50526 10096 29112 10096 29112 50526 10096 29112 50526 50526 29112 32948 24605 24605 24605 24605 11249 14323 24605 46300 24605 46300 24605 14323 14323 46300 11249 14323 23281 21340 21340 23281 13720 50295 50295 21340 21340 21340 23281 13720 50295 23281 21340 23281 59579 337 59579 59579 19349 337 19349 19349 59579 19349 53642 59579 53642 337 19349 59579 8031 56174 29681 56174 29681 56174 56174 8031 22736 8031 56174 56174 56174 56174 29681 8031 62461 62461 35603 35603 11313 48125 48125 35603 62461 48125 48125 48125 62461 62461 48125 62461
arg_in:  1 buffer long4[8] 27674 63600 53637 34199 4430 43768 29764 34106 29112 10096 50526 32948 14323 24605 46300 11249 21340 23281 50295 13720 53642 59579 19349 337 22736 8031 56174 29681 62461 11313 35603 48125
arg_in:  2 buffer ulong16[8] 14096088202138148330 3887415801029791883 11520254114263114965 16386490825227823806 7250102764142965839 3957140069050156112 4202999488454913990 16388227869294944355 4076150629410109822 7497358113405403413 17497810862853521836 18334616143121783161 17952148703329087752 3484120540334418856 14184314163820282477 1580942339101714031 12984454993385735384 2812753929113128121 10821273364249093600 10514596593006164111 2075935628651767687 15034952426594438926 4067138320390638292 9895260572345758327 17059567736727414805 17569648488418741963 827477852178940465 1432877436984539030 534150277881341895 18132787453681547840 15246042041318919406 14291798656780633242 3828871567320058407 7761757225509501003 14130061706590463095 14750188799284894656 10390046683894158206 12750732071450364745 6102683326592764852 7174868318177843141 5174323631573357016 5923437275212661770 848815211022632921 786685490353311932 5700792137635159946 14154207034429064130 1222464639020877464 17365025061739235551 10523850518218027685 5098235295389266605 5499538676128190293 14680209631949503497 15750226518173375879 11071954307736814232 14620355425579624625 6154398540519610394 12583468465729212045 3309852768380651758 6625790662846834853 1264670687800986568 5178769396528930124 17395982455188898282 17286701797957482807 9239709963282780228 8087541824219603833 15672543068802492964 10554447909928559124 3365855913070134513 7117177557002567891 15774784230644982378 2089385946797163890 14816680065742375048 18239226682117833360 14131300446196740548 3406359986902201265 12011658878410090787 16706211599370912214 14334654664323339413 12896528466638718056 17556742087189997261 6774334934820398929 12899148981982701931 16825963722702659333 2983129758319632409 8232290432157805966 3210670705145062123 4298335672714072762 9949152442850601606 4159603454998014137 4222353451215901954 10207200970224536832 12082708749821685805 13590606055427021812 234095389166384171 10920087713658872866 14037900903077366541 8526639556831876033 980475797088718342 10402324511444318183 2968615465875524514 8227150480789003883 15468596949028845570 8680792362931931558 13694038660775881077 17827567165829100160 12450763256058033701 2841156745062478766 7418615870671630982 11394978450054401938 1683616544840879794 13176484538456316547 13032788952740106745 7628654170508966720 5341386698095879532 3443629613498459966 3089720833288333714 13298430530005486473 8693653490063201667 14769417174307124111 11204556756015708882 7870248362388343560 11139761782229871759 17874597019752326415 15850332749908082955 5342200253679691772 7803384458621161456 663583457763292435 6570178730095530224

[test]
name: shuffle long8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_long8_ulong2
arg_out: 0 buffer long2[8] 10372 57082 41278 62977 7700 40926 22494 22494 10454 64756 6487 54414 9700 20212 51326 51326
arg_in:  1 buffer long8[8] 10372 47679 57082 46725 24661 19824 11216 28260 15849 62977 61727 18519 63365 30687 41278 18712 57495 40926 7700 51689 58964 52088 38316 9958 25086 23243 51575 60861 18856 16541 6004 22494 5516 64756 15540 47316 10454 31177 47348 17006 10778 63774 54414 6487 47428 24328 16785 49851 9709 55168 34914 13537 45878 9700 20212 51829 65429 40491 22937 39424 13231 51326 4675 63819
arg_in:  2 buffer ulong2[8] 18142564091343467736 17558991136105030898 7076652557339762166 17276278277523428857 12279339006762977362 9643039054178607281 6621702253785580615 16293022210492043503 5049139016834962572 10578561494452804665 14139347536759069995 14916696001112851018 6011628540163895213 716266374541826766 7703332944379119565 3372072615999839269

[test]
name: shuffle long8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_long8_ulong4
arg_out: 0 buffer long4[8] 55775 43386 26265 50448 17091 49353 25663 60629 34191 43428 44811 29358 38511 38511 34458 6053 44812 39627 57653 57653 61920 61920 35196 51152 50986 33346 31544 50986 53109 49723 13187 53618
arg_in:  1 buffer long8[8] 20396 55775 45532 26265 45895 50448 35057 43386 49353 29651 51992 32514 17091 60629 38460 25663 44367 29358 34191 29239 44811 60165 43428 50417 6053 34458 43991 59214 9141 55292 38511 63449 45579 46012 20989 57653 39627 15144 3793 44812 35196 51910 31566 61920 28853 31681 51152 33329 64739 50986 27781 14144 55614 31544 33346 3941 38072 53109 53618 43507 13187 49723 42056 43876
arg_in:  2 buffer ulong4[8] 8575145590827786153 7325253479131781607 1243768697089953259 4814791660016248381 12524022981747131132 9783284662621219520 7391391419975518151 3382262171864639285 17511305209188413522 450716704649333534 8575092176859247772 14425554456236212321 5044947816409603870 12960087508636000014 260053992632417817 5692345403595936992 519241561841280815 15996295156704706628 10038768682907422139 11540493278273274811 3663226898159871259 11087861770329449899 12025040185245487600 609567439631961550 5079184777926838633 15525633503791846230 2554026849234552477 17618890102070488177 16084178338532497169 12325632235806043653 7417138291892491140 1843036099806147922

[test]
name: shuffle long8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_long8_ulong8
arg_out: 0 buffer long8[8] 33212 18455 31905 33212 33212 12779 33212 31713 3581 30663 18448 29713 65353 18170 30663 59178 56961 60690 39776 59723 60690 24897 59723 60690 16617 17521 44432 5845 16617 9104 49420 5845 23255 53090 23255 23255 58026 53090 23217 26681 31198 2836 2836 12836 45189 57604 31198 57604 5653 33415 27626 33415 11054 26556 11054 26556 19540 13595 19540 56124 37481 37481 39357 19158
arg_in:  1 buffer long8[8] 36548 12779 32885 18455 31713 31905 33212 39507 18448 65353 54693 3581 29713 59178 30663 18170 24897 39776 56961 60690 33671 59723 20415 37576 49420 5845 44432 17521 16617 9104 52769 1206 12723 49144 53090 58026 23255 26681 23217 62632 3862 57604 34812 31198 45189 12836 2836 2408 27626 29336 11054 5653 1769 26556 33415 2974 37481 13595 56124 19540 58065 19158 24668 39357
arg_in:  2 buffer ulong8[8] 6329632631610683286 5972370891993197275 14127630549738714669 3128022407919495814 6935713927104471790 3546474902356972065 15239266953888001622 11691346465316774404 10288319611197645131 5974746097769149822 10875074403060387640 13076485088007728668 8460234438519955441 3931699232879451471 15252588044874401102 14921720330061595869 5638825571766632746 8822195159477141499 3766740686782326681 10842778990084071837 2140038484175148459 6669899392940235440 17806129696907889013 17415356745492376251 15630193527604977484 14943703320705515315 6933413609050425058 16795886738762283369 14910186292767925244 5990077114773274885 8813906811579493424 15126526836580778913 14073018280989256748 11607779506339216810 3262335729858344028 17501572210118360764 15758159982776373827 12648343242112552770 4816689777860922078 933514606228617125 4204925383010752467 17485284775317604246 16657715486764701822 11169692608542860773 1097581407145296292 7984545940603718649 15441909647486737963 2558886594865958089 10674665367656042787 11190967226476225966 4846778282345552664 11367086458337959430 1302743981416249218 5151267794548492277 11386530070929893850 17523136986483517213 12340916139683576459 7317663163855878425 3943008428466771443 14074034281830041082 15406491576932889896 13295317701870592400 3231069225636183191 7263663811758041781

[test]
name: shuffle long8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_long8_ulong16
arg_out: 0 buffer long16[8] 28459 28459 24197 39292 24197 39292 40203 28459 28459 34902 3494 28985 24197 52537 34902 39292 47960 9739 48871 47960 48871 11012 48871 8709 47960 47960 48871 47960 11012 61011 48871 31918 53686 57830 44532 19928 27460 7186 53686 51433 44532 7186 51433 24427 24427 44532 27460 24427 4554 4554 18052 19873 21623 21623 19873 4554 21623 4554 4554 18052 21623 7448 19873 21623 16987 16987 41142 17532 19136 32695 16987 19136 49328 16987 41142 49328 19136 29180 19136 29180 9321 35285 62829 4564 61844 17887 4564 4564 60499 35285 4564 17887 61844 60499 46532 4564 61452 56237 25200 12379 22618 22618 56237 25200 61452 61452 56237 15837 61452 15837 22618 61452 10991 5014 53006 56457 56457 48765 10991 10991 31985 53006 58727 31985 10991 31985 33344 10991
arg_in:  1 buffer long8[8] 24197 52537 28985 28459 39292 3494 34902 40203 47960 31918 11012 8709 54558 48871 61011 9739 7186 57830 44532 51433 19928 24427 27460 53686 62474 12459 19873 18052 7448 21623 4554 19393 41142 32695 38059 29180 49328 17532 19136 16987 4564 62829 35285 60499 46532 9321 17887 61844 61452 12379 21567 63623 25200 56237 22618 15837 31985 10991 33344 58727 48765 5014 53006 56457
arg_in:  2 buffer ulong16[8] 9053634015632058371 15333645240317386955 5393212324205139576 13237030569637248372 15602665705028673728 18327875221525684148 17922585811645991303 15236439148135703731 12583521970494904931 8384187487245971694 6526609761921189669 8531372705476015938 2949010216108557072 17916847717350014449 17084007659044914726 11855568549980715660 524534391212889024 11058101474748543799 11337092647961926941 9027926141880972976 10010671984969857589 2891126256700808322 13207957736453857341 13010122887245614107 34658324132342080 7309442914073702504 16581991439893995389 17547182477324573328 2734360434272872874 3267432188639961550 7726992142719848205 1147688823740708873 13393777005054142831 1879734082456811689 2214112185545945754 8015273515880252628 16953929984923294830 6430633511493052824 2084338466805816591 14337041080907257203 592587625332377634 18431789866022319768 621970134199899211 1874668447598902133 7608613593672360773 6678242095968906098 2945823427947867374 14109307147904916333 17799954760338445094 4912206412765432750 537825226434004459 270045722246633322 4527641924869918013 10151544728900366029 6556047659465011786 1182757407482086590 13906594686987489637 15678188988749111774 15970769225924486502 4580053107493391291 13274321826355234349 1096580972313900508 805980941184996290 14157637616131556365 10585629394297624231 6228108886723257167 251245088801002480 7437520248967088637 17367239284629866718 14080503594333188097 8120110823332827119 3150311042075107878 7717417986044433340 9980946420337136343 9112431070698147928 4420284872093768396 4662262332178982630 7978318186778844163 11491109579110028054 3614276393839955387 17001485428430349989 10330417180653509186 5179878500442103249 9556429748045272880 17804520426795046199 16574055525988150814 2461635778753654952 16578724054318612672 8462652959368395971 7326590638604591178 4406364641680898880 1736059065141103046 9672086920118165343 6499110361324053251 2866471777660428884 10352025061339243008 5074676339108806536 9954036276610749701 16450975380810107940 1457673713260371641 9670524577858106614 3286137304281678438 908898680211499469 1799067268944160684 17538086051461514016 11668269614192498088 1309303655127027285 488463238165321591 23950955434558984 17276900410746084287 4907128329103908510 13659258289465913744 6644195540031420585 17418533440390155637 15184516443714650206 4941710737440206879 7060956276996198183 1800361564914813716 1184376418370893153 10584009513107636057 11121078143865338992 4636003296943124422 1839668507966830011 16224881391940499192 16165631892055750217 3756557882263568448 16492596897544605586 15751394770582172153

[test]
name: shuffle long16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_long16_ulong2
arg_out: 0 buffer long2[8] 13058 16325 38734 17266 16515 10864 4045 29732 536 23569 40149 29732 62058 3044 63764 46997
arg_in:  1 buffer long16[8] 63140 32688 47817 17095 42250 27916 60611 1023 13895 51486 16325 33581 8023 3179 13058 22497 27236 17266 24347 4423 29393 6435 11488 56043 29063 22665 62128 20533 20527 1575 38734 53445 57208 53724 20428 2861 141 6732 59962 34050 15242 14152 12051 61560 16515 21041 55605 10864 59559 21539 42448 61065 4045 18919 29732 14795 38529 23942 24718 36774 5274 22899 34363 22939 34414 64284 26371 29112 23569 9946 24521 59864 43801 13028 30619 33603 57123 536 6550 34102 44606 19723 32052 40149 36271 20327 25007 1364 15595 3092 50688 29732 40465 13950 13102 47315 5341 34102 43851 41631 3044 24036 8840 62058 20502 15916 42221 34930 44284 26443 63993 1634 58865 12440 36543 63764 26402 13316 54594 38106 23318 13675 46997 15622 14758 24396 20177 44748
arg_in:  2 buffer ulong2[8] 18286317579827471438 12144685140736261898 7840844600056934174 14008227203324321297 13675058932732561244 13255690189562041935 18010945161223674340 14622766783650911366 6787885029131933677 12333409712746358308 10308170032872384643 18365450568695972811 3476882734651265559 3563115697138018004 9398061550485141683 11373684995224963786

[test]
name: shuffle long16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_long16_ulong4
arg_out: 0 buffer long4[8] 31115 32569 8189 31671 35210 19414 30219 29868 4806 11735 11735 16681 20220 20220 6556 16225 12634 14805 9802 14805 24722 62800 49305 16866 53946 53946 52170 53946 41507 20835 45140 56959
arg_in:  1 buffer long16[8] 57546 53835 1592 1119 8189 31115 32569 42849 31671 54270 25548 51555 48518 5795 22676 14512 31618 43587 2148 62459 5135 27701 9487 63489 42454 59665 19414 17802 13476 35210 30219 29868 51983 16681 39939 10816 55628 51928 46025 4806 18104 28063 34120 19758 25421 11735 9455 6987 6556 27563 16225 25083 27563 19358 5379 33572 11696 36755 25053 43830 53611 21963 37692 20220 9802 54874 31256 2797 35407 65356 22566 17412 63364 14805 12634 6862 43994 42656 39141 12715 16866 797 46653 51598 62800 20705 58212 31672 49305 22878 29733 24722 37129 46284 31199 733 9475 49649 46467 48614 52170 28303 16637 25051 65150 26860 10564 33751 7110 53946 18760 57845 12716 56959 56579 21265 45140 47178 38424 41507 52760 60032 35824 26301 11477 23242 32998 20835
arg_in:  2 buffer ulong4[8] 6988168814413833877 12343946993042461526 9230945574150248900 5663058088588665624 9952039233197011101 5160998007759066138 9321512453823609214 12532979504579782783 3903536765694894791 5623861927696845309 6171345168510924845 10545967065965684769 2264191071745694575 4694023672355701199 11708595292422669264 4020100860086356322 7590913489268911626 10168431651022367081 5665299406487778368 11862435609076545385 15964794851879659243 5334254739753929540 18300051258167873096 14996327461083415360 7921595788038241597 13757006636668518397 14604031898576387428 8157669943685596061 10718988697482555847 10510922984923326319 6007445350330913172 11822487499420861393

[test]
name: shuffle long16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_long16_ulong8
arg_out: 0 buffer long8[8] 56665 39942 53763 8415 39942 13609 48034 39942 36887 38631 38631 29742 36887 44097 44097 24972 47964 24223 3388 32558 24579 45887 37401 33353 54462 46145 4979 44884 45207 14543 3361 46156 52188 41328 42236 65311 6959 42236 11501 42236 5361 28908 39387 61403 30509 28908 28908 59635 38067 38067 7923 27649 27649 36915 52658 47575 29492 22550 60923 39774 63163 22550 1525 39774
arg_in:  1 buffer long16[8] 13609 64412 22669 18427 47799 11699 20767 48034 29331 8415 22914 53763 56665 39942 57896 46538 12657 36887 44097 29742 23952 40770 15785 35880 7250 38631 49339 24714 24972 43154 47968 15553 45887 27968 28053 37401 19071 51732 47964 24579 24223 33353 3388 32558 44016 19232 13837 19613 37667 3361 34944 28986 44884 46618 21257 45207 14543 46156 7284 46145 31714 54462 4979 12875 27876 58559 61046 38492 65311 12172 371 24595 11501 6959 58244 50692 52188 42236 16742 41328 17412 5091 5361 58030 17621 30509 7320 38446 59635 58951 20319 28908 39387 14914 61403 41285 28454 8169 32722 47575 59696 7923 13575 14122 23437 38067 36915 30845 52252 36212 52658 27649 40943 63163 29492 60923 9138 41475 10275 25608 22550 20564 25703 1525 48382 51471 39774 23151
arg_in:  2 buffer ulong8[8] 14691078524422905548 16412417439713644989 3100190174157898795 13090004204667285017 3541941539329647373 6415692471647147248 16472351580201460407 96541238260371373 14126107868728105281 6909990266097888889 6285499648346293241 3911858080414895171 4761831538365471601 2828131964692721538 5515728751891362338 6644092889933430540 6564778821383275958 3109899305486805656 3405283947609843786 17857532657619960603 10809688834406848119 1759713871703632624 18010826469688038563 3831716624903213753 2531059240283579981 3166912422007354635 18371948887695141454 10104788299772763716 5137680942405751271 16463966588168995848 13429835093327467761 4174244267510393417 5229559921671560780 2088469927473958559 13188745339705323533 11373381204496480404 14517330568976191673 3023482688760853453 14617207708614682328 17611761814452528349 12391320028103216018 2086692561022365547 12517155103905691452 6589769182911176302 2736016287779382837 9827591895995855419 15891439352171989019 14278330247410645480 9603678835069832489 7538090049649330233 11650320238410780581 11274197929434012575 6403230424255058607 9291958816814157546 13713834818960317566 4579976376340192227 5650282705044434274 15855398157352301736 978415922691877763 12806763664510267038 16063101709395846497 15588800807129536296 17584090151409259131 7194849096604338894

[test]
name: shuffle long16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_long16_ulong16
arg_out: 0 buffer long16[8] 21176 189 31192 10916 37209 55974 13560 24504 17464 21176 46527 17464 25682 49141 18296 17464 5899 48678 25035 23801 5899 23801 25915 21550 35601 18660 35601 18660 25915 8699 35288 23801 47099 56047 56047 41374 15859 15288 10084 63382 13220 24655 1270 56047 15859 15830 15830 25049 19431 19431 63360 46072 34760 5817 19369 46072 42420 37346 19369 62011 63360 35300 57030 41531 40259 65402 7459 7031 23090 18725 7459 65402 55052 23090 7459 18725 65402 65402 18725 56405 42340 42313 51231 11000 16529 42313 43630 20101 43630 51231 42224 36005 42224 39834 16500 42224 44675 37882 7432 44216 44216 15179 7432 44216 2219 63508 7432 2219 63508 44216 44216 3920 35484 38311 58336 40985 58336 44813 11631 35484 40985 40985 58336 44813 8687 40985 26272 63276
arg_in:  1 buffer long16[8] 40456 37239 46527 2450 24504 31192 10916 49141 55974 13560 37209 17464 18296 21176 25682 189 35288 10021 5899 23801 59875 37005 35601 52192 48678 8699 18340 25915 7201 21550 25035 18660 6050 26350 47099 41374 24655 10084 12544 1270 17045 15288 13220 15830 56047 63382 25049 15859 19431 37346 42420 29709 19369 57030 5817 62011 31058 16088 63360 35300 34760 46072 56769 41531 18725 55052 21636 7031 14637 65402 46457 60637 40259 7459 2435 32469 23090 15386 53538 56405 3661 11000 3777 11492 16500 20101 42313 36005 40363 51231 39834 42340 45708 16529 42224 43630 15179 44216 37882 6436 63256 41465 35706 63508 19091 16474 2219 23984 7432 45307 44675 3920 26520 42859 8687 44813 58336 45435 64548 65319 40985 38311 26272 11110 63276 33519 11631 35484
arg_in:  2 buffer ulong16[8] 17709765633917718269 7036516797442379023 16695467401497785093 12871232036763107238 2744606894092905594 1162476743647299368 15511998318244243945 14026459886344557652 14517718447853831419 14167305228222195469 15681522218869020210 14799908520554285995 10307928476376288014 2604815111888897463 6738601496185893228 7767710165256498331 16599942228313653586 15250060280368615400 10872044388433089646 4351737088833298419 16052997592494613778 3967006694164474643 6890736956852079579 10735947719197573053 16058790603661582390 4334683919695788415 1895059510526643686 14014625388051256063 3481939689540422987 12790392521943870393 17046270598275365648 7498981444014157747 16490475450509892770 5095874248455766412 16132528254082622396 17400629739588241379 5326846591064225567 10795006871899977993 7879134502251455685 314078776925682589 12537341677202994858 14865670120594311524 14754323546780462759 6777058758053228060 17843164740785902591 16227613058087516603 6490814063465577611 10990673930541769214 3889046661970212656 1661503952885973248 3748800350406784586 2866551336013633069 8583262334445317468 11818642872564389030 18209233228051872612 13199627154817137389 1725448213843997458 17266630242745349649 18195259093705940036 4174156001169896183 4239315727075291146 17378596758484349275 7726752751315336101 9560804036968189727 5914938261026180312 1158223639778223093 9538321298932258281 15489167783816585491 16874693117665486668 16956228398093976848 16692119643149789465 9149136959465758949 28578234668301377 3633113842838916060 6029667649120214681 5602140600197289728 17670414650127641349 6634211860269589301 6893443197142883632 16252564645350204767 13381946554914218539 18183459577018449062 8836696873098028121 14981824628806236801 6091546115643297933 17468673954428674950 1045739115490119119 16872314410006194661 379135067181807151 10646685793015889529 11192921937420393422 1861048730232996695 8175269099607480622 12340202387047976234 8921991500468627284 6164334747620799886 3603446291237282958 6928219415785571138 6932608299578810284 1777938681977201457 14756951708839561345 8993724046178826768 11576483974735330060 6706529649220651345 962578264657120682 443328152048464631 504767003718386236 2940333153466773898 7290687879621581639 12649425975096969217 8073856027023990081 8467045922780326063 14223049222387806351 14451183831691507657 8743821998337849140 2103937283697617384 13482576895906986532 10827927375347755155 12603546773772952206 7122208686414019215 8723787649341822008 13473114306524731544 10966889670929872164 266604965899133123 489695044624251154 13231968029569023528 6781042986219682106 10785034846199251212
!*/
kernel void test_shuffle_long2_ulong2(global long* out, global long* in, global ulong* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long2_ulong4(global long* out, global long* in, global ulong* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long2_ulong8(global long* out, global long* in, global ulong* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long2_ulong16(global long* out, global long* in, global ulong* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long4_ulong2(global long* out, global long* in, global ulong* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long4_ulong4(global long* out, global long* in, global ulong* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long4_ulong8(global long* out, global long* in, global ulong* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long4_ulong16(global long* out, global long* in, global ulong* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long8_ulong2(global long* out, global long* in, global ulong* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long8_ulong4(global long* out, global long* in, global ulong* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long8_ulong8(global long* out, global long* in, global ulong* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long8_ulong16(global long* out, global long* in, global ulong* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long16_ulong2(global long* out, global long* in, global ulong* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long16_ulong4(global long* out, global long* in, global ulong* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long16_ulong8(global long* out, global long* in, global ulong* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_long16_ulong16(global long* out, global long* in, global ulong* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
