/*!
[config]
name: shuffle int uint
dimensions: 1

[test]
name: shuffle int2 uint2
global_size: 8 0 0
kernel_name: test_shuffle_int2_uint2
arg_out: 0 buffer int2[8] 11833 11833 5725 20755 30932 30932 41978 41978 34025 4772 31834 31834 8589 32110 24436 24436
arg_in:  1 buffer int2[8] 11833 47839 5725 20755 28830 30932 56371 41978 34025 4772 31834 40537 8589 32110 41800 24436
arg_in:  2 buffer uint2[8] 1730258910 313867706 2777190526 2997548779 1396529739 2290830573 2803332159 2011476417 3961219924 3339403817 209442898 597435654 3832367992 12968009 4136707007 2284288089

[test]
name: shuffle int2 uint4
global_size: 8 0 0
kernel_name: test_shuffle_int2_uint4
arg_out: 0 buffer int4[8] 45370 49886 49886 45370 18456 18456 18456 18456 28131 28131 7941 28131 35991 35991 49777 35991 23777 23777 23777 55816 4159 4159 4159 4159 64689 60690 60690 64689 3286 3286 3286 3286
arg_in:  1 buffer int2[8] 45370 49886 18456 62514 7941 28131 49777 35991 23777 55816 62900 4159 60690 64689 11920 3286
arg_in:  2 buffer uint4[8] 3003412274 3411688483 3639713549 1578101862 1713458672 3780089316 1746158696 2830357918 1938901843 440906921 3465573484 4173808635 3476290301 2545611473 52200054 107854145 2283280706 1512438898 1817487246 2612745463 1796430629 1849310289 2920419433 1670903797 1771334637 1237261266 2955431410 2937262699 3355092697 3852864987 3374673431 684377445

[test]
name: shuffle int2 uint8
global_size: 8 0 0
kernel_name: test_shuffle_int2_uint8
arg_out: 0 buffer int8[8] 18547 18547 18547 18547 18547 18547 18547 18547 30847 64722 30847 64722 64722 64722 64722 30847 58212 58212 43742 58212 58212 43742 58212 43742 37185 59320 37185 59320 59320 37185 37185 37185 59384 37860 59384 37860 37860 37860 59384 37860 2658 2034 2658 2034 2034 2658 2034 2658 11298 63734 63734 11298 11298 63734 11298 63734 34872 37698 34872 37698 34872 37698 37698 37698
arg_in:  1 buffer int2[8] 10847 18547 30847 64722 43742 58212 37185 59320 37860 59384 2658 2034 11298 63734 34872 37698
arg_in:  2 buffer uint8[8] 963877923 1228024829 1444928259 1919437149 2772845495 1379148163 3195469483 3933957111 1124915388 3957296971 3670163118 4269107067 4039668443 2414198409 3624206475 409808280 2215379055 1577293495 1601419332 1971781133 1582988049 1779408706 1398482415 2879898266 4036734654 656345319 1307172314 590147367 3608806009 2253714500 459874862 2035528200 2763266975 1023797188 3500450439 1602274738 279665892 1347606756 4189012953 2943173848 545873560 1727943175 4243802026 2172629341 726862357 6620484 1469894247 2946336554 3480605106 3154134667 4237516973 2240893952 1015428524 737734619 1699127530 2431415235 1084571664 215459853 1766722170 244705693 912837138 4246798867 2106342261 3349864195

[test]
name: shuffle int2 uint16
global_size: 8 0 0
kernel_name: test_shuffle_int2_uint16
arg_out: 0 buffer int16[8] 46666 9092 46666 9092 9092 9092 46666 9092 9092 9092 9092 46666 46666 46666 9092 46666 9179 9179 9179 9179 5558 5558 5558 5558 5558 9179 5558 5558 5558 9179 5558 9179 10323 24167 10323 24167 10323 10323 24167 10323 24167 24167 24167 24167 24167 24167 10323 10323 18943 18943 18943 40863 40863 40863 18943 40863 40863 40863 40863 18943 18943 18943 40863 18943 31519 31519 31519 31519 62138 31519 31519 31519 62138 62138 62138 31519 31519 31519 62138 31519 29766 27068 29766 27068 29766 27068 29766 27068 27068 27068 27068 27068 29766 29766 27068 27068 47475 47475 42484 47475 47475 47475 47475 42484 47475 42484 42484 42484 42484 42484 47475 42484 33236 9779 9779 9779 33236 9779 9779 33236 9779 33236 33236 9779 33236 33236 9779 33236
arg_in:  1 buffer int2[8] 9092 46666 9179 5558 10323 24167 40863 18943 62138 31519 27068 29766 42484 47475 9779 33236
arg_in:  2 buffer uint16[8] 2133420035 521588012 1683643061 3608134422 2219565566 1199320746 1839871991 3055521168 1888211260 4015086812 622381032 2626594687 3309968931 955584985 1080953350 1311082363 841476750 4024210820 3857629628 3424164060 3212244933 59282437 50707017 3907765133 4073788565 4039520668 22860263 2454577169 3043111837 2933266008 3800003069 125109632 2106749334 2337061137 3134899368 2729671271 354252142 2224572150 485401237 616194376 657941377 3681819329 3032536633 948588155 1386660557 307645155 3257049934 3746454028 254866145 2824886515 4152771051 1604780950 2712919054 900830208 3295184353 2864490144 2002663046 1419497666 2534651558 2618888179 3938376821 4126249765 3245688712 1439247787 47248517 4287563591 2197475393 701255865 1269651522 3040918493 3393145817 2032078237 3422274930 4136698462 1128606242 1875632111 1508671189 198233709 3467166170 1961515391 1068746889 3889936472 1338555401 709864280 4089326451 2603154626 1719930553 3094525452 2671038624 343495730 3225455190 2996996140 2584665721 1778576501 2992289806 865562452 1625273995 1150250655 2343790258 1758258025 2445098975 2724364109 2506434597 2587721366 2498079871 3559060964 3009325848 3475971540 3061044414 860579270 3262398171 3530966672 2638769137 1556719650 671931832 3344446410 3478419437 3985088132 4097139404 3886401985 2724670580 3648012113 2345416719 1226161550 3442026659 3922758971 4220404400 531092227

[test]
name: shuffle int4 uint2
global_size: 8 0 0
kernel_name: test_shuffle_int4_uint2
arg_out: 0 buffer int2[8] 8476 53465 18362 59524 24101 41634 2847 2847 38066 43555 31765 57081 43502 34543 13373 61117
arg_in:  1 buffer int4[8] 22174 53465 8476 53566 59524 3662 18362 816 24101 15357 59672 41634 58274 33664 2847 29520 54084 43555 38066 32769 61327 31765 57159 57081 34543 50114 43502 25226 13373 30376 61117 19777
arg_in:  2 buffer uint2[8] 968983974 3307531005 915374162 3873971700 1736956236 2450168643 802950770 3136340462 463869554 2172649853 2379180061 250803495 83460258 3790652916 25176016 1981469246

[test]
name: shuffle int4 uint4
global_size: 8 0 0
kernel_name: test_shuffle_int4_uint4
arg_out: 0 buffer int4[8] 5099 50084 60421 5099 36631 4492 36631 4492 3712 3712 3712 24165 26933 60242 60242 14474 53408 16798 40583 40583 22805 22805 35983 5645 3573 55332 39254 64035 47839 32489 23319 32489
arg_in:  1 buffer int4[8] 60421 5099 50084 63950 14526 36631 43472 4492 61550 39452 3712 24165 14474 26933 60242 25201 16798 40583 53408 6976 22805 35983 64971 5645 64035 55332 39254 3573 33640 32489 47839 23319
arg_in:  2 buffer uint4[8] 4282080689 3759155070 3124348248 1386768573 2422135677 2589680187 4101012965 1874233531 1250635694 2011200614 2418230006 3887805535 412494021 2299069698 1147999646 1719593120 2246498182 1528593088 1902147573 3567092153 33341288 2434746684 2085766897 939786227 1551914507 2294633873 58372926 3516723208 3460569218 1773390845 903301411 83254041

[test]
name: shuffle int4 uint8
global_size: 8 0 0
kernel_name: test_shuffle_int4_uint8
arg_out: 0 buffer int8[8] 63183 20490 20490 46565 20490 60755 20490 63183 27095 12297 27095 12297 52410 27095 27095 27095 8186 8186 7449 8186 8186 8186 27366 8186 21894 21894 43954 43954 21894 13220 13220 43954 33048 47194 47194 47194 64007 47194 47194 33048 1563 1563 1563 14927 30956 30956 14927 1563 61421 56902 6058 58027 56902 61421 56902 58027 58715 50328 15945 58715 58715 58715 8709 15945
arg_in:  1 buffer int4[8] 20490 60755 46565 63183 27095 52410 44181 12297 27366 8186 7449 58953 30065 13220 43954 21894 18433 64007 33048 47194 1563 14927 30956 61147 56902 61421 58027 6058 50328 15945 58715 8709
arg_in:  2 buffer uint8[8] 3539739743 3263725976 1481851076 2905478178 1755841268 2841033557 3468835628 403021291 2476269272 2568774423 4128878936 48387251 555578333 266086132 1191247544 4139112052 2416750333 3831539317 357158382 34961501 2378580881 2273094741 1826736192 4105389785 4026874255 1902560587 1304796430 2740821838 3024147691 2909035541 2452474713 1470961758 871510690 3237131659 1599415823 2179066943 1057661257 2281849783 1723425887 3806085182 3723482752 1182961412 4226573312 3541011165 3186203550 2457263682 762011469 1576191040 2570425485 707906084 2316275859 311450170 3281670636 4285043113 3922051376 4273826674 2541103930 2328515600 3255674301 3691032558 1661551294 3151346286 2768050711 2954758797

[test]
name: shuffle int4 uint16
global_size: 8 0 0
kernel_name: test_shuffle_int4_uint16
arg_out: 0 buffer int16[8] 4748 50405 25642 4748 30764 30764 25642 50405 30764 25642 4748 50405 25642 30764 50405 50405 38171 49718 38171 37560 7252 37560 38171 38171 37560 7252 37560 37560 37560 38171 38171 7252 43651 60523 50142 50142 60523 54229 54229 54229 43651 54229 43651 60523 60523 54229 54229 43651 38241 14855 14855 14855 38241 53823 59576 59576 14855 38241 59576 59576 59576 53823 38241 14855 61553 61553 27616 781 35917 27616 27616 35917 61553 35917 61553 35917 61553 61553 27616 61553 56103 27620 27620 53032 53032 8540 8540 56103 56103 27620 53032 53032 56103 8540 53032 27620 41004 62477 41004 62477 41004 62477 1362 62477 62477 62477 53103 1362 62477 62477 53103 53103 30682 1379 51261 1379 30682 1379 1379 30682 30682 51261 59321 51261 30682 30682 59321 59321
arg_in:  1 buffer int4[8] 50405 25642 4748 30764 7252 38171 37560 49718 60523 43651 54229 50142 14855 53823 59576 38241 61553 27616 781 35917 53032 27620 56103 8540 41004 53103 62477 1362 51261 59321 30682 1379
arg_in:  2 buffer uint16[8] 2857767330 3480321692 2253806669 2100043390 3466364327 405216743 2162492261 2322561460 4156201143 543779097 4006760218 2412195868 1236243757 474439955 3082360232 3872199788 2208303613 1123055267 3889415777 2967425214 2243660528 3508397430 970590677 1646794861 1606901074 1121654748 573704546 652172210 2560426782 560827217 1666462101 2414519028 834087289 3756880900 3991090367 1378207675 3184183852 1357798218 61515522 3339796514 4086105485 3964711682 2094946509 2715808196 819995040 1535958358 2334469210 2774928545 250064595 2494793176 2065331496 2960759924 459293695 426764669 3818757326 277475658 1404992004 2974522975 2029504942 1402532838 4163296126 1695462397 4067613863 2499995856 2498646300 814693640 1542557793 2099677726 1751354043 859661473 2591694225 904118379 4190380632 971671271 1092459208 3201703907 1752722620 4049596324 13518625 1116145216 4159931714 4284184965 1535685117 585932216 1396919868 350084039 3166448139 4070553870 3403635774 667809489 3944619592 2597594400 1446161102 1141142523 773994076 1282937345 1384313548 2055605218 3691510080 2508542786 1515642480 2834724210 448473931 2413873946 2681964222 3920378178 1171472137 322141111 2782933742 769167694 3764535025 3563122233 1115376278 3843084159 3811295384 741941807 2798886022 2731923227 1776140159 786840038 1080770814 1198736500 36692861 802260220 838930386 2742438502 2152589545 1772413333

[test]
name: shuffle int8 uint2
global_size: 8 0 0
kernel_name: test_shuffle_int8_uint2
arg_out: 0 buffer int2[8] 46803 10210 55432 49120 2235 38544 39615 6688 19242 23043 18892 18892 50646 42793 51515 51515
arg_in:  1 buffer int8[8] 14401 46803 32716 20485 30747 10210 8225 58707 48581 5712 49120 20763 55432 20349 26582 24620 63046 40453 65409 2235 65106 50933 38544 54859 25802 37983 10347 50930 39615 2434 6688 13533 2164 12625 19242 3030 38786 23043 6294 29195 18892 59840 7586 47986 39942 60684 32479 46375 50646 42793 62668 9721 31293 9903 59873 5381 25052 34090 12874 51515 46056 53059 38176 49137
arg_in:  2 buffer uint2[8] 3983365001 3572322749 2763315740 29079522 2602111531 2713437470 1536823956 1403104782 122970242 2911157989 919029344 1335928152 2140948800 2405750785 2787459611 1051025731

[test]
name: shuffle int8 uint4
global_size: 8 0 0
kernel_name: test_shuffle_int8_uint4
arg_out: 0 buffer int4[8] 31459 54903 54903 43421 43691 44330 48872 55264 18176 18969 48008 30780 7450 12175 7450 5516 4014 61770 54080 4791 25274 21118 25274 50096 42590 42590 24759 22380 19200 60996 26002 26002
arg_in:  1 buffer int8[8] 60116 43421 54903 60824 21721 63526 13725 31459 43977 43691 48872 55264 44330 8834 39273 17990 48008 30780 64914 18176 36696 10983 18969 42698 12175 36216 5516 2018 60837 9843 7450 46070 4791 54080 34997 4014 61770 30076 10959 2036 25274 44093 48957 21118 19004 50096 4699 58837 15366 59989 42590 7853 22380 37020 22241 24759 32205 53120 19200 26002 45054 60996 5933 22056
arg_in:  2 buffer uint4[8] 4101211055 1801514866 1403346194 1585779929 2156823465 3588381812 2886445866 1773040851 3605533851 3325341174 2541263192 13754681 264586390 1960126848 131882286 1207558738 1349778475 3202102036 2104784561 1932028488 1729090704 2980720531 318325736 2884868733 4079648194 1785574842 3927633975 3591453996 1713848818 3467762173 850316995 3504471763

[test]
name: shuffle int8 uint8
global_size: 8 0 0
kernel_name: test_shuffle_int8_uint8
arg_out: 0 buffer int8[8] 12138 57076 57076 47788 57076 52074 60960 52074 25107 25107 26515 28112 28112 25107 25107 25107 47955 57494 48957 47955 47955 50575 47955 12833 35514 57884 47838 35514 48026 46550 56205 35514 46636 13716 27105 9561 9561 16708 16708 26480 55106 22774 2945 21699 35336 35336 55188 21699 62443 1415 31846 30928 11474 50882 11474 28812 60672 18550 60672 22492 32288 43676 60672 18550
arg_in:  1 buffer int8[8] 60960 47788 27572 52074 57076 4208 12138 48906 26515 28112 48836 61246 29204 64564 9597 25107 48957 47955 50575 57494 31655 19679 12833 50602 56205 40883 46550 57884 30201 35514 47838 48026 27105 10333 46636 16708 9561 33681 26480 13716 6914 55106 45946 55188 22774 21699 35336 2945 31846 62443 1415 53113 11474 30928 28812 50882 60672 32288 22157 46742 20199 18550 43676 22492
arg_in:  2 buffer uint8[8] 2372010158 1345145508 677372364 1672869721 3214041068 4188448915 2703672560 3320752723 1924726759 4244825775 3976495696 2849977625 2849973609 213260151 3975525631 1764242991 3066306169 3139936163 2634852552 3578095465 452813985 2361714122 2243717097 3230018614 610544989 1889953523 3575135150 3760740029 2888289479 2373170826 2172760824 4147795933 3507353698 1916024767 465173032 2680007932 2723908124 880349563 1596929595 3298500254 1649454097 408556340 3673073279 3302053637 3065335006 878540822 2043879267 647042741 1169188569 2364060226 4004319824 237558221 2918611676 2875419583 555007676 3542917630 1712070968 3964970557 3799625224 789461303 2458176529 383002750 606742744 3676261037

[test]
name: shuffle int8 uint16
global_size: 8 0 0
kernel_name: test_shuffle_int8_uint16
arg_out: 0 buffer int16[8] 45776 12075 12075 12075 41358 12075 37614 32251 37614 37614 37614 37614 32251 41358 41351 43976 38109 53806 22138 20873 18997 38109 29849 38109 18997 18997 65533 29849 29849 53806 29849 20873 48463 6683 58608 19989 58608 48463 48463 6334 19989 26807 19989 58608 6683 13150 26807 48463 16260 20439 3807 3807 20439 32405 20439 16260 20439 7615 8087 16260 20439 32405 16260 3807 22882 38787 18282 20610 63719 38962 1306 24764 38962 22882 1306 38962 22882 24764 38787 22882 5279 45517 43107 2729 11511 11511 45517 11511 43107 43107 44213 11511 2729 11511 5279 45517 33545 23770 33545 33545 33545 62819 33545 13824 33545 23770 13824 23770 23770 58712 34692 23770 39567 37976 9740 46101 11155 44416 17953 44416 9740 37976 39567 37976 46101 17953 60614 46101
arg_in:  1 buffer int8[8] 37614 43976 41358 41351 12075 32251 34011 45776 33429 20873 22138 29849 18997 38109 65533 53806 58608 19989 6683 48463 6334 43852 13150 26807 3807 20439 39218 7615 32405 715 16260 8087 20610 1306 63719 22882 18282 38787 38962 24764 45517 12297 45553 5279 44213 11511 2729 43107 38766 33545 62819 23265 23770 34692 58712 13824 9740 60614 46101 37976 17953 39567 44416 11155
arg_in:  2 buffer uint16[8] 1543288863 225242148 1613696812 237111188 1430302370 3860369220 4044236832 707764109 1042379648 4263605320 3980714224 4380480 1764852013 3325455058 1041316891 4112100337 4183386277 3779744751 3709218490 671057329 3719581900 73873093 2521837275 697122021 2601906916 2710836 693487382 2303973819 2093199075 3777206975 4214084987 3771645217 2303215099 3996657698 2376487688 3856587057 4255756320 1513451003 1041064827 2228540652 143132857 2783168671 1766836745 2969367456 273136826 976258702 2872478351 3052259307 781579702 2910249489 4254336120 2808308048 1169264473 2376599300 1514378257 864925742 727041841 3284305427 3624364575 1251707934 3365873929 2781068580 2644280702 1814297848 1808418851 1708820845 807551692 144747792 4151008802 1208542014 3535793409 1304562791 2911313878 2331260235 3582150153 3181076094 4186708003 2857858935 589624709 1967145227 2936572747 3429951880 155490967 3694575054 4129050093 2366717517 2793725600 2740956037 3819441639 63184607 846864372 257171445 601223070 3916767125 1532263115 1512921496 1596425457 2829305004 1007522121 3695593625 928845393 2650699658 326188481 349235031 3748676665 1157092916 2818467719 1875412028 479327676 722897638 397114293 2573987596 73230885 1436103403 2473920104 847130066 304177783 1201223158 3405823100 3423263030 1071420792 1398436243 3430577389 820223275 596984090 472670492 1626136217 3835975986

[test]
name: shuffle int16 uint2
global_size: 8 0 0
kernel_name: test_shuffle_int16_uint2
arg_out: 0 buffer int2[8] 1384 31881 30985 10545 37104 59818 22228 11090 22395 32398 58306 58306 33023 24462 46625 26211
arg_in:  1 buffer int16[8] 61917 34065 1384 3788 27003 18468 31881 42681 30436 24990 58149 38108 62099 54874 31253 40027 30985 49213 10789 20793 9150 50866 44824 10545 1076 4064 18358 49891 37881 55115 25658 58791 14084 11963 21295 15115 46878 31991 40131 46166 25566 5020 51104 22268 37104 59818 21349 54728 34494 11090 38408 16642 16910 22228 50541 5762 55222 40557 12456 52812 41305 3412 37846 23951 4512 1938 45669 38297 64842 63052 2880 10304 38210 6700 36773 64156 57787 22395 32398 1708 65288 6172 45025 58306 20321 15486 13395 23400 54469 18123 6886 53729 53759 32448 21801 47638 24013 10849 8124 17084 18939 38366 30147 24462 33023 24671 717 281 56076 14019 44543 26744 26934 7851 2877 36943 16210 42578 46625 12214 26211 42672 32115 33164 36079 41003 60969 1425
arg_in:  2 buffer uint2[8] 1256137186 1045203750 3285436720 228480519 2328752060 499739917 2121856405 816261345 1797685373 3580988382 451376627 2326623747 2702822616 411327511 2923635622 4131268808

[test]
name: shuffle int16 uint4
global_size: 8 0 0
kernel_name: test_shuffle_int16_uint4
arg_out: 0 buffer int4[8] 58006 677 4794 61561 3523 47645 43337 16472 12967 41233 12496 18870 41172 22875 41172 18077 3284 24212 6679 31700 28318 2339 61795 1074 58648 58648 42921 63262 65148 15487 8315 14732
arg_in:  1 buffer int16[8] 27032 4794 23293 9208 61561 52844 59876 24221 42553 26770 27562 57653 58006 26720 1940 677 3523 31338 49882 2604 16472 4347 24257 38074 47645 30626 7514 63290 44067 60574 31146 43337 41233 35560 47231 18870 12967 2156 57584 6377 43109 15766 27069 16860 24035 12496 15357 46706 37254 18077 36269 33238 4335 45249 49829 60879 41172 20180 22875 18581 55484 25798 32062 11616 18045 61992 35364 11960 23912 3284 19922 40761 65129 31700 24212 48994 6679 30732 57159 64553 4082 1074 14260 29283 6903 2339 47288 28318 6993 61795 6387 32099 33732 17560 43662 39764 29065 57633 810 1234 33703 58648 43596 49232 54323 42921 32934 4178 13617 2322 44639 63262 57722 24095 31948 12717 8315 17217 33516 56045 1899 14732 65148 36748 40218 28835 15487 22336
arg_in:  2 buffer uint4[8] 2785614716 3103861631 685309185 2607625332 3550261792 2234197592 3461244975 4172873236 3715744884 4228208320 3372142877 1074543411 2259904760 1719631978 1451158312 1059495825 893085061 1876135130 770641324 344863545 230663703 310705221 4274399337 2383599233 2999113109 428252037 2230302633 1303863791 3445904714 176442190 1395622756 1724012297

[test]
name: shuffle int16 uint8
global_size: 8 0 0
kernel_name: test_shuffle_int16_uint8
arg_out: 0 buffer int8[8] 37527 21474 64003 41432 4672 28540 8194 47943 33353 37560 15801 4218 27639 15801 30859 49636 58604 25325 59435 8666 36811 8666 41472 21941 24828 24828 14409 14409 41194 43294 23064 2417 43236 31825 3736 31233 31726 31233 43236 63927 35679 5609 11053 55822 11053 38689 2287 55735 3728 34457 56992 53230 56992 63513 33964 56992 47255 7395 38476 19845 45157 3445 3445 50872
arg_in:  1 buffer int16[8] 10635 22921 46167 21474 4672 41432 8194 54669 1126 51867 16597 12629 64003 28540 47943 37527 1219 62433 49877 4218 3419 49636 6580 30859 35905 33353 60759 37560 15027 27639 53603 15801 59435 44126 21941 58604 35922 8666 41472 61623 32207 10723 36811 25325 11868 62575 3588 5322 39725 24828 14409 49207 38365 64381 15553 37088 23064 41194 8165 12431 2417 64514 28077 43294 53586 31726 2933 31825 30932 63927 63112 43236 24242 42523 31233 63055 7374 43994 7063 3736 43430 2050 64838 55735 38689 2212 9433 11053 55822 2287 35679 3312 1877 28927 5609 43145 3288 34457 64591 53710 33964 3728 63513 36785 56992 64902 65010 53230 53697 28613 40870 62163 46764 46828 22917 45777 29550 7395 15389 3445 45157 19845 47255 38476 50872 60229 58750 63694
arg_in:  2 buffer uint8[8] 2695343727 2286101011 1315247164 1791776021 3050619892 3473880989 3302245958 1443538926 2452074025 2396501259 2330885167 2361227955 3369565405 931593359 3354339559 3037342309 981459379 3780767403 3576847552 3123128517 2210913082 2300343669 2699585398 2110240642 1243065649 1491271313 1985386066 1422696178 3926299625 4007359743 621699864 1304554044 858891079 2627366419 31513263 2334225082 1023915681 120615946 707943063 1235419013 2892819338 1365136126 659942631 3522695064 4154566391 2966801556 517206537 486322019 2885650981 1038933457 478925256 3993191579 3795780232 3738251046 2481457476 3977007912 801794410 2861133509 1984762859 282312089 1960863576 834045287 3341922871 3047725052

[test]
name: shuffle int16 uint16
global_size: 8 0 0
kernel_name: test_shuffle_int16_uint16
arg_out: 0 buffer int16[8] 30029 38344 1611 32182 3293 12127 3955 42359 38344 27065 14673 30029 15653 51926 38344 48664 15567 29334 47644 34080 29290 51201 48588 20319 29290 47644 34080 59183 38545 20319 29290 38545 49452 7210 61443 60919 1906 19801 46964 60919 13835 37202 45937 13835 17693 13835 19801 46970 62181 56717 20188 6556 62802 52635 2722 20188 62802 32231 19031 55954 52635 62802 35590 31463 11974 43320 44414 26430 19165 38341 36413 27759 45736 43320 26430 44414 59292 19165 35840 1484 47750 47750 62472 62360 9749 32493 34306 52941 34306 4794 52941 62360 34306 15993 60173 26047 22944 16411 63753 63753 63753 43487 12931 30814 43487 58961 26184 30064 13104 7638 10088 7638 62854 11800 9660 62854 38679 17384 5034 61688 11787 15829 11787 34123 17189 11589 15829 17384
arg_in:  1 buffer int16[8] 3293 1611 14673 27065 12127 51926 3955 18447 48664 38344 32182 4890 15653 42359 30029 27099 34080 51201 45981 29290 29334 15567 20319 38545 59183 47051 48588 59172 30449 47644 44234 49209 1906 19801 49452 60919 47494 61443 37202 11821 13835 46970 23484 7210 46964 54873 45937 17693 32231 2722 62802 17284 56717 31463 35590 20188 6277 62181 62414 6556 52635 19031 55954 15547 6999 1484 10106 26430 17361 43320 36413 59292 19165 38341 43425 44414 27759 35840 45736 11974 4794 52027 62360 60173 26047 9749 62472 15993 34306 61011 32493 55671 47750 52941 36257 5584 16040 43087 16411 22944 7638 10088 30814 30064 61663 63753 13104 46377 12931 43487 26184 58961 11787 11800 15829 62854 19145 61688 38679 11589 59139 17384 34123 17189 24889 9660 5454 5034
arg_in:  2 buffer uint16[8] 1329527390 1009094585 1630114817 595003850 3758100384 2739537428 1305906486 1255823037 678763337 1535546467 4254530034 1806373022 3297838940 3962843717 1623198681 797986104 3808723365 3146988420 101561325 2022629504 262358339 100918337 1532717834 2079345302 3744692051 3705823965 411518224 3702288344 3181252439 3764510150 35123363 777575559 1637786674 1522548859 299347333 58977907 1509653936 3547455153 3913942956 1601158771 4278173240 2984113798 4130274910 2727270888 1020450367 1313453608 1088364529 819149065 2483323257 3395793012 3469909655 3303909163 396382018 1108670780 3140824769 1936555783 1552296418 1780384176 1667479949 2880216542 1879205788 2329410306 128562726 2440488421 1016000991 1412396165 2915746955 3797634611 3474418952 3540989369 4289755990 3622127724 2368382846 4107371061 4250914403 1788740059 1739960631 1049276632 3747543485 564572289 3221604764 2903644348 3106735782 3286608818 3956498917 781232250 1463473624 814962925 1980460344 1231121952 2835610669 3004588130 121192424 2753034759 2336603875 1055987140 377393395 2668542066 441757721 2514689433 2111628185 2091657661 1061390204 750873382 1061823549 2124298895 2151504526 441002487 1999799770 1953810596 632895317 879728452 569603251 77904785 1746303741 2615956611 3990512022 1329595465 1271428431 4274429477 2206420080 1475813426 1459172256 1165058138 2478953051 625424759 720155954 2481400585
!*/
kernel void test_shuffle_int2_uint2(global int* out, global int* in, global uint* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int2_uint4(global int* out, global int* in, global uint* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int2_uint8(global int* out, global int* in, global uint* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int2_uint16(global int* out, global int* in, global uint* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int4_uint2(global int* out, global int* in, global uint* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int4_uint4(global int* out, global int* in, global uint* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int4_uint8(global int* out, global int* in, global uint* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int4_uint16(global int* out, global int* in, global uint* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int8_uint2(global int* out, global int* in, global uint* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int8_uint4(global int* out, global int* in, global uint* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int8_uint8(global int* out, global int* in, global uint* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int8_uint16(global int* out, global int* in, global uint* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int16_uint2(global int* out, global int* in, global uint* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int16_uint4(global int* out, global int* in, global uint* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int16_uint8(global int* out, global int* in, global uint* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_int16_uint16(global int* out, global int* in, global uint* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
