/*!
[config]
name: shuffle half ushort
dimensions: 1
require_device_extensions: cl_khr_fp16
[test]
name: shuffle half2 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_half2_ushort2
arg_out: 0 buffer half2[8] 3065 3065 29331 11017 34538 10848 50002 50002 16048 16048 58596 11378 35281 35281 21367 21367
arg_in:  1 buffer half2[8] 3065 54480 11017 29331 10848 34538 12811 50002 49417 16048 58596 11378 1892 35281 21367 46942
arg_in:  2 buffer ushort2[8] 65156 30936 27797 38374 46153 25246 19771 19419 65173 27897 64734 24169 20069 42817 35876 2042

[test]
name: shuffle half2 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_half2_ushort4
arg_out: 0 buffer half4[8] 34205 20369 34205 34205 9994 57389 57389 57389 55622 31720 31720 55622 31383 58649 58649 31383 48279 48279 48279 48279 55922 13889 55922 13889 36353 8699 8699 36353 65366 65366 65366 45869
arg_in:  1 buffer half2[8] 20369 34205 9994 57389 31720 55622 31383 58649 7504 48279 13889 55922 36353 8699 65366 45869
arg_in:  2 buffer ushort4[8] 24805 11346 24229 8987 4092 56907 16211 44753 42303 14898 20702 43403 39366 14779 17725 45020 54171 24383 19049 5557 44331 40044 26237 32728 37486 57411 673 33082 15912 1722 27136 24239

[test]
name: shuffle half2 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_half2_ushort8
arg_out: 0 buffer half8[8] 3203 3203 3203 53453 53453 3203 53453 53453 59187 17140 17140 17140 17140 59187 17140 17140 53214 58002 53214 53214 58002 58002 58002 53214 60340 60340 41825 41825 41825 60340 60340 60340 63345 57470 57470 57470 63345 57470 63345 57470 35525 35525 35525 35525 11620 35525 11620 11620 8506 8506 56175 56175 56175 8506 56175 56175 10411 10411 10411 25682 10411 10411 25682 10411
arg_in:  1 buffer half2[8] 53453 3203 17140 59187 53214 58002 60340 41825 57470 63345 11620 35525 8506 56175 25682 10411
arg_in:  2 buffer ushort8[8] 10955 45869 11065 50408 51498 54593 24714 45004 64635 5566 41336 17482 40082 38559 1242 17012 7382 21977 36000 42456 52843 32989 52983 29970 25674 43512 63213 42373 23249 3978 35464 19388 35821 29278 53100 16118 55061 60228 57757 53338 54263 11595 1049 27673 40486 737 30144 17310 23706 49478 22501 26349 55605 5274 23417 2261 4253 17453 36293 36588 35321 53511 26008 10109

[test]
name: shuffle half2 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_half2_ushort16
arg_out: 0 buffer half16[8] 10938 2930 2930 2930 2930 10938 2930 10938 2930 2930 10938 10938 10938 10938 10938 10938 28658 39376 28658 39376 28658 28658 28658 28658 39376 28658 39376 28658 28658 28658 28658 28658 2342 2342 2342 2342 2342 2342 42691 2342 42691 2342 2342 42691 42691 2342 2342 2342 8253 42331 42331 8253 8253 42331 8253 8253 42331 42331 8253 8253 8253 8253 8253 8253 9408 29977 29977 29977 29977 29977 29977 29977 29977 9408 29977 29977 9408 9408 9408 9408 63477 63477 63477 58494 63477 58494 58494 58494 58494 58494 58494 63477 58494 63477 63477 63477 62832 62832 62832 57414 62832 57414 57414 62832 57414 62832 62832 62832 62832 57414 62832 62832 31157 60701 31157 31157 60701 60701 60701 60701 31157 60701 60701 31157 60701 60701 31157 60701
arg_in:  1 buffer half2[8] 10938 2930 39376 28658 2342 42691 8253 42331 29977 9408 58494 63477 62832 57414 60701 31157
arg_in:  2 buffer ushort16[8] 14130 6277 5045 7373 55759 53642 62919 27098 3167 42269 580 57288 27158 64804 11868 13798 36379 53422 16895 37288 24985 4019 23771 56715 28710 49109 7396 18793 52141 59797 51703 13249 50278 39420 7872 35686 30054 18552 49881 22630 42197 28768 8026 47889 52579 54152 3692 31106 9642 48769 21259 64124 13052 12875 62998 47576 61473 2665 21046 23370 57366 27118 65428 17388 55967 39142 8068 61156 21534 24738 63620 9406 17154 50523 14200 29340 53553 64659 39277 39629 15915 9283 57399 55628 49777 24924 18412 45952 9806 2478 34246 29767 41284 11133 19043 28757 53316 7032 36976 1003 9632 55793 8867 49830 5887 8788 15052 25148 8414 54331 5076 52916 41693 51146 527 64383 39668 48900 61762 7274 32885 472 38860 37083 32538 23166 39127 28678

[test]
name: shuffle half4 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_half4_ushort2
arg_out: 0 buffer half2[8] 24938 30686 17092 998 22397 50853 25772 25772 39742 30515 7345 38228 51979 51979 12689 49489
arg_in:  1 buffer half4[8] 12519 24938 30686 58640 54503 15339 998 17092 22397 12770 24146 50853 25793 57647 62609 25772 30515 8645 39742 17575 7345 55663 36080 38228 35419 61799 51979 33334 44100 49489 9972 12689
arg_in:  2 buffer ushort2[8] 61981 8858 16847 44030 48100 9031 54179 36303 52302 23572 40436 39887 7510 40122 19811 62429

[test]
name: shuffle half4 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_half4_ushort4
arg_out: 0 buffer half4[8] 5423 27378 25151 25151 36198 9441 9441 36198 21222 21222 42239 42239 21719 7558 7558 56061 1374 43820 44932 43820 19334 46221 56006 48105 3320 8248 45903 45903 19150 44834 60408 14113
arg_in:  1 buffer half4[8] 25151 56936 5423 27378 37950 36198 9441 59382 21222 36119 10990 42239 7558 21719 23116 56061 44932 43820 1374 10140 19334 48105 46221 56006 3320 47599 8248 45903 44834 19150 60408 14113
arg_in:  2 buffer ushort4[8] 58670 17351 58500 49616 63181 40462 63686 27841 55412 41396 3183 63835 53529 19404 38532 41179 27958 14489 25756 16641 54152 5190 64471 44397 35280 43334 63423 13899 257 3948 48734 36455

[test]
name: shuffle half4 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_half4_ushort8
arg_out: 0 buffer half8[8] 50818 28898 28898 50818 50818 50818 28898 28898 12863 12863 35622 35622 8879 2211 35622 8879 53167 51923 53167 38379 53167 38379 53167 49119 24085 16222 24085 47326 49384 49384 24085 47326 43841 33884 33884 33884 43604 55751 43604 43841 12340 58180 23365 58180 31266 23365 12340 12340 24920 24920 24920 21552 12905 58715 12905 21552 46690 24309 511 511 24309 46690 7211 24309
arg_in:  1 buffer half4[8] 55192 30416 50818 28898 8879 12863 35622 2211 51923 38379 49119 53167 24085 47326 49384 16222 55751 43604 33884 43841 12340 23365 58180 31266 24920 12905 58715 21552 511 24309 46690 7211
arg_in:  2 buffer ushort8[8] 40002 30963 21183 10898 42822 62962 10687 42747 3873 5133 42346 14994 13320 54411 62954 49680 45691 36216 4623 31721 35523 25617 167 64870 676 3619 512 9793 23062 47370 60396 64861 12343 52942 20950 60602 24321 48368 61049 21375 8656 60542 3609 61182 50423 10253 6736 60644 10816 14768 20060 57603 20529 4534 16365 5739 56638 48941 44920 16016 48697 54414 65155 13417

[test]
name: shuffle half4 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_half4_ushort16
arg_out: 0 buffer half16[8] 25282 7859 16371 7859 23221 16371 7859 7859 16371 23221 16371 25282 7859 16371 7859 16371 64748 1400 54687 1400 60026 54687 1400 60026 60026 60026 1400 60026 1400 1400 1400 64748 17887 17887 2134 2134 52830 52830 2134 18351 17887 52830 18351 52830 52830 17887 52830 52830 30158 16289 14358 16289 14358 14358 30158 14358 16289 32497 16289 32497 32497 16289 14358 32497 15058 3268 15058 10824 10824 15058 10824 3268 5133 10824 10824 10824 10824 3268 10824 15058 14969 14969 14969 25058 42869 14969 42869 25058 42869 14969 25058 47822 25058 42869 47822 25058 41701 16809 16809 16809 16809 41701 16809 41358 16809 41358 41701 29371 41358 41358 29371 41358 6518 64228 17154 13250 6518 6518 64228 17154 64228 64228 64228 64228 64228 17154 64228 13250
arg_in:  1 buffer half4[8] 7859 25282 16371 23221 60026 1400 64748 54687 17887 2134 18351 52830 14358 16289 30158 32497 3268 15058 10824 5133 42869 25058 47822 14969 41358 16809 41701 29371 6518 64228 13250 17154
arg_in:  2 buffer ushort16[8] 42977 62640 20078 23452 63939 45542 17712 5796 22454 36527 45522 44493 32068 34966 54168 37702 41706 2229 62463 38485 19848 33999 25589 2128 64180 40364 62273 1064 13153 48501 32365 31442 51000 25376 50517 12597 23135 33443 13057 37086 22084 17631 59678 54111 50215 54288 30351 10539 12214 56133 41860 40285 65308 54448 53958 45540 52801 61755 52165 32611 4243 15357 36936 42003 7029 40976 39685 42858 64250 10145 16626 4384 13699 51658 32698 306 38842 30248 40914 13177 50651 54975 36163 8353 1976 29683 37760 3049 9284 34871 20113 29534 26689 31176 37510 8365 11002 29089 60797 8757 3029 64446 17049 46416 55729 50140 43650 60887 17808 988 25727 57048 28496 9681 36367 15218 39484 61268 50441 25491 49865 32749 13397 53485 7001 8399 41857 44026

[test]
name: shuffle half8 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_half8_ushort2
arg_out: 0 buffer half2[8] 21662 16800 57145 57145 34361 53761 54287 54287 50897 50672 48975 2146 35156 53494 45476 4259
arg_in:  1 buffer half8[8] 40399 21662 16800 3726 31692 11865 38480 4680 29961 22777 57145 54691 43631 15413 61985 9937 49532 61749 6363 14107 22189 62021 53761 34361 28613 54287 40780 22364 11212 13021 59674 2283 37933 21491 16589 50672 19878 30697 14759 50897 19707 25404 21464 63780 48975 13717 2146 50546 3454 53494 35156 33293 42847 11632 27145 46313 8765 45476 4259 32621 53190 11857 8653 10043
arg_in:  2 buffer ushort2[8] 39985 4786 50898 3634 51727 53894 12817 45369 28095 64827 22852 4686 9010 24689 17929 35242

[test]
name: shuffle half8 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_half8_ushort4
arg_out: 0 buffer half4[8] 30186 51627 51627 24311 12844 49860 49860 48672 65408 26842 65408 65408 31161 35067 18175 33059 3672 9867 32409 63010 57763 57763 53175 53175 64099 28339 31717 31717 32310 26358 16688 26358
arg_in:  1 buffer half8[8] 57437 30186 24311 51627 62594 15858 35514 35141 54272 9184 49860 48672 12288 12844 19062 38226 28868 57894 25224 26842 65408 24777 26402 25781 35067 56725 33059 31161 33474 62723 18175 63780 32409 3672 43423 9867 63010 53126 23997 61430 4136 4477 57763 29073 29248 30598 53175 714 31717 61932 28339 50352 46220 64099 10820 4631 65255 32310 15541 26358 61383 16688 39103 15023
arg_in:  2 buffer ushort4[8] 7977 43419 5283 36818 18005 8818 40970 49731 61004 37795 9564 13356 61963 46936 27966 2594 12801 49579 24896 43604 56098 59794 44774 34942 52117 63418 10384 56744 33481 25171 24989 16771

[test]
name: shuffle half8 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_half8_ushort8
arg_out: 0 buffer half8[8] 63749 47886 46985 63749 63749 47886 39238 20117 46083 42980 46083 42980 46083 28528 42980 46990 42633 55926 46017 55926 42633 22488 42633 10502 246 19624 246 12397 246 5858 12397 23912 61522 29513 60566 46441 2814 56961 61522 29751 17309 36803 8890 469 8890 45224 469 36803 16134 21078 37295 37295 21078 60217 18015 16134 5426 53281 60015 50528 60015 51453 53281 49837
arg_in:  1 buffer half8[8] 20117 47886 63749 46985 59606 33135 39238 6294 58056 42980 46083 31988 46990 2277 17423 28528 9382 46017 55926 22488 25211 10502 51031 42633 34038 45401 23912 50490 246 19624 12397 5858 61522 2814 29751 29513 60566 44893 46441 56961 45224 42800 30142 8890 36803 40583 17309 469 26678 44571 37295 60217 18015 21078 16134 11412 20214 50528 53281 51453 5426 60015 39229 49837
arg_in:  2 buffer ushort8[8] 14178 23313 26707 46434 52762 16777 37574 49056 55026 56113 34138 44297 2194 53527 4545 37636 59551 54474 30761 17338 15127 32227 52215 16909 33860 62253 24876 35022 40532 27287 29670 47450 30840 5987 39516 40870 64449 38847 52032 54858 46534 16204 83 16799 45155 12368 12271 28516 35230 56717 64162 4970 53685 1843 48820 12198 60140 37314 25173 43545 60733 52219 64938 1807

[test]
name: shuffle half8 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_half8_ushort16
arg_out: 0 buffer half16[8] 47887 16350 16350 62681 62681 47887 29176 16350 29176 26191 29176 16350 33359 16350 62681 29176 44087 54117 54117 54117 8245 54117 1036 33966 62167 33966 28869 28869 1036 1036 28869 62167 25811 9874 17657 25811 57327 25811 25811 9874 9874 25811 18430 17657 17657 33273 9874 44106 11060 45853 53260 53260 11060 53955 53260 42505 30562 11344 53955 45853 45853 45853 37098 11060 37288 33199 30466 12446 24337 21325 30466 37288 17684 37288 33199 33199 17684 33199 30466 30466 37167 8674 5027 37167 42539 37167 37167 8674 13153 8674 42539 42539 13689 13153 13689 42539 63408 28927 2811 56218 28927 56218 52191 2811 24108 24108 28927 52191 56218 2811 28927 28927 57197 37599 50988 63809 37599 50988 37147 55358 55358 37147 37147 17957 10853 57197 50988 50988
arg_in:  1 buffer half8[8] 33359 47887 16350 62681 42572 37997 26191 29176 8245 25049 44087 33966 1036 28869 62167 54117 57327 44106 17657 64821 18430 9874 33273 25811 45853 42505 37098 11060 53955 11344 53260 30562 33199 21325 17684 30950 24337 12446 30466 37288 33754 5027 13153 53632 37167 42539 13689 8674 52191 9928 21733 2811 63408 28927 24108 56218 55358 37599 50988 57197 63809 10853 17957 37147
arg_in:  2 buffer ushort16[8] 8817 15170 59050 57611 37299 60281 42583 30850 33143 22326 62359 1058 57240 13370 21843 29935 2618 65039 62095 48567 45848 60255 41860 36379 29118 5579 43453 12197 21324 58084 41301 17830 57255 59493 10570 16487 61864 19215 9007 56213 36597 61095 6460 43010 54466 5406 36917 35985 1051 18072 33142 18798 37611 58780 57758 65049 39263 1733 64684 15936 17288 22704 15242 6459 32599 53832 4982 25885 49668 25665 10102 28039 37778 27223 53152 18464 10794 15616 56582 31230 40900 1431 12841 60236 64853 46140 53852 7543 5730 24847 15861 6005 19582 47226 44462 25405 3732 27605 35491 19167 13373 19687 46512 15427 3894 1438 10349 35904 35823 57155 62621 41133 18739 48937 13506 27724 27361 24362 16391 38368 18664 19407 37791 7798 24957 28003 22730 50018

[test]
name: shuffle half16 ushort2
global_size: 8 0 0
kernel_name: test_shuffle_half16_ushort2
arg_out: 0 buffer half2[8] 49526 17479 12548 19598 59793 48333 56260 13502 59381 24469 49116 12417 36561 61912 9497 62924
arg_in:  1 buffer half16[8] 34386 38959 28718 4531 20187 17479 25879 49526 3445 59986 12106 55847 14382 5759 48549 54483 31718 15914 12548 61000 17098 19598 56449 59805 35592 7979 43402 53229 43807 24680 46571 45547 53804 62017 27342 59793 48333 52381 52003 24818 19118 51925 28877 31174 25697 40420 1815 7891 56260 61191 13502 44848 6054 37862 27528 24733 29455 11733 35923 2301 10129 7763 18140 40757 52141 13175 56707 30430 61410 6076 22648 39610 24469 33502 30756 3885 49010 59381 4080 14905 7883 43046 12417 49116 65530 51183 51052 33405 35675 49934 26100 1107 64932 17811 51526 35021 39257 36561 17597 50504 9161 7833 49068 61912 38396 28715 13767 59013 22103 18981 21340 45720 44251 3189 64911 62924 24978 9783 23369 28704 54801 19571 64641 3948 52437 21358 28196 9497
arg_in:  2 buffer ushort2[8] 51735 7637 3250 22213 63363 40004 38160 63026 15421 2072 3219 25826 45313 7319 23567 58931

[test]
name: shuffle half16 ushort4
global_size: 8 0 0
kernel_name: test_shuffle_half16_ushort4
arg_out: 0 buffer half4[8] 47887 35601 48227 57690 63146 56179 44126 39533 16749 1068 8898 42875 42804 23113 38358 23522 33825 40117 20617 51121 9772 11818 9772 47269 5857 3893 15811 9874 29246 29246 5236 29246
arg_in:  1 buffer half16[8] 9642 42011 41858 46905 44804 35601 48227 57690 26754 57174 4238 43815 47887 54597 12397 25776 17133 63146 58981 39533 46367 22903 4796 30386 37547 44126 10536 59706 17865 56179 11825 25246 8898 22611 9325 35123 51344 27336 10852 42875 16322 1068 21476 20168 2045 16749 20049 24414 38320 24523 28395 5333 23522 42776 42804 54052 23113 41557 38358 18978 51242 59858 15386 23177 33825 20617 48221 57620 40117 31414 5757 58868 51121 1147 40325 24692 11808 32042 46039 30633 23903 34477 11818 44135 22307 10903 12661 9772 9178 28183 52288 32565 47269 13849 10722 43467 43034 55663 50827 30061 61170 5857 9185 10158 3893 57630 45208 15811 37271 15047 9874 18967 24795 29246 5236 63985 15396 26245 26150 59513 32113 19064 28524 32330 25559 22562 27359 10279
arg_in:  2 buffer ushort4[8] 30748 20693 61302 15127 40241 60317 46745 19283 23885 21961 32848 34023 38838 39848 29866 19364 23568 2324 7601 59240 22423 64642 16599 16236 43381 48584 57275 24846 10977 35089 25170 20737

[test]
name: shuffle half16 ushort8
global_size: 8 0 0
kernel_name: test_shuffle_half16_ushort8
arg_out: 0 buffer half8[8] 3591 26381 29136 61112 61112 50416 50416 3591 41522 62317 22016 57034 29963 29963 41522 39882 53707 6857 53707 30533 23217 56457 35851 23187 38342 37791 27326 26598 12175 12175 37775 2672 32604 62547 32604 52532 2687 24449 28921 42679 47603 47993 18646 39617 54499 49041 48082 47993 12574 7225 23933 14433 31279 51203 51203 7225 46148 35129 35129 35129 24323 2577 11721 24323
arg_in:  1 buffer half16[8] 64590 9396 61001 61112 38799 4181 51783 46750 3591 36518 29136 26381 10935 31130 20278 50416 58997 15940 10100 49845 39882 34271 64785 57034 64502 22729 29963 62317 7306 12798 41522 22016 16043 56457 9298 62656 20341 52084 23187 6857 30533 23727 10269 53707 23217 21961 43327 35851 46509 56717 30680 37775 22615 55316 12175 32112 23138 26598 41411 38342 2672 53994 27326 37791 42679 61480 24449 32604 2564 10558 56273 7524 35896 42997 4695 2687 62547 51489 52532 28921 53580 48637 18646 54499 39617 48082 47993 9427 49041 21036 9677 47603 30160 49683 5891 13839 28578 18981 49283 21502 27997 14433 64333 31279 24638 51203 23933 966 49520 7225 3291 12574 61646 22884 60892 2577 24323 33824 61953 35129 27684 46148 54605 9397 11721 10828 55838 48653
arg_in:  2 buffer ushort8[8] 29816 7595 8746 58019 50755 61599 39871 39048 23182 16731 4415 19543 20938 38826 5694 42804 51579 55431 21275 4792 21308 56593 8751 43350 62203 44623 21198 18745 758 63750 23699 30732 195 41516 25843 65294 37179 25298 8303 27136 34811 27350 16626 292 34099 12376 62933 56582 42975 25837 2778 34261 36103 14121 39369 52173 985 51223 10535 22247 32388 30179 20300 41460

[test]
name: shuffle half16 ushort16
global_size: 8 0 0
kernel_name: test_shuffle_half16_ushort16
arg_out: 0 buffer half16[8] 51468 30388 21446 21446 3684 21446 59257 56244 52776 46098 41870 8418 46098 29046 41870 46098 15841 65490 30730 32122 47926 44742 56140 44742 30516 47424 30730 30516 65490 30516 44742 7535 48754 350 1113 59709 34918 27384 8023 48754 34918 59709 15142 13109 51323 58645 13062 13062 4854 2488 55515 2488 10147 18030 49862 28451 28451 34908 12224 4854 2488 4854 21294 49862 13135 28041 34519 58287 50219 2813 33532 58287 2813 28041 60452 60452 50219 56777 28041 9003 37552 686 686 42753 1293 2228 1293 1187 1187 37552 7019 42753 40456 56359 1293 1293 1602 35187 47105 14555 14555 47105 29219 9309 64994 39793 56942 35187 39793 56942 51735 48156 23864 2900 43321 43321 39396 46586 34625 52312 43321 58374 2900 23687 46586 46586 60499 34625
arg_in:  1 buffer half16[8] 49963 30388 52776 56244 41870 46098 32332 37278 38371 48700 21446 3684 8418 51468 59257 29046 30730 44450 15841 19516 47926 22788 47424 30516 53062 32122 31537 65490 5596 56140 7535 44742 8023 48754 13109 34918 350 1113 38190 58645 59709 27384 7235 49078 51323 50034 13062 15142 55515 12224 30082 19132 50084 28451 2488 34908 9883 18030 37042 35298 21294 4854 10147 49862 32030 9003 27503 50219 58287 2813 4076 49891 34519 28041 8317 13611 33532 13135 60452 56777 42753 27259 50080 43173 4494 56359 686 55553 1293 7019 1187 30170 37552 27902 2228 40456 14555 29219 55780 32165 39793 48156 64994 51735 47105 1602 3666 9309 35187 37053 56942 21090 58374 53748 52312 39396 34625 2900 34563 48058 23687 43321 43895 60499 46586 58517 56795 23864
arg_in:  2 buffer ushort16[8] 64125 45553 38714 24378 24971 63306 22702 54819 2226 709 61972 20796 31941 31295 58964 61861 52034 17323 53296 8537 2484 47247 33325 43295 21127 55622 43040 32599 11195 57703 3967 12750 48337 5652 41589 52952 13747 22009 11920 54929 55971 14584 55807 49826 24236 51927 10030 55566 42589 54982 19232 41526 29694 50249 52783 26309 12293 24647 41665 445 64246 49453 54924 51311 63901 56969 16712 59156 42723 34821 21484 30324 23125 9817 50174 23726 62003 22783 26809 40097 50956 20134 21494 6368 21368 26510 14648 9210 38618 45308 61305 22688 10591 57701 26856 55304 52857 49212 16664 49728 13728 24376 29809 64027 57270 51028 3886 32812 20548 53630 63047 23173 15055 33269 57369 55609 39683 18188 38596 52706 50569 4048 37125 4632 33052 30492 7819 61284
!*/
#pragma OPENCL EXTENSION cl_khr_fp16: enable

kernel void test_shuffle_half2_ushort2(global half* out, global half* in, global ushort* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half2_ushort4(global half* out, global half* in, global ushort* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half2_ushort8(global half* out, global half* in, global ushort* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half2_ushort16(global half* out, global half* in, global ushort* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half4_ushort2(global half* out, global half* in, global ushort* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half4_ushort4(global half* out, global half* in, global ushort* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half4_ushort8(global half* out, global half* in, global ushort* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half4_ushort16(global half* out, global half* in, global ushort* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half8_ushort2(global half* out, global half* in, global ushort* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half8_ushort4(global half* out, global half* in, global ushort* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half8_ushort8(global half* out, global half* in, global ushort* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half8_ushort16(global half* out, global half* in, global ushort* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half16_ushort2(global half* out, global half* in, global ushort* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half16_ushort4(global half* out, global half* in, global ushort* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half16_ushort8(global half* out, global half* in, global ushort* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_half16_ushort16(global half* out, global half* in, global ushort* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
