/*!
[config]
name: shuffle float uint
dimensions: 1

[test]
name: shuffle float2 uint2
global_size: 8 0 0
kernel_name: test_shuffle_float2_uint2
arg_out: 0 buffer float2[8] 25501 33771 11027 14575 6248 9823 26493 26493 26479 50203 14411 14411 11507 11507 51556 18653
arg_in:  1 buffer float2[8] 25501 33771 14575 11027 9823 6248 23165 26493 50203 26479 14411 16239 11507 39467 51556 18653
arg_in:  2 buffer uint2[8] 3978113146 2906803207 1499269495 1673419722 3536601777 1650651180 750333413 4231785547 1383576021 522733360 1275419454 401224228 2722963444 1509921490 26347852 1811732393

[test]
name: shuffle float2 uint4
global_size: 8 0 0
kernel_name: test_shuffle_float2_uint4
arg_out: 0 buffer float4[8] 45686 24283 24283 24283 61425 61425 45094 61425 57470 57470 7717 57470 45688 32078 45688 45688 24013 9036 24013 24013 55255 55255 11162 11162 2352 2352 2352 2352 30813 30813 42117 30813
arg_in:  1 buffer float2[8] 45686 24283 45094 61425 57470 7717 32078 45688 9036 24013 11162 55255 2352 42623 30813 42117
arg_in:  2 buffer uint4[8] 3005426730 73663365 2172757233 1266512361 825430457 1159953535 4079252242 2878625381 3664144358 2465647304 1521480825 1862995964 2757562227 798047992 3064814823 2848518487 2337933249 1795931640 2138496517 2014278193 1863059877 156142971 1993887958 2065617984 1029463966 1708766034 3244421714 684842056 4252211726 2739288326 3174657817 346400208

[test]
name: shuffle float2 uint8
global_size: 8 0 0
kernel_name: test_shuffle_float2_uint8
arg_out: 0 buffer float8[8] 3734 3734 3734 62721 3734 3734 62721 62721 33212 59562 59562 33212 33212 33212 59562 33212 51175 56193 56193 56193 56193 56193 51175 51175 22796 7850 7850 22796 22796 22796 7850 7850 30205 30205 55957 30205 55957 30205 55957 55957 27279 27279 38065 27279 27279 27279 27279 38065 5884 6253 6253 5884 6253 6253 5884 6253 44618 48081 48081 44618 48081 48081 44618 44618
arg_in:  1 buffer float2[8] 3734 62721 59562 33212 51175 56193 22796 7850 30205 55957 27279 38065 6253 5884 44618 48081
arg_in:  2 buffer uint8[8] 1138801854 3757775740 1166156120 1765624877 1604930506 303109420 3296198191 2825072569 2304636979 288581830 2504534666 2982471365 2782242279 2350405921 342636038 1583976837 3716544682 3927012263 2736616439 1978007845 2450031533 2632757201 2421932922 482736818 424640268 2269992605 4273092891 3363531900 260135730 2825789620 1507432193 1742627705 3481435546 3169986082 3135495807 3370830046 3678292735 3709929806 3567720171 4037274219 624059158 1161516974 371323741 4020945590 1900939254 4081172670 3283711204 3606683815 836289001 459857986 2288713958 1246706805 2206126034 1159606572 3440624789 4089951956 2325005354 2554818709 4048597513 399903622 238137757 2679193297 3955575576 1947002656

[test]
name: shuffle float2 uint16
global_size: 8 0 0
kernel_name: test_shuffle_float2_uint16
arg_out: 0 buffer float16[8] 14258 25354 25354 25354 25354 14258 14258 14258 25354 14258 25354 14258 14258 25354 25354 14258 55530 55530 48793 55530 48793 48793 55530 55530 55530 55530 48793 55530 48793 55530 55530 55530 61332 2786 2786 61332 61332 2786 2786 61332 61332 2786 61332 61332 2786 2786 2786 61332 21576 21576 60946 21576 21576 60946 21576 60946 21576 21576 21576 60946 21576 60946 21576 21576 55740 58915 58915 55740 55740 55740 55740 58915 55740 58915 58915 58915 55740 58915 55740 58915 56309 46046 56309 56309 46046 56309 56309 56309 56309 46046 46046 46046 46046 46046 46046 56309 21954 21954 21954 16860 16860 21954 16860 21954 21954 16860 21954 16860 16860 21954 16860 21954 55409 47836 55409 47836 55409 47836 47836 47836 47836 47836 55409 55409 47836 47836 55409 55409
arg_in:  1 buffer float2[8] 25354 14258 48793 55530 2786 61332 21576 60946 58915 55740 46046 56309 16860 21954 47836 55409
arg_in:  2 buffer uint16[8] 4194821379 4221560118 2803819096 887659088 3327117032 300998337 3070163005 3885758191 2712206148 1580027217 3353906014 2848109959 3348970047 2879125590 1560583076 1855816747 181255843 395824793 3716612750 3419408337 2058124142 550880722 3426845353 3739979895 2582364569 2448966673 702381558 4170557819 978664382 3702159863 1180483145 1636960319 152850771 2740404686 1488794916 782749653 462784347 2529454906 762266420 1393965831 333432767 13356022 2016490391 3209480713 3668330958 671875012 1807948888 1715072347 3631615182 1299903538 527527023 3462642702 4129365916 3303983919 2342071800 3103079245 4004147208 303858318 1772516708 1606787607 1973022488 3571388243 4243151648 3880590322 320733955 1919098118 3462913902 656289071 4259479443 2154889019 3673501027 3614549106 2872358733 3025749780 56764228 3914422030 1512041035 1647411816 3627322039 1779193584 3102135229 85839652 717791027 1500893357 2047249044 371260807 487505499 2471007301 3337362755 2070114416 2205739036 3639914818 2225257652 4274806556 957108736 3888419669 696283925 1004011573 3873492411 2710567934 3468500900 2784312751 3347464654 3241989135 1441170571 2833082026 1835281539 3148127626 2368183644 257303757 2193069940 3988601671 906602141 3216551102 2264664987 2432336556 48952519 3170699142 2793874676 1916054006 1460924128 2480059882 3079984191 1951697247 2444261672 2272420040 711501425 2284464503

[test]
name: shuffle float4 uint2
global_size: 8 0 0
kernel_name: test_shuffle_float4_uint2
arg_out: 0 buffer float2[8] 35886 54786 64344 39792 44802 44802 50311 6121 55944 55944 22229 38713 25298 59447 11090 22961
arg_in:  1 buffer float4[8] 63206 1931 54786 35886 58697 29297 39792 64344 24756 18875 54007 44802 46187 6121 50311 29724 36314 58794 21610 55944 38610 22229 32147 38713 25298 59447 60424 3462 11090 748 11962 22961
arg_in:  2 buffer uint2[8] 2082033679 3982089990 1534654843 4006813502 1971821223 218870503 370956546 2686678037 4037970379 979278107 3427513085 2484900595 833285528 2746357713 471953392 1532447063

[test]
name: shuffle float4 uint4
global_size: 8 0 0
kernel_name: test_shuffle_float4_uint4
arg_out: 0 buffer float4[8] 52270 25303 61105 61105 23801 23801 27957 27957 18062 18062 44018 15597 61892 44720 28222 61892 61828 61828 61828 61828 8488 12678 14362 50035 20464 13249 15070 15070 27094 59294 50747 59294
arg_in:  1 buffer float4[8] 43064 52270 61105 25303 14868 216 27957 23801 44018 30619 15597 18062 44720 28222 60224 61892 63986 25430 61828 41627 12678 8488 14362 50035 20464 57903 15070 13249 32551 59294 50747 27094
arg_in:  2 buffer uint4[8] 1794271253 1064791071 2761398266 2920737550 3779889795 3783232187 1406600618 2964250334 1213574959 42739031 2320936780 3470609326 510980227 3996146684 1263460989 1700372063 198978542 779968666 1061227322 3761603038 1279805277 1172969868 3166984202 4175425335 3283624504 1861272331 2747606278 103639078 4170957735 2694470373 935471838 1628054233

[test]
name: shuffle float4 uint8
global_size: 8 0 0
kernel_name: test_shuffle_float4_uint8
arg_out: 0 buffer float8[8] 13578 13578 13578 63583 13578 40716 54812 40716 40552 50842 50842 50842 50842 50842 12444 50842 6823 6823 35564 6823 12247 35564 35564 35564 15472 15472 15472 38576 38576 4071 45930 4071 30775 57358 62800 57358 30775 42908 30775 62800 57433 48576 19241 19241 19241 19241 19241 48576 15645 15645 17590 17590 17590 15645 15645 22273 4110 55722 41019 55722 41019 55722 4110 31109
arg_in:  1 buffer float4[8] 40716 13578 54812 63583 50842 12444 59796 40552 6823 35564 12247 53665 38576 45930 15472 4071 62800 30775 42908 57358 48576 19241 57433 55518 15645 22273 42303 17590 41019 55722 4110 31109
arg_in:  2 buffer uint8[8] 1766076781 1003984437 4101728257 3815368203 1739841585 4066822712 2105919822 3192760376 2957452083 4187092556 3168929096 576251180 3590955992 4207118888 476286737 4087685416 3335542004 1360225068 4080257633 3766776596 376207510 1873156217 2788339777 1444204265 429435666 662879182 3912490386 1156233516 2408396888 2704443923 1355252973 97157215 3372213685 3159300299 4095012200 156437307 2381043369 2082661278 662094721 346839360 1257837078 2638157436 2558866729 4270805097 838377425 3017442557 2920012517 3218679712 3619764796 861121072 1231075915 2780279563 3923746199 3932139252 2714998976 2384674341 1891754598 2041155877 1937415620 794608209 2584150940 3957438969 3884020934 3892705867

[test]
name: shuffle float4 uint16
global_size: 8 0 0
kernel_name: test_shuffle_float4_uint16
arg_out: 0 buffer float16[8] 29403 1762 38568 38568 29820 1762 1762 29820 38568 1762 1762 29820 1762 38568 1762 29820 2887 2887 49763 15712 49763 15712 49763 300 2887 49763 2887 2887 300 2887 300 15712 41340 33135 46132 33135 33135 14493 41340 33135 33135 33135 46132 46132 14493 46132 41340 41340 48224 6606 6606 17589 33949 6606 17589 6606 33949 48224 17589 17589 33949 48224 17589 33949 51592 8724 26496 21165 21165 26496 8724 26496 21165 51592 21165 8724 26496 26496 26496 8724 39189 39189 39189 64463 39189 33108 39189 2633 33108 33108 2633 39189 39189 33108 33108 39189 20644 26555 49665 65383 49665 65383 26555 65383 49665 20644 49665 26555 65383 20644 49665 26555 48833 48833 14501 14501 14501 14501 24289 14501 14501 48833 24289 48833 14501 24289 14501 14501
arg_in:  1 buffer float4[8] 29820 29403 38568 1762 2887 300 15712 49763 41340 46132 14493 33135 6606 17589 48224 33949 21165 8724 51592 26496 33108 39189 64463 2633 49665 65383 20644 26555 48833 14501 24289 5085
arg_in:  2 buffer uint16[8] 192178089 3927823771 4187323370 1569526854 899386988 358546159 304293351 3831006824 4176593750 4073350015 1558411911 942349032 4268198283 3223243222 2596698407 3862281668 2372206916 3548300036 1633561523 2586289542 1308051159 1062356466 1699236295 684012773 1460502264 3273258831 1422918860 1246440788 3660911973 2802282208 3508542341 3024347546 2451912396 2273786079 2016683305 2342076435 2008777735 3601824738 2385481356 111747883 211382875 3079003191 3148205141 2521885181 3340686082 1850493069 1301933476 976568240 4140642782 4181342960 3001066812 3043529889 2831157635 3558290476 619154973 723429524 3285254643 115049390 4033735129 2467326917 3845216075 1367687018 2222984845 1193532507 2654889274 1871729 2443123675 61185876 151404236 4251828723 4096864189 610453807 2219455660 3433976402 3537161200 3595056325 1218802911 1600971619 3420200515 1742425301 3835882365 2856803237 1733334261 4178584102 679863737 3198662280 723075001 553235887 4087121956 279399572 3067573163 343703981 2370011737 84956172 703469784 1443670105 3104696890 1965255567 3686976088 2441448505 1062488040 1889797229 3964381535 1403520909 3992269704 3258732662 812810800 2244367687 242573341 2338039762 3743939576 2316644479 2355091500 3666245876 529753029 1901163905 1457141225 1712843713 564907510 1815653689 3862944297 44010412 3630364458 3285544588 2749884281 1029606926 3147857061 503028973

[test]
name: shuffle float8 uint2
global_size: 8 0 0
kernel_name: test_shuffle_float8_uint2
arg_out: 0 buffer float2[8] 53979 53979 56645 33566 30773 43918 24844 10755 28165 51021 21842 29115 8705 19679 557 47195
arg_in:  1 buffer float8[8] 33613 54203 5716 37446 35868 53979 19075 33191 56645 47723 2768 47037 50578 40757 33566 4085 30773 47132 43918 11745 51835 63564 27879 1749 55200 33328 47182 24844 32023 10755 12698 14979 14743 38829 24379 51021 162 28165 18014 62091 50611 4750 29115 21842 23299 4106 44808 47923 1850 19679 12244 41800 20936 21286 8705 8396 43940 60738 557 38332 50776 24461 43609 47195
arg_in:  2 buffer uint2[8] 1706753709 1881934397 2436437904 4046911054 1832519912 2949747314 761053043 2252180701 524546749 2413484259 4227520187 182675722 444100638 1743314521 2285537098 29815359

[test]
name: shuffle float8 uint4
global_size: 8 0 0
kernel_name: test_shuffle_float8_uint4
arg_out: 0 buffer float4[8] 50002 49167 10751 27027 62506 35217 26191 60675 5175 52446 5175 60521 64538 13948 53953 64538 21660 39421 46734 32470 44325 44325 52326 45087 39250 21224 17522 15034 55371 36781 2356 36781
arg_in:  1 buffer float8[8] 21227 10751 27027 14991 50002 55612 8949 49167 11552 32875 60675 26191 50364 62506 35217 24622 5175 56149 60521 32221 52446 39378 23686 37916 10194 43958 60912 53953 6019 62559 13948 64538 32470 39421 38953 46734 34507 46734 31835 21660 54800 60670 46483 44325 25101 52326 45087 63350 35989 21224 39250 61990 17522 10154 15034 45275 65298 36781 2356 44686 57821 24971 55371 40819
arg_in:  2 buffer uint4[8] 3928487556 3580145399 1970618017 4141619642 4062329005 639925254 392947051 672033362 434791136 633769780 3974835560 2193214290 1933441103 2166115166 2753170219 2130391495 3350821119 3630932569 2392820883 1317846872 4252962651 1326517763 2142688061 867651870 3084176186 2488069441 2157843236 226165582 1964671790 3118202697 1724334730 3397892305

[test]
name: shuffle float8 uint8
global_size: 8 0 0
kernel_name: test_shuffle_float8_uint8
arg_out: 0 buffer float8[8] 30409 61475 56260 61475 29130 48571 11020 63531 38005 56197 52642 52642 38005 45603 52642 36729 17169 17169 17169 45162 26199 189 17169 49162 4390 40934 28332 25898 63315 3630 40934 25898 29726 3073 9230 60351 181 50037 3073 9230 5548 13396 53117 13396 53117 18314 53117 53117 2536 56809 56809 48674 2536 21968 42128 10943 13020 35903 13020 13020 39935 37087 43609 5653
arg_in:  1 buffer float8[8] 63531 29130 11020 56260 61475 52656 30409 48571 38005 22279 56197 30616 52642 45603 36729 53686 49162 60280 189 24855 32593 26199 45162 17169 28332 57426 40934 4390 3630 25898 63315 20196 181 29726 50037 60213 45513 60351 3073 9230 24021 5548 22030 5665 18314 34665 53117 13396 48674 10943 56809 30474 21968 42128 2536 5513 31120 35903 43609 52920 13020 37087 39935 5653
arg_in:  2 buffer uint8[8] 4276289006 211428076 1581117195 2195359028 1750326473 770593359 2160498482 960373400 614651448 1028827490 1226946924 2477956644 2949962600 3869422253 3505538788 2038905414 3202081079 1173454711 1378668383 81414958 1293180685 2563201034 3622025815 2295516008 937462363 1475472786 2933231168 3782032445 1207628110 1808704252 4183831274 1746588949 1560487233 2623235942 4276575663 3072559317 2991599352 3310967650 1471544958 1907134455 1273946609 883408423 3497328190 3461886391 448253734 1615071788 746435742 2067339390 921642198 956612994 1208897082 580966920 2720172030 3753289452 3209120909 2400510713 1768447204 3680732913 1684184092 2592931548 1922863030 1703966877 2142057458 2977779143

[test]
name: shuffle float8 uint16
global_size: 8 0 0
kernel_name: test_shuffle_float8_uint16
arg_out: 0 buffer float16[8] 58341 13765 13765 32706 32706 26981 58341 58341 14343 45386 46774 14343 25069 32706 46774 45386 6947 33950 29517 33950 29517 6947 29517 17751 35092 17796 17751 6947 38592 38592 38592 17796 30380 27264 59011 27264 43013 27264 59011 59011 55653 7505 30380 27264 55653 7505 43013 30380 16686 51535 383 51535 9664 16686 3967 23991 51535 60634 16961 3967 16961 23991 23991 23991 43710 41424 26893 34812 4583 26893 45156 43710 17674 26893 43710 43710 34812 43710 42691 4583 26859 40510 26859 59773 49691 40510 26859 59773 26859 59773 40510 18605 49691 26859 26859 40510 55210 47537 44642 44642 44642 55210 48103 48103 55210 48103 33755 36849 65478 44642 36849 48103 17616 17616 7030 19644 19644 58114 7030 7030 35813 35813 17616 58114 17616 35813 55360 58114
arg_in:  1 buffer float8[8] 45386 26981 32706 58341 14343 25069 13765 46774 17751 56771 29517 17796 33950 35092 6947 38592 32475 27264 7505 55653 59011 30380 43013 5811 3967 16961 51535 16686 60634 23991 9664 383 45156 17674 42691 43710 26893 34812 4583 41424 47167 40510 26751 18605 26859 59773 46389 49691 65478 33755 36849 29113 47537 55210 48103 44642 22821 35813 7030 19644 17616 55360 58114 52743
arg_in:  2 buffer uint16[8] 2388006979 841720302 3946601582 759477426 1732257682 333912273 2128687779 1367850107 1357702124 982562248 1639937903 4064099652 701185037 3204939986 278852327 128977144 343217694 1726256460 2251706298 2262590644 2632369298 2641313966 1788618186 568585808 1254489733 442214563 2188077128 996897862 2871191975 2049263239 3692197871 3878565915 1762186117 1038700273 4192475092 3434323977 1389052158 1109540329 1743359636 1250198100 1757574291 214874826 3836926821 2781248265 561987603 2652759258 140196670 6205789 306969715 3451118770 1172312255 2333766714 2399185574 987604443 3141589144 1320248605 993981890 723366148 4148071785 1767648960 2954367057 844418749 3081025781 1735207381 4023815523 1345645055 1856004556 2415919253 1348417150 219179972 267778568 4019022371 2403171129 1875653548 2861562347 2354541427 2353548269 1972341611 446416114 3811616430 1423125372 3833526641 1425284732 3922807277 1912246855 3691128337 2743304196 854316861 1096351052 2360851893 467769825 2688010379 1612561511 2762562052 2905878340 345806761 1035592013 3065899356 4003252759 1129091279 2013991079 1629200525 1132012702 2456778326 2230408517 3689007982 2651177345 3829675122 1177545184 1257063503 557476426 1540511014 410471212 3242789332 3237087698 3017821155 1074874971 1164642406 1112664226 3514320050 3129703377 2824672025 133347860 4137974014 2490999596 15384249 3317310053 4230790006

[test]
name: shuffle float16 uint2
global_size: 8 0 0
kernel_name: test_shuffle_float16_uint2
arg_out: 0 buffer float2[8] 30362 63453 1085 38651 27204 23268 64837 20253 38941 11838 42867 17737 61469 484 16296 64235
arg_in:  1 buffer float16[8] 11997 57950 27509 56940 65392 8244 35483 63453 52373 33209 36560 39276 46327 60341 30362 29949 14417 11213 57475 28006 24904 36809 14753 22919 4262 32140 46451 54211 5138 38651 1085 7487 8764 35088 61271 5459 31810 10293 23268 54902 36250 62309 47068 27204 39550 52935 8679 30600 64837 20253 8918 9923 10291 47287 46534 46016 29448 64922 10893 31659 17041 9913 30654 16654 37690 60865 63892 36640 43369 37589 54672 40866 11838 24703 60522 24651 38941 61739 54716 4536 58005 57562 55152 17737 42867 58403 62166 33333 25050 12107 16850 6975 55776 36578 30900 54703 27483 26769 29782 61469 49924 33695 484 5870 24696 28232 13337 35044 17911 35363 34391 17512 23406 42465 43146 22011 48321 64235 36610 48561 37751 38398 16296 43923 6486 21630 36642 1786
arg_in:  2 buffer uint2[8] 1193034974 1024710711 2895417086 3998870333 3110345515 1214161750 4264553104 4287602001 602068652 2617256712 1306378404 2113733891 519153699 3089221782 2572319882 552198821

[test]
name: shuffle float16 uint4
global_size: 8 0 0
kernel_name: test_shuffle_float16_uint4
arg_out: 0 buffer float4[8] 3771 33381 54012 40789 25872 25698 47615 34923 30363 40269 1244 40269 2525 32148 52671 15935 16710 16710 28065 24067 1333 3261 17450 48313 8900 56323 6257 28010 18882 49044 3647 16734
arg_in:  1 buffer float16[8] 33381 11663 43339 61558 3771 19882 54012 57381 48610 51836 6111 46877 23006 40789 56223 65110 20978 36967 34923 47615 60271 19969 44193 32862 12325 25698 50304 18692 53525 46627 25872 26513 61244 40325 23605 1244 57432 40269 48722 18300 30157 39796 28161 12303 30363 44359 14087 39559 22236 65466 52671 16638 9885 15935 58017 32148 12417 21981 2525 37630 9518 13933 12170 63696 21959 47149 39696 26141 18753 16710 40370 30855 28065 16142 21697 16777 408 37840 40149 24067 3261 18982 14347 31002 30249 46191 38982 44647 63895 39385 8697 1333 27145 64475 48313 17450 63372 56323 34222 24222 24479 6257 18852 8900 4474 28010 42368 40554 27507 22984 24696 63600 29564 35606 52140 14393 47905 51579 49044 18882 3647 22525 25905 18654 16656 16734 41650 16401
arg_in:  2 buffer uint4[8] 2844735380 2958243856 707686438 4246304125 2010445950 4206087513 3735755523 1754522066 2932237020 3839482101 987099667 2710967317 3033177642 1021466167 1516329058 1030397429 1867275989 2878237013 3828214440 1965038975 3204429291 2385527088 3216648879 2670931486 3371839975 513829217 3154030917 1955044841 631174871 2275380790 2036808424 1650694829

[test]
name: shuffle float16 uint8
global_size: 8 0 0
kernel_name: test_shuffle_float16_uint8
arg_out: 0 buffer float8[8] 64663 47251 16086 55322 55865 64663 30818 55865 60097 2142 13100 52812 47627 13100 43402 10148 9903 9903 65262 27678 38391 21611 44552 23455 54300 521 61937 54300 13652 23503 48053 521 9778 58786 22547 40928 31781 50589 46120 5900 56245 15576 15235 45772 23676 11100 48364 51138 36764 31665 63968 63968 44252 44252 24302 36764 34860 9907 4901 28687 31244 36125 36125 33512
arg_in:  1 buffer float16[8] 28126 3054 55865 4961 64300 65282 48981 2894 64663 30818 13235 47251 31675 16086 55322 47698 10148 47627 44623 57267 52812 60097 32987 2142 14341 55425 13100 57 43402 46720 34844 18587 43509 15198 21611 61473 38391 44552 45268 26368 23455 39421 9903 1889 64269 27678 38998 65262 48053 13652 61937 23503 521 50697 802 64645 38686 8659 5748 36196 18660 54300 20458 933 55618 31781 40928 42668 7902 28502 23151 22547 5900 28031 9778 46120 50589 19523 58786 37751 2565 40142 45772 16511 48364 24655 51138 11100 56245 15235 49178 15576 23676 17642 19289 56578 22545 48796 56411 50468 46441 27336 63968 24302 29553 1870 22536 36764 17863 31665 44252 47851 33512 38592 18750 19867 8921 28687 31244 15624 26933 9907 35681 34860 4901 61773 36125 64683
arg_in:  2 buffer uint8[8] 1871484232 3820912363 2743715949 3876542302 186250674 3091882968 3788013561 3113825186 3516751461 2306274903 673421850 2349180100 3214542593 3744056938 4164899148 53674176 985918730 1924794842 2799789679 1745540541 4291505924 2096718514 1712327173 700289416 3562568429 2132123844 2352874898 4176104509 1943625697 2780111075 3879121456 295333940 3323988842 2325723326 1500456951 558654146 2013481857 937560524 3482743483 651624680 2746936712 1014187195 407352313 3153334642 731497644 667701815 3643347524 70887526 2157322491 2454405837 3787963910 2773288326 3052085326 4049649214 3542396679 1208944059 2379304427 2297467961 2923614268 2042484149 1652437974 3867313694 4152968014 2635314688

[test]
name: shuffle float16 uint16
global_size: 8 0 0
kernel_name: test_shuffle_float16_uint16
arg_out: 0 buffer float16[8] 33489 13795 33489 61203 64708 15473 7008 61203 49662 25278 61203 15473 49662 61203 33489 13573 21146 2876 21040 52980 23550 23550 44781 21040 29806 52980 2876 29806 16626 16626 52980 46183 27587 27587 49903 35930 50572 41927 49903 49308 50572 30272 30272 11699 49308 35930 50572 56892 16640 49615 17213 4020 12169 52064 9557 16640 2782 16640 4020 12169 60282 6712 60282 17213 27729 37509 28500 16484 31438 27729 52309 31438 16484 27729 50411 21148 39467 35494 8059 28500 19210 13599 28413 30177 30177 55648 63274 29196 29196 30177 62079 29196 59065 29196 19210 16241 44481 37523 55687 55687 17192 50571 17192 44064 13650 10408 43666 55687 51052 13650 57346 17192 51222 63200 5614 5614 5614 12254 29829 62332 63200 63200 63200 18608 13313 1264 63200 51222
arg_in:  1 buffer float16[8] 64077 7008 15473 49662 60199 40281 13795 25278 13318 33489 17770 61203 16808 59729 64708 13573 44781 46183 2876 52980 21146 23550 16626 32217 56619 34320 33574 21040 29806 30608 4466 49871 39849 35930 41927 25592 49903 11699 56682 36048 30272 5106 50572 49308 56892 16100 27587 57761 3925 60282 4020 2782 9557 16640 12169 35601 19109 39160 12325 52064 6712 17213 41793 49615 52309 17430 39467 27729 56335 37509 16484 50411 31438 8059 35494 28500 29856 62423 62885 21148 29196 63274 33059 28413 29752 30177 59065 60011 55648 22517 37370 44748 62079 16241 13599 19210 39293 55687 16276 34227 57346 37523 43666 13650 44064 10408 48954 17192 47114 44481 51052 50571 63200 5614 12254 31771 64369 13313 18608 62332 1264 4669 62600 12157 37404 29829 51222 60092
arg_in:  2 buffer uint16[8] 4033439897 925376230 3760719625 2018244155 17552638 1253291250 3270473889 3584522507 3647251155 2808193543 3181579819 2077345570 4069954819 3809101787 1842465513 788756799 3981584228 3942243634 2268865419 247173427 715280853 798691493 1394452768 1764468347 2435648620 3437703363 996773522 1276808300 1800272262 265500214 4233863667 3132425697 1720158526 1376366574 926805844 136019009 3845406458 4230039522 2250289892 4004403067 1950840186 3656844504 2904984280 1192405157 400149067 2209960433 1163007962 4214648652 1152261397 3654315071 2128223085 2426831218 3300053606 379264091 3233495668 508249525 2243034675 3434882821 684496514 2444501014 1622614401 3040181036 2388062801 1399237661 2661605251 3211882085 1228874283 1509532342 3691083224 1821406131 1629260512 944860984 3650437254 2926426387 2105885463 1646709343 2632018466 873819354 329021385 930738523 2065940287 3226713614 3059781891 925335893 901490421 2654585512 933533249 1934152736 445080720 2826934037 171214956 1868016208 2637736342 1623410672 1132841279 354605101 3022767373 327210613 38619825 2320579761 2744896139 1804060815 2695581835 156781848 1969073895 63736825 1079832326 1962687745 1301345166 1197330999 4020052372 880828491 247974190 966283936 835692337 2864120097 3115984193 2020592514 1555299853 2863380647 3172150656 716591712 723871936 2500514662 2859736757 3242791928 3042087808 1778376366
!*/
kernel void test_shuffle_float2_uint2(global float* out, global float* in, global uint* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float2_uint4(global float* out, global float* in, global uint* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float2_uint8(global float* out, global float* in, global uint* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float2_uint16(global float* out, global float* in, global uint* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float4_uint2(global float* out, global float* in, global uint* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float4_uint4(global float* out, global float* in, global uint* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float4_uint8(global float* out, global float* in, global uint* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float4_uint16(global float* out, global float* in, global uint* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float8_uint2(global float* out, global float* in, global uint* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float8_uint4(global float* out, global float* in, global uint* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float8_uint8(global float* out, global float* in, global uint* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float8_uint16(global float* out, global float* in, global uint* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float16_uint2(global float* out, global float* in, global uint* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float16_uint4(global float* out, global float* in, global uint* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float16_uint8(global float* out, global float* in, global uint* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_float16_uint16(global float* out, global float* in, global uint* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
