/*!
[config]
name: shuffle double ulong
dimensions: 1
require_device_extensions: cl_khr_fp64
[test]
name: shuffle double2 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_double2_ulong2
arg_out: 0 buffer double2[8] 14863 44880 32329 32329 9668 9668 28952 28952 36140 3091 51555 51555 9027 9027 58261 58261
arg_in:  1 buffer double2[8] 14863 44880 32329 27556 9668 2303 38735 28952 36140 3091 12476 51555 42977 9027 58261 20931
arg_in:  2 buffer ulong2[8] 6243526283524372530 14124280433480287835 10170775864581462948 16901069910176065580 4001498037355424032 2380340867239554548 8056600953242802039 2209727298083781867 14934882246596289686 1207627398674756803 8739812005450592439 753056802101848669 12982030969809369581 17777955007233074885 12292688018656157606 5179258707603226176

[test]
name: shuffle double2 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_double2_ulong4
arg_out: 0 buffer double4[8] 12744 13665 12744 12744 26219 26219 20110 20110 26428 60177 60177 26428 7255 18692 18692 18692 34834 1855 1855 1855 46747 46747 46747 46747 3108 60270 3108 3108 40759 40759 40759 55711
arg_in:  1 buffer double2[8] 13665 12744 20110 26219 60177 26428 18692 7255 1855 34834 46747 8840 3108 60270 55711 40759
arg_in:  2 buffer ulong4[8] 11396423428903564643 17586248503123249180 13443386027517030051 9681027207344729103 5232279160982088357 5500521816491015073 8210222947603477420 3068431701383185032 8239130725140156781 7440834121982028904 17004063713151018138 12096029785644679657 13067154205219940305 12056784448417378106 3756161277031027632 7378877893151602184 16493286030394253745 572755551829570032 9842545391040605008 5271793682120710578 7833879052038924162 11554534724280495966 17591419537714053196 12001760182917760500 16983365422775078232 14881826431218439479 17915068115997138166 12452985776140378046 7418274250893990785 5545557488732949541 6224746297456909109 8911507483344829406

[test]
name: shuffle double2 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_double2_ulong8
arg_out: 0 buffer double8[8] 36636 36636 47308 47308 36636 36636 47308 47308 6048 6048 37900 37900 37900 37900 6048 6048 11400 24507 24507 24507 11400 24507 11400 24507 16395 16395 16395 16395 52310 16395 52310 52310 33003 33003 62615 62615 62615 62615 33003 62615 40958 43621 40958 43621 40958 40958 40958 40958 52176 52176 52176 33723 33723 52176 52176 33723 31539 31539 5070 5070 5070 5070 31539 5070
arg_in:  1 buffer double2[8] 36636 47308 6048 37900 11400 24507 16395 52310 33003 62615 40958 43621 52176 33723 5070 31539
arg_in:  2 buffer ulong8[8] 15897925351003097788 12991070964040769696 9108952189571933565 15836992909640103181 9578846320177752546 16885018864280310976 309906901231261991 13821903908864572299 5705351242371241038 12758399214514679916 4293775424390313913 370612368937902509 8230057534136521549 17620151401844705323 11402449594194399130 16268531796282349696 7502943084870509152 14739380063923568909 15836612656615114729 14841398819036657009 16985799277397663674 6597947599337258731 13551606593927842572 5635854451966323385 11750678010628283698 4184277063200360118 15059837671611617178 16640989931307724280 13659078791391303633 11335843528648485224 9397559215113781153 582940465140619845 10955141234292708036 2696343741342195934 2771270505886346683 1666454420712597561 16083804853586206567 13778599401703834301 12312884136663989416 7759408870249389343 9598998642439923652 3410377939890675859 15984000220890575950 11411298023283394915 1300145722411831272 14001416452648833916 15497839872299555596 2383976550226025670 6644928165934323992 13225790533181757180 17898060315147085890 8471197478810291487 14823800379766639547 9505536024683557892 7312245555060174704 17423576074462549109 4876162143061020237 9268598269008936895 8211176200776594172 12106423120509991076 2229647246271905942 4734827722056782252 2452698449720281327 11571106397944445528

[test]
name: shuffle double2 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_double2_ulong16
arg_out: 0 buffer double16[8] 9960 9960 9960 9960 2912 2912 9960 2912 9960 9960 2912 2912 2912 2912 9960 2912 11538 11538 47973 11538 47973 47973 11538 47973 11538 11538 11538 47973 47973 47973 11538 47973 14812 14812 22440 22440 14812 22440 22440 14812 14812 22440 14812 14812 14812 22440 22440 14812 33365 31749 33365 33365 31749 31749 31749 31749 33365 31749 33365 31749 33365 33365 33365 31749 55428 55428 28975 28975 55428 28975 55428 55428 28975 28975 28975 55428 55428 28975 55428 28975 4713 45037 45037 4713 45037 4713 45037 4713 4713 4713 45037 45037 4713 4713 45037 45037 40939 62401 40939 62401 40939 40939 62401 40939 62401 62401 62401 62401 40939 62401 62401 62401 18093 18093 18093 48531 18093 48531 18093 18093 18093 18093 18093 48531 48531 18093 48531 18093
arg_in:  1 buffer double2[8] 9960 2912 47973 11538 22440 14812 33365 31749 28975 55428 4713 45037 62401 40939 18093 48531
arg_in:  2 buffer ulong16[8] 7718400056756206512 12574289263515207826 10833483591320023162 18367530623512991632 13774431435597058061 15118512813214183783 11052667522249574440 7776093248124615601 17320483982153465770 14101709203843445856 5107640701605983269 1782909411988082005 9254635293152016993 5378187240043979339 1280328596903666302 15252491340411369139 9202406011661619389 17741210485845402063 12589911572222465482 6367119124981889657 10746039534096632286 14290534897552228460 12343677479332257231 13885929221596628014 11013209085494119779 9507408283012057169 13273190983902036007 15518631087965225360 13222435918411148112 7516953522072391552 483500188107473109 12372625571464456790 3033227724130273819 7040362685098547947 9755745028971471652 13809816432247764730 2964604607246691275 14433875619842615506 9663889282990741430 4685895443257807307 2038018798251747379 4136655481400998234 15405222341759451563 13441301455730817911 13253299232327352771 7863011344786577840 17029804384367733354 13329634988938093789 13812934417362313626 10982470060603816503 10285109364332572090 18092787813847809256 5606964406189503873 2187627344263306247 17318080373773864225 18093714331313730521 14749214019400061652 15659758175145865057 11107450194830210556 3570733226478462031 2350173582830909014 4324519991079105864 6105953900472919586 1214034269600289575 3829521115399410289 3605831034505596503 4628163997500018654 6855555543006324002 10828666370336279481 11192507748978914162 1032846601262620261 7332959554534316437 2797421472200431240 264107794209371772 665680233396480264 10248159507396480727 15943214149493508217 5606515785005617878 15995742450365847271 3141688215699554244 17054415485611372324 228089274702084251 15438350930627958971 7597073716503804118 16017588038085349733 13770586771133265736 5139997363032107695 6408650012668703240 2124012662748829482 3032461263853920074 5856845605216630185 1922604772060674413 1829035897578222608 18339886487234879376 6276698549136526235 15798598352274281465 10607970867022618385 554412674843521122 14913973285005139907 7203845866273439762 1508553430102928913 18121764180794397251 5896047222487623364 10199976191883056405 18279097606817637150 17034825812503964162 8753677962071256790 14179798013392040012 16555229477700048263 12706220670576867834 9153332500063275520 6537639015637613330 9253286555922334644 18044266424546274146 1788614920375724532 15749104007009515033 728538551444112496 1733111612571653193 12570928245181935000 13124452217514143584 11159982806945750138 15514351926095406172 13312193813980536758 675302381876415895 5467920560484275371 10604177367852217858 5746802745056372095 10306725859238554676

[test]
name: shuffle double4 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_double4_ulong2
arg_out: 0 buffer double2[8] 14752 14752 25204 25204 39545 39545 62758 62758 32299 34172 12552 35910 50342 10228 15833 39743
arg_in:  1 buffer double4[8] 14752 2074 23688 47058 47348 851 25481 25204 26791 50879 39545 19964 62758 56529 31765 4079 32299 30577 56326 34172 21424 12552 35910 21330 35619 10228 50342 46880 15833 53503 37995 39743
arg_in:  2 buffer ulong2[8] 10377572458918007900 10955896401722749092 14815046364618529107 5627260975043028147 14347710236024425746 12445360365368562282 16096666653240047040 9227070070030070656 3728917511698848492 17795912450747146967 10667305951391481741 5684595483616650950 8734395820324970326 1892864507674332349 12937961605000394436 1685991567037144083

[test]
name: shuffle double4 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_double4_ulong4
arg_out: 0 buffer double4[8] 8118 34923 11281 8118 18115 37187 6593 37187 3411 3411 33231 3411 45010 2962 2962 817 16673 44508 44508 16673 2351 2351 27684 2351 50430 40856 50430 50430 44213 10016 22957 1071
arg_in:  1 buffer double4[8] 34923 56139 8118 11281 6593 18115 11939 37187 24407 33231 3411 2295 40266 817 2962 45010 22824 2712 16673 44508 19733 27684 2351 3601 40856 53657 50430 56123 44213 22957 10016 1071
arg_in:  2 buffer ulong4[8] 15578193986600944826 16194064200455379128 6415629365216426743 16577724547434362986 8482593383243387717 5707849844358557627 13851422805245643248 7348195636576732991 2647441461960465754 2679890847187178958 15519096007779835417 16901667052857170922 563009325895937163 13084059438840862478 9970697315233046790 11557000744302964533 9183845875560511306 14323700278215493051 4596790297251174087 5889934617769492726 13551823683408426330 6512426355572843966 18105915554641818485 16691689487229556130 17847552960128958506 2916409678197068560 4094674786082389902 15645126672609674286 9410803086524862220 16514079717993771394 3316346731802470253 10988420094842051363

[test]
name: shuffle double4 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_double4_ulong8
arg_out: 0 buffer double8[8] 42679 4511 19937 19937 42679 19937 5967 4511 11037 11037 6544 11037 4009 45909 6544 6544 1590 28922 61640 61640 61640 45842 61640 45842 35993 21207 21207 20918 23684 35993 20918 35993 58119 58119 6586 37615 6586 6586 37615 58119 2122 16484 41704 2122 16484 16484 46206 46206 17503 49346 49346 17503 59634 62097 17503 49346 43628 43628 52257 63824 52257 52257 52257 52257
arg_in:  1 buffer double4[8] 42679 5967 4511 19937 6544 11037 45909 4009 61640 45842 1590 28922 20918 23684 21207 35993 57186 58119 6586 37615 2122 16484 41704 46206 49346 62097 59634 17503 52257 13850 43628 63824
arg_in:  2 buffer ulong8[8] 11051365943249794060 4734842281874951926 13564697786735929611 1826699753783718503 12221861585607771108 796274546104696003 12048921731626387789 2485494506380354166 9205692442851557929 16047221039549166149 12761626691784458688 10662408184981647137 13747438577757007483 9011905433694907794 14069941117410923540 9927993715282000280 9078684103014132246 18099267170067095163 9156992319697107724 497028743820950180 18043372752620137080 8935722808509492433 10093852138004102420 15046459859453067481 9556716241549815611 13209182556974685854 11496037739616033366 6290407914274781504 11615088289247676821 14817530042548306195 8305161850464990972 14455930195506515815 11429180894262233289 5799975927491676457 6540999768907711490 7605641539725448667 15863172175187217702 14462246114145318790 2519195847612774123 10981940872567767953 9166478230873602492 14017955592410635205 14880576069997453722 11606743651998214788 1160533878983966421 11003707560620751653 12288243358604226939 14180902506596426007 4152862369673337479 9517690250523457532 7879785551328128548 12599811031914041083 11447246562328209646 4769136259140099317 3400321456959383867 13339744399979108448 15899181598170231994 9001811338055635722 18039098952963384196 9321370051939372263 9706538485911317980 5391089255930632164 11055494453875756444 690747596750835684

[test]
name: shuffle double4 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_double4_ulong16
arg_out: 0 buffer double16[8] 29062 35871 35871 29062 42824 42824 7474 35871 42824 29062 29062 42824 29062 7474 7474 42824 26344 43976 65456 52351 65456 52351 26344 26344 43976 26344 26344 52351 43976 26344 26344 26344 49946 65459 51953 49946 65459 50447 49946 51953 51953 50447 49946 65459 65459 65459 65459 65459 47039 29685 29685 47039 29685 17764 8698 29685 8698 47039 8698 17764 47039 29685 17764 29685 31294 26013 7425 26013 7425 31294 26013 7425 7425 7425 58847 26013 58847 31294 58847 58847 22596 22596 22596 16276 6886 22596 6886 6886 16276 22596 7994 16276 16276 6886 7994 16276 51402 10383 9002 51402 51402 10383 62444 62444 51402 9002 51402 51402 51402 62444 62444 62444 49010 49401 49010 39092 49010 9505 49010 39092 49010 49010 49401 39092 49401 49010 9505 39092
arg_in:  1 buffer double4[8] 42824 35871 29062 7474 65456 52351 26344 43976 65459 51953 50447 49946 29685 17764 47039 8698 7425 26013 31294 58847 7994 16276 6886 22596 9002 10383 51402 62444 49010 39092 9505 49401
arg_in:  2 buffer ulong16[8] 11309474822275306822 3578222136560442581 6646380780374982525 7065440276091568782 8816178721002680952 15116491559481119280 14742673609557246591 2130880983930818113 5845546787977961204 10997594102742530902 11668706560649796638 17591226978400844628 4868265633210488118 3568246227725279447 14797979624597899451 4432797947857827432 13851054199338413758 5060196949064199839 17644423982978029768 5672432970807145805 14699973531751474412 10043070271586901117 6648471810673521834 3252865787836977570 11909903848973797987 3422865288472111642 5088319079002890614 9863675635203035133 7574202413568337987 2075385647140993802 13564626039390444974 6007505497522090962 7951874157294699483 17075989603878000844 9718637571725062609 13278885063492344367 17515387901223752736 16687271348679924646 15518418504019918327 12022938338574613413 2771462211987759289 6270186306602365250 4777450026029443711 3439470048227183612 1479167051090253572 4264527961012826460 12976333190886777364 220465459912807992 14191146111722589862 15331801258190200808 17232573254381189796 17285976106308989490 15695779579980226052 1639719710932419957 5830277220265856775 6784265777584451044 7686163689870249387 6681807552506851806 17040344942362929507 10106660904002156481 16398319357962249762 17721484854709017444 9647367932859467881 2608033480638430080 2515335204575987338 9991896630869344969 8703541810903965932 15216266972212717669 1027184621683927944 8756937493681460182 9853022076065309997 2153360339787979092 5282175511360197624 18395477090832391160 4866715476786021011 6366212630201550473 6753054312295006291 10319495066347904130 6866884413281298079 14004015575657891703 4390355671469884999 8878279684525930359 7819943001181589859 15654182910393589253 16680439751061022382 8190528354570649619 11493016242385789670 5890168296780869958 6618375072033507701 16201244320382507339 16760265834409594896 11245972961698598189 13193673909081290061 18143221403553280438 12255100362199226352 5718458719304090857 15921669704819691990 14676959415964646329 15400305195156986748 10123199927352059346 13521684765302451590 7981645947774838893 18433746989599013795 1922059357276849635 2738879607757711366 8907188394621719656 12223088023577845022 8937903764096786454 6787345428779147386 10077799970323935207 14131055641554756623 13853292798231750559 11114065816204972172 888321321157310555 9989314054521769276 14734172106942304761 11008007862953882976 2058153580217159526 3562543797541306104 8134693384957774881 4373940590262610044 8144279654646850308 7127552732029585083 10535200359975842949 17489008239913241195 9520787411184383548 9794667932374493662 6632301537766663181

[test]
name: shuffle double8 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_double8_ulong2
arg_out: 0 buffer double2[8] 51809 32965 17918 62876 40345 40345 60567 4855 50025 7251 26611 41514 42900 42900 8595 49905
arg_in:  1 buffer double8[8] 32965 918 1776 35785 65433 51809 36954 34937 3846 17918 50254 60313 20515 21064 62876 211 36083 5784 40345 9827 43562 60532 45476 17649 55022 65270 26588 41826 49563 60567 19117 4855 42509 31778 31957 50025 18100 7251 25773 24850 26611 60664 52808 7783 41514 46333 56652 28190 32649 532 5336 62544 7209 5909 42900 12786 40926 49905 50796 49236 8595 16830 35050 24907
arg_in:  2 buffer ulong2[8] 10184346774465723773 7301810188320124808 14843406903877067745 2801230316605286142 13585603403630383506 4891594456764936082 18275660141179574101 9729242133293720727 6740885245635138691 7932170664656069365 1121810063956011008 7352994620736867236 13609675742867034934 5384675390375924782 1710874329871460964 13540601194546375617

[test]
name: shuffle double8 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_double8_ulong4
arg_out: 0 buffer double4[8] 35474 43530 7189 48218 11328 42857 42857 57880 40537 41049 41049 16368 23233 52800 52800 52800 28508 33230 37679 37679 25639 25639 25759 43923 54537 986 2581 986 58861 50067 59474 6894
arg_in:  1 buffer double8[8] 37234 7189 36362 50080 48218 43530 18111 35474 43105 17083 42857 11328 3949 8143 45942 57880 35465 2903 41049 16368 64448 34577 40537 16935 42262 24791 52800 23233 21532 37261 9835 20761 59953 33230 28508 61780 21546 37679 59314 40998 63699 25759 43923 7459 3570 40443 25639 27194 54537 6597 986 47988 38026 32715 2581 47200 27516 34717 50067 6894 14493 58861 59474 47867
arg_in:  2 buffer ulong4[8] 853917688485285311 7333754786485965349 13172674025116097505 892855629481771204 12417488446032997363 5231594140427220874 2032434849577775538 16213640681188943743 295227994476869982 6015590495784349922 8603641925707997738 15942889963783811163 3427372472757138251 13609405990985706554 5848689260061153914 705970946711088930 3950541784777073898 2998700388329986001 11635695249815463957 13475995395634758149 10926809567230944382 11205564047298881118 13780824498391351585 3019222102168070762 1123396104564207008 2400807229615744874 12857249055233424942 17303425190692678850 9713102983849886565 1927816266158625690 6274175289973783846 17935735374289984891

[test]
name: shuffle double8 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_double8_ulong8
arg_out: 0 buffer double8[8] 26123 38344 24428 24428 38344 21142 21142 38344 32976 25653 5722 586 10229 25653 1637 5722 45393 27669 45393 7293 7293 41459 1416 44001 8177 49572 8177 17604 17604 17604 17604 2154 15333 36910 57424 50313 47272 22063 22063 36910 42389 29382 29382 58544 7934 3067 8104 7934 39855 24476 24476 6465 39855 58834 24476 31732 45684 33450 13786 61015 33450 42867 45684 61015
arg_in:  1 buffer double8[8] 38344 44659 27161 26123 21142 24428 37251 6019 33701 3394 10229 5722 586 1637 25653 32976 1416 39345 7293 27669 44001 45393 41459 3770 17604 8177 25380 59656 49572 43932 36248 2154 31209 22063 57424 36910 42480 47272 15333 50313 7934 42389 8104 25793 58544 3067 29382 25156 6465 24476 26234 49182 39855 31732 50191 58834 40912 33450 42867 41759 45684 36623 61015 13786
arg_in:  2 buffer ulong8[8] 16863061828266862131 10574391702377781616 6746315684665901845 5140790423095720725 12728912932292135840 4320711042334837788 7230366184714528276 14966629559277458848 4044194456587599151 1503283709809837422 9993269746225690995 11576993504958050788 12141411529875509218 7386611685566401342 4161416281782680021 15529353057670530883 12539170324952419485 11932632762165055523 10399860440921384485 3562704355855397978 12808214039269273946 11416686859935179358 5132682441525407488 14711239839308612508 12916885766181535081 13683771273652521012 12905420405796690313 10088735955812119360 4403342704397946216 12042978053667719880 10628231582653796424 6941053460065338895 15932468054657328318 1514972957874650899 1112984102774426874 1532980007799594207 2426566685632324981 18089684136308729849 7255871669776805169 10285767804899846147 17711829558985877433 8732194758434234198 12478945176251082534 10248801336986422708 10166641736009076528 16061257624044759365 12147536597778360994 15080689149545175376 12956758312229672156 13036489826884721729 3621568599628776801 11508404246785132648 13010856621548706956 5165016448301485671 12053682200650551905 9059020029251372333 17015203494224234348 301200500837379057 4510238235361000991 2552293882666909190 6894046783247162209 17389783876429991882 9454299161848234988 10383190363608103062

[test]
name: shuffle double8 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_double8_ulong16
arg_out: 0 buffer double16[8] 7912 7912 4298 1371 1371 52997 7912 1371 13530 48890 7912 22514 4298 4298 7912 4298 65329 36927 6739 36927 65329 6739 17627 33453 33453 6739 6739 17627 6739 65329 38090 65329 57677 28858 57677 51379 25074 26834 33765 26834 28858 57677 51379 25074 28858 62972 28858 45719 45213 36229 21240 64035 64035 21240 45213 21240 12096 36229 45213 17295 36229 36229 36229 17295 47102 16358 64480 64480 64480 64480 16358 38395 38395 38395 44039 44039 16358 44039 64480 38395 43378 56188 12459 56188 43378 56188 43378 22604 43378 12459 56188 56188 30848 56188 32839 56188 63884 23524 63884 8897 18417 23524 8897 18417 63286 63286 4795 23524 29717 29717 63286 4795 54732 23641 54732 23994 47556 65040 13935 23994 23994 23994 47556 47556 47556 23641 23994 47556
arg_in:  1 buffer double8[8] 7912 4298 52997 48890 22514 20386 13530 1371 17627 45149 33453 65329 6739 41454 36927 38090 25074 28858 45719 51379 33765 62972 57677 26834 35775 17295 21240 64035 12096 11180 36229 45213 21132 38395 44039 57058 64480 16358 54498 47102 56188 59232 12459 30848 43378 32839 22604 59621 29717 63884 8897 23524 18417 4795 63286 51557 23994 65040 15897 23641 54732 63771 47556 13935
arg_in:  2 buffer ulong16[8] 3912762866075052192 5578159545287554408 3847008204118330369 10779332261386821743 1240116146187954615 14376262643103632634 12961430800916906720 16816610953054155839 3749755241208012918 10914522790580618027 5209435832495106608 9511265257960260668 16431255725013589921 3367363977095650225 15928179630869474200 1111441933004564761 13566581793596178299 12592244281737726958 16527508373250455228 6531829659167997710 9157013682132117299 1854908027176626748 12269391570291999720 7336077787662794026 16603734714043613754 17359574819537239996 2002329349415424716 6110133361331521520 5839300747268169396 4217109845943335787 9420578670166368855 2111817458986060099 1860093347708036550 10752804502776722417 2700514856930147326 17284249524887814123 2513113192649269160 7192322380080878535 71610784453762868 10575058608746273887 10924860944246294681 6573009710280108782 11485230209739293755 7893828998031617664 14114480889366981393 9244339306959287373 10506797382500802505 3403982602312360418 5138106171094195175 11621010093324989270 17189344830296286482 7006150910453745003 14349041612072777131 8066200457268363354 6867751287834700815 9780332288414519266 14343669177031368772 6726078579920857998 9093000110667967463 13624252643175986137 16523785487826215926 12535284753363065694 5643974096608011750 1754449440235444073 9364899062383430119 17031403214260525853 16445974162279856588 15830175171002450420 7113032734445069308 5132134800925301116 18430202177532562221 6284624918137034025 14000851609062474713 7286358730821111993 9259718247221022810 10186820541584862850 2977344620790126053 2336429369113001730 10888882490466010524 18184792742296598385 17925446772316042644 9423496193876170456 100212262831133346 7022731776551462648 6266523205579979764 7497261792032492496 3641705687122766836 11107771281132168998 16256491812603174220 813501777847862314 11828212789005098984 9800458072408201416 2737168586241727283 9243986491505536296 699782545777765405 14603747066642159856 18434244554880158025 17746747441281826963 12695818494257368137 9685689139064420034 4331879224587159764 6767457735802759619 6312454305774480458 417073892916700468 15209304398679758566 4503832310472302174 14735662454527015709 1125151216042008763 6583840798881724928 14069311480796012792 14118798363818366822 11669941603349541773 2020816872602762012 11646087445807063019 8861629922080771892 1452319977946957560 9250484897697928070 7721045849397238513 9067522796385920031 3055071199132600512 4971697693353559328 351395888240991952 10131330489744229006 13966034292667458030 10963489296516722782 12990115561041876779 10466310030684471888 3680864832589376286

[test]
name: shuffle double16 ulong2
global_size: 8 0 0
kernel_name: test_shuffle_double16_ulong2
arg_out: 0 buffer double2[8] 1388 49893 21122 8894 941 58217 35452 22347 31069 21048 11014 46246 62765 51785 47909 36542
arg_in:  1 buffer double16[8] 40474 8379 11876 24262 36937 26526 58673 34758 1388 46674 48994 12390 4807 49893 13308 1476 9294 3839 16358 21122 13206 6454 62264 57599 53224 17918 47314 52314 6794 8894 63357 23943 21637 49444 5428 57216 941 46023 18805 42267 1744 58217 45068 56142 62838 38049 18895 37945 58233 9109 42524 52200 17445 20530 49051 1633 35452 10654 6815 61589 28965 8222 22347 24170 12293 24481 3136 31467 25415 55175 49611 21048 32319 22737 36652 31810 9123 17464 32118 31069 37006 7048 12506 20275 59426 36943 26751 27353 16786 49568 11014 64514 46246 21277 1547 55274 41294 62765 12167 62906 51785 44632 5468 22091 51258 13122 6665 57054 25762 29914 6699 8981 36542 37257 47909 45800 30093 19074 63665 9339 51429 15304 60025 8463 44947 52500 4705 264
arg_in:  2 buffer ulong2[8] 4432394965937555752 330932299738953405 6203322481984974387 14322856557508297149 14920637804896334532 16113819490451643561 728777155499148920 11460277203068679374 1042238826533263215 6045074899791066263 17407329409743842058 17566775791430506444 16897045486146156513 2496430471008570340 6121229400271340658 9767602979851850144

[test]
name: shuffle double16 ulong4
global_size: 8 0 0
kernel_name: test_shuffle_double16_ulong4
arg_out: 0 buffer double4[8] 43373 7263 11955 43680 47695 16057 10677 62889 32821 63010 9200 32165 8005 8005 8005 27503 58452 47137 47137 23552 41961 12689 8069 15425 6583 14376 12777 14376 829 15319 16646 31359
arg_in:  1 buffer double16[8] 29356 27890 27284 52235 64850 49825 11955 47972 56347 3342 5730 43373 7263 43680 26029 29673 47695 8828 59195 43732 62889 10677 5271 10821 27309 23500 16057 40152 29912 64767 46057 20434 63010 34469 61334 62280 9200 62342 28709 50669 33539 32165 26662 3837 39709 15285 32821 63857 10428 3364 58629 32433 51575 55839 27503 14987 3274 8040 48080 64980 9338 44110 29354 8005 24751 45187 17820 58452 47002 23552 20008 35389 11054 24739 65175 47137 61572 7560 24746 56409 5916 52299 12689 64187 37540 39126 28059 9143 8069 12816 21857 41961 15425 33298 13236 25656 20656 29458 56616 10833 12777 56315 31836 59 31284 43350 51608 36578 7201 61977 14376 6583 14186 829 45003 61551 53630 38568 60457 15319 31359 16646 3060 64153 31917 44743 63116 45791
arg_in:  2 buffer ulong4[8] 7094442992412749035 6930892745997876236 6807920064505726982 3074090274512981645 10524579860880123280 3829153595571501802 3344340235722872949 15302975040168658660 3509719757724971390 1794809384300897296 350031125671666884 14850622110107701945 18342323225598138111 5801408544501223055 14325455663938833695 6239270313999183654 220188508840177299 7117799982112953275 16059664876820051083 7829018121038109141 17088167286220363275 6549272458121575842 7202578286326491352 5668603919076698780 5685526483815104143 16357092799991559966 10094677421846086548 4991231365590220046 6784587485873951937 16768229872559273895 368821695388576793 12875835002121003592

[test]
name: shuffle double16 ulong8
global_size: 8 0 0
kernel_name: test_shuffle_double16_ulong8
arg_out: 0 buffer double8[8] 2619 59271 47551 5449 47551 58685 5449 8824 24139 44313 50889 44313 16811 3694 3694 18617 11616 51547 42126 51547 53577 32534 12218 14250 42116 22417 27936 36193 51406 1819 26047 26047 57058 2374 43564 4120 8060 3591 57058 41002 25559 15260 2182 44083 36968 56812 36968 2182 5715 41836 34062 63302 24160 37416 27564 63302 58491 4029 57591 7038 57591 7038 58491 37600
arg_in:  1 buffer double16[8] 56598 47551 58685 52199 22794 8416 49280 2619 5449 3157 8824 8626 48626 6591 59271 20484 3694 50889 51183 47126 33233 52164 11852 34798 44313 6230 18617 53665 16811 24139 45029 7220 12218 48223 25363 30112 49811 57581 34500 53577 43074 32534 14250 51547 24089 42126 11616 51831 1819 51406 36193 42116 38032 26047 19198 64782 30753 18994 22417 24474 42683 27936 34004 13270 57058 41002 8060 43564 9161 2374 4120 37169 3591 16826 14470 5357 54960 7806 49716 39178 38865 4102 26549 6344 25559 36968 19286 42831 15260 52204 20415 2182 30735 56812 50205 44083 44433 31648 40831 24160 57900 63302 40311 60411 37416 52107 27564 41836 32655 2657 34062 5715 9330 59304 7038 37600 4626 57591 29671 29884 4029 143 45394 56974 58491 19158 27798 52955
arg_in:  2 buffer ulong8[8] 1944622023954349223 212275870218576430 17505915025701167985 8592269295710987448 17785536580042741201 9545151541147681778 12424467526958926504 13141675472908773834 13832733579288883677 445942632423003000 17070469760642727153 12310961301600090760 8357706590326920940 15035328505980062752 17466563561276740992 6854344015952712330 9125393026670894558 8968407258797764539 10440497434658835469 11222661315537546619 15025009712131255591 2840716205827723225 2382029071534343488 611827005788771402 5566318180411169475 16659832377524154922 11857342536524740157 1078704834971054050 2270615361438226497 7702947336527335200 9735677837845125205 15560506516491352501 13035750083321023600 4867524310398434597 7787571483736791299 10534112550560053766 1758765783310267250 2513097429226930552 10334608068545915872 204361313280154209 8591786877272746564 13341919737301831016 3365000794258871099 7667719790378056255 4529695125514951717 2533967858210236333 8871301632846902213 3720930769402908203 4794643633276958591 3749632334325053931 4343136016552271070 15348895580081990069 9686594065194955731 9960491356807559368 13060666340312849114 16761966842205444661 2845672707210842108 10477044616436097064 2174890216821884453 9730319418805804930 867778914515415717 12761314000497914594 11557165738979842636 1711375816870548739

[test]
name: shuffle double16 ulong16
global_size: 8 0 0
kernel_name: test_shuffle_double16_ulong16
arg_out: 0 buffer double16[8] 40095 8385 40095 8385 11160 30793 44646 40095 8385 64577 64577 23931 50581 2479 50581 8385 19216 54989 3219 54989 48217 59210 23938 59210 24219 1151 8494 14101 5803 48217 5803 3219 57771 10553 26614 35546 7771 10553 56602 44164 20824 57757 57771 57444 63803 57757 7771 63803 34092 38958 18782 11700 54618 58620 7991 17000 38958 41031 34092 11700 54618 54618 62993 17000 6596 60530 54475 30339 17922 60859 30339 6596 31669 17922 17922 3431 60859 60059 8978 59413 51510 57973 48623 44985 47391 48623 31222 51769 24850 24850 31222 60733 4243 4243 60733 46528 8032 22423 63775 6443 63775 8032 63775 22423 40259 63775 50065 32746 22423 27290 22423 6443 64663 10031 61624 34817 63481 63481 63685 36930 10031 54494 47786 7506 24407 54494 10031 10031
arg_in:  1 buffer double16[8] 4809 55927 8385 7362 23931 2479 40095 5355 44646 50581 27862 64577 30793 11941 11160 18220 14101 10735 1151 23938 8612 59706 59210 32744 48217 3219 32777 19216 5803 54989 8494 24219 29482 35546 57444 44164 7771 14654 20824 56602 26614 2780 57771 10553 45781 57757 45993 63803 11465 62993 34092 7991 11700 41031 4125 58620 15104 18831 54618 17000 8946 18782 38958 61681 39233 60530 17922 35107 6596 30339 60859 61966 56325 59413 31669 54475 8978 60059 3431 38517 60733 5243 46528 51510 54879 57973 51769 24850 31222 48623 46562 44985 47391 4243 38714 47340 22423 53840 46941 50065 52619 6443 8032 63775 10559 28221 49770 50185 58213 27290 32746 40259 47786 7506 34817 64663 61624 63685 24407 63481 26659 36930 12408 38817 35599 10031 54494 12667
arg_in:  2 buffer ulong16[8] 5584870232997440486 11755303519131333170 11853100282872206262 8088642997546726306 17379744255109561438 13137896408284811500 9182439440379754424 2241399739524328870 6408996429204100658 8689409501169550779 1440001141439955787 14679516960416722148 10424665222244001705 9873292539749968693 17343022098994410041 10731843636919056962 2382279563220654891 17608635614654634877 12131628638015113449 17775623147402420797 8948207058395945752 7455511397904960214 7817704487080552947 2177517741153305494 3435058239691035503 6578613073969792098 13752458747573008094 14628668808425979184 12061638154263814956 16995880626043359416 15085796497091333452 185104236259589273 1163911205799758954 11442016279940132331 2650392266015068312 5616149990501655281 7297559288876785892 16801328651608696939 10596154355145124423 11878827244501513827 10490710029708272822 1587818675382967901 15554182351679019674 387690843345937922 11229212039831382175 3821611924848560957 9482243783506796244 8821509186833419919 5771117995429484946 13922450912578695518 9317170403445683565 2990677281245071268 6223008105342363994 1645471225147016231 10876035948424139139 14889960187646185403 14953125198260216894 11888105072661862677 15556046984141637266 5912467824656175012 12199045101952601338 17549993313815785178 128352290132970897 12903684821566283435 12985054820485864676 15603695829582006881 2393108548285206059 1280991783283643061 10270440222638113986 16129347803399041878 2342995834966932805 17190640582361661204 4631892136909307754 2531776505495596642 1598080003300118706 12235187102533174206 2737419475002777766 10081491026180523069 4568887642150110300 5459057960712033705 10305517899833287443 14649414443599987845 6129545399945424249 16178391268454163723 13142960176206187852 4046204310024334537 15624280459502265352 11019221205522668902 16956396897956765271 14535699469975466343 10008601252648652152 10395126818863091168 15636195429608383581 9519577790234383501 11958951974193666224 3296107882182149682 18299748026768814966 2201723217154911344 14525434067956532535 13147704745291995349 9508997074173434743 15368131324765703462 3580357145572543527 16627804591560103072 13045137381759434255 17618576159373344119 14583922030468668211 17825499623442405646 4784154437920388000 16008081232153288893 10305143028045832112 5134004907100660277 7180810154032578739 7171861084981553085 15033614105975995380 775580947659520626 15433021330161798647 2137279236977899175 13500860398845265285 10326030222912831097 18146147209556388333 1179843919343066990 10981929134771734736 9631684376230861425 17934501247721532774 1644758425594834878 3190382221154536829 7215246683292452301
!*/
#pragma OPENCL EXTENSION cl_khr_fp64: enable

kernel void test_shuffle_double2_ulong2(global double* out, global double* in, global ulong* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double2_ulong4(global double* out, global double* in, global ulong* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double2_ulong8(global double* out, global double* in, global ulong* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double2_ulong16(global double* out, global double* in, global ulong* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double4_ulong2(global double* out, global double* in, global ulong* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double4_ulong4(global double* out, global double* in, global ulong* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double4_ulong8(global double* out, global double* in, global ulong* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double4_ulong16(global double* out, global double* in, global ulong* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double8_ulong2(global double* out, global double* in, global ulong* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double8_ulong4(global double* out, global double* in, global ulong* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double8_ulong8(global double* out, global double* in, global ulong* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double8_ulong16(global double* out, global double* in, global ulong* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double16_ulong2(global double* out, global double* in, global ulong* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double16_ulong4(global double* out, global double* in, global ulong* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double16_ulong8(global double* out, global double* in, global ulong* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_double16_ulong16(global double* out, global double* in, global ulong* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
