/*!
[config]
name: shuffle char uchar
dimensions: 1

[test]
name: shuffle char2 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_char2_uchar2
arg_out: 0 buffer char2[8] 50494 50494 33936 33936 53075 53075 62468 39755 28631 46930 18254 18254 12429 12429 19262 19262
arg_in:  1 buffer char2[8] 50494 55125 5306 33936 63691 53075 39755 62468 46930 28631 18254 36941 18316 12429 32834 19262
arg_in:  2 buffer uchar2[8] 158 50 37 169 241 51 181 222 161 104 244 226 133 31 7 47

[test]
name: shuffle char2 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_char2_uchar4
arg_out: 0 buffer char4[8] 149 52274 149 149 64694 64694 43664 43664 31969 42625 31969 42625 8255 8255 8255 25043 29059 31275 31275 31275 58716 18677 18677 58716 10544 11955 10544 11955 41950 41950 41950 41950
arg_in:  1 buffer char2[8] 52274 149 64694 43664 31969 42625 8255 25043 29059 31275 18677 58716 11955 10544 41950 64131
arg_in:  2 buffer uchar4[8] 55 154 149 63 170 104 147 227 46 197 162 123 148 94 96 95 16 133 243 35 45 66 76 19 41 200 141 120 110 214 140 230

[test]
name: shuffle char2 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_char2_uchar8
arg_out: 0 buffer char8[8] 64573 46840 46840 64573 64573 46840 46840 46840 42509 10796 42509 10796 10796 42509 42509 10796 63759 63759 15119 63759 63759 63759 63759 63759 24953 24953 24953 24953 24953 43944 43944 24953 2124 31855 2124 2124 31855 2124 31855 31855 15353 15353 35525 35525 35525 15353 15353 35525 48766 28896 28896 28896 48766 28896 48766 48766 43586 22345 22345 22345 22345 22345 22345 22345
arg_in:  1 buffer char2[8] 64573 46840 10796 42509 15119 63759 43944 24953 31855 2124 35525 15353 28896 48766 22345 43586
arg_in:  2 buffer uchar8[8] 218 31 51 74 112 23 37 13 63 96 61 200 46 189 59 18 11 99 94 63 245 107 31 11 217 51 133 35 113 36 154 179 223 92 31 239 20 51 200 102 133 183 240 86 104 29 81 82 175 128 60 226 89 6 241 209 159 182 198 128 78 6 234 40

[test]
name: shuffle char2 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_char2_uchar16
arg_out: 0 buffer char16[8] 5989 5989 44029 44029 5989 5989 44029 44029 5989 44029 5989 44029 44029 44029 44029 44029 36815 17673 36815 17673 17673 36815 17673 17673 17673 36815 36815 36815 36815 17673 17673 17673 63154 63154 63154 63154 63154 31474 63154 31474 63154 31474 63154 63154 63154 63154 63154 63154 37732 46166 37732 37732 37732 46166 37732 46166 37732 46166 37732 37732 46166 37732 46166 37732 17346 17346 17346 47081 47081 47081 17346 47081 47081 17346 47081 47081 17346 47081 47081 47081 40671 50858 50858 40671 50858 40671 50858 40671 40671 40671 40671 40671 40671 40671 40671 40671 54318 10580 10580 54318 54318 54318 54318 10580 54318 10580 54318 54318 54318 54318 10580 10580 25206 25206 199 199 25206 199 25206 25206 25206 199 199 25206 25206 25206 25206 25206
arg_in:  1 buffer char2[8] 44029 5989 36815 17673 31474 63154 46166 37732 47081 17346 40671 50858 54318 10580 199 25206
arg_in:  2 buffer uchar16[8] 171 81 122 114 229 193 212 16 205 214 23 84 228 32 132 80 228 249 0 19 253 166 159 239 25 212 96 42 66 7 205 213 161 1 109 7 1 50 97 60 101 154 143 93 51 243 203 41 11 140 231 59 131 68 177 58 79 142 9 21 20 105 132 161 187 21 253 234 222 190 91 106 192 149 4 70 77 138 170 172 188 47 173 18 21 138 83 76 148 184 202 66 150 58 244 122 24 157 91 36 154 206 168 153 212 55 50 246 242 172 175 63 245 59 254 218 19 154 171 79 85 192 44 33 43 101 113 31

[test]
name: shuffle char4 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_char4_uchar2
arg_out: 0 buffer char2[8] 12855 1029 58791 58791 10965 10965 25158 25158 46991 15074 26435 65154 5518 5518 28297 28297
arg_in:  1 buffer char4[8] 50438 1029 12855 51617 37987 58791 64044 28475 55448 10965 48277 28853 34198 21834 56521 25158 46991 15074 8369 3620 59193 26435 15585 65154 52160 33617 27162 5518 28297 19182 13714 25948
arg_in:  2 buffer uchar2[8] 234 193 185 77 53 249 75 207 216 253 165 255 255 103 112 4

[test]
name: shuffle char4 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_char4_uchar4
arg_out: 0 buffer char4[8] 41714 42182 42182 4648 20434 19446 33670 20434 8697 8697 61660 38585 29503 17104 5166 5166 5325 58797 58797 39380 19506 19506 60389 43331 4406 4406 50099 48669 37966 55884 55884 10008
arg_in:  1 buffer char4[8] 44593 41714 42182 4648 19446 33670 20434 49676 38585 61660 8697 11094 5166 8697 29503 17104 5325 39380 2003 58797 43331 21061 19506 60389 48669 50099 4406 11881 10008 55884 27014 37966
arg_in:  2 buffer uchar4[8] 213 246 198 119 10 0 93 154 130 170 33 252 134 155 208 196 196 31 83 65 122 146 171 28 18 246 213 72 251 41 77 180

[test]
name: shuffle char4 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_char4_uchar8
arg_out: 0 buffer char8[8] 61116 4611 4611 61116 61116 61116 53888 53888 13301 6164 13301 6164 61720 61720 60146 13301 4255 4255 19840 17393 2651 19840 19840 4255 42455 25555 25555 42455 42455 13800 25555 45438 14548 64267 50254 50254 50254 14548 7885 7885 61235 16295 38847 44284 16295 38847 61235 44284 38509 50809 16660 15932 15932 38509 16660 16660 58271 24789 58271 24789 5004 24789 24789 24789
arg_in:  1 buffer char4[8] 53888 4611 61116 50683 60146 6164 13301 61720 19840 2651 4255 17393 42455 13800 45438 25555 50254 64267 14548 7885 61235 44284 16295 38847 16660 50809 38509 15932 24789 5004 51383 58271
arg_in:  2 buffer uchar8[8] 190 97 233 182 38 22 20 248 130 13 110 117 47 215 156 58 74 218 216 43 53 212 32 50 212 79 15 228 220 213 15 254 166 129 40 180 36 62 183 15 176 178 91 5 118 187 36 73 106 1 104 63 3 150 188 12 119 72 95 232 57 244 176 132

[test]
name: shuffle char4 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_char4_uchar16
arg_out: 0 buffer char16[8] 47479 3661 3661 17060 17060 17060 3661 47479 47479 47479 3661 3661 17060 3661 17060 3661 43910 62045 43910 38355 38355 62045 38355 38355 38842 62045 62045 38355 43910 43910 38355 38842 24123 24123 10591 42858 10591 42858 24123 42858 42858 13445 42858 10591 42858 24123 42858 13445 19257 40339 49360 49360 19257 20500 20500 19257 49360 49360 19257 19257 19257 20500 49360 40339 16414 31829 31829 41404 31829 16414 29205 29205 29205 16414 31829 41404 16414 41404 16414 41404 31019 48819 48819 38149 31019 31019 31019 31019 48819 24109 38149 38149 38149 24109 38149 38149 17332 55022 2693 6062 2693 6062 2693 2693 6062 6062 17332 55022 2693 55022 17332 17332 51616 9595 17304 10213 10213 10213 9595 9595 10213 10213 10213 51616 10213 9595 10213 9595
arg_in:  1 buffer char4[8] 17060 3661 27278 47479 43910 62045 38355 38842 42858 24123 10591 13445 40339 20500 49360 19257 16414 29205 41404 31829 31019 24109 38149 48819 55022 6062 17332 2693 51616 10213 9595 17304
arg_in:  2 buffer uchar16[8] 215 153 213 72 216 152 181 43 127 227 189 29 192 209 4 213 164 225 104 190 150 241 46 94 55 141 57 78 228 204 94 215 221 89 126 232 174 72 181 236 44 247 104 150 0 229 236 3 111 152 58 154 79 217 241 47 254 118 207 143 11 61 138 20 0 131 203 202 227 52 129 181 145 100 43 18 36 134 156 174 60 127 83 34 212 148 144 68 107 53 210 206 142 149 226 190 70 80 63 61 195 205 239 71 153 181 242 212 111 244 250 162 252 30 227 153 73 253 26 110 13 181 241 200 5 34 41 202

[test]
name: shuffle char8 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_char8_uchar2
arg_out: 0 buffer char2[8] 5397 15224 13822 37738 19401 57051 64481 16937 57576 28856 47659 11096 11354 46277 34848 44196
arg_in:  1 buffer char8[8] 841 47353 5397 15224 490 35432 38342 29712 18439 37738 25061 13822 56887 60410 43279 50348 22053 43344 55274 57051 19401 58627 19333 41428 16937 27376 24487 58212 45766 50970 56005 64481 51057 28856 25715 57576 26773 6526 50901 4361 30674 11096 24478 47659 7469 22724 30548 38997 11354 37280 46277 53927 60069 7070 56440 59585 64251 33390 62344 28235 44196 34848 5535 5741
arg_in:  2 buffer uchar2[8] 26 83 179 1 148 3 71 32 219 113 203 113 232 98 173 52

[test]
name: shuffle char8 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_char8_uchar4
arg_out: 0 buffer char4[8] 59735 3778 11222 42617 10500 24920 45317 32935 5833 40924 33376 33376 9481 6221 64920 60415 11221 12940 10679 64694 54265 27979 54265 55959 41890 41890 41890 36568 37421 34208 60565 34208
arg_in:  1 buffer char8[8] 11222 41815 42326 59735 42617 33488 3778 5813 24920 48326 10500 27471 45317 24613 26426 32935 39494 40924 50419 33376 63187 45080 31452 5833 40083 9481 1206 60415 64920 57435 6221 54017 64694 60360 57685 15482 11221 10679 31607 12940 20158 54265 27979 57755 10111 55959 51704 5157 23643 32732 64227 28842 16788 36568 46150 41890 56995 14062 37421 26369 38881 57905 60565 34208
arg_in:  2 buffer uchar4[8] 139 118 8 60 50 88 212 127 111 145 3 219 25 62 196 139 60 183 117 144 113 122 33 157 167 119 191 245 146 87 70 7

[test]
name: shuffle char8 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_char8_uchar8
arg_out: 0 buffer char8[8] 10021 3314 10021 42976 42976 20348 23168 20348 30630 17770 50411 50411 65108 17770 27066 27978 3409 17372 59716 3409 47004 64120 17372 59716 10324 1656 41149 21369 40461 40461 1656 28845 50343 25043 50343 50343 33968 52671 38237 52671 44979 44979 5018 29611 27349 57828 41308 29611 7626 46323 7626 7626 39964 45111 19820 2225 29592 31649 8037 31649 64370 29592 29592 3219
arg_in:  1 buffer char8[8] 42976 48101 3314 17016 51849 20348 23168 10021 17770 27066 65108 27978 30843 17318 30630 50411 46329 17372 65334 14157 3409 47004 64120 59716 40461 1656 28845 21369 64841 63034 41149 10324 33968 18015 52671 25043 41473 38237 50343 7756 27349 5018 41308 32716 44979 57828 29611 34092 45111 21277 39964 2225 46708 7626 19820 46323 2881 64370 8037 3219 31649 5893 1630 29592
arg_in:  2 buffer uchar8[8] 167 34 31 176 216 69 110 229 222 72 183 159 90 168 209 195 4 209 135 236 21 62 209 199 87 1 70 75 40 168 121 90 126 11 86 86 40 218 53 234 76 20 129 174 192 13 18 254 45 183 149 77 234 120 182 83 207 172 138 252 201 7 159 147

[test]
name: shuffle char8 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_char8_uchar16
arg_out: 0 buffer char16[8] 5020 52924 59758 34399 52924 4578 51781 61461 5020 52924 59758 61461 51781 34399 34399 59758 45428 65012 65012 2711 4492 33281 65012 37981 2711 35789 33281 37981 37981 4492 65012 33281 32851 27144 27390 44601 44601 50603 50603 32851 44601 31804 43180 31804 43180 15203 31804 27390 6718 46315 45164 43340 6718 45164 45164 43340 20469 6718 46315 20469 45164 1191 43340 20061 52908 52908 38166 38166 47604 38459 42336 38166 47604 38166 56492 38166 64862 38166 38166 47604 16495 132 132 57919 1221 16495 1221 57919 132 16495 1221 62968 1221 1221 16495 132 9207 24596 24596 8295 8295 22784 8295 24596 36530 24596 8295 22784 22263 55558 9207 24596 14424 34833 50423 14424 50423 50423 14424 50423 40815 56968 40815 50423 1787 14424 20630 40815
arg_in:  1 buffer char8[8] 61461 4578 34399 5020 59758 51781 15730 52924 45428 65012 6704 2711 35789 4492 33281 37981 27144 44601 50603 32851 27390 15203 43180 31804 46315 21305 20061 43340 1191 6718 20469 45164 47604 38166 38459 42336 64862 52908 56492 22286 132 18449 5714 57919 16495 44740 1221 62968 33764 24596 9207 55558 36530 22784 22263 8295 20630 14424 50423 56968 34833 40815 37350 1787
arg_in:  2 buffer uchar16[8] 219 143 132 162 175 97 221 72 3 79 196 184 237 18 210 116 8 185 81 99 181 254 9 127 123 140 94 215 39 229 121 230 51 96 84 225 33 218 202 139 129 223 182 167 46 157 15 252 5 128 103 203 197 223 199 19 238 181 64 142 167 12 203 242 69 21 41 177 184 2 35 97 56 241 22 161 12 161 201 64 140 208 72 75 206 156 30 83 64 68 246 23 22 198 92 176 42 41 89 135 103 133 167 129 132 233 79 229 78 19 90 17 161 36 98 233 122 234 81 170 69 243 29 42 175 1 40 53

[test]
name: shuffle char16 uchar2
global_size: 8 0 0
kernel_name: test_shuffle_char16_uchar2
arg_out: 0 buffer char2[8] 46179 44014 51054 57764 3432 8400 43727 62460 37628 3125 50660 60673 51105 5004 56562 18065
arg_in:  1 buffer char16[8] 56063 46179 59189 44014 49553 47455 15577 17840 41535 2978 23933 16397 2516 44287 25341 5785 54242 8131 40796 51054 6846 22041 46908 10147 53507 7078 57764 46527 33531 40598 59459 54031 23680 4022 59471 34622 24968 50811 8400 46872 12622 16169 3432 45978 2796 23211 52922 1788 42310 59831 65015 62460 10544 6779 52682 34372 3643 12545 10497 43727 46995 12908 61785 4334 20220 37628 4823 95 49373 44261 20560 19252 21044 22887 20837 31795 43027 3125 63296 52180 5789 29678 31495 36906 43066 22284 31219 46148 29627 21446 55148 60673 47616 18087 50660 1765 21252 738 51105 22539 19513 2557 3298 42378 484 5004 6187 14667 19358 20073 49790 3465 54884 57181 43636 32500 18065 47713 28398 52479 9574 17012 53445 45952 12655 56562 57152 32197
arg_in:  2 buffer uchar2[8] 241 195 115 202 122 246 203 35 129 141 190 11 242 121 141 20

[test]
name: shuffle char16 uchar4
global_size: 8 0 0
kernel_name: test_shuffle_char16_uchar4
arg_out: 0 buffer char4[8] 18901 51436 18901 56748 25649 61954 20841 18703 14457 53811 17584 5434 21557 27192 27192 9983 53591 34310 49301 43931 1374 14000 644 19352 63770 33277 63770 63770 27273 50884 43847 50884
arg_in:  1 buffer char16[8] 42148 51219 13980 6385 18901 51436 3512 55187 51525 56748 13738 60383 60553 21152 22230 44629 62175 53883 20841 37186 14747 48271 45274 18703 46874 61954 7065 25649 33768 23186 42555 38802 49822 5434 38156 56519 4574 53811 35267 49173 27285 45465 17584 17321 14457 46787 21726 4092 56436 52218 60754 9983 10200 55761 18127 22181 20049 27192 21557 29917 3895 17767 64624 46789 37753 43931 15529 53591 34310 20751 44888 43488 18950 49301 40008 30741 49619 45419 51152 61770 40128 53752 53254 12807 20186 19352 644 14000 26859 14573 34954 22103 49264 11190 4721 1374 15125 47469 63006 41727 14174 59326 48377 33277 63770 29978 20846 10214 22020 3379 21864 53595 27273 57433 53086 34619 2774 17598 50884 22457 57797 7032 49158 11376 53108 43847 30552 59706
arg_in:  2 buffer uchar4[8] 20 245 52 137 251 201 242 135 92 117 186 81 154 73 233 35 35 244 201 209 47 135 246 117 56 151 72 184 48 70 29 70

[test]
name: shuffle char16 uchar8
global_size: 8 0 0
kernel_name: test_shuffle_char16_uchar8
arg_out: 0 buffer char8[8] 29707 44963 14030 4333 674 52999 45518 45518 30360 10158 46512 26124 12014 29440 49959 55350 36360 47076 15657 37080 47076 61730 47022 46538 31920 50949 38189 20219 62878 29975 15810 38189 6373 40790 28921 41568 41568 60525 40790 52335 23700 26253 53281 53281 23700 23700 5727 5727 16994 23217 62217 62217 48 48 26131 29746 49970 35765 48164 57122 49970 13564 49970 3742
arg_in:  1 buffer char16[8] 26018 924 4333 52999 64270 14030 61992 45518 44963 12783 674 31678 29707 65239 40828 35973 29440 1175 64963 46512 44678 12014 10158 39946 55350 29655 48168 49959 19067 30360 37735 26124 63061 47076 37080 50376 16956 15657 52585 46538 61730 29969 49012 47022 56612 36360 47082 52543 37107 13800 62878 38189 15810 58456 20219 45090 31920 24502 44314 65444 29975 14414 50319 50949 60924 60525 28921 52335 40790 63789 30494 41225 215 12044 61835 41568 51677 29802 56538 6373 5300 53281 12252 34532 26253 42835 23405 14825 23700 47730 3704 30635 5727 1060 50157 590 16994 15268 26131 10690 61091 25913 195 54421 8752 23217 30710 29746 54450 50060 62217 48 57122 27538 49970 5399 35300 3742 45490 48164 44213 59495 17613 12065 32993 13534 13564 35765
arg_in:  2 buffer uchar8[8] 12 72 69 194 106 163 103 215 61 54 243 63 229 240 91 232 173 65 213 130 193 40 171 119 232 127 179 246 210 12 228 3 207 228 114 219 123 129 244 243 72 116 225 145 184 248 76 44 96 153 62 30 79 175 18 171 82 239 199 96 210 254 98 85

[test]
name: shuffle char16 uchar16
global_size: 8 0 0
kernel_name: test_shuffle_char16_uchar16
arg_out: 0 buffer char16[8] 6177 64676 6177 44428 6177 6177 25741 57852 24012 31846 19942 51235 44428 51235 27967 44428 29359 48842 48842 67 5707 21392 67 44321 14293 21392 58093 5707 64674 14293 58093 44321 8824 27527 28806 51225 8824 48218 61416 51225 6108 20417 48218 8824 20417 28806 60801 2788 11477 53233 8656 53922 40452 17875 53233 11477 54045 64187 26732 17875 53922 10260 542 542 50163 10972 47187 54964 33868 31342 28774 20103 50163 3655 33868 3655 3045 3045 50163 33868 8296 50532 29924 50532 44534 50339 41357 8296 34587 15282 3183 15282 50339 8296 3183 41869 17508 38224 15585 32490 4166 24843 38224 17508 50370 50370 24843 56917 38224 45065 4166 56330 7812 8868 44400 33797 13656 45094 13018 54742 33797 9841 1828 2877 21158 33797 8868 2877
arg_in:  1 buffer char16[8] 51235 6177 44428 24594 42998 24012 56890 19942 64676 27967 57852 4313 31846 63931 41639 25741 67 5707 8161 17585 31830 58093 29359 14293 55774 37538 44321 64674 25184 21392 48842 46731 57428 51225 57527 41618 61416 8824 19213 28806 14850 20417 51649 60801 27527 48218 6108 2788 53233 27174 11477 54045 53922 27586 542 17875 64187 40452 49826 8656 10260 64584 2004 26732 54964 47187 40905 10972 3045 31342 3655 48170 20103 61047 33868 14442 58609 36497 28774 50163 50339 44534 29924 34587 11662 5768 20288 41357 63575 8296 62841 56976 41869 50532 3183 15282 56917 17508 18578 4079 15585 56330 32490 4166 35650 34624 50370 15129 45065 38224 48986 24843 7812 44400 1828 21158 64940 2877 33797 43460 18044 45094 13018 54742 8868 32967 13656 9841
arg_in:  2 buffer uchar16[8] 65 248 17 114 177 49 111 90 117 204 103 224 178 80 137 178 102 110 238 160 65 141 0 42 167 157 165 17 43 7 149 58 85 140 103 177 229 45 212 209 62 41 237 165 89 151 123 223 146 16 11 4 137 39 160 162 147 24 127 71 132 28 198 214 143 115 129 160 250 229 62 216 191 86 26 118 244 196 15 122 41 157 50 93 65 224 7 185 211 63 126 255 144 137 206 220 241 29 84 182 103 127 77 113 154 74 95 128 13 92 119 213 80 124 65 86 126 153 10 235 102 31 210 85 195 198 108 197
!*/
kernel void test_shuffle_char2_uchar2(global char* out, global char* in, global uchar* mask) {
    vstore2(shuffle(vload2(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char2_uchar4(global char* out, global char* in, global uchar* mask) {
    vstore4(shuffle(vload2(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char2_uchar8(global char* out, global char* in, global uchar* mask) {
    vstore8(shuffle(vload2(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char2_uchar16(global char* out, global char* in, global uchar* mask) {
    vstore16(shuffle(vload2(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char4_uchar2(global char* out, global char* in, global uchar* mask) {
    vstore2(shuffle(vload4(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char4_uchar4(global char* out, global char* in, global uchar* mask) {
    vstore4(shuffle(vload4(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char4_uchar8(global char* out, global char* in, global uchar* mask) {
    vstore8(shuffle(vload4(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char4_uchar16(global char* out, global char* in, global uchar* mask) {
    vstore16(shuffle(vload4(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char8_uchar2(global char* out, global char* in, global uchar* mask) {
    vstore2(shuffle(vload8(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char8_uchar4(global char* out, global char* in, global uchar* mask) {
    vstore4(shuffle(vload8(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char8_uchar8(global char* out, global char* in, global uchar* mask) {
    vstore8(shuffle(vload8(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char8_uchar16(global char* out, global char* in, global uchar* mask) {
    vstore16(shuffle(vload8(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char16_uchar2(global char* out, global char* in, global uchar* mask) {
    vstore2(shuffle(vload16(get_global_id(0), in), vload2(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char16_uchar4(global char* out, global char* in, global uchar* mask) {
    vstore4(shuffle(vload16(get_global_id(0), in), vload4(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char16_uchar8(global char* out, global char* in, global uchar* mask) {
    vstore8(shuffle(vload16(get_global_id(0), in), vload8(get_global_id(0), mask)), get_global_id(0), out);
}

kernel void test_shuffle_char16_uchar16(global char* out, global char* in, global uchar* mask) {
    vstore16(shuffle(vload16(get_global_id(0), in), vload16(get_global_id(0), mask)), get_global_id(0), out);
}
