/*!
[config]
name: Test float trunc built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: trunc float1
kernel_name: test_1_trunc_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 -0.0 0.0 -0.0 nan -3.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[7] 0.5 -0.5 0.0 -0.0 nan -3.99 1.5 

[test]
name: trunc float2
kernel_name: test_2_trunc_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 -0.0 -0.0 0.0 0.0 -0.0 -0.0 nan nan -3.0 -3.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[14] 0.5 0.5 -0.5 -0.5 0.0 0.0 -0.0 -0.0 nan nan -3.99 -3.99 1.5 1.5 

[test]
name: trunc float4
kernel_name: test_4_trunc_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[28] 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 

[test]
name: trunc float8
kernel_name: test_8_trunc_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[56] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 

[test]
name: trunc float16
kernel_name: test_16_trunc_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 -3.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0  tolerance 0 ulp
arg_in: 1 buffer float[112] 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 -0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 -0.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 -3.99 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 

!*/

kernel void test_1_trunc_float(global float* out, global float* in0){
  out[get_global_id(0)] = trunc(in0[get_global_id(0)]);
}

kernel void test_2_trunc_float(global float* out, global float* in0){
  vstore2(trunc(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_trunc_float(global float* out, global float* in0){
  vstore4(trunc(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_trunc_float(global float* out, global float* in0){
  vstore8(trunc(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_trunc_float(global float* out, global float* in0){
  vstore16(trunc(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

