/*!
[config]
name: Test float tgamma built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: tgamma float1
kernel_name: test_1_tgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 1.0 0.886226925452758 1.7724538509055159 nan 999999999999999.2 nan  tolerance 16 ulp
arg_in: 1 buffer float[6] 1.0 1.5 0.5 0.0 1e-15 nan 

[test]
name: tgamma float2
kernel_name: test_2_tgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 1.0 1.0 0.886226925452758 0.886226925452758 1.7724538509055159 1.7724538509055159 nan nan 999999999999999.2 999999999999999.2 nan nan  tolerance 16 ulp
arg_in: 1 buffer float[12] 1.0 1.0 1.5 1.5 0.5 0.5 0.0 0.0 1e-15 1e-15 nan nan 

[test]
name: tgamma float4
kernel_name: test_4_tgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 1.0 1.0 1.0 1.0 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 nan nan nan nan 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 nan nan nan nan  tolerance 16 ulp
arg_in: 1 buffer float[24] 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 nan nan nan nan 

[test]
name: tgamma float8
kernel_name: test_8_tgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 nan nan nan nan nan nan nan nan 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 nan nan nan nan nan nan nan nan  tolerance 16 ulp
arg_in: 1 buffer float[48] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan 

[test]
name: tgamma float16
kernel_name: test_16_tgamma_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 0.886226925452758 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 1.7724538509055159 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 999999999999999.2 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 16 ulp
arg_in: 1 buffer float[96] 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 1.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.5 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 1e-15 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_tgamma_float(global float* out, global float* in0){
  out[get_global_id(0)] = tgamma(in0[get_global_id(0)]);
}

kernel void test_2_tgamma_float(global float* out, global float* in0){
  vstore2(tgamma(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_tgamma_float(global float* out, global float* in0){
  vstore4(tgamma(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_tgamma_float(global float* out, global float* in0){
  vstore8(tgamma(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_tgamma_float(global float* out, global float* in0){
  vstore16(tgamma(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

