/*!
[config]
name: Test float tanpi built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: tanpi float1
kernel_name: test_1_tanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[7] 0.0 1.0 0.0 1.7320508075688772 -1.0 0.9074463898250784 nan  tolerance 6 ulp
arg_in: 1 buffer float[7] 0.0 0.25 1 0.3333333333333333 0.75 2.234567 nan 

[test]
name: tanpi float2
kernel_name: test_2_tanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[14] 0.0 0.0 1.0 1.0 0.0 0.0 1.7320508075688772 1.7320508075688772 -1.0 -1.0 0.9074463898250784 0.9074463898250784 nan nan  tolerance 6 ulp
arg_in: 1 buffer float[14] 0.0 0.0 0.25 0.25 1 1 0.3333333333333333 0.3333333333333333 0.75 0.75 2.234567 2.234567 nan nan 

[test]
name: tanpi float4
kernel_name: test_4_tanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[28] 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 nan nan nan nan  tolerance 6 ulp
arg_in: 1 buffer float[28] 0.0 0.0 0.0 0.0 0.25 0.25 0.25 0.25 1 1 1 1 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.75 0.75 0.75 0.75 2.234567 2.234567 2.234567 2.234567 nan nan nan nan 

[test]
name: tanpi float8
kernel_name: test_8_tanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 nan nan nan nan nan nan nan nan  tolerance 6 ulp
arg_in: 1 buffer float[56] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 1 1 1 1 1 1 1 1 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 nan nan nan nan nan nan nan nan 

[test]
name: tanpi float16
kernel_name: test_16_tanpi_float
global_size: 7 0 0

arg_out: 0 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 1.7320508075688772 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 0.9074463898250784 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 6 ulp
arg_in: 1 buffer float[112] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 0.25 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.3333333333333333 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 0.75 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 2.234567 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_tanpi_float(global float* out, global float* in0){
  out[get_global_id(0)] = tanpi(in0[get_global_id(0)]);
}

kernel void test_2_tanpi_float(global float* out, global float* in0){
  vstore2(tanpi(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_tanpi_float(global float* out, global float* in0){
  vstore4(tanpi(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_tanpi_float(global float* out, global float* in0){
  vstore8(tanpi(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_tanpi_float(global float* out, global float* in0){
  vstore16(tanpi(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

