/*!
[config]
name: Test float tanh built-in on CL 1.1
clc_version_min: 10
dimensions: 1

[test]
name: tanh float1
kernel_name: test_1_tanh_float
global_size: 6 0 0

arg_out: 0 buffer float[6] 0.0 0.12283336405919822 0.9999999999998538 1.0 -1.0 nan  tolerance 5 ulp
arg_in: 1 buffer float[6] 0.0 0.123456789 15.123456789 inf -inf nan 

[test]
name: tanh float2
kernel_name: test_2_tanh_float
global_size: 6 0 0

arg_out: 0 buffer float[12] 0.0 0.0 0.12283336405919822 0.12283336405919822 0.9999999999998538 0.9999999999998538 1.0 1.0 -1.0 -1.0 nan nan  tolerance 5 ulp
arg_in: 1 buffer float[12] 0.0 0.0 0.123456789 0.123456789 15.123456789 15.123456789 inf inf -inf -inf nan nan 

[test]
name: tanh float4
kernel_name: test_4_tanh_float
global_size: 6 0 0

arg_out: 0 buffer float[24] 0.0 0.0 0.0 0.0 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[24] 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 15.123456789 15.123456789 15.123456789 15.123456789 inf inf inf inf -inf -inf -inf -inf nan nan nan nan 

[test]
name: tanh float8
kernel_name: test_8_tanh_float
global_size: 6 0 0

arg_out: 0 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[48] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan 

[test]
name: tanh float16
kernel_name: test_16_tanh_float
global_size: 6 0 0

arg_out: 0 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.12283336405919822 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 0.9999999999998538 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 -1.0 nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan  tolerance 5 ulp
arg_in: 1 buffer float[96] 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.0 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 0.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 15.123456789 inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf -inf nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan nan 

!*/

kernel void test_1_tanh_float(global float* out, global float* in0){
  out[get_global_id(0)] = tanh(in0[get_global_id(0)]);
}

kernel void test_2_tanh_float(global float* out, global float* in0){
  vstore2(tanh(vload2(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_4_tanh_float(global float* out, global float* in0){
  vstore4(tanh(vload4(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_8_tanh_float(global float* out, global float* in0){
  vstore8(tanh(vload8(get_global_id(0), in0)), get_global_id(0), out);
}

kernel void test_16_tanh_float(global float* out, global float* in0){
  vstore16(tanh(vload16(get_global_id(0), in0)), get_global_id(0), out);
}

